/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.order.extend.ability.saleorder.PebErpDeliveryOrderAbilityService;
import com.tydic.order.extend.ability.saleorder.PebErpShipmentOrderAbilityService;
import com.tydic.order.extend.ability.saleorder.PebExtInspectionListQryAbilityService;
import com.tydic.order.extend.bo.saleorder.PebErpDeliveryOrderRspBO;
import com.tydic.order.extend.bo.saleorder.PebErpReceiveShipmentOrderReqBO;
import com.tydic.order.extend.bo.saleorder.PebErpShipmentOrderRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtInspectionListQryAbilityReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtInspectionListQryAbilityRspBO;
import com.tydic.pfscext.dao.PushErpLogDetailMapper;
import com.tydic.pfscext.dao.PushErpLogMapper;
import com.tydic.pfscext.dao.po.PushErpLogDetailPO;
import com.tydic.pfscext.dao.po.PushErpLogPO;
import com.tydic.pfscext.external.api.BusiPushErpPayableDetailService;
import com.tydic.pfscext.external.api.BusiPushErpSaleOrderChangeService;
import com.tydic.pfscext.external.api.bo.BillDownloadPushErpInfo;
import com.tydic.pfscext.external.api.bo.BillDownloadPushErpInfoBO;
import com.tydic.pfscext.external.api.bo.BillNotificationPushErpInfo;
import com.tydic.pfscext.external.api.bo.BusiNotificationPushErpInfoBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpSaleOrderChangeReqBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpSaleOrderChangeRspBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpYFDetailReqBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpYFDetailRspBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpYSDetailReqBO;
import com.tydic.pfscext.external.api.bo.BusiPushErpYSDetailRspBO;
import com.tydic.pfscext.external.api.bo.ErpYFBO;
import com.tydic.pfscext.external.api.bo.ErpYSBO;
import com.tydic.pfscext.external.api.bo.PushErpBaseInfo;
import com.tydic.pfscext.external.exception.PfscExternalBusinessException;
import com.tydic.pfscext.service.busi.BusiNotificationPushErpMsgService;
import com.tydic.pfscext.service.busi.BusiPushErpBillService;
import com.tydic.pfscext.service.busi.bo.BusiBillPushErpRspBO;
import com.tydic.pfscext.service.busi.bo.BusiNotificationPushErpReqBO;
import com.tydic.pfscext.service.busi.bo.BusiNotificationPushErpRspBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpBillReqBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYfReqBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYfRspBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYsReqBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYsRspBO;
import com.tydic.umcext.ability.supplier.UmcQrySupplierInfoDetailAbilityService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BusiPushErpBillServiceImpl
implements BusiPushErpBillService {
    private static final Logger log = LoggerFactory.getLogger(BusiPushErpBillServiceImpl.class);
    @Autowired
    private PebErpDeliveryOrderAbilityService pebErpDeliveryOrderAbilityService;
    @Autowired
    private PebErpShipmentOrderAbilityService pebErpShipmentOrderAbilityService;
    @Autowired
    private BusiPushErpPayableDetailService busiPushErpPayableDetailService;
    @Autowired
    private UmcQrySupplierInfoDetailAbilityService umcQrySupplierInfoDetailAbilityService;
    @Autowired
    private BusiPushErpSaleOrderChangeService busiPushErpSaleOrderChangeService;
    @Autowired
    private BusiNotificationPushErpMsgService busiNotificationPushErpMsgService;
    @Autowired
    private PushErpLogMapper pushErpLogMapper;
    @Autowired
    private PushErpLogDetailMapper pushErpLogDetailMapper;
    @Autowired
    private PebExtInspectionListQryAbilityService pebExtInspectionListQryAbilityService;
    @Value(value="${ERP_ENT_CODE}")
    private String entCode;
    private final String success = "1";

    @Override
    public BusiBillPushErpRspBO pushErp(BusiPushErpBillReqBO reqBO) {
        log.info("\u63a8\u9001Erp\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        BusiBillPushErpRspBO rspBO = new BusiBillPushErpRspBO();
        StringBuilder respStr = new StringBuilder();
        PushErpLogPO lastPushLog = this.pushErpLogMapper.queryLastPushLog(reqBO.getApplyNo());
        LinkedList<PushErpLogDetailPO> detailLogList = new LinkedList<PushErpLogDetailPO>();
        HashMap<String, String> failMap = new HashMap(8);
        boolean pushYf = false;
        boolean pushYs = false;
        boolean pushChange = false;
        if (lastPushLog == null) {
            pushYf = true;
            pushYs = true;
            pushChange = true;
        } else {
            if (!lastPushLog.getYfStatus().equals("1")) {
                pushYf = true;
            }
            if (!lastPushLog.getYsStatus().equals("1")) {
                pushYs = true;
            }
            if (!lastPushLog.getSaleOrderStatus().equals("1")) {
                pushChange = true;
            }
            List<PushErpLogDetailPO> erpLogList = this.pushErpLogDetailMapper.queryFailLog(lastPushLog.getId());
            failMap = erpLogList.stream().collect(Collectors.toMap(PushErpLogDetailPO::getInvoice, PushErpLogDetailPO::getAction));
        }
        this.initRspStatus(rspBO);
        try {
            if (pushYf) {
                BusiNotificationPushErpReqBO notificationPushErpReqBO = new BusiNotificationPushErpReqBO();
                notificationPushErpReqBO.setApplyNo(reqBO.getApplyNo());
                BusiNotificationPushErpRspBO pushErpNotificationMsg = this.busiNotificationPushErpMsgService.getPushErpNotificationMsg(notificationPushErpReqBO);
                if (pushErpNotificationMsg.getRespCode().equals("0000")) {
                    reqBO.setYfList(pushErpNotificationMsg.getYfList().stream().distinct().collect(Collectors.toList()));
                } else {
                    rspBO.setYfStatus("0");
                }
            }
            boolean changeFlag = true;
            if (!CollectionUtils.isEmpty(reqBO.getSaleOrderChangeBOList()) && pushChange) {
                BusiPushErpSaleOrderChangeReqBO saleOrderChangeReqBO = new BusiPushErpSaleOrderChangeReqBO();
                PushErpBaseInfo saleOrderPushErpBaseInfo = this.initPushErpBaseInfo();
                saleOrderChangeReqBO.setAction("UpdataSOCust");
                saleOrderChangeReqBO.setContext(saleOrderPushErpBaseInfo);
                saleOrderChangeReqBO.setArgs(JSONObject.toJSONString(reqBO.getSaleOrderChangeBOList()));
                BusiPushErpSaleOrderChangeRspBO saleOrderChangeRspBO = this.busiPushErpSaleOrderChangeService.pushErpSaleOrderChange(saleOrderChangeReqBO);
                if (!saleOrderChangeRspBO.getRespCode().equals("0000")) {
                    rspBO.setSaleOrderStatus("0");
                    respStr.append("[\u53d1\u7968\u62ac\u5934\u53d8\u66f4\u5931\u8d25\uff1a").append(saleOrderChangeRspBO.getRespDesc()).append("],");
                    PushErpLogDetailPO detail = new PushErpLogDetailPO();
                    detail.setAction("UpdataSOCust");
                    detail.setApplyNo(reqBO.getApplyNo());
                    detail.setFailLog(saleOrderChangeRspBO.getRespDesc());
                    detailLogList.add(detail);
                    changeFlag = false;
                }
            }
            if (!changeFlag) {
                rspBO.setDeliveryStatus("0");
                rspBO.setShipmentStatus("0");
                rspBO.setYfStatus("0");
                rspBO.setYsStatus("0");
                rspBO.setSaleOrderStatus("0");
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(respStr.toString());
                this.saveLog(reqBO, rspBO, detailLogList);
                return rspBO;
            }
            HashMap<String, String> inspectionMap = new HashMap<String, String>(reqBO.getInspectionIdList().size());
            this.pushYf(reqBO, pushYf, inspectionMap, rspBO, respStr, detailLogList, failMap);
            this.pushYs(reqBO, pushYs, inspectionMap, rspBO, respStr, detailLogList, failMap);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001ERP\u5f02\u5e38\uff1a" + e);
            rspBO.setDeliveryStatus("0");
            rspBO.setShipmentStatus("0");
            rspBO.setYfStatus("0");
            rspBO.setYsStatus("0");
            rspBO.setSaleOrderStatus("0");
            detailLogList = new LinkedList();
        }
        if (StringUtils.isEmpty((CharSequence)respStr.toString())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(respStr.toString());
        }
        this.saveLog(reqBO, rspBO, detailLogList);
        return rspBO;
    }

    private void saveLog(BusiPushErpBillReqBO reqBO, BusiBillPushErpRspBO rspBO, List<PushErpLogDetailPO> detailLogList) {
        try {
            PushErpLogPO pushErpLogPo = new PushErpLogPO();
            BeanUtils.copyProperties((Object)rspBO, (Object)pushErpLogPo);
            pushErpLogPo.setApplyNo(reqBO.getApplyNo());
            pushErpLogPo.setId(Sequence.getInstance().nextId());
            if (pushErpLogPo.getYsStatus().equals("1")) {
                pushErpLogPo.setShipmentStatus("1");
            }
            if (pushErpLogPo.getYfStatus().equals("1")) {
                pushErpLogPo.setDeliveryStatus("1");
            }
            pushErpLogPo.setPushDate(new Date());
            this.pushErpLogMapper.insert(pushErpLogPo);
            if (!CollectionUtils.isEmpty(detailLogList)) {
                detailLogList.forEach(item -> item.setPushId(pushErpLogPo.getId()));
                this.pushErpLogDetailMapper.insertBatch(detailLogList);
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u7ed3\u7b97\u4e0b\u6e38\u63a8\u9001ERP\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }

    private void pushYs(BusiPushErpBillReqBO reqBO, boolean pushYs, Map<String, String> inspectionMap, BusiBillPushErpRspBO rspBO, StringBuilder respStr, List<PushErpLogDetailPO> detailLogList, Map<String, String> failMap) {
        if (pushYs) {
            if (CollectionUtils.isEmpty(reqBO.getYsList())) {
                rspBO.setYsStatus("0");
            }
            for (BillDownloadPushErpInfoBO pushErpInfoBO : reqBO.getYsList()) {
                if (failMap.size() != 0 && failMap.get(pushErpInfoBO.getInvoiceNum() + "-" + pushErpInfoBO.getInvoiceCode() + "-" + pushErpInfoBO.getInvoiceDate()) == null) continue;
                for (String inspectionId : pushErpInfoBO.getInspectionIdList()) {
                    LinkedList<Long> idList = new LinkedList<Long>();
                    idList.add(Long.valueOf(inspectionId));
                    PebErpReceiveShipmentOrderReqBO shipmentOrderReqBO = new PebErpReceiveShipmentOrderReqBO();
                    shipmentOrderReqBO.setReqBO(idList);
                    shipmentOrderReqBO.setInoivceNo(pushErpInfoBO.getCustCode());
                    PebErpShipmentOrderRspBO shipmentOrderRspBO = this.pebErpShipmentOrderAbilityService.pushPebErpShipmentOrder(shipmentOrderReqBO);
                    inspectionMap.put(String.valueOf(shipmentOrderRspBO.getInspectionVoucherId()), shipmentOrderRspBO.getInspectionVoucherCode());
                    log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u6807\u51c6\u51fa\u8d27\u5355\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)shipmentOrderRspBO));
                    if (shipmentOrderRspBO.getReturnStatus() != null && shipmentOrderRspBO.getReturnStatus() != 1) continue;
                    rspBO.setShipmentStatus("0");
                }
                for (BillDownloadPushErpInfo row : pushErpInfoBO.getRows()) {
                    row.setSrcDocNo(inspectionMap.get(row.getSrcDocNo()));
                }
                String reqString = JSONObject.toJSONString((Object)pushErpInfoBO);
                BusiPushErpYSDetailReqBO ysDetailReqBO = new BusiPushErpYSDetailReqBO();
                ysDetailReqBO.setAction("CreateARBill");
                PushErpBaseInfo ysPushErpBaseInfo = this.initPushErpBaseInfo();
                ErpYSBO erpYsBO = (ErpYSBO)JSONObject.parseObject((String)reqString, ErpYSBO.class);
                LinkedList<ErpYSBO> ysArgs = new LinkedList<ErpYSBO>();
                ysArgs.add(erpYsBO);
                ysDetailReqBO.setArgs(JSONObject.toJSONString(ysArgs));
                ysDetailReqBO.setContext(ysPushErpBaseInfo);
                BusiPushErpYSDetailRspBO ysDetailRspBO = this.busiPushErpPayableDetailService.pushErpYSpayableDetail(ysDetailReqBO);
                if (ysDetailRspBO.getRespCode().equals("0000")) continue;
                rspBO.setYsStatus("0");
                respStr.append("[").append(ysDetailRspBO.getRespDesc()).append("]");
                PushErpLogDetailPO detail = new PushErpLogDetailPO();
                detail.setAction("CreateARBill");
                detail.setApplyNo(reqBO.getApplyNo());
                detail.setFailLog(ysDetailRspBO.getRespDesc());
                detail.setInvoice(pushErpInfoBO.getInvoiceNum() + "-" + pushErpInfoBO.getInvoiceCode() + "-" + pushErpInfoBO.getInvoiceDate());
                detailLogList.add(detail);
            }
        }
    }

    private void pushYf(BusiPushErpBillReqBO reqBO, boolean pushYf, Map<String, String> inspectionMap, BusiBillPushErpRspBO rspBO, StringBuilder respStr, List<PushErpLogDetailPO> detailLogList, Map<String, String> failMap) {
        if (pushYf) {
            if (CollectionUtils.isEmpty(reqBO.getYfList())) {
                rspBO.setYfStatus("0");
            }
            for (BusiNotificationPushErpInfoBO pushErpInfoBO : reqBO.getYfList()) {
                if (failMap.size() != 0 && failMap.get(pushErpInfoBO.getInvoiceNum() + "-" + pushErpInfoBO.getInvoiceCode() + "-" + pushErpInfoBO.getInvoiceDate()) == null) continue;
                for (String inspectionId : pushErpInfoBO.getInspectionIdList()) {
                    if (inspectionMap.get(inspectionId) != null) continue;
                    LinkedList<Long> idList = new LinkedList<Long>();
                    idList.add(Long.valueOf(inspectionId));
                    PebErpDeliveryOrderRspBO deliveryOrderRspBO = this.pebErpDeliveryOrderAbilityService.pushPebErpDeliveryOrder(idList);
                    inspectionMap.put(String.valueOf(deliveryOrderRspBO.getInspectionVoucherId()), deliveryOrderRspBO.getInspectionVoucherCode());
                    log.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u63a8\u9001\u91c7\u8d2d\u6536\u8d27\u5355\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)deliveryOrderRspBO));
                    if (deliveryOrderRspBO.getReturnStatus() != null && deliveryOrderRspBO.getReturnStatus() != 1) continue;
                    rspBO.setDeliveryStatus("0");
                }
                for (BillNotificationPushErpInfo row : pushErpInfoBO.getRows()) {
                    row.setSrcDocNo(inspectionMap.get(row.getSrcDocNo()));
                }
                String reqString = JSONObject.toJSONString((Object)pushErpInfoBO);
                BusiPushErpYFDetailReqBO yfDetailReqBO = new BusiPushErpYFDetailReqBO();
                yfDetailReqBO.setAction("CreateAPBill");
                PushErpBaseInfo yfPushErpBaseInfo = this.initPushErpBaseInfo();
                ErpYFBO erpYfBO = (ErpYFBO)JSONObject.parseObject((String)reqString, ErpYFBO.class);
                LinkedList<ErpYFBO> yfArgs = new LinkedList<ErpYFBO>();
                yfArgs.add(erpYfBO);
                yfDetailReqBO.setArgs(JSONObject.toJSONString(yfArgs));
                yfDetailReqBO.setContext(yfPushErpBaseInfo);
                BusiPushErpYFDetailRspBO yfDetailRspBO = this.busiPushErpPayableDetailService.pushErpYFPayableDetail(yfDetailReqBO);
                if (yfDetailRspBO.getRespCode().equals("0000")) continue;
                rspBO.setYfStatus("0");
                respStr.append("[").append(yfDetailRspBO.getRespDesc()).append("],");
                PushErpLogDetailPO detail = new PushErpLogDetailPO();
                detail.setAction("CreateAPBill");
                detail.setApplyNo(reqBO.getApplyNo());
                detail.setFailLog(yfDetailRspBO.getRespDesc());
                detail.setInvoice(pushErpInfoBO.getInvoiceNum() + "-" + pushErpInfoBO.getInvoiceCode() + "-" + pushErpInfoBO.getInvoiceDate());
                detailLogList.add(detail);
            }
        }
    }

    private void initRspStatus(BusiBillPushErpRspBO rspBO) {
        rspBO.setDeliveryStatus("1");
        rspBO.setShipmentStatus("1");
        rspBO.setYfStatus("1");
        rspBO.setYsStatus("1");
        rspBO.setSaleOrderStatus("1");
    }

    private PushErpBaseInfo initPushErpBaseInfo() {
        PushErpBaseInfo pushErpBaseInfo = new PushErpBaseInfo();
        pushErpBaseInfo.setCultureName("zh-CN");
        pushErpBaseInfo.setEntCode(this.entCode);
        pushErpBaseInfo.setOrgCode("15");
        pushErpBaseInfo.setUserCode("admin");
        return pushErpBaseInfo;
    }

    @Override
    public BusiPushErpYfRspBO pushErpYf(BusiPushErpYfReqBO reqBO) {
        BusiPushErpYfRspBO rspBO = new BusiPushErpYfRspBO();
        if (CollectionUtils.isEmpty(reqBO.getYfList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u5e94\u4ed8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (CollectionUtils.isEmpty(reqBO.getInspectionIdList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u9a8c\u6536\u5355[inspectionIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        log.debug("\u63a8\u9001Erp\u5e94\u4ed8\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqBO));
        StringBuilder respStr = new StringBuilder();
        ArrayList<PushErpLogDetailPO> detailList = new ArrayList<PushErpLogDetailPO>();
        PushErpLogPO pushErpLogPO = new PushErpLogPO();
        pushErpLogPO.setPushDate(new Date());
        pushErpLogPO.setApplyNo(reqBO.getNotificationNo());
        pushErpLogPO.setStatus("1");
        pushErpLogPO.setId(Sequence.getInstance().nextId());
        Map<Long, String> inspectionMap = this.getInspectionVoucherCode(reqBO.getInspectionIdList());
        for (BusiNotificationPushErpInfoBO pushErpInfoBO : reqBO.getYfList()) {
            for (BillNotificationPushErpInfo row : pushErpInfoBO.getRows()) {
                row.setSrcDocNo(inspectionMap.get(Long.valueOf(row.getSrcDocNo())));
            }
            String reqString = JSONObject.toJSONString((Object)pushErpInfoBO);
            BusiPushErpYFDetailReqBO yfDetailReqBO = new BusiPushErpYFDetailReqBO();
            yfDetailReqBO.setAction("CreateAPBill");
            PushErpBaseInfo yfPushErpBaseInfo = this.initPushErpBaseInfo();
            ErpYFBO erpYfBO = (ErpYFBO)JSONObject.parseObject((String)reqString, ErpYFBO.class);
            LinkedList<ErpYFBO> yfArgs = new LinkedList<ErpYFBO>();
            yfArgs.add(erpYfBO);
            yfDetailReqBO.setArgs(JSONObject.toJSONString(yfArgs));
            yfDetailReqBO.setContext(yfPushErpBaseInfo);
            BusiPushErpYFDetailRspBO yfDetailRspBO = this.busiPushErpPayableDetailService.pushErpYFPayableDetail(yfDetailReqBO);
            if (yfDetailRspBO.getRespCode().equals("0000")) continue;
            pushErpLogPO.setStatus("0");
            respStr.append("[").append(yfDetailRspBO.getRespDesc()).append("],");
            PushErpLogDetailPO detail = new PushErpLogDetailPO();
            detail.setAction("CreateAPBill");
            detail.setApplyNo(reqBO.getNotificationNo());
            detail.setFailLog(yfDetailRspBO.getRespDesc());
            detail.setInvoice(pushErpInfoBO.getInvoiceNum() + "-" + pushErpInfoBO.getInvoiceCode() + "-" + pushErpInfoBO.getInvoiceDate());
            detailList.add(detail);
        }
        this.savePushLog(pushErpLogPO, detailList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(respStr.toString());
        return rspBO;
    }

    @Override
    public BusiPushErpYsRspBO pushErpYs(BusiPushErpYsReqBO reqBO) {
        BusiPushErpYsRspBO rspBO = new BusiPushErpYsRspBO();
        if (CollectionUtils.isEmpty(reqBO.getYsList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u5e94\u4ed8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (CollectionUtils.isEmpty(reqBO.getInspectionIdList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u9a8c\u6536\u5355[inspectionIdList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        log.debug("\u63a8\u9001Erp\u5e94\u624b\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqBO));
        Map<Long, String> inspectionMap = this.getInspectionVoucherCode(reqBO.getInspectionIdList());
        StringBuilder respStr = new StringBuilder();
        ArrayList<PushErpLogDetailPO> detailList = new ArrayList<PushErpLogDetailPO>();
        PushErpLogPO pushErpLogPO = new PushErpLogPO();
        pushErpLogPO.setPushDate(new Date());
        pushErpLogPO.setApplyNo(reqBO.getApplyNo());
        pushErpLogPO.setStatus("1");
        pushErpLogPO.setId(Sequence.getInstance().nextId());
        for (BillDownloadPushErpInfoBO pushErpInfoBO : reqBO.getYsList()) {
            for (BillDownloadPushErpInfo row : pushErpInfoBO.getRows()) {
                row.setSrcDocNo(inspectionMap.get(Long.valueOf(row.getSrcDocNo())));
            }
            String reqString = JSONObject.toJSONString((Object)pushErpInfoBO);
            BusiPushErpYSDetailReqBO ysDetailReqBO = new BusiPushErpYSDetailReqBO();
            ysDetailReqBO.setAction("CreateARBill");
            PushErpBaseInfo ysPushErpBaseInfo = this.initPushErpBaseInfo();
            ErpYSBO erpYsBO = (ErpYSBO)JSONObject.parseObject((String)reqString, ErpYSBO.class);
            LinkedList<ErpYSBO> ysArgs = new LinkedList<ErpYSBO>();
            ysArgs.add(erpYsBO);
            ysDetailReqBO.setArgs(JSONObject.toJSONString(ysArgs));
            ysDetailReqBO.setContext(ysPushErpBaseInfo);
            BusiPushErpYSDetailRspBO ysDetailRspBO = this.busiPushErpPayableDetailService.pushErpYSpayableDetail(ysDetailReqBO);
            if (ysDetailRspBO.getRespCode().equals("0000")) continue;
            pushErpLogPO.setStatus("0");
            respStr.append("[").append(ysDetailRspBO.getRespDesc()).append("]");
            PushErpLogDetailPO detail = new PushErpLogDetailPO();
            detail.setAction("CreateARBill");
            detail.setApplyNo(reqBO.getApplyNo());
            detail.setFailLog(ysDetailRspBO.getRespDesc());
            detail.setInvoice(pushErpInfoBO.getInvoiceNum() + "-" + pushErpInfoBO.getInvoiceCode() + "-" + pushErpInfoBO.getInvoiceDate());
            detailList.add(detail);
        }
        this.savePushLog(pushErpLogPO, detailList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc(respStr.toString());
        return rspBO;
    }

    private void savePushLog(PushErpLogPO pushErpLogPO, List<PushErpLogDetailPO> detailList) {
        try {
            this.pushErpLogMapper.insert(pushErpLogPO);
            if (!CollectionUtils.isEmpty(detailList)) {
                detailList.forEach(item -> item.setPushId(pushErpLogPO.getId()));
                this.pushErpLogDetailMapper.insertBatch(detailList);
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8\u7ed3\u7b97\u63a8\u9001ERP\u65e5\u5fd7\u5931\u8d25\uff01" + e);
        }
    }

    private Map<Long, String> getInspectionVoucherCode(List<Long> inspectionIdList) {
        PebExtInspectionListQryAbilityReqBO abilityReqBO = new PebExtInspectionListQryAbilityReqBO();
        abilityReqBO.setInspectionIdList(inspectionIdList);
        PebExtInspectionListQryAbilityRspBO abilityRspBO = this.pebExtInspectionListQryAbilityService.qryInspectionList(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000") || abilityRspBO.getInspectionMap().size() == 0) {
            throw new PfscExternalBusinessException("8888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        return abilityRspBO.getInspectionMap();
    }
}

