/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiReceivableWriteOffXbjService;
import com.tydic.pfscext.api.busi.bo.BusiReceivableWriteOffXbjInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiReceivableWriteOffXbjReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.RecvAbleInfoMapper;
import com.tydic.pfscext.dao.RecvAmtDetailMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.po.RecvAbleInfo;
import com.tydic.pfscext.dao.po.RecvAmtDetail;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.vo.RecvAmtDetailVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.RecvAbleInfoRecvStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusiReceivableWriteOffXbjServiceImpl
implements BusiReceivableWriteOffXbjService {
    private static final Logger logger = LoggerFactory.getLogger(BusiReceivableWriteOffXbjServiceImpl.class);
    @Autowired
    private RecvAbleInfoMapper recvAbleInfoMapper;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    public PfscExtRspBaseBO processWriteOff(BusiReceivableWriteOffXbjReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8be2\u6bd4\u4ef7\u5e94\u6536\u6838\u9500\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getXbjWriteOffInfo())) {
            throw new PfscExtBusinessException("0001", "\u6838\u9500\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dealWithWriteOff(reqBO.getXbjWriteOffInfo(), reqBO.getIsBatch());
        return new PfscExtRspBaseBO();
    }

    private void dealWithWriteOff(List<BusiReceivableWriteOffXbjInfoReqBO> eachXbjInfoList, Integer isBatch) {
        for (BusiReceivableWriteOffXbjInfoReqBO xbjInfoReqBO : eachXbjInfoList) {
            String recvableNo = xbjInfoReqBO.getRecvableNo();
            RecvAbleInfo recvAbleInfo = this.recvAbleInfoMapper.selectByPrimaryKey(recvableNo);
            BigDecimal toWriteoffAmt = xbjInfoReqBO.getToWriteoffAmt();
            if (toWriteoffAmt == null || toWriteoffAmt.compareTo(BigDecimal.ZERO) <= 0) {
                logger.error("\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
                throw new PfscExtBusinessException("18000", "\u5e94\u6536\u8bb0\u5f55[\u5e94\u6536\u7f16\u53f7=" + recvableNo + "]\u7684\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            if (!RecvAbleInfoRecvStatus.TO_RECEIVE.getCode().equals(recvAbleInfo.getRecvStatus())) {
                throw new PfscExtBusinessException("18000", "\u53ea\u6709\u6536\u6b3e\u72b6\u6001\u4e3a\u5f85\u6536\u6b3e\u7684\u8bb0\u5f55\u624d\u80fd\u529e\u7406\u6b64\u4e1a\u52a1");
            }
            if (recvAbleInfo.getRecvableAmt().compareTo(toWriteoffAmt) != 0) {
                if (null == isBatch || isBatch == 0) {
                    throw new PfscExtBusinessException("18000", "\u5bf9\u4e8e\u8be2\u6bd4\u4ef7\u914d\u9001\u7c7b,\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u5e94\u6536\u91d1\u989d");
                }
                RecvAbleInfo record = new RecvAbleInfo();
                record.setRecvableNo(recvableNo);
                record.setRecvRemark("\u5bf9\u4e8e\u8be2\u6bd4\u4ef7\u914d\u9001\u7c7b,\u672c\u6b21\u6536\u6b3e\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u5e94\u6536\u91d1\u989d");
                this.recvAbleInfoMapper.updateByPrimaryKeySelective(record);
                continue;
            }
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setOrderId(recvAbleInfo.getOrderId());
            saleItemInfoVO.setApplyNo(recvAbleInfo.getInvoiceApyNo());
            List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(saleItemInfoVO);
            if (CollectionUtils.isEmpty(saleItemInfoList)) {
                throw new PfscExtBusinessException("18000", "\u6839\u636e\u8ba2\u5355Id" + recvAbleInfo.getOrderId() + ",\u7533\u8bf7\u5355\u53f7" + recvAbleInfo.getInvoiceApyNo() + "\u83b7\u53d6\u9500\u552e\u5546\u54c1\u8bb0\u5f55\u4e3a\u7a7a");
            }
            HashSet<Long> inspectionIdSet = new HashSet<Long>();
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                inspectionIdSet.add(saleItemInfo.getInspectionId());
            }
            boolean allExist = true;
            for (Long inspectionId : inspectionIdSet) {
                RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
                recvAmtDetailVO.setInspectionId(inspectionId);
                List<RecvAmtDetail> recvAmtDetailList = this.recvAmtDetailMapper.getList(recvAmtDetailVO);
                if (!CollectionUtils.isEmpty(recvAmtDetailList)) continue;
                allExist = false;
                break;
            }
            RecvAbleInfo recvAbleInfo2 = new RecvAbleInfo();
            recvAbleInfo2.setRecvableNo(recvableNo);
            if (allExist) {
                recvAbleInfo2.setWriteoffAmt(recvAbleInfo.getWriteoffAmt().add(toWriteoffAmt));
                recvAbleInfo2.setRecvStatus(RecvAbleInfoRecvStatus.RECEIVED.getCode());
                recvAbleInfo2.setRecvRemark("");
            } else {
                recvAbleInfo2.setRecvRemark("\u8be5\u5e94\u6536\u8bb0\u5f55\u5bf9\u5e94\u7684\u8ba2\u5355\u7684\u9a8c\u6536\u5355\u6ca1\u6709\u505a\u6536\u6b3e\u786e\u8ba4");
            }
            this.recvAbleInfoMapper.updateByPrimaryKeySelective(recvAbleInfo2);
        }
    }
}

