/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.pfscext.api.busi.BusiRefundResendService;
import com.tydic.pfscext.api.busi.bo.BusiRefundResendReqBO;
import com.tydic.pfscext.api.busi.bo.BusiRefundResendRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.FscPaymentFlowInfoDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.FscPaymentFlowInfoDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiRefundResendService"})
public class BusiRefundResendServiceImpl
implements BusiRefundResendService {
    private static final Logger log = LoggerFactory.getLogger(BusiRefundResendServiceImpl.class);
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private FscPaymentFlowInfoDetailMapper fscPaymentFlowInfoDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    private static final String PART_REFUND = "06";
    @Value(value="${REFUND_RESULT_CALL_BACK:http://}")
    private String REFUND_RESULT_CALL_BACK;
    @Autowired
    private BillSNService billSNService;

    @PostMapping(value={"refundResend"})
    public BusiRefundResendRspBO refundResend(@RequestBody BusiRefundResendReqBO reqBo) {
        BusiRefundResendRspBO busiRefundResendRspBO = new BusiRefundResendRspBO();
        PaymentFlowInfo paymentFlowInfo = this.paymentFlowInfoMapper.selectByPrimaryKey(reqBo.getSeq());
        Long outOrderId = this.billSNService.getSn(BillType.PAY_APPLICATION);
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("REFUND-").append(outOrderId);
        paymentFlowInfo.setPayTime(null);
        paymentFlowInfo.setPaymentStatus(null);
        paymentFlowInfo.setCreateUserName(reqBo.getName());
        paymentFlowInfo.setOutOrderId(payOrderNo.toString());
        paymentFlowInfo.setClientIp(reqBo.getClientIp());
        paymentFlowInfo.setOrdPurchaserId(paymentFlowInfo.getOrdPurchaserId());
        long flowId = this.paymentFlowInfoMapper.insert(paymentFlowInfo);
        FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetailQry = new FscPaymentFlowInfoDetailPO();
        fscPaymentFlowInfoDetailQry.setFlowId(reqBo.getSeq());
        List<FscPaymentFlowInfoDetailPO> list = this.fscPaymentFlowInfoDetailMapper.getList(fscPaymentFlowInfoDetailQry);
        if (!CollectionUtils.isEmpty(list)) {
            for (FscPaymentFlowInfoDetailPO item : list) {
                FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetail = new FscPaymentFlowInfoDetailPO();
                fscPaymentFlowInfoDetail.setFlowId(paymentFlowInfo.getSeq());
                fscPaymentFlowInfoDetail.setOutOrderId(paymentFlowInfo.getOutOrderId());
                fscPaymentFlowInfoDetail.setFlowFlag(item.getFlowFlag());
                fscPaymentFlowInfoDetail.setCreateDate(new Date());
                this.fscPaymentFlowInfoDetailMapper.insert(fscPaymentFlowInfoDetail);
            }
        }
        return busiRefundResendRspBO;
    }

    private PayProRefundAbilityRspBo createRefundOrder(PaymentFlowInfo paymentFlowInfo, BusiRefundResendReqBO reqBO) {
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        payProRefundAbilityReqBo.setRefundOutOrderId(paymentFlowInfo.getOutOrderId());
        payProRefundAbilityReqBo.setOriOutOrderId(paymentFlowInfo.getReturnOutOrderId());
        payProRefundAbilityReqBo.setBusiCode(paymentFlowInfo.getBusiCode());
        payProRefundAbilityReqBo.setRefundFee(paymentFlowInfo.getOrderAmt().setScale(0, 1).toString());
        payProRefundAbilityReqBo.setRefundReason(paymentFlowInfo.getOrderDesc());
        payProRefundAbilityReqBo.setNotifyUrl(this.REFUND_RESULT_CALL_BACK);
        payProRefundAbilityReqBo.setCreateOperId(String.valueOf(reqBO.getUserId()));
        payProRefundAbilityReqBo.setCreateOperIdName(reqBO.getName());
        String[] split = paymentFlowInfo.getReturnOutOrderId().split("-");
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(split[1]);
        BigDecimal paymentAmt = BigDecimal.ZERO;
        for (ApplyDetail applyDetail : applyDetails) {
            paymentAmt = paymentAmt.add(applyDetail.getAmt());
        }
        if (paymentFlowInfo.getOrderAmt().compareTo(paymentAmt) < 0) {
            payProRefundAbilityReqBo.setOrderType(PART_REFUND);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!"0000".equals(payProRefundAbilityRspBo.getRespCode())) {
            log.error("\u521b\u5efa\u9000\u6b3e\u8ba2\u5355[" + paymentFlowInfo.getOutOrderId() + "]\u5931\u8d25,\uff1a" + payProRefundAbilityRspBo.getRespDesc());
            this.savelog("CreateRefundOrderService-1", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", payProRefundAbilityRspBo.getRespDesc());
        }
        this.savelog("CreateRefundOrderService-2", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return payProRefundAbilityRspBo;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }
}

