/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.pfscext.api.busi.BusiSaleInvoiceInfoService;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoRspBO;
import com.tydic.pfscext.api.busi.vo.SaleItemInfoExportVO;
import com.tydic.pfscext.api.deal.bo.SaleInvoiceInfoExportBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoInvoicingTempMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceDetail;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfoInvoicingTempPO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.InvoiceMethod;
import com.tydic.pfscext.enums.PushStatus;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiSaleInvoiceInfoService"})
public class BusiSaleInvoiceInfoServiceImpl
implements BusiSaleInvoiceInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSaleInvoiceInfoServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleOrderInfoInvoicingTempMapper saleOrderInfoInvoicingTempMapper;

    @Transactional
    @PostMapping(value={"dealManualInvoice"})
    public BusiSaleInvoiceInfoRspBO dealManualInvoice(@RequestBody BusiSaleInvoiceInfoReqBO reqBO) {
        BillApplyInfo billApplyInfo;
        BusiSaleInvoiceInfoRspBO rspBO = new BusiSaleInvoiceInfoRspBO();
        if (!StringUtils.hasText((String)reqBO.getApplyNo())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (YesNo.YES.getCode().equals(reqBO.getTempFlag())) {
            if (reqBO.getVersionId() == null || 0L == reqBO.getVersionId()) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u5bfc\u5165\u6570\u636e\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                return rspBO;
            }
        } else if (CollectionUtils.isEmpty((Collection)reqBO.getSaleInvoiceList())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u53d1\u7968\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if ((billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(reqBO.getApplyNo())) == null) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355\u53f7[" + reqBO.getApplyNo() + "]\u67e5\u8be2\u7533\u8bf7\u5355\u4e3a\u7a7a");
            return rspBO;
        }
        String billStatus = billApplyInfo.getBillStatus();
        if (BillStatus.SIGNED_IN.getCode().equals(billStatus)) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u7684\u53d1\u7968\u5df2\u6536\u7968,\u4e0d\u5141\u8bb8\u518d\u5904\u7406");
            return rspBO;
        }
        String pushStatus = billApplyInfo.getPushStatus();
        if (BillStatus.NO_APPLY.getCode().equals(billStatus)) {
            if (!PushStatus.NOT_PUSH.getCode().equals(pushStatus) && !PushStatus.PUSH_FAIL.getCode().equals(pushStatus)) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u7684\u63a8\u9001\u72b6\u6001\u4e3a" + PushStatus.getInstance(pushStatus).getCodeDescr() + ",\u4e0d\u5141\u8bb8\u5904\u7406");
                return rspBO;
            }
        } else if (BillStatus.SEND_BILL.getCode().equals(billStatus)) {
            if (pushStatus != null) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u7684\u63a8\u9001\u72b6\u6001\u4e3aNULL,\u4e0d\u5141\u8bb8\u5904\u7406");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u72b6\u6001\u4e0d\u5141\u8bb8\u624b\u52a8\u5f00\u7968\uff0cBillStatus\uff1a" + billStatus);
            return rspBO;
        }
        List<SaleInvoiceInfoExportBO> saleInvoiceList = reqBO.getSaleInvoiceList();
        if (YesNo.YES.getCode().equals(reqBO.getTempFlag())) {
            saleInvoiceList = this.getSaleInvoiceListFromTemp(reqBO.getVersionId());
        }
        if (CollectionUtils.isEmpty((Collection)saleInvoiceList)) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5bfc\u5165\u7684\u53d1\u7968\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        logger.debug("---\u5bfc\u5165\u53d1\u7968\u6570\u636e,\u9700\u5bfc\u5165\u7684\u53d1\u7968\u6570\u91cf:" + saleInvoiceList.size());
        List applyNoList = saleInvoiceList.stream().map(SaleInvoiceInfoExportBO::getApplyNo).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(applyNoList)) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5f00\u7968\u660e\u7ec6\u4e2d\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a");
            return rspBO;
        }
        if (applyNoList.size() > 1) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5f00\u7968\u660e\u7ec6\u4e2d\u7533\u8bf7\u5355\u53f7\u5b58\u5728\u591a\u4e2a\uff1a" + applyNoList);
            return rspBO;
        }
        if (!reqBO.getApplyNo().equals(applyNoList.get(0))) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5f00\u7968\u660e\u7ec6\u4e2d\u7533\u8bf7\u5355\u53f7[" + (String)applyNoList.get(0) + "]\u9519\u8bef");
            return rspBO;
        }
        Map<String, List<SaleInvoiceInfoExportBO>> saleInvoiceMap = saleInvoiceList.stream().collect(Collectors.groupingBy(SaleInvoiceInfoExportBO::getInvoiceNo));
        for (String invoiceNo2 : saleInvoiceMap.keySet()) {
            SaleInvoiceInfo selectByPrimaryKey = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo2);
            if (null == selectByPrimaryKey || reqBO.getApplyNo().equals(selectByPrimaryKey.getApplyNo())) continue;
            rspBO.setRespDesc("\u53d1\u7968\u53f7:" + selectByPrimaryKey.getInvoiceNo() + ",\u53d1\u7968\u4ee3\u7801:" + selectByPrimaryKey.getInvoiceCode() + ",\u5f00\u7968\u65e5\u671f:" + DateUtils.dateToStr((Date)selectByPrimaryKey.getInvoiceDate()) + " \u7684\u53d1\u7968\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff0c\u8be5\u53d1\u7968\u7533\u8bf7\u5355\u53f7:" + selectByPrimaryKey.getApplyNo());
            rspBO.setRespCode("18000");
            return rspBO;
        }
        List<SaleItemInfoExportVO> itemInfoList = this.saleItemInfoMapper.getSaleItemInfoByApplyNo(reqBO.getApplyNo());
        if (saleInvoiceList.size() != itemInfoList.size()) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u4e0e\u4e0b\u8f7d\u7684\u6a21\u677f\u4e0d\u5bf9\u7b49\uff01");
            return rspBO;
        }
        long startTime = System.currentTimeMillis();
        logger.debug("\u6570\u636e\u8f6c\u6362{}\u5f00\u59cb:{}", (Object)reqBO.getApplyNo(), (Object)startTime);
        Map saleItemInfoMap = itemInfoList.stream().filter(i -> reqBO.getApplyNo().equals(i.getApplyNo())).collect(Collectors.toMap(i -> i.getItemNo() + "-" + i.getSeq(), Function.identity()));
        ArrayList saleInvoiceInfoList = new ArrayList();
        ArrayList saleInvoiceDetailList = new ArrayList();
        Integer invoiceType = Optional.ofNullable(billApplyInfo.getInvoiceType()).map(Integer::valueOf).orElse(null);
        saleInvoiceMap.keySet().forEach(invoiceNo -> {
            List exportBos = (List)saleInvoiceMap.get(invoiceNo);
            exportBos.forEach(exportBO -> {
                SaleItemInfoExportVO saleItemInfoExportVo = (SaleItemInfoExportVO)saleItemInfoMap.get(exportBO.getIdentify());
                if (saleItemInfoExportVo == null) {
                    throw new PfscExtBusinessException("18000", StrUtil.format((CharSequence)"\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u4e2d\u7b2c{}\u884c\u7684\u5546\u54c1\u884c\u53f7-\u5546\u54c1ID[{}]\u88ab\u4fee\u6539\uff01", (Object[])new Object[]{exportBO.getSerialNumber(), exportBO.getIdentify()}));
                }
                if (!String.valueOf(saleItemInfoExportVo.getPurchaseOrderId()).equals(exportBO.getPurchaseOrderId())) {
                    String format = StrUtil.format((CharSequence)"\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u4e2d\u7b2c{}\u884c\u7684\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7[{}]\u88ab\u4fee\u6539\uff01", (Object[])new Object[]{exportBO.getSerialNumber(), exportBO.getPurchaseOrderId()});
                    logger.error(format + "\u5bfc\u5165\u6570\u636e\uff1a{}.\u6e90\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)exportBO, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]), (Object)JSON.toJSONString((Object)saleItemInfoExportVo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
                    throw new PfscExtBusinessException("18000", format);
                }
                if (!saleItemInfoExportVo.getSkuName().trim().equals(exportBO.getSkuName())) {
                    String format = StrUtil.format((CharSequence)"\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u4e2d\u7b2c{}\u884c\u7684\u7269\u8d44\u540d\u79f0[{}]\u88ab\u4fee\u6539\uff01", (Object[])new Object[]{exportBO.getSerialNumber(), exportBO.getSkuName()});
                    logger.error(format + "\u5bfc\u5165\u6570\u636e\uff1a{}.\u6e90\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)exportBO, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]), (Object)JSON.toJSONString((Object)saleItemInfoExportVo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
                    throw new PfscExtBusinessException("18000", format);
                }
                if (!String.valueOf(saleItemInfoExportVo.getSkuId()).equals(exportBO.getSkuId())) {
                    String format = StrUtil.format((CharSequence)"\u4e0a\u4f20\u7684\u5f00\u7968\u660e\u7ec6\u4e2d\u7b2c{}\u884c\u7684\u5546\u54c1\u7f16\u7801[{}]\u88ab\u4fee\u6539\uff01", (Object[])new Object[]{exportBO.getSerialNumber(), exportBO.getSkuId()});
                    logger.error(format + "\u5bfc\u5165\u6570\u636e\uff1a{}.\u6e90\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)exportBO, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]), (Object)JSON.toJSONString((Object)saleItemInfoExportVo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
                    throw new PfscExtBusinessException("18000", format);
                }
                exportBO.setSkuName(saleItemInfoExportVo.getSkuName());
                SaleInvoiceDetail detail = FscRu.js(exportBO, SaleInvoiceDetail.class);
                detail.setInvoiceNo(exportBO.getInvoiceNo());
                detail.setTaxAmt(exportBO.getTaxAmt());
                detail.setUntaxAmt(exportBO.getUnTaxAmt());
                detail.setAmount(exportBO.getAmount());
                detail.setTaxRate(exportBO.getTaxRate());
                detail.setTaxClassCode(exportBO.getTaxCatCode());
                detail.setItemName(exportBO.getSkuName());
                detail.setInspectionId(saleItemInfoExportVo.getInspectionId());
                detail.setItemNo(saleItemInfoExportVo.getItemNo());
                detail.setSaleUnitPrice(saleItemInfoExportVo.getSaleUnitPrice());
                detail.setQuantity(saleItemInfoExportVo.getQuantity());
                detail.setUnitName(saleItemInfoExportVo.getUnitName());
                detail.setOrderId(saleItemInfoExportVo.getOrderId());
                detail.setItemSeq(saleItemInfoExportVo.getSeq());
                saleInvoiceDetailList.add(detail);
            });
            SaleInvoiceInfo saleInvoiceInfo = FscRu.js(exportBos.get(0), SaleInvoiceInfo.class);
            saleInvoiceInfo.setInvoiceType(invoiceType);
            saleInvoiceInfo.setAddress(reqBO.getAddr());
            saleInvoiceInfo.setBankName(reqBO.getBankName());
            saleInvoiceInfo.setBankAcNo(reqBO.getBankAcctNo());
            saleInvoiceInfo.setPhone(reqBO.getPhone());
            saleInvoiceInfo.setTaxNo(reqBO.getTaxNo());
            saleInvoiceInfo.setName(reqBO.getInvoiceName());
            saleInvoiceInfo.setElectronicInvoiceUrl(reqBO.getElectronicInvoiceUrl());
            saleInvoiceInfo.setElectronicInvoiceName(reqBO.getElectronicInvoiceName());
            BigDecimal amount = exportBos.stream().map(SaleInvoiceInfoExportBO::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            saleInvoiceInfo.setAmt(amount);
            BigDecimal unTaxAmt = exportBos.stream().map(SaleInvoiceInfoExportBO::getUnTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            saleInvoiceInfo.setUntaxAmt(unTaxAmt);
            BigDecimal taxAmt = exportBos.stream().map(SaleInvoiceInfoExportBO::getTaxAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            saleInvoiceInfo.setTaxAmt(taxAmt);
            saleInvoiceInfo.setInvoiceStatus("1");
            saleInvoiceInfoList.add(saleInvoiceInfo);
        });
        logger.debug("\u6570\u636e\u8f6c\u6362{}\u7ed3\u675f\u7528\u65f6:{} ms.", (Object)reqBO.getApplyNo(), (Object)(System.currentTimeMillis() - startTime));
        List<SaleInvoiceInfo> listByApplyNo = this.saleInvoiceInfoMapper.selectByApplyNo(reqBO.getApplyNo());
        if (!CollectionUtils.isEmpty(listByApplyNo)) {
            Iterator invoiceNos = listByApplyNo.stream().map(SaleInvoiceInfo::getInvoiceNo).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            logger.debug("\u539f\u53d1\u7968\u4fe1\u606f\uff1a{}.{}", invoiceNos, (Object)listByApplyNo.size());
            this.saleInvoiceInfoMapper.deleteByApplyNo(reqBO.getApplyNo());
            for (List subList : ListUtil.batchList(invoiceNos, (int)500)) {
                if (CollectionUtils.isEmpty((Collection)subList)) continue;
                this.saleInvoiceDetailMapper.deleteByInvoiceNos(subList);
            }
        }
        for (List subList : ListUtil.batchList(saleInvoiceInfoList, (int)500)) {
            if (CollectionUtils.isEmpty((Collection)subList)) continue;
            this.saleInvoiceInfoMapper.batchInsertSaleInvoiceInfo(subList);
        }
        for (List subList : ListUtil.batchList(saleInvoiceDetailList, (int)500)) {
            if (CollectionUtils.isEmpty((Collection)subList)) continue;
            this.saleInvoiceDetailMapper.batchInsertSaleInvoiceDetail(new HashSet<SaleInvoiceDetail>(subList));
        }
        HashMap<String, Object> updateParam = new HashMap<String, Object>();
        updateParam.put("billStatus", BillStatus.SEND_BILL.getCode());
        updateParam.put("applyNo", reqBO.getApplyNo());
        updateParam.put("invoiceMethod", InvoiceMethod.MANUAL.getCode());
        updateParam.put("pushStatus", null);
        updateParam.put("invoiceImportUrl", reqBO.getInvoiceXlsUrl());
        updateParam.put("invoiceImportName", reqBO.getInvoiceXlsName());
        updateParam.put("receiveDate", new Date());
        this.billApplyInfoMapper.updateBillApplyStatusByApplyNo(updateParam);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u624b\u52a8\u5f00\u7968\u5165\u5e93\u6210\u529f\uff01");
        return rspBO;
    }

    private List<SaleInvoiceInfoExportBO> getSaleInvoiceListFromTemp(Long versionId) {
        ArrayList<SaleInvoiceInfoExportBO> saleInvoiceList = new ArrayList<SaleInvoiceInfoExportBO>();
        if (versionId != null && versionId != 0L) {
            SaleOrderInfoInvoicingTempPO saleOrderInfoInvoicingTempQry = new SaleOrderInfoInvoicingTempPO();
            saleOrderInfoInvoicingTempQry.setVersionId(versionId);
            List<SaleOrderInfoInvoicingTempPO> tempList = this.saleOrderInfoInvoicingTempMapper.getList(saleOrderInfoInvoicingTempQry);
            if (!CollectionUtils.isEmpty(tempList)) {
                saleInvoiceList.addAll(tempList.stream().map(item -> {
                    SaleInvoiceInfoExportBO exportBo = new SaleInvoiceInfoExportBO();
                    exportBo.setInvoiceNo(item.getInvoiceNo());
                    exportBo.setInvoiceCode(item.getInvoiceCode());
                    exportBo.setInvoiceDate(item.getInvoiceDate());
                    exportBo.setApplyNo(item.getApplyNo());
                    exportBo.setUnTaxAmt(item.getUnTaxAmt());
                    exportBo.setTaxAmt(item.getTaxAmt());
                    exportBo.setAmount(item.getAmount());
                    exportBo.setIdentify(item.getIdentify());
                    exportBo.setTaxRate(item.getTaxRate());
                    exportBo.setTaxCatCode(item.getTaxCatCode());
                    exportBo.setSkuName(item.getSkuName());
                    exportBo.setSkuId(item.getSkuId());
                    exportBo.setPurchaseOrderId(item.getPurchaseOrderId());
                    exportBo.setSerialNumber(item.getSerialNumber());
                    return exportBo;
                }).collect(Collectors.toList()));
            }
        }
        return saleInvoiceList;
    }
}

