/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.api.busi.BusiSyncPushErpService;
import com.tydic.pfscext.api.busi.bo.BusiSyncPushErpReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSyncPushErpRspBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.PushErpLogMapper;
import com.tydic.pfscext.dao.SaleInvoiceDetailMapper;
import com.tydic.pfscext.dao.SaleInvoiceInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.SaleInvoiceDetailCheckPO;
import com.tydic.pfscext.dao.po.SaleInvoiceInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.bo.BillDownloadPushErpInfo;
import com.tydic.pfscext.external.api.bo.BillDownloadPushErpInfoBO;
import com.tydic.pfscext.service.busi.BusiPushErpBillService;
import com.tydic.pfscext.service.busi.bo.BusiBillPushErpRspBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpBillReqBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpSaleOrderChangeBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYsReqBO;
import com.tydic.pfscext.service.busi.bo.BusiPushErpYsRspBO;
import com.tydic.pfscext.utils.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.BusiSyncPushErpService"})
public class BusiSyncPushErpServiceImpl
implements BusiSyncPushErpService {
    private static final Logger log = LoggerFactory.getLogger(BusiSyncPushErpServiceImpl.class);
    @Autowired
    private BusiPushErpBillService busiPushErpBillService;
    @Autowired
    private PushErpLogMapper pushErpLogMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Value(value="${FSC_PUSH_ERP_OLD_ORDER_RECV_TIME:2022-08-30 22:00:00}")
    private String pushErpOldOrderTime;

    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    @PostMapping(value={"syncPushErp"})
    public BusiSyncPushErpRspBO syncPushErp(@RequestBody BusiSyncPushErpReqBO reqBO) {
        this.valid(reqBO);
        BusiSyncPushErpRspBO rspBO = new BusiSyncPushErpRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getApplyNoList())) {
            for (String applyNo : reqBO.getApplyNoList()) {
                BusiPushErpYsReqBO pushErpReqBO = new BusiPushErpYsReqBO();
                TreeSet<String> idList = new TreeSet<String>();
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
                if (ObjectUtils.isEmpty((Object)billApplyInfo)) {
                    throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355[" + applyNo + "]\u672a\u627e\u5230\uff01");
                }
                List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getModelByApplyNo(billApplyInfo.getApplyNo());
                boolean needPushErp = true;
                boolean isPushErpOldCode = true;
                LinkedList<Long> inspectionIdList = new LinkedList<Long>();
                LinkedList<BusiPushErpSaleOrderChangeBO> changeBOList = new LinkedList<BusiPushErpSaleOrderChangeBO>();
                for (SaleOrderInfo orderInfo : saleOrderInfoList) {
                    Date pushErpOldOrderTimeDate;
                    inspectionIdList.add(orderInfo.getInspectionId());
                    if (orderInfo.getIsErp() == null || !"1".equals(orderInfo.getIsErp())) {
                        needPushErp = false;
                        break;
                    }
                    if (!billApplyInfo.getInvoceName().equals(orderInfo.getInvoceName())) {
                        BusiPushErpSaleOrderChangeBO changeBO = new BusiPushErpSaleOrderChangeBO();
                        changeBO.setMallDocNo(orderInfo.getSaleOrderCode());
                        changeBO.setUpCustomer(billApplyInfo.getTaxNo());
                        changeBOList.add(changeBO);
                    }
                    if ((pushErpOldOrderTimeDate = DateUtil.strToDate(this.pushErpOldOrderTime, "yyyy-MM-dd HH:mm:ss")) != null && orderInfo.getRecvDate() != null) {
                        if (pushErpOldOrderTimeDate.getTime() >= orderInfo.getRecvDate().getTime()) continue;
                        isPushErpOldCode = false;
                        continue;
                    }
                    isPushErpOldCode = false;
                }
                if (!needPushErp) continue;
                if (isPushErpOldCode) {
                    return this.dealOldPushErp(billApplyInfo.getApplyNo(), idList, inspectionIdList, changeBOList);
                }
                pushErpReqBO.setInspectionIdList(inspectionIdList);
                pushErpReqBO.setApplyNo(billApplyInfo.getApplyNo());
                LinkedList<BillDownloadPushErpInfoBO> ysList = new LinkedList<BillDownloadPushErpInfoBO>();
                BillDownloadPushErpInfoBO pushErpInfoBO = new BillDownloadPushErpInfoBO();
                List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectByApplyNo(applyNo);
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
                    pushErpInfoBO.setCustCode(saleInvoiceInfo.getTaxNo());
                    pushErpInfoBO.setInvoiceNum(saleInvoiceInfo.getInvoiceNo());
                    pushErpInfoBO.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                    pushErpInfoBO.setInvoiceDate(DateUtil.dateToStr(saleInvoiceInfo.getInvoiceDate(), "yyyy-MM-dd"));
                    pushErpInfoBO.setPlatformSign("1");
                    ArrayList<BillDownloadPushErpInfo> pushErpInfoList = new ArrayList<BillDownloadPushErpInfo>();
                    List<SaleInvoiceDetailCheckPO> invoiceDetailList = this.saleInvoiceDetailMapper.getSaleInvoiceInspectionIds(billApplyInfo.getApplyNo(), pushErpInfoBO.getInvoiceNum(), pushErpInfoBO.getInvoiceCode(), DateUtil.strToDate(pushErpInfoBO.getInvoiceDate(), "yyyy-MM-dd"));
                    for (SaleInvoiceDetailCheckPO invoiceDetail : invoiceDetailList) {
                        BillDownloadPushErpInfo pushErpInfo = new BillDownloadPushErpInfo();
                        pushErpInfo.setQty(new BigDecimal(invoiceDetail.getInvoiceQuantity()));
                        pushErpInfo.setTaxMoney(invoiceDetail.getTaxAmt());
                        pushErpInfo.setNoTaxMoney(invoiceDetail.getUntaxAmt());
                        pushErpInfo.setTotalMoney(invoiceDetail.getInvoiceAmount());
                        pushErpInfo.setTaxPrice(new BigDecimal(invoiceDetail.getOrderSaleUnitPrice()));
                        idList.add(invoiceDetail.getInspectionId());
                        pushErpInfo.setSrcDocNo(invoiceDetail.getInspectionId());
                        pushErpInfo.setSrcorderitemid(invoiceDetail.getItemNo());
                        pushErpInfo.setOrderitemid(invoiceDetail.getPurchaseItemNo());
                        pushErpInfoList.add(pushErpInfo);
                    }
                    pushErpInfoBO.setInspectionIdList(idList);
                    pushErpInfoBO.setRows(pushErpInfoList);
                    ysList.add(pushErpInfoBO);
                }
                pushErpReqBO.setYsList(ysList);
                BusiPushErpYsRspBO busiBillPushErpRspBO = this.busiPushErpBillService.pushErpYs(pushErpReqBO);
                String respString = JSONObject.toJSONString((Object)busiBillPushErpRspBO);
                rspBO = (BusiSyncPushErpRspBO)JSONObject.parseObject((String)respString, BusiSyncPushErpRspBO.class);
            }
        }
        return rspBO;
    }

    private BusiSyncPushErpRspBO dealOldPushErp(String applyNo, Set<String> idList, List<Long> inspectionIdList, List<BusiPushErpSaleOrderChangeBO> changeBOList) {
        BusiPushErpBillReqBO pushErpReqBO = new BusiPushErpBillReqBO();
        pushErpReqBO.setInspectionIdList(inspectionIdList);
        pushErpReqBO.setApplyNo(applyNo);
        pushErpReqBO.setSaleOrderChangeBOList(changeBOList);
        LinkedList<BillDownloadPushErpInfoBO> ysList = new LinkedList<BillDownloadPushErpInfoBO>();
        BillDownloadPushErpInfoBO pushErpInfoBO = new BillDownloadPushErpInfoBO();
        List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectByApplyNo(applyNo);
        for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
            pushErpInfoBO.setCustCode(saleInvoiceInfo.getTaxNo());
            pushErpInfoBO.setInvoiceNum(saleInvoiceInfo.getInvoiceNo());
            pushErpInfoBO.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
            pushErpInfoBO.setInvoiceDate(DateUtil.dateToStr(saleInvoiceInfo.getInvoiceDate(), "yyyy-MM-dd"));
            pushErpInfoBO.setPlatformSign("1");
            ArrayList<BillDownloadPushErpInfo> pushErpInfoList = new ArrayList<BillDownloadPushErpInfo>();
            List<SaleInvoiceDetailCheckPO> invoiceDetailList = this.saleInvoiceDetailMapper.getSaleInvoiceInspectionIds(applyNo, pushErpInfoBO.getInvoiceNum(), pushErpInfoBO.getInvoiceCode(), DateUtil.strToDate(pushErpInfoBO.getInvoiceDate(), "yyyy-MM-dd"));
            for (SaleInvoiceDetailCheckPO invoiceDetail : invoiceDetailList) {
                BillDownloadPushErpInfo pushErpInfo = new BillDownloadPushErpInfo();
                pushErpInfo.setQty(new BigDecimal(invoiceDetail.getInvoiceQuantity()));
                pushErpInfo.setTaxMoney(invoiceDetail.getTaxAmt());
                pushErpInfo.setNoTaxMoney(invoiceDetail.getUntaxAmt());
                pushErpInfo.setTotalMoney(invoiceDetail.getInvoiceAmount());
                pushErpInfo.setTaxPrice(new BigDecimal(invoiceDetail.getOrderSaleUnitPrice()));
                idList.add(invoiceDetail.getInspectionId());
                pushErpInfo.setSrcDocNo(invoiceDetail.getInspectionId());
                pushErpInfo.setSrcorderitemid(invoiceDetail.getItemNo());
                pushErpInfo.setOrderitemid(invoiceDetail.getPurchaseItemNo());
                pushErpInfoList.add(pushErpInfo);
            }
            pushErpInfoBO.setInspectionIdList(idList);
            pushErpInfoBO.setRows(pushErpInfoList);
            ysList.add(pushErpInfoBO);
        }
        pushErpReqBO.setYsList(ysList);
        BusiBillPushErpRspBO busiBillPushErpRspBO = this.busiPushErpBillService.pushErp(pushErpReqBO);
        String respString = JSONObject.toJSONString((Object)busiBillPushErpRspBO);
        BusiSyncPushErpRspBO rspBO = (BusiSyncPushErpRspBO)JSONObject.parseObject((String)respString, BusiSyncPushErpRspBO.class);
        return rspBO;
    }

    private void valid(BusiSyncPushErpReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

