/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import com.tydic.pfscext.api.busi.ChangeOfReceiptBusiService;
import com.tydic.pfscext.api.busi.FscCreatePayableNoService;
import com.tydic.pfscext.api.busi.bo.FscRefundOrderOperRspBO;
import com.tydic.pfscext.api.reverse.RefundOrderOperService;
import com.tydic.pfscext.api.reverse.bo.ChangeReceiptMatchReqBO;
import com.tydic.pfscext.api.zm.bo.ChangOfReceiptItemBO;
import com.tydic.pfscext.api.zm.bo.ChangeOfReceiptBO;
import com.tydic.pfscext.api.zm.bo.ChangeReceiptServiceReqBO;
import com.tydic.pfscext.api.zm.bo.SendGoodsNoBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.ChangeOrderInfoMapper;
import com.tydic.pfscext.dao.ChangeOrderItemInfoMapper;
import com.tydic.pfscext.dao.FscPaymentFlowInfoDetailMapper;
import com.tydic.pfscext.dao.OrgMerchantConfigMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.SaleItemServfeeInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderServfeeInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.ChangeOrderInfoPO;
import com.tydic.pfscext.dao.po.ChangeOrderItemInfoPO;
import com.tydic.pfscext.dao.po.FscPaymentFlowInfoDetailPO;
import com.tydic.pfscext.dao.po.OrgMerchantConfigPO;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.dao.po.SaleItemInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.ApplyPayInfoVO;
import com.tydic.pfscext.dao.vo.PayItemInfoVO;
import com.tydic.pfscext.dao.vo.SaleItemInfoVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.enums.BillType;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FlowFlag;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.enums.ReconciliationStatus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.BillSNService;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ChangeOfReceiptBusiServiceImpl
implements ChangeOfReceiptBusiService {
    private static final Logger log = LoggerFactory.getLogger(ChangeOfReceiptBusiServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private FscPaymentFlowInfoDetailMapper fscPaymentFlowInfoDetailMapper;
    @Autowired
    private RefundOrderOperService refundOrderOperService;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private ChangeOrderInfoMapper changeOrderInfoMapper;
    @Autowired
    private ChangeOrderItemInfoMapper changeOrderItemInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private OrgMerchantConfigMapper orgMerchantConfigMapper;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Value(value="${REFUND_RESULT_CALL_BACK:http://}")
    private String REFUND_RESULT_CALL_BACK;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private FscCreatePayableNoService fscCreatePayableNoService;
    @Autowired
    private BillSNService billSNService;
    private static final String PART_REFUND = "06";
    private static final String REFUNDING = "01";
    private static final String REFUNDED = "02";
    private static final String UPDATE_TYPE_SUCCESS = "1";
    private static final String PAY_SUBMITTED = "SUBMITTED";
    private static final String PAY_SUCCESS = "SUCCESS";
    @Resource(name="frameOrderIdSeq")
    private OrderSequence frameOrderIdSeqSeqService;
    @Autowired
    private SaleOrderServfeeInfoMapper saleOrderServfeeInfoMapper;
    @Autowired
    private SaleItemServfeeInfoMapper saleItemServfeeInfoMapper;

    public PfscExtRspBaseBO changeOfReceipt(ChangeReceiptServiceReqBO reqBo) {
        for (ChangeOfReceiptBO changeOfReceiptBo : reqBo.getChangeOfReceiptBOS()) {
            this.change(changeOfReceiptBo);
        }
        return FscRu.success("\u5f02\u5e38\u53d8\u66f4\u5904\u7406\u6210\u529f", PfscExtRspBaseBO.class);
    }

    private void change(ChangeOfReceiptBO changeBo) {
        log.debug("\u8ba2\u5355\u4fa7\u6570\u636e\u5f00\u59cb\u5165\u5e93=====");
        this.addChangeOrder(changeBo);
        log.debug("\u8ba2\u5355\u4fa7\u6570\u636e\u5165\u5e93\u5b8c\u6210=====");
        PayPurchaseOrderInfo payPurchaseOrderInfo = this.queryPayPurchaseOrder(changeBo.getInspectionId(), changeBo.getOrderCode());
        if (payPurchaseOrderInfo.getOrderAmt().compareTo(changeBo.getPurchearOriginalOrderAmt()) != 0) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u8ba2\u5355[" + changeBo.getOrderCode() + "]\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        SaleOrderInfo saleOrderInfo = this.querySaleOrder(changeBo.getInspectionId(), changeBo.getOrderCode());
        if (saleOrderInfo.getOrderAmt().compareTo(changeBo.getSaleOriginalOrderAmt()) != 0) {
            throw new PfscExtBusinessException("18000", "\u9500\u552e\u8ba2\u5355[" + changeBo.getOrderCode() + "]\u91d1\u989d\u4e0d\u4e00\u81f4");
        }
        this.updatePurchase(changeBo, payPurchaseOrderInfo);
        this.updateSale(changeBo, saleOrderInfo);
        PfscExtRspBaseBO rspBaseBo = this.accountPay(FscRu.js(changeBo, ChangeReceiptMatchReqBO.class));
    }

    private void addChangeOrder(ChangeOfReceiptBO changeOfReceiptBo) {
        ChangeOrderInfoPO record = FscRu.js(changeOfReceiptBo, ChangeOrderInfoPO.class);
        record.setSaleOrderCode(changeOfReceiptBo.getOrderCode());
        if (NumberUtil.isNumber((CharSequence)changeOfReceiptBo.getParentOrderId())) {
            record.setOrderId(Long.valueOf(changeOfReceiptBo.getParentOrderId()));
        }
        record.setOrderAmt(changeOfReceiptBo.getOrderAmt());
        List sendGoodsNoBos = changeOfReceiptBo.getSendGoodsNoBOList();
        if (!CollectionUtils.isEmpty((Collection)sendGoodsNoBos)) {
            record.setSendGoodsNo(JSONObject.toJSONString((Object)sendGoodsNoBos, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        }
        record.setUpdateType(UPDATE_TYPE_SUCCESS);
        this.changeOrderInfoMapper.insertSelective(record);
        List changOfReceiptItemBos = changeOfReceiptBo.getChangOfReceiptItemBOS();
        if (!CollectionUtils.isEmpty((Collection)changOfReceiptItemBos)) {
            for (ChangOfReceiptItemBO itemBo : changOfReceiptItemBos) {
                ChangeOrderItemInfoPO changeOrderItemInfoPo = FscRu.js(itemBo, ChangeOrderItemInfoPO.class);
                changeOrderItemInfoPo.setSaleOrderCode(itemBo.getOrderCode());
                changeOrderItemInfoPo.setOrderId(record.getOrderId());
                if (StrUtil.isNotEmpty((CharSequence)itemBo.getSaleOrderItemNo()) && NumberUtil.isNumber((CharSequence)itemBo.getSaleOrderItemNo().trim())) {
                    changeOrderItemInfoPo.setItemNo(Long.parseLong(itemBo.getSaleOrderItemNo().trim()));
                }
                this.changeOrderItemInfoMapper.insertSelective(changeOrderItemInfoPo);
            }
        }
    }

    private void updatePurchase(ChangeOfReceiptBO changeBo, PayPurchaseOrderInfo payPurchaseOrderInfo) {
        int purUpdateCount;
        PayPurchaseOrderInfo payPurchaseOrderInfoUpdate = new PayPurchaseOrderInfo();
        payPurchaseOrderInfoUpdate.setOrderAmt(changeBo.getPurchearNowOrderAmt());
        payPurchaseOrderInfoUpdate.setInspectionId(payPurchaseOrderInfo.getInspectionId());
        payPurchaseOrderInfoUpdate.setRemark(changeBo.getRemark());
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(payPurchaseOrderInfo.getSource())) {
            payPurchaseOrderInfoUpdate.setReconciliationStatus(ReconciliationStatus.NOT_RECONCILED.getCode());
        }
        if ((purUpdateCount = this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(payPurchaseOrderInfoUpdate)) > 1) {
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u91c7\u8d2d\u8ba2\u5355\u66f4\u65b0\u5f02\u5e38");
        }
        for (ChangOfReceiptItemBO itemBo : changeBo.getChangOfReceiptItemBOS()) {
            PayItemInfoVO payItemInfoQry = new PayItemInfoVO();
            payItemInfoQry.setItemNo(Long.valueOf(itemBo.getPurchearItemNo()));
            payItemInfoQry.setPurchaseOrderCode(itemBo.getOrderCode());
            payItemInfoQry.setInspectionId(changeBo.getInspectionId());
            List<PayItemInfo> payItemInfos = this.payItemInfoMapper.selectBy(payItemInfoQry);
            ValUtil.isCollEmpty(payItemInfos).exception("\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u67e5\u8be2\u4e3a\u7a7a");
            if (payItemInfos.size() > 1) {
                throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u6570\u636e\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u6761");
            }
            PayItemInfo payItemInfo = payItemInfos.get(0);
            ValUtil.isEmpty(payItemInfo.getAmount()).exception("\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u67e5\u8be2\u7ed3\u679c\u91d1\u989d\u4e3a\u7a7a");
            if (itemBo.getPurchearAmt().compareTo(BigDecimal.ZERO) < 0 && payItemInfo.getAmount().compareTo(itemBo.getPurchearAmt().abs()) < 0) {
                throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u539f\u6709\u91d1\u989d\u5c0f\u4e8e\u53d8\u66f4\u91d1\u989d");
            }
            ValUtil.isEmpty(payItemInfo.getQuantity()).exception("\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\u4e3a\u7a7a");
            if (itemBo.getPurchearNum() < 0L && payItemInfo.getQuantity().compareTo(new BigDecimal(itemBo.getPurchearNum()).abs()) < 0) {
                throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u539f\u6709\u6570\u91cf\u5c0f\u4e8e\u53d8\u66f4\u6570\u91cf");
            }
            ValUtil.isEmpty(payItemInfo.getTaxRate()).exception("\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u67e5\u8be2\u7ed3\u679c\u7a0e\u7387\u4e3a\u7a7a");
            BigDecimal amount = payItemInfo.getAmount().subtract(itemBo.getPurchearAmt());
            BigDecimal quantity = payItemInfo.getQuantity().add(new BigDecimal(itemBo.getPurchearNum().toString()));
            BigDecimal taxAmt = amount.divide(BigDecimal.ONE.add(payItemInfo.getTaxRate()), 5, RoundingMode.HALF_UP).multiply(payItemInfo.getTaxRate()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal unTaxAmt = amount.subtract(taxAmt);
            PayItemInfo payItemInfoUpdate = new PayItemInfo();
            payItemInfoUpdate.setAmount(amount);
            payItemInfoUpdate.setQuantity(quantity);
            payItemInfoUpdate.setTaxAmt(taxAmt);
            payItemInfoUpdate.setUntaxAmt(unTaxAmt);
            payItemInfoUpdate.setItemNo(payItemInfo.getItemNo());
            payItemInfoUpdate.setInspectionId(changeBo.getInspectionId());
            payItemInfoUpdate.setSeq(payItemInfo.getSeq());
            this.payItemInfoMapper.updateByPrimaryKeySelective(payItemInfoUpdate);
        }
    }

    private void updateSale(ChangeOfReceiptBO changeBo, SaleOrderInfo saleOrderInfo) {
        SaleOrderInfo saleOrderInfoUpdate = new SaleOrderInfo();
        saleOrderInfoUpdate.setOrderAmt(changeBo.getSaleNowOrderAmt());
        saleOrderInfoUpdate.setRemark(changeBo.getRemark());
        saleOrderInfoUpdate.setSaleOrderCode(changeBo.getOrderCode());
        saleOrderInfoUpdate.setInspectionId(changeBo.getInspectionId());
        int updateCount = this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfoUpdate);
        if (updateCount > 1) {
            throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u9500\u552e\u8ba2\u5355\u66f4\u65b0\u5f02\u5e38");
        }
        for (ChangOfReceiptItemBO itemBo : changeBo.getChangOfReceiptItemBOS()) {
            SaleItemInfo saleItemInfo = new SaleItemInfo();
            saleItemInfo.setItemNo(Long.valueOf(itemBo.getSaleOrderItemNo()));
            saleItemInfo.setSaleOrderCode(itemBo.getOrderCode());
            saleItemInfo.setInspectionId(changeBo.getInspectionId());
            saleItemInfo = this.saleItemInfoMapper.getModelBy(saleItemInfo);
            ValUtil.isEmpty(saleItemInfo).exception("\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            ValUtil.isEmpty(saleItemInfo.getAmount()).exception("\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u67e5\u8be2\u7ed3\u679c\u91d1\u989d\u4e3a\u7a7a");
            if (itemBo.getSaleAmt().compareTo(BigDecimal.ZERO) < 0 && saleItemInfo.getAmount().compareTo(itemBo.getSaleAmt().abs()) < 0) {
                throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u539f\u6709\u91d1\u989d\u5c0f\u4e8e\u53d8\u66f4\u91d1\u989d");
            }
            ValUtil.isEmpty(saleItemInfo.getAmount()).exception("\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u67e5\u8be2\u7ed3\u679c\u91d1\u989d\u4e3a\u7a7a");
            if (itemBo.getSaleNum() < 0L && saleItemInfo.getQuantity().compareTo(new BigDecimal(itemBo.getSaleNum()).abs()) < 0) {
                throw new PfscExtBusinessException("18000", "\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u539f\u6709\u6570\u91cf\u5c0f\u4e8e\u53d8\u66f4\u6570\u91cf");
            }
            ValUtil.isEmpty(saleItemInfo.getTaxRate()).exception("\u9a8c\u6536\u5355[" + changeBo.getInspectionId() + "]\u9500\u552e\u8ba2\u5355\u660e\u7ec6[" + itemBo.getPurchearItemNo() + "]\u67e5\u8be2\u7ed3\u679c\u7a0e\u7387\u4e3a\u7a7a");
            BigDecimal amount = saleItemInfo.getAmount().subtract(itemBo.getSaleAmt());
            BigDecimal quantity = saleItemInfo.getQuantity().add(BigDecimal.valueOf(itemBo.getSaleNum()));
            BigDecimal taxAmt = amount.divide(BigDecimal.ONE.add(saleItemInfo.getTaxRate()), 5, RoundingMode.HALF_UP).multiply(saleItemInfo.getTaxRate()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal unTaxAmt = amount.subtract(taxAmt);
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setAmount(amount);
            saleItemInfoVO.setQuantity(quantity);
            saleItemInfoVO.setTaxAmt(taxAmt);
            saleItemInfoVO.setUntaxAmt(unTaxAmt);
            saleItemInfoVO.setSeq(saleItemInfo.getSeq());
            this.saleItemInfoMapper.updateRefundLock(saleItemInfoVO);
        }
    }

    public PfscExtRspBaseBO accountPay(ChangeReceiptMatchReqBO reqBo) {
        PfscExtRspBaseBO rspBaseBo;
        log.debug("\u5f00\u542f\u9006\u5411\u6d41\u7a0b======" + JSON.toJSONString((Object)reqBo));
        PayPurchaseOrderInfo payPurchaseOrderInfo = this.queryPayPurchaseOrder(reqBo.getInspectionId(), reqBo.getOrderCode());
        SaleOrderInfo saleOrderInfo = this.querySaleOrder(reqBo.getInspectionId(), reqBo.getOrderCode());
        String billNotificationStatus = null;
        String billApplyStatus = null;
        BigDecimal newAmt = BigDecimal.ZERO;
        String applyNo = saleOrderInfo.getApplyNo();
        String saleOrderStatus = saleOrderInfo.getOrderStatus();
        String notificationNo = payPurchaseOrderInfo.getNotificationNo();
        String payOrderStatus = payPurchaseOrderInfo.getOrderStatus();
        log.debug("\u5f00\u7968\u901a\u77e5\u5355:{}.\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001:{}.\u5f00\u7968\u7533\u8bf7\u5355:{}.\u9500\u552e\u8ba2\u5355\u72b6\u6001:{}", new Object[]{notificationNo, payOrderStatus, applyNo, saleOrderStatus});
        PayableDetailPO po = new PayableDetailPO();
        if (StringUtils.hasText((String)notificationNo)) {
            BillNotificationInfo billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
            ValUtil.isEmpty(billNotificationInfo).exception("\u9a8c\u6536\u5355[" + reqBo.getInspectionId() + "]\u901a\u77e5\u5355[" + notificationNo + "]\u67e5\u8be2\u4e3a\u7a7a");
            ValUtil.isEmpty(billNotificationInfo.getAmt()).exception("\u9a8c\u6536\u5355[" + reqBo.getInspectionId() + "]\u901a\u77e5\u5355[" + notificationNo + "]\u91d1\u989d\u4e3a\u7a7a");
            billNotificationStatus = billNotificationInfo.getInvoiceStatus();
            newAmt = billNotificationInfo.getAmt().subtract(reqBo.getPayOrderAmt());
            log.debug("\u5f00\u7968\u901a\u77e5\u5355[{}]\u901a\u77e5\u5355\u72b6\u6001-payOrderAmt:{}.billAmt:{}.newAmt:{}.invoiceStatus:{}", new Object[]{notificationNo, reqBo.getPayOrderAmt(), billNotificationInfo.getAmt(), newAmt, billNotificationStatus});
            po.setNotificationNo(notificationNo);
        }
        if (StringUtils.hasText((String)applyNo)) {
            BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
            ValUtil.isEmpty(billApplyInfo).exception("\u9a8c\u6536\u5355[" + reqBo.getInspectionId() + "]\u901a\u77e5\u5355[" + notificationNo + "]\u67e5\u8be2\u4e3a\u7a7a");
            ValUtil.isEmpty(billApplyInfo.getAmt()).exception("\u9a8c\u6536\u5355[" + reqBo.getInspectionId() + "]\u901a\u77e5\u5355[" + notificationNo + "]\u91d1\u989d\u4e3a\u7a7a");
            billApplyStatus = billApplyInfo.getBillStatus();
            newAmt = billApplyInfo.getAmt().subtract(reqBo.getOrderAmt());
            log.debug("\u5f00\u7968\u901a\u77e5\u5355[{}]\u901a\u77e5\u5355\u72b6\u6001-orderAmt:{}.billAmt:{}.newAmt:{}.invoiceStatus:{}", new Object[]{notificationNo, reqBo.getOrderAmt(), billApplyInfo.getAmt(), newAmt, billApplyStatus});
            po.setApplyNo(applyNo);
        }
        if (NumberUtil.isLong((String)reqBo.getParentOrderId())) {
            po.setOrderId(Long.valueOf(reqBo.getParentOrderId()));
        }
        po.setPurchaseOrderCode(reqBo.getOrderCode());
        po.setPaymentType(reqBo.getPaymentType());
        if (null != reqBo.getBusiModel()) {
            po.setBusiModel(Integer.valueOf(reqBo.getBusiModel()));
        }
        log.debug("\u5e94\u4ed8\u8bb0\u5f55=====" + po.toString());
        List<PayableDetailPO> payablePO = this.payableDetailMapper.getListAndApplyDetail(po);
        log.debug("\u5e94\u4ed8\u8bb0\u5f55=====" + payablePO.toString());
        ArrayList<PayableDetailPO> fscNotificationPayable = new ArrayList<PayableDetailPO>();
        ArrayList<PayableDetailPO> fscApplyPayable = new ArrayList<PayableDetailPO>();
        ArrayList<PayableDetailPO> orderPayable = new ArrayList<PayableDetailPO>();
        for (PayableDetailPO detailPO : payablePO) {
            if (StringUtils.hasText((String)detailPO.getNotificationNo())) {
                fscNotificationPayable.add(detailPO);
                continue;
            }
            if (StringUtils.hasText((String)detailPO.getApplyNo())) {
                fscApplyPayable.add(detailPO);
                continue;
            }
            orderPayable.add(detailPO);
        }
        log.debug("\u5f00\u7968\u901a\u77e5\u5355\u5e94\u4ed8\uff1a" + ((Object)fscNotificationPayable).toString());
        log.debug("\u5f00\u7968\u7533\u8bf7\u5e94\u4ed8\uff1a" + ((Object)fscApplyPayable).toString());
        log.debug("\u8ba2\u5355\u63a8\u9001\u5e94\u4ed8\uff1a" + ((Object)orderPayable).toString());
        if (BusiModel.TRADE_MODEL.getCode().equals(reqBo.getBusiModel())) {
            if (SaleOrderPayType.BANK_RECEIVE.getCode().equals(reqBo.getPaymentType())) {
                log.debug("\u8d38\u6613\u6a21\u5f0f-\u9884\u4ed8\u6b3e===");
                if (orderPayable.size() > 0 && FscRu.isFailed((rspBaseBo = this.advanceCharge(reqBo)).getRespCode()).booleanValue()) {
                    return rspBaseBo;
                }
                this.updateBillApply(reqBo, billApplyStatus, applyNo, saleOrderStatus, newAmt);
                this.updateBillNotification(reqBo, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
            } else if (SaleOrderPayType.BILL_AGREEMENT.getCode().equals(reqBo.getPaymentType())) {
                log.debug("\u8d38\u6613\u6a21\u5f0f-\u534f\u8bae\u7ea6\u675f===");
                this.updateBillApply(reqBo, billApplyStatus, applyNo, saleOrderStatus, newAmt);
                this.updateBillNotification(reqBo, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
                this.updatePayableDetailCGForFrame(reqBo);
            } else {
                log.debug("\u8d38\u6613\u6a21\u5f0f-\u8d26\u671f===");
                if (orderPayable.size() > 0 && FscRu.isFailed((rspBaseBo = this.advanceCharge(reqBo)).getRespCode()).booleanValue()) {
                    return rspBaseBo;
                }
                if (UPDATE_TYPE_SUCCESS.equals(saleOrderInfo.getOrderCategory()) && FscRu.isFailed((rspBaseBo = this.updatePayableDetail(reqBo, fscApplyPayable, FlowFlag.RETURN_GOODS_REFUND.getCode())).getRespCode()).booleanValue()) {
                    return rspBaseBo;
                }
            }
            if (fscNotificationPayable.size() > 0) {
                this.updatePayableDetail(reqBo, fscNotificationPayable, FlowFlag.PAYABLE_REIMBURSE.getCode());
            }
            this.updateBillApply(reqBo, billApplyStatus, applyNo, saleOrderStatus, newAmt);
            this.updateBillNotification(reqBo, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
        } else if (SaleOrderPayType.BANK_RECEIVE.getCode().equals(reqBo.getPaymentType())) {
            log.debug("\u64ae\u5408\u6a21\u5f0f-\u9884\u4ed8\u6b3e===");
            if (orderPayable.size() > 0 && FscRu.isFailed((rspBaseBo = this.advanceCharge(reqBo)).getRespCode()).booleanValue()) {
                return rspBaseBo;
            }
            this.updateBillNotification(reqBo, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
            this.updateBillApply(reqBo, billApplyStatus, applyNo, saleOrderStatus, newAmt);
        } else if (SaleOrderPayType.BILL_AGREEMENT.getCode().equals(reqBo.getPaymentType())) {
            log.debug("\u64ae\u5408\u6a21\u5f0f-\u534f\u8bae\u7ea6\u675f===");
            this.updateBillNotification(reqBo, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
            this.updatePayableDetailCGForFrame(reqBo);
        } else {
            log.debug("\u64ae\u5408\u6a21\u5f0f-\u8d26\u671f===");
            if (fscNotificationPayable.size() > 0 && FscRu.isFailed((rspBaseBo = this.updatePayableDetail(reqBo, fscNotificationPayable, FlowFlag.PAYABLE_REIMBURSE.getCode())).getRespCode()).booleanValue()) {
                return rspBaseBo;
            }
            this.updateBillNotification(reqBo, billNotificationStatus, notificationNo, payOrderStatus, newAmt);
            this.updateBillApply(reqBo, billApplyStatus, applyNo, saleOrderStatus, newAmt);
        }
        rspBaseBo = new PfscExtRspBaseBO();
        rspBaseBo.setRespCode("0000");
        rspBaseBo.setRespDesc("\u9006\u5411\u6d41\u7a0b\u53d8\u66f4\u6210\u529f\uff01");
        return rspBaseBo;
    }

    private void updatePayableDetailCGForFrame(ChangeReceiptMatchReqBO reqBO) {
        log.error("\u5165\u53c2==" + JSON.toJSONString((Object)reqBO));
        List sendGoodsNoBOList = reqBO.getSendGoodsNoBOList();
        if (CollectionUtils.isEmpty((Collection)sendGoodsNoBOList)) {
            throw new PfscExtBusinessException("18000", "\u65e0\u53d1\u8d27\u5355\u53f7\u4fe1\u606f\uff01");
        }
        BigDecimal orderAmtAll = new BigDecimal(0);
        for (SendGoodsNoBO sgn : sendGoodsNoBOList) {
            PayableDetailPO payableDetailPO1;
            BigDecimal divide2;
            BigDecimal add;
            String sendGoodsNo = sgn.getSendGoodsNo();
            BigDecimal orderAmt = sgn.getOrderAmt();
            orderAmtAll = add = orderAmtAll.add(orderAmt);
            Object payableAmt = null;
            BigDecimal orderAmtDH = new BigDecimal(0);
            BigDecimal orderAmtYS = new BigDecimal(0);
            BigDecimal divide = new BigDecimal(0);
            divide = reqBO.getWarrantyRatio() == null ? new BigDecimal(0) : (divide2 = reqBO.getWarrantyRatio().divide(new BigDecimal(100), 2, 4));
            BigDecimal multiply = orderAmt.abs().multiply(divide);
            PayableDetailPO payableDetailPODH = new PayableDetailPO();
            PayableDetailPO payableDetailPOYS = new PayableDetailPO();
            PayableDetailPO payableDetailPOZB = new PayableDetailPO();
            PayableDetailPO payableDetailPOYF = new PayableDetailPO();
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            payableDetailPO.setSendGoodsNo(sendGoodsNo);
            payableDetailPOYS.setSendGoodsNo(sendGoodsNo);
            payableDetailPODH.setSendGoodsNo(sendGoodsNo);
            List<PayableDetailPO> list = this.payableDetailMapper.getList(payableDetailPO);
            ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
            applyPayInfoVO.setSendGoodsNo(sendGoodsNo);
            applyPayInfoVO.setSupplierId(null);
            List<ApplyPayInfoVO> applyPayInfoVOs = this.applyPayInfoMapper.selectListPayableDetail(applyPayInfoVO);
            ApplyPayInfoVO applyPayInfoVOByOrderCode = new ApplyPayInfoVO();
            applyPayInfoVOByOrderCode.setPurchaseOrderCode(reqBO.getOrderCode());
            applyPayInfoVOByOrderCode.setPaytableType(Integer.parseInt(PayableType.YFYF.getCode()));
            List<ApplyPayInfoVO> applyPayList = this.applyPayInfoMapper.selectListPayableDetail(applyPayInfoVOByOrderCode);
            applyPayInfoVOs.addAll(applyPayList);
            HashMap<Integer, ApplyPayInfoVO> map = new HashMap<Integer, ApplyPayInfoVO>();
            if (applyPayInfoVOs != null && applyPayInfoVOs.size() > 0) {
                for (ApplyPayInfoVO applyPayInfo : applyPayInfoVOs) {
                    map.put(applyPayInfo.getPaytableType(), applyPayInfo);
                }
            }
            BigDecimal ZBPableAmt = new BigDecimal("0");
            PayableDetailPO payableByOrderCode = new PayableDetailPO();
            payableByOrderCode.setPurchaseOrderCode(reqBO.getOrderCode());
            payableByOrderCode.setPayableType(Integer.parseInt(PayableType.YFYF.getCode()));
            List<PayableDetailPO> yfPayableList = this.payableDetailMapper.getList(payableByOrderCode);
            log.info("\u67e5\u8be2\u9884\u4ed8\u5e94\u4ed8\u8bb0\u5f55\u7ed3\u679c:" + JSON.toJSONString(yfPayableList));
            list.addAll(yfPayableList);
            if (list != null && list.size() > 0) {
                for (PayableDetailPO ppo : list) {
                    if (ppo.getPayableType().equals(2)) {
                        BeanUtils.copyProperties((Object)ppo, (Object)payableDetailPODH);
                        continue;
                    }
                    if (ppo.getPayableType().equals(3)) {
                        BeanUtils.copyProperties((Object)ppo, (Object)payableDetailPOYS);
                        continue;
                    }
                    if (ppo.getPayableType().equals(4)) {
                        BeanUtils.copyProperties((Object)ppo, (Object)payableDetailPOZB);
                        ZBPableAmt = ppo.getPayableAmt();
                        continue;
                    }
                    if (!ppo.getPayableType().equals(10)) continue;
                    BeanUtils.copyProperties((Object)ppo, (Object)payableDetailPOYF);
                }
            }
            if (payableDetailPODH.getPayableStatus() != null) {
                if (payableDetailPODH.getPayableStatus().equals(REFUNDING)) {
                    BigDecimal orderAmtDH2;
                    orderAmtDH = orderAmtDH2 = payableDetailPODH.getPayableAmt();
                } else if (payableDetailPODH.getPayableStatus().equals(REFUNDED)) {
                    throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d\uff0c\u4e0d\u80fd\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7");
                }
            }
            if (payableDetailPOYS.getPayableStatus() != null) {
                if (payableDetailPOYS.getPayableStatus().equals(REFUNDING)) {
                    BigDecimal orderAmtYS2;
                    orderAmtYS = orderAmtYS2 = payableDetailPOYS.getPayableAmt();
                } else if (payableDetailPOYS.getPayableStatus().equals(REFUNDED)) {
                    throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d\uff0c\u4e0d\u80fd\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7");
                }
            }
            log.error("\u552e\u540e\u91d1\u989d==" + orderAmt);
            log.error("\u5230\u8d27\u672a\u4ed8\u91d1\u989d==" + orderAmtDH);
            log.error("\u9a8c\u6536\u672a\u4ed8\u91d1\u989d==" + orderAmtYS);
            log.error("\u552e\u540e\u91d1\u989d*\u8d28\u4fdd\u91d1\u6bd4\u4f8b==" + multiply);
            BigDecimal trueAmt = orderAmt.subtract(orderAmtDH).subtract(orderAmtYS).subtract(multiply);
            log.error("\u5b9e\u9645\u9000\u6b3e\u91d1\u989d==" + trueAmt);
            ArrayList<PayableDetailPO> payableDetailPOs = new ArrayList<PayableDetailPO>();
            if (PayableStatus.PENDING.getCode().equals(payableDetailPOZB.getPayableStatus())) {
                PayableDetailPO payableDetailPO3 = new PayableDetailPO();
                payableDetailPO3.setSendGoodsNo(sendGoodsNo);
                payableDetailPO3.setPayableType(4);
                payableDetailPO3.setPayableAmt(ZBPableAmt.subtract(multiply));
                this.payableDetailMapper.updateSelectiveBySendGoodsNo(payableDetailPO3);
            } else if (PayableStatus.SUCCESS.getCode().equals(payableDetailPOZB.getPayableStatus())) {
                payableDetailPOZB.setRefundAmt(multiply);
                payableDetailPOs.add(payableDetailPOZB);
            }
            if (trueAmt.compareTo(BigDecimal.ZERO) == 1 || trueAmt.compareTo(BigDecimal.ZERO) == 0) {
                log.error("\u9000\u6b3e\u64cd\u4f5c\u5f00\u59cb");
                ArrayList<PayableDetailPO> truePayableDetailPOs = new ArrayList<PayableDetailPO>();
                truePayableDetailPOs.add(payableDetailPODH);
                truePayableDetailPOs.add(payableDetailPOYS);
                truePayableDetailPOs.add(payableDetailPOYF);
                for (PayableDetailPO payableDetailPO2 : truePayableDetailPOs) {
                    if (PayableStatus.PENDING.getCode().equals(payableDetailPO2.getPayableStatus()) && StrUtil.isNotBlank((CharSequence)payableDetailPO2.getSendGoodsNo())) {
                        payableDetailPO1 = new PayableDetailPO();
                        payableDetailPO1.setSendGoodsNo(payableDetailPO2.getSendGoodsNo());
                        payableDetailPO1.setPayableType(payableDetailPO2.getPayableType());
                        payableDetailPO1.setPayableAmt(new BigDecimal(0));
                        payableDetailPO1.setPayableStatus(PayableStatus.TERMINATION.getCode());
                        this.payableDetailMapper.updateSelectiveBySendGoodsNo(payableDetailPO1);
                        continue;
                    }
                    if (!PayableStatus.SUCCESS.getCode().equals(payableDetailPO2.getPayableStatus()) || trueAmt.compareTo(BigDecimal.ZERO) != 1) continue;
                    if ((trueAmt = trueAmt.subtract(payableDetailPO2.getPayableAmt())).compareTo(BigDecimal.ZERO) >= 0) {
                        payableDetailPO2.setRefundAmt(payableDetailPO2.getPayableAmt());
                    } else {
                        payableDetailPO2.setRefundAmt(payableDetailPO2.getPayableAmt().add(trueAmt));
                    }
                    payableDetailPOs.add(payableDetailPO2);
                }
                if (payableDetailPOs.size() <= 0) continue;
                Long recOrgNo = 0L;
                for (PayableDetailPO payableDetail : payableDetailPOs) {
                    boolean falg = PayMethod.ZH_BF.getCode().equals(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayMathod()) || PayMethod.ZHCQT_SF.getCode().equals(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayMathod()) || PayMethod.ZH_SF.getCode().equals(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayMathod()) || PayMethod.OFFLINE_PAY.getCode().equals(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayMathod());
                    PaymentFlowInfo record = new PaymentFlowInfo();
                    String refundNo = this.billSNService.getSn(BillType.REFUND_APPLICATION).toString();
                    String refundOrderNo = "REFUND-" + payableDetail.getPayableNo() + "-" + refundNo;
                    record.setOutOrderId(refundOrderNo);
                    record.setReturnOutOrderId("PAYMENT-" + payableDetail.getPayNo());
                    record.setPayTime(new Date());
                    record.setOrderCode(reqBO.getOrderCode());
                    record.setChildOrderCode(payableDetail.getChildPurchaseOrderCode());
                    if (!PayableType.NOTIFICATION.getCodeAsInt().equals(payableDetailPO.getPayableType()) || !BusiModel.TRADE_MODEL.getCodeAsInt().equals(payableDetailPO.getBusiModel())) {
                        record.setOrdPurchaserId(payableDetail.getPurchaserId());
                    }
                    record.setCreateUserId(reqBO.getOperatorId());
                    record.setCreateUserName(reqBO.getOperatorName());
                    record.setOrderDesc(FlowFlag.RETURN_GOODS_REFUND.getDescr());
                    record.setFlowFlag(FlowFlag.RETURN_GOODS_REFUND.getCode());
                    record.setPayName(reqBO.getRecName());
                    record.setRecName(reqBO.getPayName());
                    record.setOrderAmt(payableDetail.getRefundAmt());
                    record.setCreateTime(new Date());
                    log.error("\u7ebf\u4e0a\u7ebf\u4e0b\u9000\u6b3e\u5224\u65ad");
                    if (falg) {
                        record.setPayChannel(PayChannel.PAY_OFFLINE.getCode());
                        record.setPayType(PayMethod.OFFLINE_PAY.getCode());
                    } else {
                        OrgMerchantConfigPO orgMerchantConfigPO;
                        Long receiptOrgId = payableDetail.getSupplierId();
                        if (Integer.valueOf(BusiModel.TRADE_MODEL.getCode()).equals(payableDetail.getBusiModel())) {
                            receiptOrgId = payableDetail.getOperatorId();
                        }
                        if (null == (orgMerchantConfigPO = this.orgMerchantConfigMapper.selectByOrgId(receiptOrgId))) {
                            throw new PfscExtBusinessException("18000", "\u8bf7\u5148\u914d\u7f6e\u5546\u6237\u4fe1\u606f");
                        }
                        payableDetail.setPayNo(((ApplyPayInfoVO)map.get(payableDetail.getPayableType())).getPayno());
                        PayProRefundAbilityRspBo refundRsp = this.createRefundOrder(payableDetail, reqBO, refundOrderNo, orgMerchantConfigPO.getBusiCode());
                        log.error("\u652f\u4ed8\u4e2d\u5fc3\u8fd4\u56de\u7ed3\u679c1" + refundRsp.getResultCode());
                        record.setPayTime(new Date());
                        record.setPaymentStatus(PAY_SUCCESS);
                        record.setPaymentFlowId(refundRsp.getRefundTransId());
                    }
                    PaymentFlowInfo paymentFlowInfoOri = this.paymentFlowInfoMapper.selectByOutOrderId("PAYMENT-" + payableDetail.getPayNo());
                    if (paymentFlowInfoOri != null) {
                        record.setPayChannel(paymentFlowInfoOri.getPayChannel());
                        record.setPayType(paymentFlowInfoOri.getPayType());
                        record.setRecOrgNo(paymentFlowInfoOri.getPayOrgNo());
                        record.setPayOrgNo(paymentFlowInfoOri.getRecOrgNo());
                    }
                    if (!StringUtils.isEmpty((Object)reqBO.getFlowType())) {
                        record.setFlowType(Integer.parseInt(reqBO.getFlowType()));
                    }
                    log.debug("\u751f\u6210\u6d41\u6c34\u5165\u53c2\uff1a" + record.toString());
                    long flowId = this.paymentFlowInfoMapper.insert(record);
                    FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetail = new FscPaymentFlowInfoDetailPO();
                    fscPaymentFlowInfoDetail.setFlowId(record.getSeq());
                    fscPaymentFlowInfoDetail.setOutOrderId(record.getOutOrderId());
                    fscPaymentFlowInfoDetail.setFlowFlag(record.getFlowFlag());
                    fscPaymentFlowInfoDetail.setCreateDate(new Date());
                    this.fscPaymentFlowInfoDetailMapper.insert(fscPaymentFlowInfoDetail);
                }
                continue;
            }
            log.debug("\u76f4\u63a5\u6263\u9664\u5e94\u4ed8");
            BigDecimal newOrderAmtDH = new BigDecimal(0);
            BigDecimal newOrderAmtYS = new BigDecimal(0);
            BigDecimal bigDecimal = orderAmt.subtract(multiply).subtract(orderAmtYS);
            payableDetailPO1 = new PayableDetailPO();
            payableDetailPO1.setPayableStatus(PayableStatus.TERMINATION.getCode());
            if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                newOrderAmtYS = bigDecimal.abs();
                payableDetailPO1.setPayableStatus(PayableStatus.PENDING.getCode());
            }
            payableDetailPO1.setSendGoodsNo(payableDetailPOYS.getSendGoodsNo());
            payableDetailPO1.setPayableType(payableDetailPOYS.getPayableType());
            payableDetailPO1.setPayableAmt(newOrderAmtYS);
            payableDetailPO1.setPendingAmt(new BigDecimal(0));
            this.payableDetailMapper.updateSelectiveBySendGoodsNo(payableDetailPO1);
            if (bigDecimal.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal subtract2 = orderAmt.subtract(multiply).subtract(orderAmtYS).subtract(orderAmtDH);
            PayableDetailPO payableDetailPO2 = new PayableDetailPO();
            payableDetailPO1.setPayableStatus(PayableStatus.TERMINATION.getCode());
            if (subtract2.compareTo(BigDecimal.ZERO) < 0) {
                newOrderAmtDH = subtract2.abs();
                payableDetailPO2.setPayableStatus(PayableStatus.PENDING.getCode());
            }
            payableDetailPO2.setSendGoodsNo(payableDetailPODH.getSendGoodsNo());
            payableDetailPO2.setPayableType(payableDetailPODH.getPayableType());
            payableDetailPO2.setPayableAmt(newOrderAmtDH);
            payableDetailPO2.setPendingAmt(new BigDecimal(0));
            this.payableDetailMapper.updateSelectiveBySendGoodsNo(payableDetailPO2);
        }
    }

    private PayProRefundAbilityRspBo createRefundOrder(PayableDetailPO payableDetailPO, ChangeReceiptMatchReqBO reqBO, String refundOrderNo, String busiCode) {
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        StringBuffer payOrderNo = new StringBuffer();
        payOrderNo.append("PAYMENT-").append(payableDetailPO.getPayNo());
        payProRefundAbilityReqBo.setRefundOutOrderId(refundOrderNo);
        payProRefundAbilityReqBo.setOriOutOrderId(payOrderNo.toString());
        payProRefundAbilityReqBo.setBusiCode(busiCode);
        BigDecimal refundAmtB = payableDetailPO.getRefundAmt().multiply(new BigDecimal(100));
        payProRefundAbilityReqBo.setRefundFee(refundAmtB.setScale(0, 5).abs().toString());
        payProRefundAbilityReqBo.setNotifyUrl(this.REFUND_RESULT_CALL_BACK);
        payProRefundAbilityReqBo.setCreateOperId(String.valueOf(reqBO.getOperatorId()));
        payProRefundAbilityReqBo.setCreateOperIdName(reqBO.getOperatorName());
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableListByPayno(payableDetailPO.getPayableNo());
        if (null == applyDetails || applyDetails.size() == 0) {
            throw new PfscExtBusinessException("18000", "\u5b58\u5728\u5e94\u4ed8\u5355\u3010" + payableDetailPO.getPayableNo() + "\u3011\u672a\u67e5\u627e\u5230\u4ed8\u6b3e\u7533\u8bf7\u6210\u529f\u8bb0\u5f55\uff01");
        }
        BigDecimal paymentAmt = BigDecimal.ZERO;
        for (ApplyDetail applyDetail : applyDetails) {
            paymentAmt = paymentAmt.add(applyDetail.getAmt());
        }
        if (payableDetailPO.getRefundAmt().compareTo(paymentAmt) < 0) {
            payProRefundAbilityReqBo.setOrderType(PART_REFUND);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u652f\u4ed8\u4e2d\u5fc3\u521b\u5efa\u9000\u6b3e\u5355\u51fa\u53c2:{}", (Object)JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (!"0000".equals(payProRefundAbilityRspBo.getRespCode())) {
            log.error("\u521b\u5efa\u9000\u6b3e\u8ba2\u5355[" + payOrderNo.toString() + "]\u5931\u8d25,\uff1a" + payProRefundAbilityRspBo.getRespDesc());
            this.savelog("CreateRefundOrderService-1", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            throw new PfscExtBusinessException("18000", payProRefundAbilityRspBo.getRespDesc());
        }
        this.savelog("CreateRefundOrderService-2", JSONObject.toJSONString((Object)payProRefundAbilityReqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), JSONObject.toJSONString((Object)payProRefundAbilityRspBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return payProRefundAbilityRspBo;
    }

    private void savelog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private void updateBillApply(ChangeReceiptMatchReqBO reqBO, String billStatus, String applyNo, String saleOrderStatus, BigDecimal newAmt) {
        log.debug("\u5f00\u7968\u7533\u8bf7\u53d8\u66f4===billStatus\uff1a" + billStatus + "\uff0capplyNo\uff1a" + applyNo + "\uff0csaleOrderStatus\uff1a" + saleOrderStatus + ",\u66f4\u65b0\u91d1\u989d\uff1a" + newAmt);
        try {
            if (null == applyNo || "".equals(applyNo)) {
                if (OrderStatus.AFTER_SALE.getCode().equals(saleOrderStatus)) {
                    SaleOrderInfo saleOrderInfo1 = new SaleOrderInfo();
                    saleOrderInfo1.setSaleOrderCode(reqBO.getOrderCode());
                    saleOrderInfo1.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                    if (null != reqBO.getInspectionId()) {
                        saleOrderInfo1.setInspectionId((long)reqBO.getInspectionId());
                    }
                    log.debug("\u552e\u540e\u4e2d\u53d8\u66f4\u8ba2\u5355\u72b6\u60011===" + saleOrderInfo1.toString());
                    this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfo1);
                }
            } else if (OrderStatus.APPLIED.getCode().equals(saleOrderStatus) && BillStatus.GUAQI_APPLY.getCode().equals(billStatus)) {
                log.debug("\u8ba2\u5355\u72b6\u6001\uff1a" + OrderStatus.APPLIED.getDescr() + ",\u5f00\u7968\u7533\u8bf7\u5355\u72b6\u6001\uff1a" + BillStatus.GUAQI_APPLY.getDescr());
                BillApplyInfo record = new BillApplyInfo();
                record.setBillStatus(BillStatus.NO_APPLY.getCode());
                record.setApplyNo(applyNo);
                record.setAmt(newAmt);
                log.debug("\u53d8\u66f4\u5f00\u7968\u7533\u8bf7\u72b6\u60012===" + record.toString());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(record);
            } else if (OrderStatus.SEND_BILL.getCode().equals(saleOrderStatus) && BillStatus.SEND_BILL.getCode().equals(billStatus)) {
                log.debug("\u8ba2\u5355\u72b6\u6001\uff1a" + OrderStatus.SEND_BILL.getDescr() + ",\u5f00\u7968\u7533\u8bf7\u5355\u72b6\u6001\uff1a" + BillStatus.SEND_BILL.getDescr());
                BillApplyInfo record = new BillApplyInfo();
                record.setRedMarkRefund(1);
                record.setApplyNo(applyNo);
                record.setRemark("\u9000\u7968\u7ea2\u51b2");
                log.debug("\u53d8\u66f4\u5f00\u7968\u7533\u8bf7\u72b6\u60013===" + record.toString());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(record);
            } else if (OrderStatus.RECEIVE_BILL.getCode().equals(saleOrderStatus) && BillStatus.SIGNED_IN.getCode().equals(billStatus)) {
                log.debug("\u8ba2\u5355\u72b6\u6001\uff1a" + OrderStatus.RECEIVE_BILL.getDescr() + ",\u5f00\u7968\u7533\u8bf7\u5355\u72b6\u6001\uff1a" + BillStatus.SIGNED_IN.getDescr());
                BillApplyInfo record = new BillApplyInfo();
                record.setRedMarkRefund(1);
                record.setApplyNo(applyNo);
                record.setRemark("\u9000\u7968\u7ea2\u51b2");
                log.debug("\u53d8\u66f4\u5f00\u7968\u7533\u8bf7\u72b6\u60014===" + record.toString());
                this.billApplyInfoMapper.updateByPrimaryKeySelective(record);
            }
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\uff1a" + reqBO.getOrderCode() + "\u53d8\u66f4\u5f00\u7968\u7533\u8bf7\u5f02\u5e38\uff01");
        }
    }

    private PfscExtRspBaseBO updatePayableDetail(ChangeReceiptMatchReqBO reqBO, List<PayableDetailPO> payableDetailPO, String flowFlag) {
        PfscExtRspBaseBO rspBaseBO = new PfscExtRspBaseBO();
        log.debug("\u5e94\u4ed8\u53d8\u66f4====s" + reqBO.toString());
        log.debug("\u5e94\u4ed8\u8bb0\u5f55=====" + payableDetailPO.toString());
        for (PayableDetailPO po : payableDetailPO) {
            if (new BigDecimal("0").compareTo(po.getPendingAmt()) != 0) {
                throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d\uff0c\u4e0d\u80fd\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7");
            }
            PayableDetailPO po1 = new PayableDetailPO();
            po1.setPayableNo(po.getPayableNo());
            BigDecimal noAmt = po.getPayableAmt().subtract(po.getPaidAmt()).subtract(po.getPendingAmt());
            if (PayableType.APPLY.getCode().equals(po.getPayableType().toString())) {
                if (PayableStatus.PAYING.getCode().equals(po.getPayableStatus()) || PayableStatus.PENDING.getCode().equals(po.getPayableStatus())) {
                    po1.setPayableAmt(po.getPayableAmt().subtract(reqBO.getOrderAmt()));
                    po1.setOrderAmt(po.getOrderAmt().subtract(reqBO.getOrderAmt()));
                }
                PaymentFlowInfo record = new PaymentFlowInfo();
                if (noAmt.compareTo(reqBO.getOrderAmt()) < 0) {
                    po1.setPayableStatus(PayableStatus.TERMINATION.getCode());
                    String refundOrderNo = "REFUND-" + po.getApplyNo();
                    record.setOutOrderId(refundOrderNo);
                    record.setReturnOutOrderId(refundOrderNo);
                    record.setPayTime(new Date());
                    record.setOrderCode(reqBO.getOrderCode());
                    record.setChildOrderCode(po.getChildPurchaseOrderCode());
                    if (!PayableType.NOTIFICATION.getCodeAsInt().equals(po.getPayableType()) || !BusiModel.TRADE_MODEL.getCodeAsInt().equals(po.getBusiModel())) {
                        record.setOrdPurchaserId(po.getPurchaserId());
                    }
                    record.setOrderAmt(reqBO.getOrderAmt());
                    record.setCreateUserId(reqBO.getOperatorId());
                    record.setCreateUserName(reqBO.getOperatorName());
                    record.setOrderDesc(FlowFlag.RETURN_GOODS_REFUND.getDescr());
                    record.setPayName(reqBO.getRecName());
                    record.setRecName(reqBO.getPayName());
                    record.setFlowFlag(REFUNDED);
                    record.setPayChannel(PayChannel.PAY_OFFLINE.getCode());
                    record.setPayType(PayMethod.OFFLINE_PAY.getCode());
                }
                long flowId = this.paymentFlowInfoMapper.insertSelective(record);
                FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetail = new FscPaymentFlowInfoDetailPO();
                fscPaymentFlowInfoDetail.setFlowId(record.getSeq());
                fscPaymentFlowInfoDetail.setOutOrderId(record.getOutOrderId());
                fscPaymentFlowInfoDetail.setFlowFlag(record.getFlowFlag());
                fscPaymentFlowInfoDetail.setCreateDate(new Date());
                this.fscPaymentFlowInfoDetailMapper.insert(fscPaymentFlowInfoDetail);
            }
            if (PayableType.NOTIFICATION.getCode().equals(po.getPayableType().toString())) {
                if (new BigDecimal("0").compareTo(po.getPendingAmt()) != 0) {
                    throw new PfscExtBusinessException("18000", "\u5b58\u5728\u4ed8\u6b3e\u4e2d\u7684\u91d1\u989d\uff0c\u4e0d\u80fd\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7");
                }
                ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
                applyPayInfoVO.setNotificationNo(po.getNotificationNo());
                List<ApplyPayInfoVO> applyPayInfoVOs = this.applyPayInfoMapper.selectListPayableDetail(applyPayInfoVO);
                BigDecimal olineAmt = new BigDecimal("0");
                for (ApplyPayInfoVO applyPayInfo : applyPayInfoVOs) {
                    boolean falg = PayMethod.ZH_BF.getCode().equals(applyPayInfo.getPayMathod()) || PayMethod.ZHCQT_SF.getCode().equals(applyPayInfo.getPayMathod()) || PayMethod.ZH_SF.getCode().equals(applyPayInfo.getPayMathod()) || PayMethod.OFFLINE_PAY.getCode().equals(applyPayInfo.getPayChannel());
                    if (falg) continue;
                    olineAmt = olineAmt.add(applyPayInfo.getPayAmt());
                }
                if (PayableStatus.PENDING.getCode().equals(po.getPayableStatus()) || PayableStatus.PAYING.getCode().equals(po.getPayableStatus())) {
                    po1.setPayableAmt(po.getPayableAmt().subtract(reqBO.getPayOrderAmt()));
                    po1.setOrderAmt(po.getOrderAmt().subtract(reqBO.getPayOrderAmt()));
                }
                if (noAmt.compareTo(reqBO.getPayOrderAmt()) < 0) {
                    po1.setPayableStatus(PayableStatus.TERMINATION.getCode());
                    BigDecimal mulpAmt = reqBO.getPayOrderAmt().subtract(noAmt);
                    PayableDetailPO newPO = new PayableDetailPO();
                    BeanUtils.copyProperties((Object)po, (Object)newPO);
                    String snNo = this.fscCreatePayableNoService.createPayableNo("SH");
                    newPO.setPayableNo(snNo);
                    newPO.setPayableType(Integer.valueOf(PayableType.SHYF.getCode()));
                    newPO.setPendingAmt(BigDecimal.ZERO);
                    newPO.setPaidAmt(BigDecimal.ZERO);
                    newPO.setPurchaseOrderCode(reqBO.getOrderCode());
                    newPO.setCreateDate(new Date());
                    newPO.setPayableStatus(PayableStatus.PENDING.getCode());
                    log.debug("\u771f\u6b63\u9000\u6b3e\u91d1\u989d\uff1a" + mulpAmt);
                    if (mulpAmt.compareTo(olineAmt) >= 0) {
                        newPO.setPayableAmt(olineAmt);
                        PaymentFlowInfo record = new PaymentFlowInfo();
                        String refundOrderNo = "REFUND-" + po.getPayNo();
                        record.setOutOrderId(refundOrderNo);
                        record.setReturnOutOrderId(refundOrderNo);
                        record.setPayTime(new Date());
                        record.setOrderCode(reqBO.getOrderCode());
                        record.setChildOrderCode(po.getChildPurchaseOrderCode());
                        if (!PayableType.NOTIFICATION.getCodeAsInt().equals(po.getPayableType()) || !BusiModel.TRADE_MODEL.getCodeAsInt().equals(po.getBusiModel())) {
                            record.setOrdPurchaserId(po.getPurchaserId());
                        }
                        record.setOrderAmt(reqBO.getOrderAmt());
                        record.setCreateUserId(reqBO.getOperatorId());
                        record.setCreateUserName(reqBO.getOperatorName());
                        record.setOrderDesc(FlowFlag.RETURN_GOODS_REFUND.getDescr());
                        record.setPayName(reqBO.getRecName());
                        record.setRecName(reqBO.getPayName());
                        record.setFlowFlag(REFUNDED);
                        record.setPayChannel(PayChannel.PAY_OFFLINE.getCode());
                        record.setPayType(PayMethod.OFFLINE_PAY.getCode());
                        record.setOrderAmt(mulpAmt.subtract(olineAmt));
                        long flowId = this.paymentFlowInfoMapper.insertSelective(record);
                        FscPaymentFlowInfoDetailPO fscPaymentFlowInfoDetail = new FscPaymentFlowInfoDetailPO();
                        fscPaymentFlowInfoDetail.setFlowId(record.getSeq());
                        fscPaymentFlowInfoDetail.setOutOrderId(record.getOutOrderId());
                        fscPaymentFlowInfoDetail.setFlowFlag(record.getFlowFlag());
                        fscPaymentFlowInfoDetail.setCreateDate(new Date());
                        this.fscPaymentFlowInfoDetailMapper.insert(fscPaymentFlowInfoDetail);
                    } else {
                        newPO.setPayableAmt(mulpAmt);
                    }
                    log.debug("\u751f\u6210\u552e\u540e\u5e94\u4ed8====" + newPO.toString());
                    this.payableDetailMapper.insert(newPO);
                }
            }
            if (noAmt.compareTo(reqBO.getOrderAmt()) == 0) {
                po1.setPayableStatus(PayableStatus.TERMINATION.getCode());
            }
            if (!PayableStatus.PAYING.getCode().equals(po.getPayableStatus()) && !PayableStatus.PENDING.getCode().equals(po.getPayableStatus())) continue;
            this.payableDetailMapper.updateByPayableNo(po1);
        }
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u5e94\u4ed8\u8bb0\u5f55\u53d8\u66f4\u6210\u529f\uff01");
        return rspBaseBO;
    }

    private void updateBillNotification(ChangeReceiptMatchReqBO reqBO, String invoiceStatus, String notificationNo, String payOrderStatus, BigDecimal newAmt) {
        log.debug("\u5f00\u7968\u901a\u77e5\u5355\u53d8\u66f4====notificationNo\uff1a" + notificationNo + "\uff0cinvoiceStatus\uff1a" + invoiceStatus + "\uff0cpayOrderStatus\uff1a" + payOrderStatus + "\uff0c\u66f4\u65b0\u91d1\u989d\uff1a" + newAmt);
        try {
            if (null == notificationNo || "".equals(notificationNo)) {
                if (OrderStatus.HANGING.getCode().equals(payOrderStatus)) {
                    PayPurchaseOrderInfo orderRecord = new PayPurchaseOrderInfo();
                    orderRecord.setPurchaseOrderCode(reqBO.getOrderCode());
                    orderRecord.setOrderStatus(OrderStatus.NO_APPLY.getCode());
                    if (null != reqBO.getInspectionId()) {
                        orderRecord.setInspectionId((long)reqBO.getInspectionId());
                    }
                    this.payPurchaseOrderInfoMapper.updateByPrimaryKeySelective(orderRecord);
                }
            } else {
                BillNotificationInfo billRecord = new BillNotificationInfo();
                billRecord.setNotificationNo(notificationNo);
                if (OrderStatus.APPLIED.getCode().equals(payOrderStatus) && NotificationInvoiceStatus.HANGING.getCode().equals(invoiceStatus)) {
                    billRecord.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
                    billRecord.setAmt(newAmt);
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(billRecord);
                } else if (OrderStatus.SEND_BILL.getCode().equals(payOrderStatus) && NotificationInvoiceStatus.HAS_MAKE.getCode().equals(invoiceStatus)) {
                    billRecord.setRedMarkRefund(1);
                    billRecord.setRemark("\u9000\u7968\u7ea2\u51b2\u6807\u8bb0");
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(billRecord);
                } else if (OrderStatus.RECEIVE_BILL.getCode().equals(payOrderStatus) && NotificationInvoiceStatus.RECEIVED.getCode().equals(invoiceStatus)) {
                    billRecord.setRedMarkRefund(1);
                    billRecord.setRemark("\u9000\u7968\u7ea2\u51b2\u6807\u8bb0");
                    this.billNotificationInfoMapper.updateByPrimaryKeySelective(billRecord);
                }
            }
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u7f16\u53f7\uff1a" + reqBO.getOrderCode() + "\u53d8\u66f4\u5f00\u7968\u901a\u77e5\u8bb0\u5f55\u5f02\u5e38\uff01");
        }
    }

    private PfscExtRspBaseBO advanceCharge(ChangeReceiptMatchReqBO reqBO) {
        PfscExtRspBaseBO rspBaseBO = new PfscExtRspBaseBO();
        log.debug("\u9884\u4ed8\u6b3e\u652f\u4ed8-\u5165\u53c2====" + reqBO.toString());
        reqBO.setOperType("SUBMIT");
        FscRefundOrderOperRspBO rspBO = this.refundOrderOperService.makeRefund(reqBO);
        rspBaseBO.setRespCode(rspBO.getRespCode());
        rspBaseBO.setRespDesc(rspBO.getRespDesc());
        return rspBaseBO;
    }

    private SaleOrderInfo querySaleOrder(Long inspectionId, String orderCode) {
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setSaleOrderCode(orderCode);
        saleOrderInfo.setInspectionId(inspectionId);
        saleOrderInfo = this.saleOrderInfoMapper.getModelBy2(saleOrderInfo);
        if (null == saleOrderInfo) {
            throw new PfscExtBusinessException("18000", "\u9500\u552e\u8ba2\u5355[" + orderCode + "]\u4e0d\u5b58\u5728");
        }
        if (null == saleOrderInfo.getOrderAmt()) {
            throw new PfscExtBusinessException("18000", "\u9500\u552e\u8ba2\u5355[" + orderCode + "]\u5bf9\u5e94\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
        }
        return saleOrderInfo;
    }

    private PayPurchaseOrderInfo queryPayPurchaseOrder(Long inspectionId, String orderCode) {
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        payPurchaseOrderInfo.setPurchaseOrderCode(orderCode);
        payPurchaseOrderInfo.setInspectionId(inspectionId);
        payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelBy(payPurchaseOrderInfo);
        if (null == payPurchaseOrderInfo) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u8ba2\u5355[" + orderCode + "]\u4e0d\u5b58\u5728");
        }
        if (null == payPurchaseOrderInfo.getOrderAmt()) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u8ba2\u5355[" + orderCode + "]\u5bf9\u5e94\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
        }
        return payPurchaseOrderInfo;
    }
}

