/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.FscAutoInvoiceConfigQueryBusiService;
import com.tydic.pfscext.api.busi.bo.FscAutoInvoiceConfigQueryBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscAutoInvoiceConfigQueryBusiRspBO;
import com.tydic.pfscext.dao.AutoInvoiceConfigMapper;
import com.tydic.pfscext.dao.FscNotificationPurchaseExceptMapper;
import com.tydic.pfscext.dao.po.AutoInvoiceConfigInfo;
import com.tydic.pfscext.dao.po.FscNotificationPurchaseExceptPO;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.FscAutoInvoiceConfigQueryBusiService"})
public class FscAutoInvoiceConfigQueryBusiServiceImpl
implements FscAutoInvoiceConfigQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAutoInvoiceConfigQueryBusiServiceImpl.class);
    @Resource
    private AutoInvoiceConfigMapper autoInvoiceConfigMapper;
    @Resource
    private FscNotificationPurchaseExceptMapper fscNotificationPurchaseExceptMapper;

    @PostMapping(value={"queryAutoInvoiceConfig"})
    public FscAutoInvoiceConfigQueryBusiRspBO queryAutoInvoiceConfig(@RequestBody FscAutoInvoiceConfigQueryBusiReqBO reqBo) {
        ValUtil.isEmpty(reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getConfigId()).exception("\u5165\u53c2[configId]\u4e0d\u80fd\u4e3a\u7a7a");
        AutoInvoiceConfigInfo configInfo = this.autoInvoiceConfigMapper.queryAutoInvoiceConfigInfoById(reqBo.getConfigId());
        ValUtil.isEmpty(configInfo).exception("\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
        FscAutoInvoiceConfigQueryBusiRspBO rspBo = FscRu.success(FscAutoInvoiceConfigQueryBusiRspBO.class);
        BeanUtils.copyProperties((Object)configInfo, (Object)rspBo);
        if ("1".equals(configInfo.getConfigType()) && reqBo.getConfigOrgId() != null) {
            FscNotificationPurchaseExceptPO exceptPo = new FscNotificationPurchaseExceptPO();
            exceptPo.setConfigId(configInfo.getConfigId());
            exceptPo.setPurchaseNo(reqBo.getConfigOrgId());
            exceptPo = this.fscNotificationPurchaseExceptMapper.getModelBy(exceptPo);
            if (exceptPo != null) {
                rspBo.setExceptionFlag(YesNo.YES.getCode());
                rspBo.setExceptionConfigStatus(exceptPo.getStatus());
                rspBo.setExceptionInvoiceDay(exceptPo.getInvoiceDay());
                rspBo.setExceptionTakeUpInvoice(exceptPo.getTakeUpInvoice());
            } else {
                rspBo.setExceptionFlag(YesNo.NO.getCode());
            }
        }
        return rspBo;
    }
}

