/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.pfscext.api.busi.FscCreatePayableNoService;
import com.tydic.pfscext.dao.PayableDetailMapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscCreatePayableNoServiceImpl
implements FscCreatePayableNoService {
    private static final Logger log = LoggerFactory.getLogger(FscCreatePayableNoServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private CacheClient cacheClient;
    private static final String PAYABLE_NO_KEY = "payableNo";

    public String createPayableNoByType(Integer payableType) {
        return this.getPayableNo(payableType);
    }

    public String createPayableNo(String prefix) {
        return this.getPayInfoId(prefix);
    }

    private synchronized String getPayInfoId(String prefix) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String dateL = Long.valueOf(df.format(new Date())).toString();
        StringBuilder sb = new StringBuilder();
        String num = "0001";
        String cacheKey = prefix + PAYABLE_NO_KEY;
        if (null == this.cacheClient.get(cacheKey)) {
            String maxNum = this.payableDetailMapper.selectMaxPayNoNumByLength(prefix + dateL, String.valueOf(prefix.length()));
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
        } else {
            String oldNo = this.cacheClient.get(cacheKey).toString();
            log.debug("\u539f\u5e94\u4ed8\u5355\u53f7oldNo:{}", (Object)oldNo);
            if (oldNo.contains(dateL)) {
                num = oldNo.substring(oldNo.length() - 4);
                log.debug("\u539f\u5e94\u4ed8\u5355\u53f7\u622a\u53d6\u672b\u5c3e4\u4f4d:{}", (Object)num);
                num = String.format("%04d", Integer.parseInt(num) + 1);
                log.debug("\u65b0\u5e94\u4ed8\u5355\u53f7\u672b\u5c3e4\u4f4d:{}", (Object)num);
            }
        }
        sb.append(prefix).append(dateL).append(num);
        this.cacheClient.set(cacheKey, (Object)sb.toString(), 86400);
        log.debug("\u751f\u6210\u5e94\u4ed8\u5355\u53f7:{}", (Object)sb.toString());
        return sb.toString();
    }

    public String getPayableNo(Integer payableType) {
        String prefix = "CG";
        if (payableType == 2) {
            prefix = "DH";
        } else if (payableType == 3) {
            prefix = "YS";
        } else if (payableType == 4) {
            prefix = "ZB";
        } else if (payableType == 8) {
            prefix = "SH";
        } else if (payableType == 9) {
            prefix = "YFYS";
        } else if (payableType == 10) {
            prefix = "YF";
        } else if (payableType == 11) {
            prefix = "RY";
        } else if (payableType == 12) {
            prefix = "SF";
        }
        return this.getPayInfoId(prefix);
    }
}

