/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.order.extend.bo.saleorder.PebExtUocOrderTypeQryInfoBO;
import com.tydic.order.extend.bo.saleorder.PebExtUocOrderTypeStakeholderInfoBO;
import com.tydic.order.pec.ability.bo.UocPenaltyQueryRspBO;
import com.tydic.pfscext.constants.FscConstants;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.FscPayableDetailOverduePenaltyChangeMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.dao.po.FscPayableDetailOverduePenaltyChangePO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.PayableDetailVO;
import com.tydic.pfscext.enums.BillApplyInfoStatus;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.FscPayCreditControlTag;
import com.tydic.pfscext.enums.FscPayCreditWarningTag;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.umc.api.FscUmcQryAccountListExternalService;
import com.tydic.pfscext.external.uoc.api.FscPebExtUocOrderTypeQryExternalService;
import com.tydic.pfscext.external.uoc.api.FscUocOrderCreditInfoStatisticsQryExternalService;
import com.tydic.pfscext.external.uoc.api.FscUocPenaltyQueryExternalService;
import com.tydic.pfscext.external.uoc.bo.FscPebExtUocOrderTypeQryExternalReqBO;
import com.tydic.pfscext.external.uoc.bo.FscPebExtUocOrderTypeQryExternalRspBO;
import com.tydic.pfscext.external.uoc.bo.FscUocOrderCreditInfoStatisticsQryExternalReqBO;
import com.tydic.pfscext.external.uoc.bo.FscUocOrderCreditInfoStatisticsQryExternalRspBO;
import com.tydic.pfscext.external.uoc.bo.FscUocPenaltyQueryExternalReqBO;
import com.tydic.pfscext.external.uoc.bo.FscUocPenaltyQueryExternalRspBO;
import com.tydic.pfscext.service.atom.FscExtInterLogAtomService;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogAtomReqBO;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.FscCreditControlUserOverdueBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlLogBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlLogPayConfigBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserInspectionBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserInspectionBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserOverdueBusiReqBO;
import com.tydic.pfscext.service.comb.bo.FscUserOverdueInfoBO;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscCreditControlBusiServiceImpl
implements FscCreditControlBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCreditControlBusiServiceImpl.class);
    @Resource
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private FscPayableDetailOverduePenaltyChangeMapper fscPayableDetailOverduePenaltyChangeMapper;
    @Autowired
    private FscUocPenaltyQueryExternalService fscUocPenaltyQueryExternalService;
    @Autowired
    private FscCreditControlUserOverdueBusiService fscCreditControlUserOverdueBusiService;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private FscExtInterLogAtomService fscExtInterLogAtomService;
    @Resource(name="fscPayConfigSaveProvider")
    private ProxyMessageProducer fscPayConfigSaveProvider;
    @Value(value="${FSC_PAY_CONFIG_SAVE_TOPIC:FSC_PAY_CONFIG_SAVE_TOPIC}")
    private String FSC_PAY_CONFIG_SAVE_TOPIC;
    @Value(value="${FSC_PAY_CONFIG_SAVE_TAG:*}")
    private String FSC_PAY_CONFIG_SAVE_TAG;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private FscUmcQryAccountListExternalService fscUmcQryAccountListExternalService;
    @Autowired
    private FscUocOrderCreditInfoStatisticsQryExternalService fscUocOrderCreditInfoStatisticsQryExternalService;
    @Autowired
    private FscPebExtUocOrderTypeQryExternalService fscPebExtUocOrderTypeQryExternalService;

    @Override
    public FscCreditControlBusiRspBO dealCreditControl(FscCreditControlBusiReqBO reqBo) {
        ValUtil.isEmpty((Object)reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getPayConfigId()).exception("\u652f\u4ed8\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigPO fscPayConfigOld = new FscPayConfigPO();
        fscPayConfigOld.setPayConfigId(reqBo.getPayConfigId());
        fscPayConfigOld = this.fscPayConfigMapper.getModelBy(fscPayConfigOld);
        if (fscPayConfigOld == null) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
        }
        if (!YesOrNo.YES.getCode().equals(fscPayConfigOld.getPayUsedPeriodFlag())) {
            throw new PfscExtBusinessException("18000", "\u8be5\u652f\u4ed8\u914d\u7f6e\u672a\u914d\u7f6e\u8fc7\u6388\u4fe1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u540e\u518d\u4f7f\u7528\u6388\u4fe1");
        }
        if (!FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigOld.getPayConfigType()) && !FscPayConfigType.DEF.getCode().equals(fscPayConfigOld.getPayConfigType())) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u7ed3\u679c\u9519\u8bef\uff0c\u4e0d\u662f\u5355\u4f4d\u652f\u4ed8\u914d\u7f6e");
        }
        FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
        fscPayConfigUpdate.setPayConfigId(fscPayConfigOld.getPayConfigId());
        List currentOrgControlTagListOld = JSON.parseArray((String)Optional.ofNullable(fscPayConfigOld.getCurrentOrgControlTag()).orElse("[]"), String.class);
        HashSet<String> currentOrgControlTagList = new HashSet<String>(currentOrgControlTagListOld);
        List currentOrgWarningTagListOld = JSON.parseArray((String)Optional.ofNullable(fscPayConfigOld.getCurrentOrgWarningTag()).orElse("[]"), String.class);
        HashSet<String> currentOrgWarningTagList = new HashSet<String>(currentOrgWarningTagListOld);
        log.warn("\u5386\u53f2\u6388\u4fe1\u9884\u8b66\u6807\u7b7e\uff1a{}.\u5386\u53f2\u6388\u4fe1\u7ba1\u63a7\u6807\u7b7e\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", new Object[]{currentOrgWarningTagList, currentOrgControlTagList, reqBo.getPayConfigId()});
        String currentOrgControlReason = "";
        StringJoiner joiner = new StringJoiner(",");
        BigDecimal creditAmount = Optional.ofNullable(fscPayConfigOld.getCreditAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedAmount = Optional.ofNullable(fscPayConfigOld.getUsedAmount()).orElse(BigDecimal.ZERO);
        BigDecimal usedWarningAmount = Optional.ofNullable(fscPayConfigOld.getUsedWarningAmount()).orElse(BigDecimal.ZERO);
        log.debug("\u6388\u4fe1\u989d\u5ea6\uff1a{}.\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\uff1a{}.\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u9884\u8b66\u503c\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", new Object[]{creditAmount, usedAmount, usedWarningAmount, reqBo.getPayConfigId()});
        if (usedAmount.compareTo(BigDecimal.ZERO) >= 0) {
            if (usedAmount.compareTo(usedWarningAmount) >= 0) {
                currentOrgWarningTagList.add(FscPayCreditWarningTag.WARNING_QUOTA.getCode());
                if (!currentOrgWarningTagListOld.contains(FscPayCreditWarningTag.WARNING_QUOTA.getCode())) {
                    currentOrgControlReason = "\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u8d85\u8fc7\u9884\u8b66\u503c";
                    joiner.add(currentOrgControlReason);
                    log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                }
            } else {
                currentOrgWarningTagList.remove(FscPayCreditWarningTag.WARNING_QUOTA.getCode());
                if (currentOrgWarningTagListOld.contains(FscPayCreditWarningTag.WARNING_QUOTA.getCode())) {
                    currentOrgControlReason = "\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4f4e\u4e8e\u9884\u8b66\u503c";
                    joiner.add(currentOrgControlReason);
                    log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                }
            }
            if (usedAmount.compareTo(creditAmount) >= 0) {
                currentOrgControlTagList.add(FscPayCreditControlTag.CONTROL_QUOTA.getCode());
                currentOrgWarningTagList.remove(FscPayCreditWarningTag.WARNING_QUOTA.getCode());
                if (!currentOrgControlTagListOld.contains(FscPayCreditControlTag.CONTROL_QUOTA.getCode())) {
                    currentOrgControlReason = "\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u8d85\u8fc7\u6388\u4fe1\u989d\u5ea6";
                    joiner.add(currentOrgControlReason);
                    log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                }
            } else {
                currentOrgControlTagList.remove(FscPayCreditControlTag.CONTROL_QUOTA.getCode());
                if (currentOrgControlTagListOld.contains(FscPayCreditControlTag.CONTROL_QUOTA.getCode())) {
                    currentOrgControlReason = "\u5df2\u7528\u6388\u4fe1\u989d\u5ea6\u4f4e\u4e8e\u6388\u4fe1\u989d\u5ea6";
                    joiner.add(currentOrgControlReason);
                    log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                }
            }
            BigDecimal currentOverdueAmount = Optional.ofNullable(fscPayConfigOld.getCurrentOverdueAmount()).orElse(BigDecimal.ZERO);
            log.debug("\u903e\u671f\u91d1\u989d\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOverdueAmount, (Object)reqBo.getPayConfigId());
            if (currentOverdueAmount.compareTo(BigDecimal.ZERO) >= 0) {
                BigDecimal currentOverdueRatio = BigDecimal.ZERO;
                if (usedAmount.compareTo(BigDecimal.ZERO) > 0) {
                    currentOverdueRatio = currentOverdueAmount.divide(usedAmount, 5, RoundingMode.HALF_UP);
                }
                fscPayConfigUpdate.setCurrentOverdueRatio(currentOverdueRatio);
                BigDecimal overdueWarningRatio = Optional.ofNullable(fscPayConfigOld.getOverdueWarningRatio()).orElse(BigDecimal.ZERO);
                BigDecimal overdueControlRatio = Optional.ofNullable(fscPayConfigOld.getOverdueControlRatio()).orElse(BigDecimal.ZERO);
                BigDecimal overdueRecoveryRatio = Optional.ofNullable(fscPayConfigOld.getOverdueRecoveryRatio()).orElse(BigDecimal.ZERO);
                BigDecimal overdueStartAmount = Optional.ofNullable(fscPayConfigOld.getOverdueStartAmount()).orElse(BigDecimal.ZERO);
                log.debug("\u903e\u671f\u8d77\u7b97\u91d1\u989d\uff1a{}.\u5f53\u524d\u903e\u671f\u5360\u6bd4\uff1a{}.\u903e\u671f\u8b66\u544a\u5360\u6bd4\uff1a{}.\u903e\u671f\u7ba1\u63a7\u5360\u6bd4\uff1a{}.\u903e\u671f\u6062\u590d\u5360\u6bd4:{}.\u652f\u4ed8\u914d\u7f6eID\uff1a{}", new Object[]{overdueStartAmount, currentOverdueRatio, overdueWarningRatio, overdueControlRatio, overdueRecoveryRatio, reqBo.getPayConfigId()});
                if (currentOverdueRatio.compareTo(BigDecimal.ZERO) >= 0) {
                    if (currentOverdueAmount.compareTo(overdueStartAmount) < 0) {
                        currentOrgWarningTagList.remove(FscPayCreditWarningTag.WARNING_OVERDUE_RATIO.getCode());
                        currentOrgControlTagList.remove(FscPayCreditControlTag.CONTROL_OVERDUE_RATIO.getCode());
                        if (currentOrgWarningTagListOld.contains(FscPayCreditWarningTag.WARNING_OVERDUE_RATIO.getCode()) || currentOrgControlTagListOld.contains(FscPayCreditControlTag.CONTROL_OVERDUE_RATIO.getCode())) {
                            currentOrgControlReason = "\u903e\u671f\u91d1\u989d\u4f4e\u4e8e\u903e\u671f\u7ba1\u63a7\u8d77\u7b97\u91d1\u989d";
                            joiner.add(currentOrgControlReason);
                            log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                        }
                    } else {
                        if (currentOverdueRatio.compareTo(overdueWarningRatio) >= 0) {
                            currentOrgWarningTagList.add(FscPayCreditWarningTag.WARNING_OVERDUE_RATIO.getCode());
                            if (!currentOrgWarningTagListOld.contains(FscPayCreditWarningTag.WARNING_OVERDUE_RATIO.getCode())) {
                                currentOrgControlReason = "\u903e\u671f\u5360\u6bd4\u8d85\u8fc7\u9884\u8b66\u503c";
                                joiner.add(currentOrgControlReason);
                                log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                            }
                        } else {
                            currentOrgWarningTagList.remove(FscPayCreditWarningTag.WARNING_OVERDUE_RATIO.getCode());
                            if (currentOrgWarningTagListOld.contains(FscPayCreditWarningTag.WARNING_OVERDUE_RATIO.getCode())) {
                                currentOrgControlReason = "\u903e\u671f\u5360\u6bd4\u4f4e\u4e8e\u9884\u8b66\u9608\u503c";
                                joiner.add(currentOrgControlReason);
                                log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                            }
                        }
                        if (currentOverdueRatio.compareTo(overdueControlRatio) >= 0) {
                            currentOrgWarningTagList.remove(FscPayCreditWarningTag.WARNING_OVERDUE_RATIO.getCode());
                            currentOrgControlTagList.add(FscPayCreditControlTag.CONTROL_OVERDUE_RATIO.getCode());
                            if (!currentOrgControlTagListOld.contains(FscPayCreditControlTag.CONTROL_OVERDUE_RATIO.getCode())) {
                                currentOrgControlReason = "\u903e\u671f\u5360\u6bd4\u8d85\u8fc7\u7ba1\u63a7\u9608\u503c";
                                joiner.add(currentOrgControlReason);
                                log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                            }
                        }
                        if (currentOverdueRatio.compareTo(overdueRecoveryRatio) <= 0) {
                            currentOrgControlTagList.remove(FscPayCreditControlTag.CONTROL_OVERDUE_RATIO.getCode());
                            if (currentOrgControlTagListOld.contains(FscPayCreditControlTag.CONTROL_OVERDUE_RATIO.getCode())) {
                                currentOrgControlReason = "\u903e\u671f\u5360\u6bd4\u4f4e\u4e8e\u6062\u590d\u9608\u503c";
                                joiner.add(currentOrgControlReason);
                                log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                            }
                        }
                    }
                }
                BigDecimal currentOverdueIndex = Optional.ofNullable(fscPayConfigOld.getCurrentOverdueIndex()).orElse(BigDecimal.ZERO);
                BigDecimal overdueWarningIndex = Optional.ofNullable(fscPayConfigOld.getOverdueWarningIndex()).orElse(BigDecimal.ZERO);
                BigDecimal overdueControlIndex = Optional.ofNullable(fscPayConfigOld.getOverdueControlIndex()).orElse(BigDecimal.ZERO);
                BigDecimal overdueRecoveryIndex = Optional.ofNullable(fscPayConfigOld.getOverdueRecoveryIndex()).orElse(BigDecimal.ZERO);
                log.debug("\u5f53\u524d\u7d2f\u8ba1\u903e\u671f\u6307\u6570\uff1a{}.\u903e\u671f\u8b66\u544a\u6307\u6570\uff1a{}.\u903e\u671f\u7ba1\u63a7\u6307\u6570\uff1a{}.\u903e\u671f\u6062\u590d\u6307\u6570:{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", new Object[]{currentOverdueIndex, overdueWarningIndex, overdueControlIndex, overdueRecoveryIndex, reqBo.getPayConfigId()});
                if (currentOverdueIndex.compareTo(BigDecimal.ZERO) >= 0) {
                    if (currentOverdueIndex.compareTo(overdueWarningIndex) >= 0) {
                        currentOrgWarningTagList.add(FscPayCreditWarningTag.WARNING_OVERDUE_INDEX.getCode());
                        if (!currentOrgWarningTagListOld.contains(FscPayCreditWarningTag.WARNING_OVERDUE_INDEX.getCode())) {
                            currentOrgControlReason = "\u903e\u671f\u6307\u6570\u8d85\u8fc7\u9884\u8b66\u9608\u503c";
                            joiner.add(currentOrgControlReason);
                            log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                        }
                    } else {
                        currentOrgWarningTagList.remove(FscPayCreditWarningTag.WARNING_OVERDUE_INDEX.getCode());
                        if (currentOrgWarningTagListOld.contains(FscPayCreditWarningTag.WARNING_OVERDUE_INDEX.getCode())) {
                            currentOrgControlReason = "\u903e\u671f\u6307\u6570\u4f4e\u4e8e\u9884\u8b66\u9608\u503c";
                            joiner.add(currentOrgControlReason);
                            log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                        }
                    }
                    if (currentOverdueIndex.compareTo(overdueControlIndex) >= 0) {
                        currentOrgWarningTagList.remove(FscPayCreditWarningTag.WARNING_OVERDUE_INDEX.getCode());
                        currentOrgControlTagList.add(FscPayCreditControlTag.CONTROL_OVERDUE_INDEX.getCode());
                        if (!currentOrgControlTagListOld.contains(FscPayCreditControlTag.CONTROL_OVERDUE_INDEX.getCode())) {
                            currentOrgControlReason = "\u903e\u671f\u6307\u6570\u8d85\u8fc7\u7ba1\u63a7\u9608\u503c";
                            joiner.add(currentOrgControlReason);
                            log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                        }
                    }
                    if (currentOverdueIndex.compareTo(overdueRecoveryIndex) <= 0) {
                        currentOrgControlTagList.remove(FscPayCreditControlTag.CONTROL_OVERDUE_INDEX.getCode());
                        if (currentOrgControlTagListOld.contains(FscPayCreditControlTag.CONTROL_OVERDUE_INDEX.getCode())) {
                            currentOrgControlReason = "\u903e\u671f\u6307\u6570\u4f4e\u4e8e\u6062\u590d\u9608\u503c";
                            joiner.add(currentOrgControlReason);
                            log.debug("\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", (Object)currentOrgControlReason, (Object)reqBo.getPayConfigId());
                        }
                    }
                }
            }
        }
        fscPayConfigUpdate.setCurrentOrgWarningTag(JSON.toJSONString(currentOrgWarningTagList.stream().distinct().collect(Collectors.toList())));
        fscPayConfigUpdate.setCurrentOrgControlTag(JSON.toJSONString(currentOrgControlTagList.stream().distinct().collect(Collectors.toList())));
        if (!CollectionUtils.isEmpty(currentOrgControlTagList)) {
            fscPayConfigUpdate.setCurrentOrgControlStatus(FscPayConfigControlStatus.RESTRICTED.getCode());
        } else if (!CollectionUtils.isEmpty(currentOrgWarningTagList)) {
            fscPayConfigUpdate.setCurrentOrgControlStatus(FscPayConfigControlStatus.WARNING.getCode());
        } else {
            fscPayConfigUpdate.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
        }
        log.warn("\u66f4\u65b0\u7684\u6388\u4fe1\u9884\u8b66\u6807\u7b7e\uff1a{}.\u66f4\u65b0\u7684\u6388\u4fe1\u7ba1\u63a7\u6807\u7b7e\uff1a{}.\u53d8\u66f4\u539f\u56e0\uff1a{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", new Object[]{currentOrgWarningTagList, currentOrgControlTagList, joiner, reqBo.getPayConfigId()});
        int count = this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
        FscPayConfigPO fscPayConfigAfterUpdate = new FscPayConfigPO();
        fscPayConfigAfterUpdate.setPayConfigId(fscPayConfigUpdate.getPayConfigId());
        fscPayConfigAfterUpdate = this.fscPayConfigMapper.getModelBy(fscPayConfigAfterUpdate);
        long countControlSub = currentOrgControlTagListOld.stream().filter(i -> !currentOrgControlTagList.contains(i)).count();
        long countControlAdd = currentOrgControlTagList.stream().filter(i -> !currentOrgControlTagListOld.contains(i)).count();
        long countWarningSub = currentOrgWarningTagListOld.stream().filter(i -> !currentOrgWarningTagList.contains(i)).count();
        long countWarningAdd = currentOrgWarningTagList.stream().filter(i -> !currentOrgWarningTagListOld.contains(i)).count();
        log.debug("\u6388\u4fe1\u7ba1\u63a7\u6807\u7b7e\u53d8\u66f4-countControlSub:{}.countControlAdd:{}.countWarningSub:{}.countWarningAdd:{}.\u652f\u4ed8\u914d\u7f6e\uff1a{}", new Object[]{countControlSub, countControlAdd, countWarningSub, countWarningAdd, reqBo.getPayConfigId()});
        long countChange = countControlSub + countControlAdd + countWarningAdd + countWarningSub;
        if (countChange > 0L) {
            FscCreditControlLogBusiReqBO fscCreditControlLogBusiReqBo = FscRu.js((Object)reqBo, FscCreditControlLogBusiReqBO.class);
            FscCreditControlLogPayConfigBO fscPayConfigAfterUpdateLog = FscRu.js(fscPayConfigAfterUpdate, FscCreditControlLogPayConfigBO.class);
            fscPayConfigAfterUpdateLog.setCurrentOrgControlReason(currentOrgControlReason);
            fscCreditControlLogBusiReqBo.setFscPayConfigAfterUpdate(fscPayConfigAfterUpdateLog);
            JSONObject data = new JSONObject();
            data.put("type", (Object)"CONTROL_LOG");
            data.put("busiReqBo", (Object)fscCreditControlLogBusiReqBo);
            try {
                ProxyMessage message = new ProxyMessage(this.FSC_PAY_CONFIG_SAVE_TOPIC, this.FSC_PAY_CONFIG_SAVE_TAG, data.toJSONString());
                ProxySendResult sendResult = this.fscPayConfigSaveProvider.send(message);
                if (!"SEND_OK".equals(sendResult.getStatus())) {
                    throw new PfscExtBusinessException("18000", "\u5f02\u6b65\u5904\u7406\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25");
                }
            }
            catch (Exception e) {
                log.error("\u53d1\u9001MQ\u5f02\u5e38,\u5165\u53c2\uff1a{}.\u9519\u8bef\u4fe1\u606f\uff1a", (Object)data.toJSONString(), (Object)e);
                throw new PfscExtBusinessException("18000", "\u5f02\u6b65\u5904\u7406\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0cMQ\u53d1\u9001\u5931\u8d25");
            }
        }
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setPayOrgId(fscPayConfigOld.getPayOrgId());
        List<FscPayConfigPO> valueList = this.fscPayConfigMapper.getList(fscPayConfigQry);
        String key = "TipsUseRedisCompany_" + fscPayConfigOld.getPayOrgId();
        log.debug("\u5237\u65b0\u673a\u6784\u6388\u4fe1\u7ba1\u63a7redis\uff1a{}", (Object)key);
        this.cacheClient.set(key, (Object)JSON.toJSONString(valueList));
        return FscRu.success(FscCreditControlBusiRspBO.class);
    }

    @Override
    public FscCreditControlUserInspectionBusiRspBO dealUserCreditControlInspection(FscCreditControlUserInspectionBusiReqBO reqBo) {
        FscCreditControlUserInspectionBusiRspBO rspBo = FscRu.success(FscCreditControlUserInspectionBusiRspBO.class);
        if (reqBo.getInspectionId() == null) {
            rspBo.setRespDesc("\u7528\u6237\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u66f4\u65b0\u5931\u8d25\uff0c\u5165\u53c2\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
            return rspBo;
        }
        SaleOrderInfo saleOrderInfoQry = new SaleOrderInfo();
        saleOrderInfoQry.setInspectionId(reqBo.getInspectionId());
        SaleOrderInfo saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfoQry);
        if (saleOrderInfo == null) {
            log.error("\u7528\u6237\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u66f4\u65b0\uff0c\u6839\u636e\u9a8c\u6536\u5355ID\u67e5\u8be2\u7ed3\u7b97\u9a8c\u6536\u5355\u6570\u636e\u4e3a\u7a7a.inspectionId\uff1a{}.orderCode:{}", (Object)reqBo.getInspectionId(), (Object)reqBo.getOrderCode());
            if (StringUtils.hasText((String)reqBo.getOrderCode())) {
                this.dealUpdateUserOverdueByUoc(reqBo.getOrderCode());
            }
        } else {
            if (saleOrderInfo.getPurchaserId() == null) {
                log.error("\u7528\u6237\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u66f4\u65b0\u5931\u8d25\uff0c\u6839\u636e\u9a8c\u6536\u5355ID\u67e5\u8be2\u9a8c\u6536\u5355\u4e2d\u4e0b\u5355\u4ebaID[purchaserId]\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderInfo));
            } else if ("0".equals(saleOrderInfo.getOrderCategory())) {
                this.dealUpdateUserOverdue(saleOrderInfo.getPurchaserId());
            } else {
                log.error("\u7528\u6237\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u66f4\u65b0\u5931\u8d25\uff0c\u8ba2\u5355\u7c7b\u522b[orderCategory]\u4e0d\u662f\u5bf9\u516c\u4e1a\u52a1\uff1a{}", (Object)saleOrderInfo.getOrderCategory());
            }
            this.dealUpdatePayableOverduePenalty(saleOrderInfo);
        }
        return rspBo;
    }

    private void dealUpdateUserOverdueByUoc(String orderCode) {
        FscPebExtUocOrderTypeQryExternalReqBO reqBo = new FscPebExtUocOrderTypeQryExternalReqBO();
        reqBo.setOrderCodeList(Collections.singletonList(orderCode));
        reqBo.setStakeholderFlag(YesOrNo.YES.getCode().toString());
        FscPebExtUocOrderTypeQryExternalRspBO rspBo = this.fscPebExtUocOrderTypeQryExternalService.qryOrderTypeByOrderCode(reqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getInfoList())) {
            for (PebExtUocOrderTypeQryInfoBO infoBo : rspBo.getInfoList()) {
                if (!orderCode.equals(infoBo.getSaleOrderCode()) || infoBo.getStakeholderInfoBo() == null) continue;
                PebExtUocOrderTypeStakeholderInfoBO stakeholderInfoBo = infoBo.getStakeholderInfoBo();
                if (StringUtils.hasText((String)stakeholderInfoBo.getPurPlaceOrderId()) && "0".equals(stakeholderInfoBo.getOrderCategory())) {
                    Long purchaserId = null;
                    try {
                        purchaserId = Long.valueOf(stakeholderInfoBo.getPurPlaceOrderId());
                        this.dealUpdateUserOverdue(purchaserId);
                    }
                    catch (NumberFormatException e) {
                        log.error("\u6839\u636e\u8ba2\u5355\u7f16\u53f7\u4ece\u8ba2\u5355\u4e2d\u5fc3\u4e2d\u67e5\u8be2\u7684\u4e0b\u5355\u4ebaID\u66f4\u65b0\u7528\u6237\u903e\u671f\u8ba2\u5355\u6570\u91cf\u5f02\u5e38.\u8ba2\u5355\u7f16\u53f7\uff1a{},\u4e0b\u5355\u4eba\uff1a{}.\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{orderCode, stakeholderInfoBo.getPurPlaceOrderId(), e.toString()});
                    }
                    continue;
                }
                log.error("\u7528\u6237\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u66f4\u65b0\u5931\u8d25\uff0c\u8ba2\u5355\u4e0b\u5355\u4eba[purPlaceOrderId = {}]\u4e3a\u7a7a\u6216\u8ba2\u5355\u7c7b\u522b[orderCategory = {}]\u4e0d\u662f\u5bf9\u516c\u4e1a\u52a1", (Object)stakeholderInfoBo.getPurPlaceOrderId(), (Object)stakeholderInfoBo.getOrderCategory());
            }
        }
    }

    private void dealUpdatePayableOverduePenalty(SaleOrderInfo saleOrderInfo) {
        log.error("\u66f4\u65b0\u5e94\u4ed8\u8fdd\u7ea6\u91d1\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}));
        if ("03".equals(saleOrderInfo.getPayType())) {
            if (saleOrderInfo.getBusiModel() != null) {
                if (BusiModel.TRADE_MODEL.getCode().equals(saleOrderInfo.getBusiModel())) {
                    if ("1".equals(saleOrderInfo.getOrderCategory())) {
                        BillApplyInfo billApplyInfo;
                        if (StringUtils.hasText((String)saleOrderInfo.getApplyNo()) && (billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(saleOrderInfo.getApplyNo())) != null && BillApplyInfoStatus.RECEIVE.getCode().equals(billApplyInfo.getBillStatus())) {
                            List<PayableDetailPO> listByApplyNo = this.payableDetailMapper.getListByApplyNo(billApplyInfo.getApplyNo());
                            log.debug("\u5e94\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString(listByApplyNo));
                            if (!CollectionUtils.isEmpty(listByApplyNo)) {
                                PayableDetailPO payableDetailPo = listByApplyNo.get(0);
                                if (PayableStatus.PENDING.getCode().equals(payableDetailPo.getPayableStatus())) {
                                    List<Long> inspectionIds;
                                    List<SaleOrderInfo> list = this.saleOrderInfoMapper.getSaleOrderListByApplyNo(payableDetailPo.getApplyNo());
                                    if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(inspectionIds = list.stream().map(SaleOrderInfo::getInspectionId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
                                        Date paidDate = payableDetailPo.getPaidDate();
                                        UocPenaltyQueryRspBO penaltyBo = this.getPenalty(inspectionIds, paidDate);
                                        if (penaltyBo == null) {
                                            log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u9519\u8bef\uff0c\u67e5\u8be2\u8fdd\u7ea6\u91d1\u4e3a\u7a7a\uff1a{}", inspectionIds);
                                        } else {
                                            BigDecimal penalty = penaltyBo.getPenalty();
                                            Date newPaidDate = penaltyBo.getPaymentDueLatestTime();
                                            BigDecimal payableAmt = payableDetailPo.getPayableAmt();
                                            BigDecimal overduePenalty = payableDetailPo.getOverduePenalty();
                                            BigDecimal subtract = penalty.subtract(Optional.ofNullable(overduePenalty).orElse(BigDecimal.ZERO));
                                            log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u5f00\u7968\u7533\u8bf7:{}.\u5e94\u4ed8\u5355:{}.\u8ba2\u5355\u91d1\u989d\uff1a{}.\u5e94\u4ed8\u91d1\u989d\uff1a{}.\u5386\u53f2\u8fdd\u7ea6\u91d1\uff1a{},\u5f53\u524d\u8fdd\u7ea6\u91d1\uff1a{},\u5dee\u989d\uff1a{},\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f:{},\u65b0\u7684\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f:{}.", new Object[]{payableDetailPo.getApplyNo(), payableDetailPo.getPayableNo(), payableDetailPo.getOrderAmt(), payableAmt, overduePenalty, penalty, subtract, paidDate, newPaidDate});
                                            if (subtract.signum() != 0 || newPaidDate != null) {
                                                BigDecimal curPayableAmt;
                                                String changeReason = StrUtil.format((CharSequence)"\u5e94\u4ed8\u5355[{}]\u5f00\u7968\u7533\u8bf7[{}]\u8fdd\u7ea6\u91d1\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u53d8\u66f4", (Object[])new Object[]{payableDetailPo.getPayableNo(), payableDetailPo.getApplyNo()});
                                                if (payableDetailPo.getApproveResult() != null && 1 == payableDetailPo.getApproveResult()) {
                                                    curPayableAmt = payableAmt;
                                                    changeReason = changeReason + ".\u5df2\u540c\u610f\u51cf\u514d\u8fdd\u7ea6\u91d1\uff0c\u4e0d\u518d\u7d2f\u52a0\u8fdd\u7ea6\u91d1";
                                                } else {
                                                    curPayableAmt = payableAmt.add(subtract);
                                                }
                                                this.updatePenaltyAndAddChangeRecord(payableDetailPo, penalty, subtract, curPayableAmt, changeReason, paidDate, newPaidDate);
                                            } else {
                                                log.debug("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u5f00\u7968\u7533\u8bf7[{}]\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u66f4\u65b0\u503c\u4e3a\u7a7a\u5e76\u4e14\u8fdd\u7ea6\u91d1\u672a\u53d8\uff0c\u672a\u5904\u7406", (Object)payableDetailPo.getPayableNo());
                                            }
                                        }
                                    }
                                } else {
                                    log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u9519\u8bef:\u5e94\u4ed8\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001.\u9500\u552e\u9a8c\u6536\u5355\uff1a{}.\u5e94\u4ed8\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderInfo), (Object)JSON.toJSONString((Object)payableDetailPo));
                                }
                            }
                        }
                    } else {
                        PayableDetailVO payableDetailQry = new PayableDetailVO();
                        payableDetailQry.setOrderIdList(Collections.singletonList(saleOrderInfo.getOrderId()));
                        payableDetailQry.setInspectionIdList(Collections.singletonList(saleOrderInfo.getInspectionId()));
                        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.selectList(payableDetailQry);
                        log.debug("\u5e94\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString(payableDetailPOs));
                        if (CollectionUtils.isEmpty(payableDetailPOs)) {
                            this.saveLog(saleOrderInfo.getOrderId(), saleOrderInfo.getInspectionId(), saleOrderInfo.getSaleOrderCode(), "\u8ba2\u5355\u56de\u8c03\u66f4\u65b0\u903e\u671f\u4fe1\u606f", JSON.toJSONString((Object)saleOrderInfo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]), JSON.toJSONString(payableDetailPOs, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]), "\u6839\u636e\u8ba2\u5355ID\u548c\u9a8c\u6536\u5355ID\u67e5\u8be2\u5e94\u4ed8\u4e3a\u7a7a");
                        } else {
                            List pos = payableDetailPOs.stream().filter(i -> PayableStatus.PENDING.getCode().equals(i.getPayableStatus())).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(pos)) {
                                this.saveLog(saleOrderInfo.getOrderId(), saleOrderInfo.getInspectionId(), saleOrderInfo.getSaleOrderCode(), "\u8ba2\u5355\u56de\u8c03\u66f4\u65b0\u903e\u671f\u4fe1\u606f", JSON.toJSONString((Object)saleOrderInfo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]), JSON.toJSONString(payableDetailPOs, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]), "\u67e5\u8be2\u7684\u5e94\u4ed8\u4e2d\u4e0d\u5b58\u5728\u5f85\u4ed8\u6b3e\u7684\u5e94\u4ed8");
                            } else {
                                for (PayableDetailPO payableDetailPo : pos) {
                                    Date paidDate = payableDetailPo.getPaidDate();
                                    if (PayableStatus.PENDING.getCode().equals(payableDetailPo.getPayableStatus())) {
                                        UocPenaltyQueryRspBO penaltyBo = this.getPenalty(Collections.singletonList(saleOrderInfo.getInspectionId()), paidDate);
                                        if (penaltyBo == null) {
                                            log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u8ba2\u5355\u5e94\u4ed8\u9519\u8bef\uff0c\u67e5\u5bfb\u8fdd\u7ea6\u91d1\u4e3a\u7a7a\uff1a{}", (Object)saleOrderInfo.getInspectionId());
                                            continue;
                                        }
                                        BigDecimal penalty = penaltyBo.getPenalty();
                                        Date newPaidDate = penaltyBo.getPaymentDueLatestTime();
                                        BigDecimal payableAmt = payableDetailPo.getPayableAmt();
                                        BigDecimal overduePenalty = payableDetailPo.getOverduePenalty();
                                        BigDecimal subtract = penalty.subtract(Optional.ofNullable(overduePenalty).orElse(BigDecimal.ZERO));
                                        log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u8ba2\u5355\u5e94\u4ed8:{}.\u5e94\u4ed8\u5355:{}.\u8ba2\u5355\u91d1\u989d\uff1a{}.\u5e94\u4ed8\u91d1\u989d\uff1a{}.\u5386\u53f2\u8fdd\u7ea6\u91d1\uff1a{},\u5f53\u524d\u8fdd\u7ea6\u91d1\uff1a{},\u5dee\u989d\uff1a{},\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f:{},\u65b0\u7684\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f:{}.", new Object[]{payableDetailPo.getPurchaseOrderCode(), payableDetailPo.getPayableNo(), payableDetailPo.getOrderAmt(), payableAmt, overduePenalty, penalty, subtract, paidDate, newPaidDate});
                                        if (subtract.signum() != 0 || newPaidDate != null) {
                                            BigDecimal curPayableAmt;
                                            String changeReason = StrUtil.format((CharSequence)"\u5e94\u4ed8\u5355[{}]\u8ba2\u5355\u5e94\u4ed8[{}]\u8fdd\u7ea6\u91d1\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u53d8\u66f4", (Object[])new Object[]{payableDetailPo.getPayableNo(), saleOrderInfo.getSaleOrderCode()});
                                            if (payableDetailPo.getApproveResult() != null && 1 == payableDetailPo.getApproveResult()) {
                                                curPayableAmt = payableAmt;
                                                changeReason = changeReason + ".\u5df2\u540c\u610f\u51cf\u514d\u8fdd\u7ea6\u91d1\uff0c\u5e94\u4ed8\u4e0d\u518d\u7d2f\u52a0\u8fdd\u7ea6\u91d1";
                                            } else {
                                                curPayableAmt = payableAmt.add(subtract);
                                            }
                                            this.updatePenaltyAndAddChangeRecord(payableDetailPo, penalty, subtract, curPayableAmt, changeReason, paidDate, newPaidDate);
                                            continue;
                                        }
                                        log.debug("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u8ba2\u5355\u5e94\u4ed8[{}]\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u66f4\u65b0\u503c\u4e3a\u7a7a\u5e76\u4e14\u8fdd\u7ea6\u91d1\u672a\u53d8\uff0c\u672a\u5904\u7406", (Object)payableDetailPo.getPayableNo());
                                        continue;
                                    }
                                    log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u8ba2\u5355\u5e94\u4ed8\u9519\u8bef:\u5e94\u4ed8\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001.\u9500\u552e\u9a8c\u6536\u5355\uff1a{}.\u5e94\u4ed8\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderInfo), (Object)JSON.toJSONString((Object)payableDetailPo));
                                }
                            }
                        }
                    }
                } else if (BusiModel.MATCH_UP_MODEL.getCode().equals(saleOrderInfo.getBusiModel())) {
                    PayPurchaseOrderInfo purchaseOrderInfo = this.payPurchaseOrderInfoMapper.getModelByPrimaryKey(saleOrderInfo.getOrderId(), saleOrderInfo.getInspectionId());
                    if (purchaseOrderInfo != null && StringUtils.hasText((String)purchaseOrderInfo.getNotificationNo())) {
                        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.selectByNotifNo(purchaseOrderInfo.getNotificationNo());
                        log.debug("\u5e94\u4ed8\u4fe1\u606f:{}", (Object)JSON.toJSONString(payableDetailPOS));
                        if (!CollectionUtils.isEmpty(payableDetailPOS)) {
                            PayableDetailPO payableDetailPo = payableDetailPOS.get(0);
                            if (PayableStatus.PENDING.getCode().equals(payableDetailPo.getPayableStatus())) {
                                List<PayPurchaseOrderInfo> payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.selectByNotifNo(payableDetailPo.getNotificationNo());
                                if (!CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
                                    Date paidDate;
                                    List<Long> inspectionIds = payPurchaseOrderInfoList.stream().map(PayPurchaseOrderInfo::getInspectionId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                                    UocPenaltyQueryRspBO penaltyBo = this.getPenalty(inspectionIds, paidDate = payableDetailPo.getPaidDate());
                                    if (penaltyBo == null) {
                                        log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u5f00\u7968\u901a\u77e5\u9519\u8bef\uff0c\u67e5\u5bfb\u8fdd\u7ea6\u91d1\u4e3a\u7a7a\uff1a{}", inspectionIds);
                                    } else {
                                        BigDecimal penalty = penaltyBo.getPenalty();
                                        Date newPaidDate = penaltyBo.getPaymentDueLatestTime();
                                        BigDecimal payableAmt = payableDetailPo.getPayableAmt();
                                        BigDecimal overduePenalty = payableDetailPo.getOverduePenalty();
                                        BigDecimal subtract = BigDecimal.ZERO;
                                        log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u5f00\u7968\u901a\u77e5(\u4f9b\u5e94\u5546\u6536\u6b3e\u4e0d\u66f4\u65b0\u8fdd\u7ea6\u91d1):{}.\u5e94\u4ed8\u5355:{}.\u8ba2\u5355\u91d1\u989d\uff1a{}.\u5e94\u4ed8\u91d1\u989d\uff1a{}.\u5386\u53f2\u8fdd\u7ea6\u91d1\uff1a{},\u5f53\u524d\u8fdd\u7ea6\u91d1\uff1a{},\u5dee\u989d\uff1a{},\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f:{},\u65b0\u7684\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f:{}.", new Object[]{payableDetailPo.getNotificationNo(), payableDetailPo.getPayableNo(), payableDetailPo.getOrderAmt(), payableAmt, overduePenalty, penalty, subtract, paidDate, newPaidDate});
                                        if (newPaidDate != null) {
                                            String changeReason = StrUtil.format((CharSequence)"\u5e94\u4ed8\u5355[{}]\u5f00\u7968\u901a\u77e5[{}]\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u53d8\u66f4.\u8ba2\u5355\u4ea7\u751f\u8fdd\u7ea6\u91d1[{}],\u4f46\u4f9b\u5e94\u5546\u6536\u6b3e\u4e0d\u6536\u53d6\u8fdd\u7ea6", (Object[])new Object[]{payableDetailPo.getPayableNo(), purchaseOrderInfo.getNotificationNo(), penalty});
                                            this.updatePenaltyAndAddChangeRecord(payableDetailPo, BigDecimal.ZERO, BigDecimal.ZERO, null, changeReason, paidDate, newPaidDate);
                                        } else {
                                            log.debug("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u5f00\u7968\u901a\u77e5[{}]\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u66f4\u65b0\u503c\u4e3a\u7a7a\uff0c\u672a\u5904\u7406", (Object)payableDetailPo.getPayableNo());
                                        }
                                    }
                                }
                            } else {
                                log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u5f00\u7968\u901a\u77e5\u9519\u8bef:\u5e94\u4ed8\u4e0d\u662f\u5f85\u4ed8\u6b3e\u72b6\u6001.\u9500\u552e\u9a8c\u6536\u5355\uff1a{}.\u5e94\u4ed8\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderInfo), (Object)JSON.toJSONString((Object)payableDetailPo));
                            }
                        }
                    } else {
                        log.error("\u64ae\u5408\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)purchaseOrderInfo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.NotWriteDefaultValue}));
                    }
                }
            } else {
                log.error("\u7ed3\u7b97\u6a21\u5f0f\u4e3a\u7a7a");
            }
        } else {
            log.error("\u652f\u4ed8\u65b9\u5f0f\uff1a{}", (Object)saleOrderInfo.getPayType());
        }
    }

    private void saveLog(Long orderId, Long objId, String objCode, String createLoginId, String reqJson, String rspJson, String errDetail) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            FscExtInterLogAtomReqBO logAtomReqBo = new FscExtInterLogAtomReqBO();
            logAtomReqBo.setObjId(objId);
            logAtomReqBo.setObjCode(objCode);
            logAtomReqBo.setObjType(FscConstants.FscExtInterLogObjType.PAY_OVERDUE_BACK);
            logAtomReqBo.setOrderId(orderId);
            logAtomReqBo.setInterSn("1");
            logAtomReqBo.setInterCode("FscCreditControlBusiServiceImpl.dealUpdatePayableOverduePenalty");
            logAtomReqBo.setFlowFlag(1);
            logAtomReqBo.setInContent(reqJson);
            logAtomReqBo.setOutContent(rspJson);
            logAtomReqBo.setCallCount(0);
            logAtomReqBo.setCallTime(new Date());
            logAtomReqBo.setRetTime(new Date());
            logAtomReqBo.setCallState("18000");
            logAtomReqBo.setErrCode("18000");
            logAtomReqBo.setErrDetail(errDetail);
            logAtomReqBo.setCreateTime(new Date());
            logAtomReqBo.setCreateLoginId(createLoginId);
            this.fscExtInterLogAtomService.dealFscExtInterLogAdd(logAtomReqBo);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Object)e.toString());
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private void updatePenaltyAndAddChangeRecord(PayableDetailPO payableDetailPo, BigDecimal penalty, BigDecimal subtract, BigDecimal curPayableAmt, String changeReason, Date paidDate, Date newPaidDate) {
        if (payableDetailPo.getPayableNo() != null) {
            PayableDetailPO payableDetailUpdate = new PayableDetailPO();
            payableDetailUpdate.setPayableNo(payableDetailPo.getPayableNo());
            if (curPayableAmt != null) {
                payableDetailUpdate.setPayableAmt(curPayableAmt);
            }
            payableDetailUpdate.setOverduePenalty(penalty);
            payableDetailUpdate.setPaidDate(newPaidDate);
            int n = this.payableDetailMapper.updateSelective(payableDetailUpdate);
        }
        FscPayableDetailOverduePenaltyChangePO penaltyChangeInsertPo = new FscPayableDetailOverduePenaltyChangePO();
        penaltyChangeInsertPo.setLogId(Sequence.getInstance().nextId());
        penaltyChangeInsertPo.setPayableNo(payableDetailPo.getPayableNo());
        penaltyChangeInsertPo.setChangeType(subtract.signum() > 0 ? "1" : "2");
        penaltyChangeInsertPo.setPayableAmt(payableDetailPo.getPayableAmt());
        penaltyChangeInsertPo.setOrderAmt(payableDetailPo.getOrderAmt());
        penaltyChangeInsertPo.setOverduePenalty(payableDetailPo.getOverduePenalty());
        penaltyChangeInsertPo.setChangeAmt(subtract);
        penaltyChangeInsertPo.setNewPayableAmt(curPayableAmt);
        penaltyChangeInsertPo.setNewOverduePenalty(penalty);
        penaltyChangeInsertPo.setPaidDate(paidDate);
        penaltyChangeInsertPo.setNewPaidDate(newPaidDate);
        penaltyChangeInsertPo.setChangeReason(changeReason);
        penaltyChangeInsertPo.setUpdateTime(new Date());
        penaltyChangeInsertPo.setOrderCode(payableDetailPo.getPurchaseOrderCode());
        this.fscPayableDetailOverduePenaltyChangeMapper.insert(penaltyChangeInsertPo);
    }

    private UocPenaltyQueryRspBO getPenalty(List<Long> inspectionIds, Date paidDate) {
        UocPenaltyQueryRspBO penaltyBo = null;
        if (!CollectionUtils.isEmpty(inspectionIds)) {
            FscUocPenaltyQueryExternalReqBO uocReqBo = new FscUocPenaltyQueryExternalReqBO();
            uocReqBo.setInspectionVoucherIdList(inspectionIds);
            FscUocPenaltyQueryExternalRspBO uocRspBo = this.fscUocPenaltyQueryExternalService.queryPenalty(uocReqBo);
            if (!CollectionUtils.isEmpty((Collection)uocRspBo.getUocPenaltyQueryRspBOList())) {
                penaltyBo = new UocPenaltyQueryRspBO();
                BigDecimal penalty = uocRspBo.getUocPenaltyQueryRspBOList().stream().map(UocPenaltyQueryRspBO::getPenalty).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                penaltyBo.setPenalty(penalty);
                Optional<Date> optionalDate = uocRspBo.getUocPenaltyQueryRspBOList().stream().map(UocPenaltyQueryRspBO::getPaymentDueLatestTime).filter(Objects::nonNull).min(Comparator.comparing(Date::getTime));
                if (optionalDate.isPresent()) {
                    String pattern = "yyyy-MM-dd 00:00:00";
                    Date paymentTime = DateUtil.strToDateLong(DateUtil.dateToStr(optionalDate.get(), pattern));
                    log.debug("\u903e\u671f\u65f6\u95f4\uff1a{}", (Object)paymentTime);
                    if (paymentTime != null) {
                        if (paidDate == null) {
                            penaltyBo.setPaymentDueLatestTime(paymentTime);
                        } else if (paidDate.getTime() > paymentTime.getTime()) {
                            penaltyBo.setPaymentDueLatestTime(paymentTime);
                        }
                    }
                }
            }
        }
        return penaltyBo;
    }

    private void dealUpdateUserOverdue(Long purchaserId) {
        if (purchaserId == null) {
            log.error("\u4e0b\u5355\u4ebaID\u4e3a\u7a7a");
            return;
        }
        FscUocOrderCreditInfoStatisticsQryExternalReqBO externalReqBo = new FscUocOrderCreditInfoStatisticsQryExternalReqBO();
        externalReqBo.setUserIdList(Collections.singletonList(purchaserId));
        FscUocOrderCreditInfoStatisticsQryExternalRspBO externalRspBo = this.fscUocOrderCreditInfoStatisticsQryExternalService.listUserCreditInfoStatistics(externalReqBo);
        if (CollectionUtils.isEmpty((Collection)externalRspBo.getCreditInfoBOList())) {
            log.error("\u7528\u6237\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u66f4\u65b0\u4e2d\u6b62\uff0c\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u8ba2\u5355\u8d26\u671f\u6570\u636e\u4e3a\u7a7a.\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)externalRspBo));
            return;
        }
        log.debug("\u66f4\u65b0\u7528\u6237\u903e\u671f\u6570\u636e");
        FscCreditControlUserOverdueBusiReqBO busiReqBo = new FscCreditControlUserOverdueBusiReqBO();
        busiReqBo.setInfoList(externalRspBo.getCreditInfoBOList().stream().map(uocCreditInfoBo -> {
            FscUserOverdueInfoBO infoBo = new FscUserOverdueInfoBO();
            infoBo.setUserId(uocCreditInfoBo.getPurNo());
            infoBo.setOrderCount(uocCreditInfoBo.getOrderCount());
            infoBo.setOverdueCount(uocCreditInfoBo.getOverdueCount());
            infoBo.setSaleFeeTotal(uocCreditInfoBo.getSalefeeTotal());
            infoBo.setOverdueSaleFeeTotal(uocCreditInfoBo.getOverdueSaleFeeTotal());
            return infoBo;
        }).collect(Collectors.toList()));
        this.fscCreditControlUserOverdueBusiService.dealCreditControlUser(busiReqBo);
    }
}

