/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.order.pec.ability.bo.UocOverdueIndexStatisticsBO;
import com.tydic.pfscext.dao.FscCreditControlLogMapper;
import com.tydic.pfscext.dao.po.FscCreditControlLogPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.external.uoc.api.FscUocOrderOverdueIndexStatisticsQryExternalService;
import com.tydic.pfscext.external.uoc.bo.FscUocOrderOverdueIndexStatisticsQryExternalReqBO;
import com.tydic.pfscext.external.uoc.bo.FscUocOrderOverdueIndexStatisticsQryExternalRspBO;
import com.tydic.pfscext.service.busi.FscCreditControlLogBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlLogBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlLogBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlLogPayConfigBO;
import com.tydic.pfscext.utils.FscRu;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscCreditControlLogBusiServiceImpl
implements FscCreditControlLogBusiService {
    @Resource
    private FscCreditControlLogMapper fscCreditControlLogMapper;
    @Autowired
    private FscUocOrderOverdueIndexStatisticsQryExternalService fscUocOrderOverdueIndexStatisticsQryExternalService;

    @Override
    public FscCreditControlLogBusiRspBO dealAddCreditControlLog(FscCreditControlLogBusiReqBO reqBo) {
        FscCreditControlLogPayConfigBO fscPayConfigAfterUpdate = reqBo.getFscPayConfigAfterUpdate();
        FscCreditControlLogPO fscCreditControlLogInsert = new FscCreditControlLogPO();
        fscCreditControlLogInsert.setCreditControlLogId(Sequence.getInstance().nextId());
        BeanUtils.copyProperties((Object)fscPayConfigAfterUpdate, (Object)fscCreditControlLogInsert);
        this.initCurrentDayOverdueInfoFromUoc(fscCreditControlLogInsert);
        String controlStatusStr = FscPayConfigControlStatus.desc((String)fscPayConfigAfterUpdate.getCurrentOrgControlStatus());
        if (FscPayConfigBusiType.FL.getCode().equals(fscPayConfigAfterUpdate.getPayBusiType())) {
            if (FscPayConfigControlStatus.RESTRICTED.getCode().equals(fscPayConfigAfterUpdate.getCurrentOrgControlStatus())) {
                controlStatusStr = "\u9650\u5236\u6d3b\u52a8\u521b\u5efa\u6743\u9650";
            } else if (FscPayConfigControlStatus.NORMAL.getCode().equals(fscPayConfigAfterUpdate.getCurrentOrgControlStatus())) {
                controlStatusStr = "\u6062\u590d\u6d3b\u52a8\u521b\u5efa\u6743\u9650";
            } else if (FscPayConfigControlStatus.WARNING.getCode().equals(fscPayConfigAfterUpdate.getCurrentOrgControlStatus())) {
                controlStatusStr = "\u6d3b\u52a8\u521b\u5efa\u6743\u9650\u9884\u8b66";
            }
        } else if (FscPayConfigControlStatus.RESTRICTED.getCode().equals(fscPayConfigAfterUpdate.getCurrentOrgControlStatus())) {
            controlStatusStr = "\u9650\u5236\u5355\u4f4d\u4e0b\u5355\u6743\u9650";
        } else if (FscPayConfigControlStatus.NORMAL.getCode().equals(fscPayConfigAfterUpdate.getCurrentOrgControlStatus())) {
            controlStatusStr = "\u6062\u590d\u5355\u4f4d\u4e0b\u5355\u6743\u9650";
        } else if (FscPayConfigControlStatus.WARNING.getCode().equals(fscPayConfigAfterUpdate.getCurrentOrgControlStatus())) {
            controlStatusStr = "\u5355\u4f4d\u4e0b\u5355\u6743\u9650\u9884\u8b66";
        }
        fscCreditControlLogInsert.setCurrentOrgControlReason(fscPayConfigAfterUpdate.getCurrentOrgControlReason());
        fscCreditControlLogInsert.setCurrentOrgControlStatusStr(controlStatusStr);
        fscCreditControlLogInsert.setCreateTime(new Date());
        fscCreditControlLogInsert.setCreateUserId(reqBo.getUserId());
        fscCreditControlLogInsert.setCreateUserName(reqBo.getUsername());
        int insert = this.fscCreditControlLogMapper.insert(fscCreditControlLogInsert);
        return FscRu.success(FscCreditControlLogBusiRspBO.class);
    }

    private void initCurrentDayOverdueInfoFromUoc(FscCreditControlLogPO fscCreditControlLogInsert) {
        fscCreditControlLogInsert.setCurrentDayOverdueAmount(fscCreditControlLogInsert.getCurrentOverdueAmount());
        fscCreditControlLogInsert.setCurrentDayOverdueRatio(BigDecimal.ZERO);
        if (fscCreditControlLogInsert.getPayOrgId() != null) {
            FscUocOrderOverdueIndexStatisticsQryExternalReqBO externalReqBo = new FscUocOrderOverdueIndexStatisticsQryExternalReqBO();
            externalReqBo.setBusiType(fscCreditControlLogInsert.getPayBusiType());
            externalReqBo.setPurOrgIdList(Collections.singletonList(fscCreditControlLogInsert.getPayOrgId() + ""));
            FscUocOrderOverdueIndexStatisticsQryExternalRspBO externalRspBo = this.fscUocOrderOverdueIndexStatisticsQryExternalService.listOrgOrderOverdueIndexStatistics(externalReqBo);
            if (!CollectionUtils.isEmpty((Collection)externalRspBo.getOverdueIndexStatisticsBOList())) {
                UocOverdueIndexStatisticsBO statisticsBo = (UocOverdueIndexStatisticsBO)externalRspBo.getOverdueIndexStatisticsBOList().get(0);
                fscCreditControlLogInsert.setCurrentDayOverdueIndex(statisticsBo.getRegulatoryIndexes());
            }
        } else {
            fscCreditControlLogInsert.setCurrentDayOverdueIndex(BigDecimal.ZERO);
        }
    }
}

