/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.pfscext.dao.FscUserOverdueControlConfigMapper;
import com.tydic.pfscext.dao.FscUserOverdueStatisticsMapper;
import com.tydic.pfscext.dao.po.FscUserOverdueControlConfigPO;
import com.tydic.pfscext.dao.po.FscUserOverdueStatisticsPO;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.service.busi.FscCreditControlUserOverdueBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserOverdueBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserOverdueBusiRspBO;
import com.tydic.pfscext.service.comb.bo.FscUserOverdueInfoBO;
import com.tydic.pfscext.utils.FscRu;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscCreditControlUserOverdueBusiServiceImpl
implements FscCreditControlUserOverdueBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCreditControlUserOverdueBusiServiceImpl.class);
    @Autowired
    private FscUserOverdueStatisticsMapper fscUserOverdueStatisticsMapper;
    @Autowired
    private FscUserOverdueControlConfigMapper fscUserOverdueControlConfigMapper;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public FscCreditControlUserOverdueBusiRspBO dealCreditControlUser(FscCreditControlUserOverdueBusiReqBO reqBo) {
        FscCreditControlUserOverdueBusiRspBO rspBo = FscRu.success(FscCreditControlUserOverdueBusiRspBO.class);
        if (CollectionUtils.isEmpty(reqBo.getInfoList())) {
            rspBo.setRespDesc("\u5165\u53c2[infoList]\u4e3a\u7a7a");
            return rspBo;
        }
        for (FscUserOverdueInfoBO fscUserOverdueInfoBo : reqBo.getInfoList()) {
            Long userId = fscUserOverdueInfoBo.getUserId();
            if (userId != null && userId != 0L) {
                FscUserOverdueControlConfigPO modelBy = null;
                FscUserOverdueControlConfigPO fscUserOverdueControlConfigQry = new FscUserOverdueControlConfigPO();
                fscUserOverdueControlConfigQry.setConfigUserId(userId);
                try {
                    modelBy = this.fscUserOverdueControlConfigMapper.getUserOverdueControlConfig(fscUserOverdueControlConfigQry);
                }
                catch (Exception e) {
                    log.error("\u6839\u636euserId\u67e5\u8be2\u7528\u6237\u903e\u671f\u7ba1\u63a7\u6570\u636e\u5f02\u5e38.userId:{}.\u9519\u8bef\u4fe1\u606f:{}", (Object)userId, (Object)e.toString());
                }
                if (modelBy != null) {
                    FscUserOverdueStatisticsPO fscUserOverdueStatisticsUpdate = new FscUserOverdueStatisticsPO();
                    fscUserOverdueStatisticsUpdate.setStatisticsId(modelBy.getStatisticsId());
                    fscUserOverdueStatisticsUpdate.setCurrentOrderOverdueNum(fscUserOverdueInfoBo.getOverdueCount());
                    fscUserOverdueStatisticsUpdate.setCurrentOrderCreditNum(fscUserOverdueInfoBo.getOrderCount());
                    fscUserOverdueStatisticsUpdate.setOrderOverdueAmount(fscUserOverdueInfoBo.getOverdueSaleFeeTotal());
                    fscUserOverdueStatisticsUpdate.setOrderCreditAmount(fscUserOverdueInfoBo.getSaleFeeTotal());
                    fscUserOverdueStatisticsUpdate.setConfigOrgId(fscUserOverdueInfoBo.getConfigOrgId());
                    fscUserOverdueStatisticsUpdate.setConfigOrgName(fscUserOverdueInfoBo.getConfigOrgName());
                    fscUserOverdueStatisticsUpdate.setConfigOrgPath(fscUserOverdueInfoBo.getConfigOrgPath());
                    fscUserOverdueStatisticsUpdate.setConfigOrgFullName(fscUserOverdueInfoBo.getConfigOrgFullName());
                    fscUserOverdueStatisticsUpdate.setConfigUserAccount(fscUserOverdueInfoBo.getConfigUserAccount());
                    fscUserOverdueStatisticsUpdate.setConfigUserName(fscUserOverdueInfoBo.getConfigUserName());
                    fscUserOverdueStatisticsUpdate.setConfigAuthRole(fscUserOverdueInfoBo.getConfigAuthRole());
                    boolean DEFAULT_ZERO = false;
                    Integer currentOrderOverdueNum = Optional.ofNullable(fscUserOverdueInfoBo.getOverdueCount()).orElse(0);
                    Integer orderWarningNum = Optional.ofNullable(modelBy.getOrderWarningNum()).orElse(0);
                    Integer orderControlNum = Optional.ofNullable(modelBy.getOrderControlNum()).orElse(0);
                    Integer orderRecoveryNum = Optional.ofNullable(modelBy.getOrderRecoveryNum()).orElse(0);
                    String controlStatusBefore = modelBy.getCurrentUserControlStatus();
                    FscPayConfigControlStatus userControlStatus = FscPayConfigControlStatus.NORMAL;
                    if (currentOrderOverdueNum >= orderControlNum) {
                        userControlStatus = FscPayConfigControlStatus.RESTRICTED;
                    } else if (FscPayConfigControlStatus.RESTRICTED.getCode().equals(controlStatusBefore)) {
                        userControlStatus = currentOrderOverdueNum > orderRecoveryNum ? FscPayConfigControlStatus.RESTRICTED : (currentOrderOverdueNum >= orderWarningNum ? FscPayConfigControlStatus.WARNING : FscPayConfigControlStatus.NORMAL);
                    } else if (currentOrderOverdueNum >= orderWarningNum) {
                        userControlStatus = FscPayConfigControlStatus.WARNING;
                    }
                    fscUserOverdueStatisticsUpdate.setCurrentUserControlStatus(userControlStatus.getCode());
                    int count = this.fscUserOverdueStatisticsMapper.updateById(fscUserOverdueStatisticsUpdate);
                    log.error("\u66f4\u65b0\u7528\u6237\u903e\u671f\u8ba2\u5355\u6570\u91cf\u7ed3\u679c\uff1a{}", (Object)count);
                    try {
                        FscUserOverdueControlConfigPO cachePo = this.fscUserOverdueControlConfigMapper.getUserOverdueControlConfig(fscUserOverdueControlConfigQry);
                        if (cachePo == null) continue;
                        String key = "TipsUseRedisUser_" + userId;
                        log.debug("\u5237\u65b0\u7528\u6237\u6388\u4fe1\u7ba1\u63a7redis\uff1a{}", (Object)key);
                        this.cacheClient.set(key, (Object)JSON.toJSONString((Object)cachePo));
                    }
                    catch (Exception e) {
                        log.error("\u5237\u65b0\u7528\u6237\u6388\u4fe1\u7ba1\u63a7redis\u5f02\u5e38\uff1a{}", (Object)e.toString());
                    }
                    continue;
                }
                log.error("\u6839\u636euserId\u67e5\u8be2\u914d\u7f6e\u4e3a\u7a7a.{}", (Object)userId);
                continue;
            }
            log.error("userId\u4e3a\u7a7a.{}", (Object)JSON.toJSONString((Object)fscUserOverdueInfoBo));
        }
        return rspBo;
    }
}

