/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.ability.bo.FscCreditDataTransferCreateLineAbilityRspBO;
import com.tydic.pfscext.api.ability.bo.FscCreditDataTransferPayConfigAbilityRspBO;
import com.tydic.pfscext.dao.FscCreditRecordDataMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelDataMapper;
import com.tydic.pfscext.dao.FscPayConfigDataMapper;
import com.tydic.pfscext.dao.po.FscCreditRecordPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscCreditDataTransferBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditDataTransferCreateLineBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditDataTransferPayConfigBusiReqBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscCreditDataTransferBusiServiceImpl
implements FscCreditDataTransferBusiService {
    @Autowired
    private FscCreditRecordDataMapper fscCreditRecordDataMapper;
    @Autowired
    private FscPayConfigDataMapper fscPayConfigDataMapper;
    @Autowired
    private FscPayConfigChannelDataMapper fscPayConfigChannelDataMapper;

    @Override
    public FscCreditDataTransferCreateLineAbilityRspBO dealTransferCreditLineData(FscCreditDataTransferCreateLineBusiReqBO reqBo) {
        List<FscCreditRecordPO> fscCreditRecordList = reqBo.getFscCreditRecordList();
        if (!CollectionUtils.isEmpty(fscCreditRecordList)) {
            for (List subList : ListUtil.batchList(fscCreditRecordList, (int)200)) {
                List<Long> recordIdList;
                if (CollectionUtils.isEmpty((Collection)subList) || CollectionUtils.isEmpty(recordIdList = subList.stream().map(FscCreditRecordPO::getRecordId).collect(Collectors.toList()))) continue;
                FscCreditRecordPO fscCreditRecordPo = new FscCreditRecordPO();
                fscCreditRecordPo.setRecordIdList(recordIdList);
                List<FscCreditRecordPO> list = this.fscCreditRecordDataMapper.getList(fscCreditRecordPo);
                if (!CollectionUtils.isEmpty(list)) {
                    List recordIdListOld = list.stream().map(FscCreditRecordPO::getRecordId).collect(Collectors.toList());
                    List<FscCreditRecordPO> updateList = subList.stream().filter(i -> recordIdListOld.contains(i.getRecordId())).collect(Collectors.toList());
                    List insertList = subList.stream().filter(i -> !recordIdListOld.contains(i.getRecordId())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(updateList)) {
                        updateList.forEach(this.fscCreditRecordDataMapper::updateById);
                    }
                    if (CollectionUtils.isEmpty(insertList)) continue;
                    for (List subInsert : ListUtil.batchList(insertList, (int)50)) {
                        this.fscCreditRecordDataMapper.insertBatch(subInsert);
                    }
                    continue;
                }
                for (List subInsert : ListUtil.batchList((List)subList, (int)50)) {
                    this.fscCreditRecordDataMapper.insertBatch(subInsert);
                }
            }
        }
        return FscRu.success(FscCreditDataTransferCreateLineAbilityRspBO.class);
    }

    @Override
    public FscCreditDataTransferPayConfigAbilityRspBO dealTransferPayConfigData(FscCreditDataTransferPayConfigBusiReqBO reqBo) {
        FscPayConfigPO payConfigMain = reqBo.getPayConfigMain();
        if (payConfigMain != null) {
            this.fscPayConfigDataMapper.insert(payConfigMain);
        }
        if (!CollectionUtils.isEmpty(reqBo.getPayConfigChannelsMain())) {
            for (List subList : ListUtil.batchList(reqBo.getPayConfigChannelsMain(), (int)50)) {
                this.fscPayConfigChannelDataMapper.insertBatch(subList);
            }
        }
        if (!CollectionUtils.isEmpty(reqBo.getPayConfigsDetail())) {
            for (List subList : ListUtil.batchList(reqBo.getPayConfigsDetail(), (int)50)) {
                this.fscPayConfigDataMapper.insertBatch(subList);
            }
        }
        if (!CollectionUtils.isEmpty(reqBo.getPayConfigChannelsDetail())) {
            for (List subList : ListUtil.batchList(reqBo.getPayConfigChannelsDetail(), (int)50)) {
                this.fscPayConfigChannelDataMapper.insertBatch(subList);
            }
        }
        if (payConfigMain != null) {
            int count;
            FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
            fscPayConfigUpdate.setPayConfigId(payConfigMain.getPayConfigId());
            fscPayConfigUpdate.setStatus(FscPayConfigStatus.EFFECT.getCode());
            int exceptionOrgNum = this.getExceptionNum(payConfigMain.getPayConfigId(), FscPayConfigType.EXT_ORG.getCode());
            fscPayConfigUpdate.setExceptionOrgNum(exceptionOrgNum);
            int exceptionAgrNum = this.getExceptionNum(payConfigMain.getPayConfigId(), FscPayConfigType.EXT_AGR.getCode());
            fscPayConfigUpdate.setExceptionAgrNum(exceptionAgrNum);
            int exceptionConnNum = this.getExceptionNum(payConfigMain.getPayConfigId(), FscPayConfigType.EXT_CONN.getCode());
            fscPayConfigUpdate.setExceptionConnNum(exceptionConnNum);
            if (exceptionOrgNum + exceptionAgrNum + exceptionConnNum > 0) {
                fscPayConfigUpdate.setPayAllowExceptionFlag(YesOrNo.YES.getCode());
            }
            if ((count = this.fscPayConfigDataMapper.updateById(fscPayConfigUpdate)) > 1) {
                throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u4e3b\u914d\u7f6e\u751f\u6548\u5f02\u5e38");
            }
        }
        return FscRu.success(FscCreditDataTransferPayConfigAbilityRspBO.class);
    }

    private Integer getExceptionNum(Long payConfigId, String payConfigType) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setParentConfigId(payConfigId);
        fscPayConfigQry.setPayConfigType(payConfigType);
        return this.fscPayConfigDataMapper.getCheckBy(fscPayConfigQry);
    }
}

