/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.bo.FscActCreditRecordAddUserInfoBO;
import com.tydic.pfscext.constants.FscConstants;
import com.tydic.pfscext.dao.FscCreditRecordMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscCreditRecordPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscCreditBusiCategory;
import com.tydic.pfscext.enums.FscCreditBusiType;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.FscExtInterLogAtomService;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogBatchAddAtomReqBO;
import com.tydic.pfscext.service.atom.bo.FscExtInterLogBatchAddInfoBO;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.FscCreditRecordBusiService;
import com.tydic.pfscext.service.busi.bo.FscActCreditRecordAddBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscActCreditRecordAddBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordPayBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordPayBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordPayInfoBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordWriteOffFailBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCreditRecordWriteOffFailBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscCreditRecordBusiServiceImpl
implements FscCreditRecordBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCreditRecordBusiServiceImpl.class);
    @Autowired
    private FscCreditRecordMapper fscCreditRecordMapper;
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscCreditControlBusiService fscCreditControlBusiService;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private FscExtInterLogAtomService fscExtInterLogAtomService;

    @Override
    public FscOrderCreditRecordBusiRspBO dealOrderCreditRecord(FscOrderCreditRecordBusiReqBO reqBo) {
        Long recordId;
        FscOrderCreditRecordBusiRspBO rspBo = FscRu.success(FscOrderCreditRecordBusiRspBO.class);
        ValUtil.isEmpty(reqBo.getBusiCategory()).exception("\u989d\u5ea6\u4f7f\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        FscCreditBusiCategory busiCategory = FscCreditBusiCategory.instance((String)reqBo.getBusiCategory());
        if (FscCreditBusiCategory.ORD_DISPATCH.equals((Object)busiCategory)) {
            ValUtil.isEmptyNum(reqBo.getOrderId()).exception("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmptyNum(reqBo.getSupplierNo()).exception("\u4f9b\u5e94\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            FscCreditRecordPO set = new FscCreditRecordPO();
            set.setSupplierNo(reqBo.getSupplierNo());
            set.setSupplierName(reqBo.getSupplierName());
            set.setRemark(StrUtil.subPre((CharSequence)reqBo.getRemark(), (int)199));
            FscCreditRecordPO where = new FscCreditRecordPO();
            where.setObjId(reqBo.getOrderId());
            this.fscCreditRecordMapper.updateBy(set, where);
            rspBo.setRespDesc("\u6d3e\u5355\u66f4\u65b0\u4e0b\u5355\u8bb0\u5f55\u4f9b\u5e94\u5546\u6210\u529f");
            return rspBo;
        }
        if (FscCreditBusiCategory.ORD_DISPATCH_RESEND.equals((Object)busiCategory)) {
            ValUtil.isEmptyNum(reqBo.getOrderId()).exception("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmptyNum(reqBo.getDispatchOrderId()).exception("\u6d3e\u5355\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
            fscCreditRecordOld.setObjId(reqBo.getOrderId());
            fscCreditRecordOld.setObjCode(reqBo.getOrderCode());
            fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
            fscCreditRecordOld = this.fscCreditRecordMapper.getModelBy(fscCreditRecordOld);
            if (fscCreditRecordOld == null) {
                throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba2\u5355\u4e0b\u5355\u6388\u4fe1\u6263\u51cf\u8bb0\u5f55\u4e3a\u7a7a");
            }
            FscCreditRecordPO insertCancelPo = FscRu.js(fscCreditRecordOld, FscCreditRecordPO.class);
            insertCancelPo.setRecordId(Sequence.getInstance().nextId());
            insertCancelPo.setBusiCategory(FscCreditBusiCategory.ORD_CANCEL.getCode());
            insertCancelPo.setBusiAmount(fscCreditRecordOld.getBusiAmount().negate());
            insertCancelPo.setBusiBeforeAmount(null);
            insertCancelPo.setBusiAfterAmount(null);
            insertCancelPo.setCreateTime(new Date());
            insertCancelPo.setCreateUserId(reqBo.getUserId());
            insertCancelPo.setCreateUserName(reqBo.getUsername());
            insertCancelPo.setRemark("\u91cd\u65b0\u6d3e\u5355\u64cd\u4f5c");
            this.fscCreditRecordMapper.insert(insertCancelPo);
            FscCreditRecordPO insertNewPo = FscRu.js(fscCreditRecordOld, FscCreditRecordPO.class);
            insertNewPo.setRecordId(Sequence.getInstance().nextId());
            insertNewPo.setObjId(reqBo.getDispatchOrderId());
            insertNewPo.setObjCode(reqBo.getDispatchOrderCode());
            insertNewPo.setSupplierNo(null);
            insertNewPo.setSupplierName(null);
            insertNewPo.setCreateTime(new Date());
            insertNewPo.setCreateUserId(reqBo.getUserId());
            insertNewPo.setCreateUserName(reqBo.getUsername());
            insertNewPo.setRemark(StrUtil.subPre((CharSequence)reqBo.getRemark(), (int)199));
            this.fscCreditRecordMapper.insert(insertNewPo);
            rspBo.setRespDesc("\u91cd\u65b0\u6d3e\u5355\u6839\u636e\u65e7\u8bb0\u5f55\u751f\u6210\u65b0\u8ba2\u5355\u8bb0\u5f55\u6210\u529f");
            return rspBo;
        }
        BigDecimal payAmount = reqBo.getBusiAmount();
        if (FscCreditBusiCategory.ORD_ADD.getCode().equals(reqBo.getBusiCategory())) {
            ValUtil.isEmpty(reqBo.getBusiType()).exception("\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(reqBo.getPayConfigId()).exception("\u652f\u4ed8\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(reqBo.getAccountId()).exception("\u91c7\u8d2d\u5355\u4f4d\u5e10\u5957\u4e0d\u80fd\u4e3a\u7a7a");
            if (!FscCreditBusiType.ORD_PD.getCode().equals(reqBo.getBusiType())) {
                ValUtil.isEmpty(reqBo.getSupplierNo()).exception("\u4f9b\u5e94\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ValUtil.isEmpty(reqBo.getBusiModel()).exception("\u7ed3\u7b97\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(reqBo.getBusiAmount()).exception("\u6388\u4fe1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            if (reqBo.getOrderId() == null || reqBo.getOrderCode() == null) {
                throw new PfscExtBusinessException("0001", "\u8ba2\u5355ID\u548c\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            FscCreditRecordPO fscCreditRecordOldQry = new FscCreditRecordPO();
            fscCreditRecordOldQry.setObjId(reqBo.getOrderId());
            fscCreditRecordOldQry.setObjCode(reqBo.getOrderCode());
            fscCreditRecordOldQry.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
            List<FscCreditRecordPO> creditRecordAddList = this.fscCreditRecordMapper.getList(fscCreditRecordOldQry);
            if (CollectionUtils.isEmpty(creditRecordAddList)) {
                throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba2\u5355\u4e0b\u5355\u6388\u4fe1\u6263\u51cf\u8bb0\u5f55\u4e3a\u7a7a");
            }
            FscCreditRecordPO fscCreditRecordOld = creditRecordAddList.get(0);
            reqBo.setAccountId(fscCreditRecordOld.getAccountId());
            reqBo.setPayConfigId(fscCreditRecordOld.getPayConfigId());
            reqBo.setPurOrgId(fscCreditRecordOld.getPurOrgId());
            reqBo.setPurCompanyId(fscCreditRecordOld.getPurCompanyId());
            reqBo.setSupplierNo(fscCreditRecordOld.getSupplierNo());
            reqBo.setSupplierName(fscCreditRecordOld.getSupplierName());
            reqBo.setBusiModel(fscCreditRecordOld.getBusiModel());
            reqBo.setBusiType(fscCreditRecordOld.getBusiType());
            if (FscCreditBusiCategory.ORD_CANCEL.getCode().equals(reqBo.getBusiCategory())) {
                FscCreditRecordPO fscCreditRecordCheckBy = new FscCreditRecordPO();
                fscCreditRecordCheckBy.setObjId(reqBo.getOrderId());
                fscCreditRecordCheckBy.setObjCode(reqBo.getOrderCode());
                fscCreditRecordCheckBy.setBusiCategory(FscCreditBusiCategory.ORD_CANCEL.getCode());
                int checkBy = this.fscCreditRecordMapper.getCheckBy(fscCreditRecordCheckBy);
                if (checkBy > 0) {
                    String respDesc = "\u8ba2\u5355\u53d6\u6d88\u5df2\u5b58\u5728\uff0c\u672c\u8bb0\u5f55\u4e0d\u5165\u5e93.orderId:" + reqBo.getOrderId();
                    this.saveLog(Collections.singletonList(this.initLogPo(reqBo.getOrderId(), reqBo.getOrderId(), reqBo.getOrderCode(), null, reqBo.getUserId() + "", new Date(), JSON.toJSONString((Object)((Object)reqBo)), "", respDesc)));
                    rspBo.setRespDesc(respDesc);
                    return rspBo;
                }
            }
            if (FscCreditBusiCategory.ORD_PAY.getCode().equals(reqBo.getBusiCategory())) {
                FscCreditRecordPO fscCreditRecordPayQry = new FscCreditRecordPO();
                fscCreditRecordPayQry.setObjId(reqBo.getOrderId());
                fscCreditRecordPayQry.setObjCode(reqBo.getOrderCode());
                fscCreditRecordPayQry.setBusiCategory(FscCreditBusiCategory.ORD_PAY.getCode());
                List<FscCreditRecordPO> payList = this.fscCreditRecordMapper.getList(fscCreditRecordPayQry);
                if (CollUtil.isNotEmpty(payList)) {
                    if (reqBo.getInspectionId() != null && reqBo.getInspectionId() != 0L) {
                        List payInspectionList = payList.stream().filter(i -> i.getInspectionId() != null && reqBo.getInspectionId().equals(i.getInspectionId())).collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(payInspectionList)) {
                            BigDecimal havePayAmt = payInspectionList.stream().map(FscCreditRecordPO::getBusiAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                            log.warn("\u8ba2\u5355\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u8bb0\u5f55.\u64cd\u4f5c\u989d\u5ea6\uff1a{},\u5df2\u4ed8\u6b3e\u91d1\u989d:{},\u5b9e\u4ed8\u91d1\u989d\uff1a{},\u914d\u7f6e\u4e3b\u952e\uff1a{},\u8ba2\u5355ID\uff1a{}", new Object[]{reqBo.getBusiAmount(), havePayAmt, payAmount, reqBo.getPayConfigId(), reqBo.getOrderId()});
                            if (havePayAmt.compareTo(reqBo.getBusiAmount()) == 0) {
                                String respDesc = "\u9a8c\u6536\u5355\u4ed8\u6b3e\u5df2\u5b58\u5728\uff0c\u4ed8\u6b3e\u91d1\u989d\u4e0e\u5f53\u524d\u4ed8\u6b3e\u91d1\u989d\u4e00\u81f4\uff0c\u672c\u8bb0\u5f55\u4e0d\u5165\u5e93orderId:" + reqBo.getOrderId() + ".inspectionId:" + reqBo.getInspectionId();
                                this.saveLog(Collections.singletonList(this.initLogPo(reqBo.getOrderId(), reqBo.getOrderId(), reqBo.getOrderCode(), null, reqBo.getUserId() + "", new Date(), JSON.toJSONString((Object)((Object)reqBo)), "", respDesc)));
                                rspBo.setRespDesc(respDesc);
                                return rspBo;
                            }
                            payAmount = reqBo.getBusiAmount().subtract(havePayAmt);
                            String remark = "\u3010\u4ea4\u6613\u91d1\u989d:" + reqBo.getBusiAmount() + ".\u5df2\u4ed8\u91d1\u989d:" + havePayAmt + ".\u5f53\u524d\u4ea4\u6613\u91d1\u989d:" + payAmount + "\u3011";
                            reqBo.setRemark(remark + reqBo.getRemark());
                        }
                    } else {
                        BigDecimal ordAddAmt = fscCreditRecordOld.getBusiAmount().abs();
                        BigDecimal ordPayAmt = payList.stream().map(FscCreditRecordPO::getBusiAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).abs();
                        if (ordPayAmt.compareTo(ordAddAmt) >= 0) {
                            String respDesc = "\u8ba2\u5355\u4ed8\u6b3e\u91d1\u989d\uff1a" + ordPayAmt + "\uff0c\u672c\u8bb0\u5f55\u4e0d\u5165\u5e93orderId:" + reqBo.getOrderId();
                            this.saveLog(Collections.singletonList(this.initLogPo(reqBo.getOrderId(), reqBo.getOrderId(), reqBo.getOrderCode(), null, reqBo.getUserId() + "", new Date(), JSON.toJSONString((Object)((Object)reqBo)), "", respDesc)));
                            rspBo.setRespDesc(respDesc);
                            return rspBo;
                        }
                    }
                }
            }
        }
        FscPayConfigPO fscPayConfigPo = new FscPayConfigPO();
        fscPayConfigPo.setPayConfigId(reqBo.getPayConfigId());
        fscPayConfigPo = this.fscPayConfigMapper.getModelBy(fscPayConfigPo);
        if (fscPayConfigPo == null) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u652f\u4ed8\u914d\u7f6eID\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a");
        }
        if ((FscCreditBusiCategory.ORD_ADD.getCode().equals(reqBo.getBusiCategory()) || FscCreditBusiCategory.WRITE_OFF_FAIL.getCode().equals(reqBo.getBusiCategory())) && (FscCreditBusiType.ORD.getCode().equals(reqBo.getBusiType()) || FscCreditBusiType.ORD_PD.getCode().equals(reqBo.getBusiType())) && FscPayConfigControlStatus.RESTRICTED.getCode().equals(fscPayConfigPo.getCurrentOrgControlStatus())) {
            throw new PfscExtBusinessException("18000", "\u6263\u51cf\u6388\u4fe1\u5931\u8d25\uff0c\u8be5\u673a\u6784\u5f53\u524d\u4e3a\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001");
        }
        if (!FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigPo.getPayConfigType()) && !FscPayConfigType.DEF.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u652f\u4ed8\u914d\u7f6eID\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u7ed3\u679c\u9519\u8bef\uff0c\u4e0d\u662f\u5355\u4f4d\u652f\u4ed8\u914d\u7f6e");
        }
        if (!YesOrNo.YES.getCode().equals(fscPayConfigPo.getPayUsedPeriodFlag())) {
            throw new PfscExtBusinessException("18000", "\u8be5\u652f\u4ed8\u914d\u7f6e\u672a\u914d\u7f6e\u8fc7\u6388\u4fe1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u540e\u518d\u4f7f\u7528\u6388\u4fe1");
        }
        BigDecimal busiAmount = reqBo.getBusiAmount();
        if (FscCreditBusiCategory.ORD_PAY.getCode().equals(reqBo.getBusiCategory())) {
            busiAmount = payAmount;
        }
        BigDecimal creditAmount = fscPayConfigPo.getCreditAmount();
        BigDecimal usedAmount = Optional.ofNullable(fscPayConfigPo.getUsedAmount()).orElse(BigDecimal.ZERO);
        BigDecimal balanceAmount = Optional.ofNullable(fscPayConfigPo.getBalanceAmount()).orElse(BigDecimal.ZERO);
        log.warn("\u8ba2\u5355\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u8bb0\u5f55.\u64cd\u4f5c\u989d\u5ea6\uff1a{},\u5b9e\u4ed8\u91d1\u989d\uff1a{},\u603b\u989d\u5ea6\uff1a{},\u5df2\u4f7f\u7528\u989d\u5ea6\uff1a{},\u5269\u4f59\u989d\u5ea6\uff1a{},\u914d\u7f6e\u4e3b\u952e\uff1a{},\u8ba2\u5355ID\uff1a{}", new Object[]{busiAmount, payAmount, creditAmount, usedAmount, balanceAmount, reqBo.getPayConfigId(), reqBo.getOrderId()});
        if (usedAmount.compareTo(BigDecimal.ZERO) < 0) {
            throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u5f02\u5e38\uff0c\u5df2\u4f7f\u7528\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        if (creditAmount == null) {
            throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4e3a\u7a7a");
        }
        if (FscCreditBusiCategory.ORD_ADD.getCode().equals(reqBo.getBusiCategory()) || FscCreditBusiCategory.WRITE_OFF_FAIL.getCode().equals(reqBo.getBusiCategory()) || FscCreditBusiCategory.ORD_DIFF.getCode().equals(reqBo.getBusiCategory())) {
            if (busiAmount.compareTo(BigDecimal.ZERO) > 0) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u91d1\u989d\u5f02\u5e38\uff1a" + busiAmount);
            }
            if ((FscCreditBusiType.ORD.getCode().equals(reqBo.getBusiType()) || FscCreditBusiType.ORD_PD.getCode().equals(reqBo.getBusiType())) && (FscCreditBusiCategory.ORD_ADD.getCode().equals(reqBo.getBusiCategory()) || FscCreditBusiCategory.WRITE_OFF_FAIL.getCode().equals(reqBo.getBusiCategory())) && busiAmount.negate().add(usedAmount).compareTo(creditAmount) > 0) {
                throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4e0d\u8db3\uff0c\u5269\u4f59\u6388\u4fe1\u989d\u5ea6\uff1a" + balanceAmount + "\uff0c\u5f53\u524d\u8ba2\u5355\u91d1\u989d\uff1a" + busiAmount);
            }
            recordId = this.insertCreditRecord(reqBo, busiAmount, balanceAmount);
            rspBo.setRecordId(recordId);
            if (FscCreditBusiType.ORD.getCode().equals(reqBo.getBusiType()) || FscCreditBusiType.ORD_PD.getCode().equals(reqBo.getBusiType())) {
                this.fscPayConfigMapper.updateRebateAmount(reqBo.getPayConfigId(), busiAmount);
            }
        } else {
            recordId = this.insertCreditRecord(reqBo, busiAmount, balanceAmount);
            rspBo.setRecordId(recordId);
            if (FscCreditBusiType.ORD.getCode().equals(reqBo.getBusiType()) || FscCreditBusiType.ORD_PD.getCode().equals(reqBo.getBusiType()) || FscCreditBusiType.ORD_FL.getCode().equals(reqBo.getBusiType()) && FscCreditBusiCategory.ORD_PAY.getCode().equals(reqBo.getBusiCategory())) {
                this.fscPayConfigMapper.updateRebateAmount(reqBo.getPayConfigId(), busiAmount);
            }
        }
        this.dealCreditControl(reqBo.getPayConfigId());
        return rspBo;
    }

    @Override
    public FscOrderCreditRecordWriteOffFailBusiRspBO dealOrderCreditRecordWriteOffFail(FscOrderCreditRecordWriteOffFailBusiReqBO reqBo) {
        ValUtil.isEmpty(reqBo.getOrderId()).exception("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getBusiAmount()).exception("\u4ea4\u6613\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        FscOrderCreditRecordWriteOffFailBusiRspBO rspBo = FscRu.success(FscOrderCreditRecordWriteOffFailBusiRspBO.class);
        FscCreditRecordPO fscCreditRecordOld = new FscCreditRecordPO();
        fscCreditRecordOld.setObjId(reqBo.getOrderId());
        fscCreditRecordOld.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
        fscCreditRecordOld = this.fscCreditRecordMapper.getModelBy(fscCreditRecordOld);
        if (fscCreditRecordOld == null) {
            throw new PfscExtBusinessException("18000", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba2\u5355\u4e0b\u5355\u6388\u4fe1\u6263\u51cf\u8bb0\u5f55\u4e3a\u7a7a");
        }
        FscPayConfigPO fscPayConfigPo = new FscPayConfigPO();
        fscPayConfigPo.setPayConfigId(fscCreditRecordOld.getPayConfigId());
        fscPayConfigPo = this.fscPayConfigMapper.getModelBy(fscPayConfigPo);
        if (fscPayConfigPo == null) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u652f\u4ed8\u914d\u7f6eID\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (FscPayConfigControlStatus.RESTRICTED.getCode().equals(fscPayConfigPo.getCurrentOrgControlStatus())) {
            throw new PfscExtBusinessException("18000", "\u6838\u9500\u6263\u51cf\u6388\u4fe1\u5931\u8d25\uff0c\u8be5\u673a\u6784\u5f53\u524d\u4e3a\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001");
        }
        if (!FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigPo.getPayConfigType()) && !FscPayConfigType.DEF.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u652f\u4ed8\u914d\u7f6eID\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u7ed3\u679c\u9519\u8bef\uff0c\u4e0d\u662f\u5355\u4f4d\u652f\u4ed8\u914d\u7f6e");
        }
        if (!YesOrNo.YES.getCode().equals(fscPayConfigPo.getPayUsedPeriodFlag())) {
            throw new PfscExtBusinessException("18000", "\u8be5\u652f\u4ed8\u914d\u7f6e\u672a\u914d\u7f6e\u8fc7\u6388\u4fe1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u540e\u518d\u4f7f\u7528\u6388\u4fe1");
        }
        BigDecimal busiAmount = reqBo.getBusiAmount();
        BigDecimal creditAmount = fscPayConfigPo.getCreditAmount();
        BigDecimal usedAmount = Optional.ofNullable(fscPayConfigPo.getUsedAmount()).orElse(BigDecimal.ZERO);
        BigDecimal balanceAmount = Optional.ofNullable(fscPayConfigPo.getBalanceAmount()).orElse(BigDecimal.ZERO);
        log.warn("\u5e94\u4ed8\u6838\u9500\u5931\u8d25\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u8bb0\u5f55.\u64cd\u4f5c\u989d\u5ea6\uff1a{},\u603b\u989d\u5ea6\uff1a{},\u5df2\u4f7f\u7528\u989d\u5ea6\uff1a{},\u5269\u4f59\u989d\u5ea6\uff1a{},\u914d\u7f6e\u4e3b\u952e\uff1a{},\u8ba2\u5355ID\uff1a{}", new Object[]{busiAmount, creditAmount, usedAmount, balanceAmount, fscPayConfigPo.getPayConfigId(), reqBo.getOrderId()});
        if (usedAmount.compareTo(BigDecimal.ZERO) < 0) {
            throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u5f02\u5e38\uff0c\u5df2\u4f7f\u7528\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        if (creditAmount == null) {
            throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4e3a\u7a7a");
        }
        FscCreditRecordPO insertPo = new FscCreditRecordPO();
        insertPo.setRecordId(Sequence.getInstance().nextId());
        insertPo.setPayConfigId(fscCreditRecordOld.getPayConfigId());
        insertPo.setPurOrgId(fscCreditRecordOld.getPurOrgId());
        insertPo.setSupplierNo(fscCreditRecordOld.getSupplierNo());
        insertPo.setAccountId(fscCreditRecordOld.getAccountId());
        insertPo.setBusiAmount(busiAmount.negate());
        insertPo.setBusiBeforeAmount(balanceAmount);
        BigDecimal busiAfterAmount = balanceAmount.subtract(busiAmount);
        insertPo.setBusiAfterAmount(busiAfterAmount);
        insertPo.setObjId(reqBo.getOrderId());
        insertPo.setObjCode(fscCreditRecordOld.getObjCode());
        insertPo.setBusiCategory(fscCreditRecordOld.getBusiCategory());
        insertPo.setBusiType(fscCreditRecordOld.getBusiType());
        insertPo.setBusiModel(fscCreditRecordOld.getBusiModel());
        insertPo.setCreateTime(new Date());
        insertPo.setCreateUserId(reqBo.getUserId());
        insertPo.setCreateUserName(reqBo.getUsername());
        this.fscCreditRecordMapper.insert(insertPo);
        rspBo.setRecordId(insertPo.getRecordId());
        if (FscCreditBusiType.ORD.getCode().equals(fscCreditRecordOld.getBusiType()) || FscCreditBusiType.ORD_PD.getCode().equals(fscCreditRecordOld.getBusiType())) {
            this.fscPayConfigMapper.updateUsedAmount(fscPayConfigPo.getPayConfigId(), busiAmount);
        }
        return rspBo;
    }

    @Override
    public FscActCreditRecordAddBusiRspBO dealActCreditRecord(FscActCreditRecordAddBusiReqBO reqBo) {
        FscActCreditRecordAddBusiRspBO rspBo = FscRu.success(FscActCreditRecordAddBusiRspBO.class);
        rspBo.setRecordIds(new ArrayList<Long>(1));
        FscPayConfigPO fscPayConfigPo = new FscPayConfigPO();
        if (FscCreditBusiCategory.ACT_ADD.getCode().equals(reqBo.getBusiCategory())) {
            fscPayConfigPo.setPaySubType(reqBo.getPaySubType());
            fscPayConfigPo.setPaySubClass(reqBo.getPaySubClass());
        } else {
            FscCreditRecordPO fscCreditRecordQry = new FscCreditRecordPO();
            fscCreditRecordQry.setObjId(reqBo.getActivityId());
            fscCreditRecordQry.setBusiCategory(FscCreditBusiCategory.ACT_ADD.getCode());
            List<FscCreditRecordPO> addActList = this.fscCreditRecordMapper.getList(fscCreditRecordQry);
            if (CollectionUtils.isEmpty(addActList)) {
                throw new PfscExtBusinessException("18000", "\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6388\u4fe1\u4f7f\u7528\u8bb0\u5f55");
            }
            fscPayConfigPo.setPayConfigId(addActList.get(0).getPayConfigId());
        }
        fscPayConfigPo.setPayOrgId(reqBo.getPurOrgId());
        fscPayConfigPo.setPayBusiType(FscPayConfigBusiType.FL.getCode());
        fscPayConfigPo = this.fscPayConfigMapper.getModelBy(fscPayConfigPo);
        if (fscPayConfigPo == null) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a");
        }
        if (!FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigPo.getPayConfigType()) && !FscPayConfigType.DEF.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u7ed3\u679c\u9519\u8bef\uff0c\u4e0d\u662f\u5355\u4f4d\u652f\u4ed8\u914d\u7f6e");
        }
        if (!YesOrNo.YES.getCode().equals(fscPayConfigPo.getPayUsedPeriodFlag())) {
            throw new PfscExtBusinessException("18000", "\u8be5\u652f\u4ed8\u914d\u7f6e\u672a\u914d\u7f6e\u8fc7\u6388\u4fe1,\u8bf7\u68c0\u67e5\u914d\u7f6e\u540e\u518d\u4f7f\u7528\u6388\u4fe1");
        }
        BigDecimal creditAmount = fscPayConfigPo.getCreditAmount();
        BigDecimal usedAmount = Optional.ofNullable(fscPayConfigPo.getUsedAmount()).orElse(BigDecimal.ZERO);
        BigDecimal balanceAmount = Optional.ofNullable(fscPayConfigPo.getBalanceAmount()).orElse(BigDecimal.ZERO);
        BigDecimal beforeAmountAll = reqBo.getUserInfos().stream().map(FscActCreditRecordAddUserInfoBO::getBeforeAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal afterAmountAll = reqBo.getUserInfos().stream().map(FscActCreditRecordAddUserInfoBO::getAfterAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal busiAmountAll = afterAmountAll.subtract(beforeAmountAll);
        log.warn("\u6d3b\u52a8\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u8bb0\u5f55.\u64cd\u4f5c\u603b\u989d\u5ea6\uff1a{},\u603b\u989d\u5ea6\uff1a{},\u5df2\u4f7f\u7528\u989d\u5ea6\uff1a{},\u5269\u4f59\u989d\u5ea6\uff1a{},\u914d\u7f6e\u4e3b\u952e\uff1a{},\u6d3b\u52a8ID\uff1a{}", new Object[]{busiAmountAll, creditAmount, usedAmount, balanceAmount, fscPayConfigPo.getPayConfigId(), reqBo.getActivityId()});
        if (creditAmount == null) {
            throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4e3a\u7a7a");
        }
        if (usedAmount.compareTo(BigDecimal.ZERO) < 0) {
            throw new PfscExtBusinessException("18000", "\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u5f02\u5e38\uff0c\u5df2\u4f7f\u7528\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        if (busiAmountAll.add(usedAmount.abs()).compareTo(creditAmount) > 0) {
            throw new PfscExtBusinessException("18000", "\u60a8\u7684\u6388\u4fe1\u989d\u5ea6\u5df2\u7528\u5b8c\uff0c\u65e0\u6cd5\u6dfb\u52a0\u6d3b\u52a8\u79ef\u5206");
        }
        ArrayList<FscCreditRecordPO> recordList = new ArrayList<FscCreditRecordPO>(reqBo.getUserInfos().size());
        BigDecimal balanceAmountUsed = balanceAmount.add(BigDecimal.ZERO);
        for (FscActCreditRecordAddUserInfoBO userInfo : reqBo.getUserInfos()) {
            BigDecimal busiAmount = userInfo.getBeforeAmount().subtract(userInfo.getAfterAmount());
            FscCreditRecordPO insertPo = new FscCreditRecordPO();
            insertPo.setRecordId(Sequence.getInstance().nextId());
            insertPo.setPayConfigId(fscPayConfigPo.getPayConfigId());
            insertPo.setPurOrgId(reqBo.getPurOrgId());
            insertPo.setPurCompanyId(reqBo.getPurCompanyId());
            insertPo.setSupplierNo(0L);
            insertPo.setAccountId(reqBo.getAccountId());
            insertPo.setBusiAmount(busiAmount);
            insertPo.setBusiBeforeAmount(balanceAmountUsed);
            balanceAmountUsed = balanceAmountUsed.add(busiAmount);
            insertPo.setBusiAfterAmount(balanceAmountUsed);
            insertPo.setObjId(reqBo.getActivityId());
            insertPo.setObjCode(reqBo.getActivityNo());
            insertPo.setBusiCategory(reqBo.getBusiCategory());
            insertPo.setBusiType(FscCreditBusiType.ACT.getCode());
            insertPo.setBusiModel(reqBo.getBusiModel());
            insertPo.setActUserId(userInfo.getActUserId());
            insertPo.setActUserName(userInfo.getActUserName());
            insertPo.setCreateTime(new Date());
            insertPo.setCreateUserId(reqBo.getUserId());
            insertPo.setCreateUserName(reqBo.getUsername());
            recordList.add(insertPo);
            rspBo.getRecordIds().add(insertPo.getRecordId());
        }
        List subRecordList = ListUtil.batchList(recordList, (int)50);
        for (List recordPos : subRecordList) {
            this.fscCreditRecordMapper.insertBatch(recordPos);
        }
        if (BigDecimal.ZERO.compareTo(busiAmountAll) != 0) {
            this.fscPayConfigMapper.updateUsedAmount(fscPayConfigPo.getPayConfigId(), busiAmountAll);
            this.dealCreditControl(fscPayConfigPo.getPayConfigId());
        }
        return rspBo;
    }

    @Override
    public FscOrderCreditRecordPayBusiRspBO dealOrderCreditRecordPay(FscOrderCreditRecordPayBusiReqBO reqBo) {
        if (CollectionUtils.isEmpty(reqBo.getCreditRecordList())) {
            throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u8ba2\u5355\u96c6\u5408\u4e3a\u7a7a");
        }
        HashSet<String> objCodeSet = new HashSet<String>();
        for (FscOrderCreditRecordPayInfoBO payInfoBo : reqBo.getCreditRecordList()) {
            if (!StringUtils.hasText((String)payInfoBo.getOrderCode())) {
                throw new PfscExtBusinessException("18000", "\u4ed8\u6b3e\u8ba2\u5355\u96c6\u5408\u7684\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            objCodeSet.add(payInfoBo.getOrderCode());
        }
        Map<String, List<FscCreditRecordPO>> mapCreditRecord = this.mapCreditRecord(objCodeSet);
        ArrayList<FscOrderCreditRecordPayInfoBO> insertPayInfoBoList = new ArrayList<FscOrderCreditRecordPayInfoBO>();
        ArrayList<FscExtInterLogBatchAddInfoBO> logList = new ArrayList<FscExtInterLogBatchAddInfoBO>();
        ArrayList<FscCreditRecordPO> insertCreditRecordList = new ArrayList<FscCreditRecordPO>();
        ArrayList<Long> recordIds = new ArrayList<Long>();
        Date nowTime = new Date();
        for (FscOrderCreditRecordPayInfoBO payInfoBo : reqBo.getCreditRecordList()) {
            String orderCode = payInfoBo.getOrderCode();
            List<FscCreditRecordPO> orderAddRecordPos = mapCreditRecord.get(orderCode);
            if (CollectionUtils.isEmpty(orderAddRecordPos)) {
                logList.add(this.initLogPo(payInfoBo.getOrderId(), payInfoBo.getOrderId(), payInfoBo.getOrderCode(), reqBo.getInterCode(), reqBo.getUserId() + "", nowTime, JSON.toJSONString((Object)payInfoBo), "", "\u56de\u6b3e\u6838\u9500\u5931\u8d25\uff0c\u5e94\u4ed8\u5bf9\u5e94\u4e0b\u5355\u6263\u51cf\u6388\u4fe1\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u4e0d\u9000\u6388\u4fe1"));
                continue;
            }
            FscCreditRecordPO fscCreditRecordOld = orderAddRecordPos.get(0);
            if (FscCreditBusiCategory.ORD_PAY.getCode().equals(payInfoBo.getBusiCategory())) {
                FscCreditRecordPO fscCreditRecordPayQry = new FscCreditRecordPO();
                fscCreditRecordPayQry.setObjId(payInfoBo.getOrderId());
                fscCreditRecordPayQry.setObjCode(payInfoBo.getOrderCode());
                fscCreditRecordPayQry.setBusiCategory(FscCreditBusiCategory.ORD_PAY.getCode());
                List<FscCreditRecordPO> payList = this.fscCreditRecordMapper.getList(fscCreditRecordPayQry);
                if (CollUtil.isNotEmpty(payList)) {
                    if (payInfoBo.getInspectionId() != null && payInfoBo.getInspectionId() != 0L) {
                        long count = payList.stream().filter(i -> i.getInspectionId() != null && payInfoBo.getInspectionId().equals(i.getInspectionId())).count();
                        if (count > 0L) {
                            logList.add(this.initLogPo(payInfoBo.getOrderId(), payInfoBo.getOrderId(), payInfoBo.getOrderCode(), reqBo.getInterCode(), reqBo.getUserId() + "", nowTime, JSON.toJSONString((Object)payInfoBo), "", "\u56de\u6b3e\u6838\u9500\u5931\u8d25,\u9a8c\u6536\u5355\u4ed8\u6b3e\u8bb0\u5f55\u5df2\u5b58\u5728\uff0c\u672c\u8bb0\u5f55\u4e0d\u5165\u5e93orderId:" + payInfoBo.getOrderId() + ".inspectionId:" + payInfoBo.getInspectionId()));
                            continue;
                        }
                    } else {
                        BigDecimal ordAddAmt = fscCreditRecordOld.getBusiAmount().abs();
                        BigDecimal ordPayAmt = payList.stream().map(FscCreditRecordPO::getBusiAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add).abs();
                        if (ordPayAmt.compareTo(ordAddAmt) >= 0) {
                            logList.add(this.initLogPo(payInfoBo.getOrderId(), payInfoBo.getOrderId(), payInfoBo.getOrderCode(), reqBo.getInterCode(), reqBo.getUserId() + "", nowTime, JSON.toJSONString((Object)payInfoBo), "", "\u56de\u6b3e\u6838\u9500\u5931\u8d25,\u8ba2\u5355\u4ed8\u6b3e\u91d1\u989d:" + ordPayAmt + "\uff0c\u672c\u8bb0\u5f55\u4e0d\u5165\u5e93orderId:" + payInfoBo.getOrderId()));
                            continue;
                        }
                    }
                }
            }
            payInfoBo.setAccountId(fscCreditRecordOld.getAccountId());
            payInfoBo.setPayConfigId(fscCreditRecordOld.getPayConfigId());
            payInfoBo.setPurOrgId(fscCreditRecordOld.getPurOrgId());
            payInfoBo.setPurCompanyId(fscCreditRecordOld.getPurCompanyId());
            payInfoBo.setSupplierNo(fscCreditRecordOld.getSupplierNo());
            payInfoBo.setSupplierName(fscCreditRecordOld.getSupplierName());
            payInfoBo.setBusiModel(fscCreditRecordOld.getBusiModel());
            payInfoBo.setBusiType(fscCreditRecordOld.getBusiType());
            insertPayInfoBoList.add(payInfoBo);
        }
        if (!CollectionUtils.isEmpty(insertPayInfoBoList)) {
            Map<Long, FscPayConfigPO> mapPayConfigPo = this.mapPayConfigPo(insertPayInfoBoList);
            Map<Long, List<FscOrderCreditRecordPayInfoBO>> mapOrderCreditRecordPayInfo = insertPayInfoBoList.stream().collect(Collectors.groupingBy(FscOrderCreditRecordPayInfoBO::getPayConfigId));
            for (Map.Entry<Long, List<FscOrderCreditRecordPayInfoBO>> entry : mapOrderCreditRecordPayInfo.entrySet()) {
                int count;
                Long payConfigId = entry.getKey();
                List<FscOrderCreditRecordPayInfoBO> payInfoList = entry.getValue();
                FscPayConfigPO fscPayConfigPo = (FscPayConfigPO)mapPayConfigPo.get(payConfigId);
                if (fscPayConfigPo == null) {
                    throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a" + payConfigId);
                }
                BigDecimal busiAmount = payInfoList.stream().map(FscOrderCreditRecordPayInfoBO::getBusiAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (BigDecimal.ZERO.compareTo(busiAmount) != 0 && (count = this.fscPayConfigMapper.updateRebateAmount(payConfigId, busiAmount)) > 1) {
                    throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u914d\u7f6e\u66f4\u65b0\u6388\u4fe1\u989d\u5ea6\u5f02\u5e38\uff0ccount:" + count + ".payConfigId:" + payConfigId);
                }
                BigDecimal balanceAmount = Optional.ofNullable(fscPayConfigPo.getBalanceAmount()).orElse(BigDecimal.ZERO);
                for (FscOrderCreditRecordPayInfoBO fscOrderCreditRecordPayInfoBo : payInfoList) {
                    FscCreditRecordPO insertPo = new FscCreditRecordPO();
                    insertPo.setRecordId(Sequence.getInstance().nextId());
                    insertPo.setPayConfigId(payConfigId);
                    insertPo.setPurOrgId(fscOrderCreditRecordPayInfoBo.getPurOrgId());
                    insertPo.setPurCompanyId(fscOrderCreditRecordPayInfoBo.getPurCompanyId());
                    insertPo.setSupplierNo(fscOrderCreditRecordPayInfoBo.getSupplierNo());
                    insertPo.setSupplierName(fscOrderCreditRecordPayInfoBo.getSupplierName());
                    insertPo.setAccountId(fscOrderCreditRecordPayInfoBo.getAccountId());
                    insertPo.setBusiAmount(fscOrderCreditRecordPayInfoBo.getBusiAmount());
                    insertPo.setBusiBeforeAmount(balanceAmount);
                    balanceAmount = balanceAmount.add(Optional.ofNullable(insertPo.getBusiAmount()).orElse(BigDecimal.ZERO));
                    insertPo.setBusiAfterAmount(balanceAmount);
                    insertPo.setObjId(fscOrderCreditRecordPayInfoBo.getOrderId());
                    insertPo.setObjCode(fscOrderCreditRecordPayInfoBo.getOrderCode());
                    insertPo.setBusiCategory(fscOrderCreditRecordPayInfoBo.getBusiCategory());
                    insertPo.setBusiType(fscOrderCreditRecordPayInfoBo.getBusiType());
                    insertPo.setBusiModel(fscOrderCreditRecordPayInfoBo.getBusiModel());
                    insertPo.setPayApplyCode(fscOrderCreditRecordPayInfoBo.getPayApplyCode());
                    insertPo.setInspectionId(fscOrderCreditRecordPayInfoBo.getInspectionId());
                    insertPo.setCreateTime(nowTime);
                    insertPo.setCreateUserId(reqBo.getUserId());
                    insertPo.setCreateUserName(reqBo.getUsername());
                    insertPo.setRemark(fscOrderCreditRecordPayInfoBo.getRemark());
                    insertCreditRecordList.add(insertPo);
                    recordIds.add(insertPo.getRecordId());
                }
            }
        }
        if (!CollectionUtils.isEmpty(logList)) {
            this.saveLog(logList);
        }
        if (!CollectionUtils.isEmpty(insertCreditRecordList)) {
            for (List subList : ListUtil.batchList(insertCreditRecordList, (int)50)) {
                this.fscCreditRecordMapper.insertBatch(subList);
            }
        }
        FscOrderCreditRecordPayBusiRspBO rspBo = FscRu.success(FscOrderCreditRecordPayBusiRspBO.class);
        rspBo.setRecordIds(recordIds);
        return rspBo;
    }

    private Map<Long, FscPayConfigPO> mapPayConfigPo(List<FscOrderCreditRecordPayInfoBO> insertPayInfoBoList) {
        HashMap<Long, FscPayConfigPO> mapPayConfig = new HashMap<Long, FscPayConfigPO>();
        List payConfigIdList = insertPayInfoBoList.stream().map(FscOrderCreditRecordPayInfoBO::getPayConfigId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        for (List subList : ListUtil.batchList(payConfigIdList)) {
            FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
            fscPayConfigQry.setPayConfigIdList(subList);
            List<FscPayConfigPO> list = this.fscPayConfigMapper.getList(fscPayConfigQry);
            if (CollectionUtils.isEmpty(list)) continue;
            mapPayConfig.putAll(list.stream().collect(Collectors.toMap(FscPayConfigPO::getPayConfigId, Function.identity(), (cur, old) -> cur)));
        }
        return mapPayConfig;
    }

    private FscExtInterLogBatchAddInfoBO initLogPo(Long orderId, Long objId, String objCode, String interCode, String createLoginId, Date nowTime, String reqJson, String rspJson, String errDetail) {
        FscExtInterLogBatchAddInfoBO logItemInfoBo = new FscExtInterLogBatchAddInfoBO();
        logItemInfoBo.setObjId(objId);
        logItemInfoBo.setObjCode(objCode);
        logItemInfoBo.setObjType(FscConstants.FscExtInterLogObjType.PAY_CREDIT_BACK);
        logItemInfoBo.setOrderId(orderId);
        logItemInfoBo.setInterSn("1");
        logItemInfoBo.setInterCode(interCode);
        logItemInfoBo.setFlowFlag(1);
        logItemInfoBo.setInContent(reqJson);
        logItemInfoBo.setOutContent(rspJson);
        logItemInfoBo.setCallCount(0);
        logItemInfoBo.setCallTime(nowTime);
        logItemInfoBo.setRetTime(nowTime);
        logItemInfoBo.setCallState("18000");
        logItemInfoBo.setErrCode("18000");
        logItemInfoBo.setErrDetail(errDetail);
        logItemInfoBo.setCreateTime(new Date());
        logItemInfoBo.setCreateLoginId(createLoginId);
        return logItemInfoBo;
    }

    private Map<String, List<FscCreditRecordPO>> mapCreditRecord(Set<String> objCodeSet) {
        HashMap<String, List<FscCreditRecordPO>> mapCreditRecord = new HashMap<String, List<FscCreditRecordPO>>();
        ArrayList<String> objCodeList = new ArrayList<String>(objCodeSet);
        if (!CollectionUtils.isEmpty(objCodeList)) {
            for (List subList : ListUtil.batchList(objCodeList)) {
                FscCreditRecordPO fscCreditRecordQry = new FscCreditRecordPO();
                fscCreditRecordQry.setObjCodeList(subList);
                fscCreditRecordQry.setBusiCategory(FscCreditBusiCategory.ORD_ADD.getCode());
                List<FscCreditRecordPO> recordPos = this.fscCreditRecordMapper.getList(fscCreditRecordQry);
                if (CollectionUtils.isEmpty(recordPos)) continue;
                mapCreditRecord.putAll(recordPos.stream().collect(Collectors.groupingBy(FscCreditRecordPO::getObjCode)));
            }
        }
        return mapCreditRecord;
    }

    private void saveLog(List<FscExtInterLogBatchAddInfoBO> logList) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            FscExtInterLogBatchAddAtomReqBO logAtomReqBo = new FscExtInterLogBatchAddAtomReqBO();
            logAtomReqBo.setInfoList(logList);
            this.fscExtInterLogAtomService.dealFscExtInterLogBatchAdd(logAtomReqBo);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u65e5\u5fd7\u5f02\u5e38\uff1a{}", (Object)e.toString());
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private void dealCreditControl(Long payConfigId) {
        FscCreditControlBusiReqBO reqBo = new FscCreditControlBusiReqBO();
        reqBo.setPayConfigId(payConfigId);
        FscCreditControlBusiRspBO rspBo = this.fscCreditControlBusiService.dealCreditControl(reqBo);
        if (FscRu.isFailed(rspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(rspBo.getRespCode(), "\u66f4\u65b0\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001\u5f02\u5e38\uff1a" + rspBo.getRespDesc());
        }
    }

    private Long insertCreditRecord(FscOrderCreditRecordBusiReqBO reqBo, BigDecimal busiAmount, BigDecimal balanceAmount) {
        FscCreditRecordPO insertPo = new FscCreditRecordPO();
        insertPo.setRecordId(Sequence.getInstance().nextId());
        insertPo.setPayConfigId(reqBo.getPayConfigId());
        insertPo.setPurOrgId(reqBo.getPurOrgId());
        insertPo.setPurCompanyId(reqBo.getPurCompanyId());
        insertPo.setSupplierNo(reqBo.getSupplierNo());
        insertPo.setSupplierName(reqBo.getSupplierName());
        insertPo.setAccountId(reqBo.getAccountId());
        insertPo.setBusiAmount(busiAmount);
        insertPo.setBusiBeforeAmount(balanceAmount);
        insertPo.setBusiAfterAmount(balanceAmount.add(busiAmount));
        insertPo.setObjId(reqBo.getOrderId());
        insertPo.setObjCode(reqBo.getOrderCode());
        insertPo.setBusiCategory(reqBo.getBusiCategory());
        insertPo.setBusiType(reqBo.getBusiType());
        insertPo.setBusiModel(reqBo.getBusiModel());
        insertPo.setPayApplyCode(reqBo.getPayApplyCode());
        insertPo.setInspectionId(reqBo.getInspectionId());
        insertPo.setCreateTime(new Date());
        insertPo.setCreateUserId(reqBo.getUserId());
        insertPo.setCreateUserName(reqBo.getUsername());
        insertPo.setRemark(StrUtil.subPre((CharSequence)reqBo.getRemark(), (int)199));
        this.fscCreditRecordMapper.insert(insertPo);
        return insertPo.getRecordId();
    }
}

