/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.ability.bo.FscOrderBeachHangAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscOrderBeachHangAbilityRspBO;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscOrderBeachHangBusiService;
import com.tydic.pfscext.utils.FscRu;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscOrderBeachHangBusiServiceImpl
implements FscOrderBeachHangBusiService {
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @Override
    public FscOrderBeachHangAbilityRspBO dealPurchaseOrderHang(FscOrderBeachHangAbilityReqBO reqBo) {
        for (Long inspectionId : reqBo.getInspectionIdList()) {
            PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
            orderInfo.setInspectionId(inspectionId);
            orderInfo.setOrderStatus(OrderStatus.HANGING.getCode());
            orderInfo.setRemark(reqBo.getRemark());
            orderInfo.setHangDate(new Date());
            int count = this.payPurchaseOrderInfoMapper.updateBy(orderInfo);
            if (count == 1) continue;
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u9a8c\u6536\u5355[" + inspectionId + "]\u4fe1\u606f\u5931\u8d25");
        }
        return FscRu.success(FscOrderBeachHangAbilityRspBO.class);
    }

    @Override
    public FscOrderBeachHangAbilityRspBO dealPurchaseOrderCancelHang(FscOrderBeachHangAbilityReqBO reqBo) {
        for (Long inspectionId : reqBo.getInspectionIdList()) {
            PayPurchaseOrderInfo orderInfo = new PayPurchaseOrderInfo();
            orderInfo.setInspectionId(inspectionId);
            orderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            orderInfo.setRemark("");
            int count = this.payPurchaseOrderInfoMapper.updateByCancel(orderInfo);
            if (count == 1) continue;
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u9a8c\u6536\u5355[" + inspectionId + "]\u4fe1\u606f\u5931\u8d25");
        }
        return FscRu.success(FscOrderBeachHangAbilityRspBO.class);
    }

    @Override
    public FscOrderBeachHangAbilityRspBO dealSaleOrderHang(FscOrderBeachHangAbilityReqBO reqBo) {
        for (Long inspectionId : reqBo.getInspectionIdList()) {
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setInspectionId(inspectionId);
            saleOrderInfo.setOrderStatus(OrderStatus.HANGING.getCode());
            saleOrderInfo.setHangDate(new Date());
            int count = this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfo);
            if (count == 1) continue;
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u9a8c\u6536\u5355[" + inspectionId + "]\u4fe1\u606f\u5931\u8d25");
        }
        return FscRu.success(FscOrderBeachHangAbilityRspBO.class);
    }

    @Override
    public FscOrderBeachHangAbilityRspBO dealSaleOrderCancelHang(FscOrderBeachHangAbilityReqBO reqBo) {
        for (Long inspectionId : reqBo.getInspectionIdList()) {
            SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
            saleOrderInfo.setInspectionId(inspectionId);
            saleOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            saleOrderInfo.setHangDate(null);
            int count = this.saleOrderInfoMapper.updateByPrimaryKeySelective(saleOrderInfo);
            if (count == 1) continue;
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u9a8c\u6536\u5355[" + inspectionId + "]\u4fe1\u606f\u5931\u8d25");
        }
        return FscRu.success(FscOrderBeachHangAbilityRspBO.class);
    }
}

