/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.dao.FscUserOverdueControlConfigMapper;
import com.tydic.pfscext.dao.FscUserOverdueStatisticsMapper;
import com.tydic.pfscext.dao.po.FscUserOverdueControlConfigPO;
import com.tydic.pfscext.dao.po.FscUserOverdueStatisticsPO;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.external.umc.api.FscUmcQryAccountListExternalService;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalReqBO;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalRspBO;
import com.tydic.pfscext.service.busi.FscOrderCheckUserControlConfigBusiService;
import com.tydic.pfscext.service.busi.bo.FscOrderCheckUserControlConfigBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscOrderCheckUserControlConfigBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscOrderCheckUserControlConfigBusiServiceImpl
implements FscOrderCheckUserControlConfigBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderCheckUserControlConfigBusiServiceImpl.class);
    @Autowired
    private FscUserOverdueStatisticsMapper fscUserOverdueStatisticsMapper;
    @Autowired
    private FscUserOverdueControlConfigMapper fscUserOverdueControlConfigMapper;
    @Autowired
    private FscUmcQryAccountListExternalService fscUmcQryAccountListExternalService;

    @Override
    public FscOrderCheckUserControlConfigBusiRspBO dealOrderCheckUserControlConfig(FscOrderCheckUserControlConfigBusiReqBO reqBo) {
        FscOrderCheckUserControlConfigBusiRspBO rspBo = FscRu.success(FscOrderCheckUserControlConfigBusiRspBO.class);
        if (reqBo.getUmcUserId() == null || reqBo.getUmcUserId() == 0L) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
            return rspBo;
        }
        FscUserOverdueStatisticsPO statisticsPo = new FscUserOverdueStatisticsPO();
        statisticsPo.setConfigUserId(reqBo.getUmcUserId());
        statisticsPo = this.fscUserOverdueStatisticsMapper.getModelBy(statisticsPo);
        if (statisticsPo != null) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6839\u636e\u7528\u6237ID[" + reqBo.getUmcUserId() + "]\u5df2\u5b58\u5728");
            return rspBo;
        }
        FscUmcQryMemListExternalReqBO umcReqBo = new FscUmcQryMemListExternalReqBO();
        umcReqBo.setPageSize(Integer.valueOf(10));
        umcReqBo.setPageNo(Integer.valueOf(1));
        umcReqBo.setUserIds(Collections.singletonList(reqBo.getUmcUserId()));
        FscUmcQryMemListExternalRspBO umcRspBo = this.fscUmcQryAccountListExternalService.qryMem(umcReqBo);
        if (CollectionUtils.isEmpty((Collection)umcRspBo.getRows())) {
            log.error("\u6839\u636e\u7528\u6237ID\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u7ed3\u679c\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6:" + JSON.toJSONString((Object)umcReqBo) + ".\u67e5\u8be2\u5b50\u8d26\u6237\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcRspBo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u6839\u636e\u7528\u6237ID[" + reqBo.getUmcUserId() + "]\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u7ed3\u679c\u4e3a\u7a7a");
            return rspBo;
        }
        Map mapUserInfo = umcRspBo.getRows().stream().filter(i -> i.getUserId() != null && i.getUserId() != 0L).collect(Collectors.toMap(UmcMemDetailInfoAbilityBO::getUserId, Function.identity(), (c, o) -> c));
        if (mapUserInfo.keySet().isEmpty()) {
            log.error("\u6839\u636e\u7528\u6237ID\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u7ed3\u679c\u4e2duserId\u5168\u4e3a\u7a7a\u3002\u67e5\u8be2\u6761\u4ef6:" + JSON.toJSONString((Object)umcReqBo) + ".\u67e5\u8be2\u8d26\u6237\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)umcRspBo, (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u6839\u636e\u7528\u6237ID[" + reqBo.getUmcUserId() + "]\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u7ed3\u679c\u4e2duserId\u5168\u4e3a\u7a7a");
            return rspBo;
        }
        FscUserOverdueStatisticsPO fscUserOverdueStatisticsQry = new FscUserOverdueStatisticsPO();
        fscUserOverdueStatisticsQry.setConfigUserIdList(new ArrayList<Long>(mapUserInfo.keySet()));
        List<FscUserOverdueStatisticsPO> statisticsList = this.fscUserOverdueStatisticsMapper.getList(fscUserOverdueStatisticsQry);
        ArrayList<Long> configUserIdListNew = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(statisticsList)) {
            List configUserIdList = statisticsList.stream().map(FscUserOverdueStatisticsPO::getConfigUserId).distinct().collect(Collectors.toList());
            configUserIdListNew.addAll(mapUserInfo.keySet().stream().filter(i -> !configUserIdList.contains(i)).collect(Collectors.toList()));
        } else {
            configUserIdListNew.addAll(mapUserInfo.keySet());
        }
        if (CollectionUtils.isEmpty(configUserIdListNew)) {
            rspBo.setRespCode("18000");
            rspBo.setRespDesc("\u6839\u636e\u7528\u6237ID[" + reqBo.getUmcUserId() + "]\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u6240\u6709userId\u90fd\u5df2\u5b58\u5728");
            return rspBo;
        }
        FscUserOverdueControlConfigPO configPo = new FscUserOverdueControlConfigPO();
        configPo.setConfigType("1");
        configPo.setDeleteFlag(YesOrNo.NO.getCode());
        configPo = this.fscUserOverdueControlConfigMapper.getModelBy(configPo);
        if (configPo == null) {
            log.error("\u6839\u636e\u7528\u6237ID\u65b0\u589e\u5b50\u8d26\u6237\u7528\u6237\u903e\u671f\u914d\u7f6e\u5931\u8d25\uff0c\u4e3b\u914d\u7f6e\u4e0d\u5b58\u5728:" + configUserIdListNew);
            rspBo.setRespDesc("\u6839\u636e\u7528\u6237ID[" + reqBo.getUmcUserId() + "]\u65b0\u589e\u5b50\u8d26\u6237\u7528\u6237\u903e\u671f\u914d\u7f6e\u5931\u8d25\uff0c\u4e3b\u914d\u7f6e\u4e0d\u5b58\u5728");
            return rspBo;
        }
        for (Long configUserId : configUserIdListNew) {
            UmcMemDetailInfoAbilityBO umcInfoBo = (UmcMemDetailInfoAbilityBO)mapUserInfo.get(configUserId);
            if (umcInfoBo != null) {
                FscUserOverdueStatisticsPO fscUserOverdueStatisticsPo = new FscUserOverdueStatisticsPO();
                fscUserOverdueStatisticsPo.setStatisticsId(Sequence.getInstance().nextId());
                fscUserOverdueStatisticsPo.setConfigId(configPo.getConfigId());
                fscUserOverdueStatisticsPo.setConfigType("0");
                fscUserOverdueStatisticsPo.setCurrentUserControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
                fscUserOverdueStatisticsPo.setCurrentOrderOverdueNum(0);
                fscUserOverdueStatisticsPo.setCurrentOrderCreditNum(0);
                fscUserOverdueStatisticsPo.setOrderCreditAmount(BigDecimal.ZERO);
                fscUserOverdueStatisticsPo.setOrderOverdueAmount(BigDecimal.ZERO);
                fscUserOverdueStatisticsPo.setConfigOrgId(umcInfoBo.getOrgId());
                fscUserOverdueStatisticsPo.setConfigOrgName(umcInfoBo.getOrgName());
                fscUserOverdueStatisticsPo.setConfigOrgPath(umcInfoBo.getOrgTreePath());
                fscUserOverdueStatisticsPo.setConfigOrgFullName(umcInfoBo.getOrgFullName());
                fscUserOverdueStatisticsPo.setConfigUserId(umcInfoBo.getUserId());
                fscUserOverdueStatisticsPo.setConfigUserAccount(umcInfoBo.getRegAccount());
                fscUserOverdueStatisticsPo.setConfigUserName(umcInfoBo.getMemName2());
                fscUserOverdueStatisticsPo.setConfigAuthRole(umcInfoBo.getUserFullRoleName());
                fscUserOverdueStatisticsPo.setDeleteFlag(YesOrNo.NO.getCode());
                fscUserOverdueStatisticsPo.setCreateTime(new Date());
                fscUserOverdueStatisticsPo.setCreateUserId(umcInfoBo.getUserId());
                fscUserOverdueStatisticsPo.setCreateUserName("\u4e0b\u5355\u751f\u6210");
                this.fscUserOverdueStatisticsMapper.insert(fscUserOverdueStatisticsPo);
                continue;
            }
            log.error("\u6839\u636e\u7528\u6237ID\u65b0\u589e\u5b50\u8d26\u6237\u7528\u6237\u903e\u671f\u914d\u7f6e\u5f02\u5e38\uff0c\u673a\u6784\u6570\u636e\u4e0d\u5b58\u5728userId:" + configUserId);
        }
        return rspBo;
    }
}

