/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.pfscext.api.busi.FscOssUploadFileService;
import com.tydic.pfscext.api.busi.bo.FscOssUploadFileReqBO;
import com.tydic.pfscext.api.busi.bo.FscOssUploadFileRspBO;
import com.tydic.pfscext.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.FscOssUploadFileService"})
public class FscOssUploadFileServiceImpl
implements FscOssUploadFileService {
    private static final Logger log = LoggerFactory.getLogger(FscOssUploadFileServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String accessUrl;
    private static String filedir = "fsc/";

    @PostMapping(value={"uploadFile"})
    public FscOssUploadFileRspBO uploadFile(@RequestBody FscOssUploadFileReqBO reqBO) {
        MultipartFile file = Base64.base64ToMultipart(reqBO.getBase64Img());
        String filePath = null;
        FscOssUploadFileRspBO rspBO = new FscOssUploadFileRspBO();
        try {
            String fileUrl = this.fileClient.uploadFileByInputStream(filedir, reqBO.getFileName(), file.getInputStream());
            String[] fileStr = fileUrl.split(",");
            filePath = fileStr[0] + "/" + fileStr[1];
        }
        catch (OSSException oe) {
            log.info("\u4e0a\u4f20oss\u670d\u52a1\u5f02\u5e38\uff0c\u4e1a\u52a1ID:{}" + reqBO.getBusinessId());
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        catch (ClientException ce) {
            log.info("\u4e0a\u4f20oss\u5ba2\u6237\u7aef\u8fde\u63a5\u670d\u52a1\u5f02\u5e38\uff0c\u4e1a\u52a1ID:{}" + reqBO.getBusinessId());
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        catch (Exception e) {
            log.info("\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5f02\u5e38\uff0c\u4e1a\u52a1ID:{}" + reqBO.getBusinessId(), (Throwable)e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        rspBO.setFileUrl(this.getUrl(this.accessUrl + "/" + filePath));
        rspBO.setFileName(reqBO.getFileName());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public String getUrl(String key) {
        return FscOssUploadFileServiceImpl.splitUrl(key);
    }

    public static String splitUrl(String url) {
        if (url.indexOf("?Expires") != -1) {
            return url.split("Expires")[0].substring(0, url.split("Expires")[0].length() - 1);
        }
        return url;
    }
}

