/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.busi.FscPayConfigDeleteBatchBusiService;
import com.tydic.pfscext.api.busi.bo.FscPayConfigDeleteBatchBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayConfigDeleteBatchBusiRspBO;
import com.tydic.pfscext.dao.FscPayConfigChannelHisMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigHisMapper;
import com.tydic.pfscext.dao.FscPayConfigLogDetailMapper;
import com.tydic.pfscext.dao.FscPayConfigLogMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigChannelHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogDetailPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscPayConfigDeleteBatchBusiServiceImpl
implements FscPayConfigDeleteBatchBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigDeleteBatchBusiServiceImpl.class);
    @Resource
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;
    @Resource
    private FscPayConfigLogMapper fscPayConfigLogMapper;
    @Resource
    private FscPayConfigHisMapper fscPayConfigHisMapper;
    @Resource
    private FscPayConfigChannelHisMapper fscPayConfigChannelHisMapper;
    @Resource
    private FscPayConfigLogDetailMapper fscPayConfigLogDetailMapper;
    @Resource
    private FscCreditControlBusiService fscCreditControlBusiService;
    private final Integer YES = 1;
    private final Integer NO = 0;

    public FscPayConfigDeleteBatchBusiRspBO dealPayConfigDeleteBatch(FscPayConfigDeleteBatchBusiReqBO reqBo) {
        FscPayConfigPO fscPayConfigParent = new FscPayConfigPO();
        fscPayConfigParent.setPayConfigId(reqBo.getParentConfigId());
        fscPayConfigParent = this.fscPayConfigMapper.getModelBy(fscPayConfigParent);
        ValUtil.isEmpty(fscPayConfigParent).exception("\u652f\u4ed8\u914d\u7f6e\u7236\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
        List<Long> payConfigIdList = reqBo.getPayConfigIdList().stream().distinct().collect(Collectors.toList());
        ValUtil.isCollEmpty(payConfigIdList).exception("\u88ab\u5220\u9664\u652f\u4ed8\u914d\u7f6eID\u96c6\u5408\u4e3a\u7a7a");
        FscPayConfigPO fscPayConfigCheck = new FscPayConfigPO();
        fscPayConfigCheck.setPayConfigIdList(payConfigIdList);
        List<FscPayConfigPO> deletePayConfigPos = this.fscPayConfigMapper.getList(fscPayConfigCheck);
        ValUtil.isCollEmpty(deletePayConfigPos).exception("\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
        List parentPayConfigIdNoMatch = deletePayConfigPos.stream().filter(i -> !Objects.equals(reqBo.getParentConfigId(), i.getParentConfigId())).map(FscPayConfigPO::getPayConfigId).collect(Collectors.toList());
        ValUtil.doAssert(CollUtil.isNotEmpty(parentPayConfigIdNoMatch)).exception("\u652f\u4ed8\u914d\u7f6e[" + parentPayConfigIdNoMatch + "]\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7236\u914d\u7f6eID");
        List deletePayConfigIds = deletePayConfigPos.stream().map(FscPayConfigPO::getPayConfigId).collect(Collectors.toList());
        List noMatchPayConfigIds = payConfigIdList.stream().filter(i -> !deletePayConfigIds.contains(i)).collect(Collectors.toList());
        ValUtil.doAssert(CollUtil.isNotEmpty(noMatchPayConfigIds)).exception("\u652f\u4ed8\u914d\u7f6e[" + noMatchPayConfigIds + "]\u4e0d\u5b58\u5728");
        ValUtil.doAssert(CollUtil.isNotEmpty(parentPayConfigIdNoMatch)).exception("\u652f\u4ed8\u914d\u7f6e[" + parentPayConfigIdNoMatch + "]\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7236\u914d\u7f6eID");
        List deletePayBusiTypes = deletePayConfigPos.stream().map(FscPayConfigPO::getPayBusiType).distinct().collect(Collectors.toList());
        if (deletePayBusiTypes.size() != 1) {
            throw new PfscExtBusinessException("18000", "\u88ab\u5220\u9664\u652f\u4ed8\u914d\u7f6e\u4e1a\u52a1\u7c7b\u578b\u5b58\u5728\u591a\u79cd");
        }
        List deletePaySubTypes = deletePayConfigPos.stream().map(FscPayConfigPO::getPaySubType).distinct().collect(Collectors.toList());
        if (deletePaySubTypes.size() != 1) {
            throw new PfscExtBusinessException("18000", "\u88ab\u5220\u9664\u652f\u4ed8\u914d\u7f6e\u4ed8\u6b3e\u4e3b\u4f53\u7c7b\u578b\u5b58\u5728\u591a\u79cd");
        }
        List deletePaySubClass = deletePayConfigPos.stream().map(FscPayConfigPO::getPaySubClass).distinct().collect(Collectors.toList());
        if (deletePaySubClass.size() != 1) {
            throw new PfscExtBusinessException("18000", "\u88ab\u5220\u9664\u652f\u4ed8\u914d\u7f6e\u4ed8\u6b3e\u4e3b\u4f53\u5206\u7c7b\u5b58\u5728\u591a\u79cd");
        }
        List deletePayConfigTypes = deletePayConfigPos.stream().map(FscPayConfigPO::getPayConfigType).distinct().collect(Collectors.toList());
        if (deletePayConfigTypes.size() != 1) {
            throw new PfscExtBusinessException("18000", "\u88ab\u5220\u9664\u652f\u4ed8\u914d\u7f6e\u914d\u7f6e\u7c7b\u578b\u5b58\u5728\u591a\u79cd");
        }
        String exceptionType = (String)deletePayConfigTypes.get(0);
        if (FscPayConfigType.EXT_ORG.getCode().equals(exceptionType)) {
            if (!FscPayConfigType.MAIN.getCode().equals(fscPayConfigParent.getPayConfigType())) {
                throw new PfscExtBusinessException("18000", "\u5220\u9664\u4f8b\u5916\u5355\u4f4d\u5931\u8d25\uff0c\u7236\u914d\u7f6e\u4e0d\u662f\u4e3b\u914d\u7f6e");
            }
            this.dealDeleteExcOrgConfig(reqBo, fscPayConfigParent, payConfigIdList);
        } else if (FscPayConfigType.EXT_AGR.getCode().equals(exceptionType)) {
            this.dealDeleteExcAgrOrExtConnConfig(reqBo, fscPayConfigParent, payConfigIdList, exceptionType, this.YES, this.NO);
        } else if (FscPayConfigType.EXT_CONN.getCode().equals(exceptionType)) {
            this.dealDeleteExcAgrOrExtConnConfig(reqBo, fscPayConfigParent, payConfigIdList, exceptionType, this.NO, this.YES);
        } else if (FscPayConfigType.NO_CREDIT_AGR.getCode().equals(exceptionType)) {
            if (!FscPayConfigType.MAIN.getCode().equals(fscPayConfigParent.getPayConfigType())) {
                throw new PfscExtBusinessException("18000", "\u5220\u9664\u4e0d\u7ba1\u63a7\u534f\u8bae\u5931\u8d25\uff0c\u7236\u914d\u7f6e\u4e0d\u662f\u4e3b\u914d\u7f6e");
            }
            this.dealDeleteNoCreditAgrConfig(reqBo, fscPayConfigParent, payConfigIdList);
        } else if (FscPayConfigType.DEF.getCode().equals(exceptionType)) {
            for (Long payConfigId : payConfigIdList) {
                FscPayConfigPO fscPayConfigDefDelete = new FscPayConfigPO();
                fscPayConfigDefDelete.setPayConfigId(payConfigId);
                fscPayConfigDefDelete.setDeleteFlag(YesOrNo.YES.getCode());
                fscPayConfigDefDelete.setUpdateTime(new Date());
                fscPayConfigDefDelete.setUpdateUserId(reqBo.getUserId());
                fscPayConfigDefDelete.setUpdateUserName(reqBo.getName());
                this.fscPayConfigMapper.updateById(fscPayConfigDefDelete);
            }
        } else {
            log.error("\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)fscPayConfigParent));
            throw new PfscExtBusinessException("18000", "\u5220\u9664\u5931\u8d25\uff0c\u914d\u7f6e\u7c7b\u578b\u5f02\u5e38");
        }
        FscPayConfigDeleteBatchBusiRspBO rspBo = FscRu.success(FscPayConfigDeleteBatchBusiRspBO.class);
        rspBo.setRespDesc("\u6279\u91cf\u5220\u9664\u6210\u529f");
        return rspBo;
    }

    private void dealDeleteExcOrgConfig(FscPayConfigDeleteBatchBusiReqBO reqBo, FscPayConfigPO fscPayConfigMain, List<Long> payConfigIdList) {
        if (payConfigIdList == null) {
            return;
        }
        Date nowTime = new Date();
        Long payLogId = this.insertPayConfigLogPo(reqBo, fscPayConfigMain, this.NO, this.YES, this.NO, this.NO, this.NO, nowTime);
        for (Long payConfigId : payConfigIdList) {
            long payConfigHisOldId = this.initPayConfigHis(payLogId, payConfigId);
            FscPayConfigChannelHisPO fscPayConfigChannelHisPo = new FscPayConfigChannelHisPO();
            fscPayConfigChannelHisPo.setPayConfigHisId(payConfigHisOldId);
            fscPayConfigChannelHisPo.setPayConfigId(payConfigId);
            fscPayConfigChannelHisPo.setHisCreateTime(nowTime);
            fscPayConfigChannelHisPo.setHisCreateUserId(reqBo.getUserId());
            fscPayConfigChannelHisPo.setHisCreateUserName(reqBo.getUsername());
            this.fscPayConfigChannelHisMapper.insertBySelect(fscPayConfigChannelHisPo);
            long payLogDetailId = this.initPayConfigLogDetail(reqBo.getUserId(), reqBo.getUsername(), FscPayConfigType.EXT_ORG.getCode(), nowTime, payLogId, payConfigHisOldId);
            FscPayConfigPO fscPayConfigOrgUpdate = new FscPayConfigPO();
            fscPayConfigOrgUpdate.setPayConfigId(payConfigId);
            fscPayConfigOrgUpdate.setParentConfigId(fscPayConfigMain.getPayConfigId());
            fscPayConfigOrgUpdate.setPayType(fscPayConfigMain.getPayType());
            fscPayConfigOrgUpdate.setPayBusiType(fscPayConfigMain.getPayBusiType());
            fscPayConfigOrgUpdate.setDeleteFlag(YesOrNo.NO.getCode());
            fscPayConfigOrgUpdate.setStatus(FscPayConfigStatus.EFFECT.getCode());
            fscPayConfigOrgUpdate.setUpdateTime(nowTime);
            fscPayConfigOrgUpdate.setUpdateUserId(reqBo.getUserId());
            fscPayConfigOrgUpdate.setUpdateUserName(reqBo.getName());
            int updateById = this.fscPayConfigMapper.updateExtOrgFromMainById(fscPayConfigOrgUpdate);
            if (updateById != 1) {
                log.error("\u5f85\u66f4\u65b0\u6570\u636e.count:{}.po\uff1a{}", (Object)updateById, (Object)JSON.toJSONString((Object)fscPayConfigOrgUpdate));
                throw new PfscExtBusinessException("18000", "\u5220\u9664\u4f8b\u5916\u5355\u4f4d\u5931\u8d25\uff0c\u66f4\u65b0\u4f8b\u5916\u5355\u4f4d\u4e3a\u9ed8\u8ba4\u914d\u7f6e\u5f02\u5e38");
            }
            FscPayConfigPO fscPayConfigCheckPo = new FscPayConfigPO();
            fscPayConfigCheckPo.setPayConfigId(payConfigId);
            fscPayConfigCheckPo.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
            if (this.fscPayConfigMapper.getCheckBy(fscPayConfigCheckPo) <= 0) continue;
            FscCreditControlBusiReqBO creditControlBusiReqBo = new FscCreditControlBusiReqBO();
            creditControlBusiReqBo.setPayConfigId(fscPayConfigOrgUpdate.getPayConfigId());
            FscCreditControlBusiRspBO creditControlBusiRspBo = this.fscCreditControlBusiService.dealCreditControl(creditControlBusiReqBo);
            if (!FscRu.isFailed(creditControlBusiRspBo.getRespCode()).booleanValue()) continue;
            throw new PfscExtBusinessException(creditControlBusiRspBo.getRespCode(), "\u66f4\u65b0\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001\u5f02\u5e38\uff1a" + creditControlBusiRspBo.getRespDesc());
        }
        if (Arrays.asList(FscPayConfigBusiType.FL.getCode(), FscPayConfigBusiType.EC.getCode(), FscPayConfigBusiType.AGR_PT.getCode()).contains(fscPayConfigMain.getPayBusiType())) {
            FscPayConfigPO fscPayConfigAgrConnDelete = new FscPayConfigPO();
            fscPayConfigAgrConnDelete.setParentConfigIdList(payConfigIdList);
            fscPayConfigAgrConnDelete.setPayConfigTypeList(Arrays.asList(FscPayConfigType.EXT_AGR.getCode(), FscPayConfigType.EXT_CONN.getCode()));
            this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
        }
        FscPayConfigChannelPO fscPayConfigChannelDelete = new FscPayConfigChannelPO();
        fscPayConfigChannelDelete.setPayConfigIdList(payConfigIdList);
        this.fscPayConfigChannelMapper.deleteBy(fscPayConfigChannelDelete);
        this.updateParentExceptionNum(reqBo, fscPayConfigMain, nowTime);
    }

    private void dealDeleteExcAgrOrExtConnConfig(FscPayConfigDeleteBatchBusiReqBO reqBo, FscPayConfigPO fscPayConfigParent, List<Long> payConfigIdList, String payConfigType, Integer exceptionAgr, Integer exceptionConn) {
        if (payConfigIdList == null) {
            return;
        }
        Date nowTime = new Date();
        if (FscPayConfigType.MAIN.getCode().equals(fscPayConfigParent.getPayConfigType())) {
            Long payLogId = this.insertPayConfigLogPo(reqBo, fscPayConfigParent, this.NO, this.NO, exceptionAgr, exceptionConn, this.NO, nowTime);
            for (Long payConfigId : payConfigIdList) {
                long payConfigHisOldId = this.initPayConfigHis(payLogId, payConfigId);
                long l = this.initPayConfigLogDetail(reqBo.getUserId(), reqBo.getUsername(), payConfigType, nowTime, payLogId, payConfigHisOldId);
            }
        }
        FscPayConfigPO fscPayConfigAgrConnDelete = new FscPayConfigPO();
        fscPayConfigAgrConnDelete.setParentConfigId(fscPayConfigParent.getPayConfigId());
        fscPayConfigAgrConnDelete.setPayConfigIdList(payConfigIdList);
        fscPayConfigAgrConnDelete.setPayConfigType(payConfigType);
        this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
        this.updateParentExceptionNum(reqBo, fscPayConfigParent, nowTime);
    }

    private void dealDeleteNoCreditAgrConfig(FscPayConfigDeleteBatchBusiReqBO reqBo, FscPayConfigPO fscPayConfigMain, List<Long> payConfigIdList) {
        if (payConfigIdList == null) {
            return;
        }
        Date nowTime = new Date();
        Long payLogId = this.insertPayConfigLogPo(reqBo, fscPayConfigMain, this.NO, this.NO, this.NO, this.NO, this.YES, nowTime);
        for (Long payConfigId : payConfigIdList) {
            long payConfigHisOldId = this.initPayConfigHis(payLogId, payConfigId);
            long l = this.initPayConfigLogDetail(reqBo.getUserId(), reqBo.getUsername(), FscPayConfigType.NO_CREDIT_AGR.getCode(), nowTime, payLogId, payConfigHisOldId);
        }
        FscPayConfigPO fscPayConfigAgrConnDelete = new FscPayConfigPO();
        fscPayConfigAgrConnDelete.setParentConfigId(fscPayConfigMain.getPayConfigId());
        fscPayConfigAgrConnDelete.setPayConfigIdList(payConfigIdList);
        fscPayConfigAgrConnDelete.setPayConfigType(FscPayConfigType.NO_CREDIT_AGR.getCode());
        this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
    }

    private void updateParentExceptionNum(FscPayConfigDeleteBatchBusiReqBO reqBo, FscPayConfigPO fscPayConfigParent, Date nowTime) {
        FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
        fscPayConfigUpdate.setPayConfigId(fscPayConfigParent.getPayConfigId());
        Integer exceptionOrgNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.EXT_ORG.getCode());
        fscPayConfigUpdate.setExceptionOrgNum(exceptionOrgNum);
        Integer exceptionAgrNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.EXT_AGR.getCode());
        fscPayConfigUpdate.setExceptionAgrNum(exceptionAgrNum);
        Integer exceptionConnNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.EXT_CONN.getCode());
        fscPayConfigUpdate.setExceptionConnNum(exceptionConnNum);
        Integer noControlAgrNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.NO_CREDIT_AGR.getCode());
        fscPayConfigUpdate.setNoControlAgrNum(noControlAgrNum);
        int exceptionNum = exceptionOrgNum + exceptionAgrNum + exceptionConnNum;
        fscPayConfigUpdate.setPayAllowExceptionFlag(exceptionNum > 0 ? YesOrNo.YES.getCode() : YesOrNo.NO.getCode());
        fscPayConfigUpdate.setUpdateTime(nowTime);
        fscPayConfigUpdate.setUpdateUserId(reqBo.getUserId());
        fscPayConfigUpdate.setUpdateUserName(reqBo.getName());
        this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
    }

    private long initPayConfigLogDetail(Long userId, String username, String payConfigType, Date nowTime, Long payLogId, long payConfigHisOldId) {
        long payLogDetailId = Sequence.getInstance().nextId();
        FscPayConfigLogDetailPO fscPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
        fscPayConfigLogDetailInsert.setPayLogDetailId(payLogDetailId);
        fscPayConfigLogDetailInsert.setPayLogId(payLogId);
        fscPayConfigLogDetailInsert.setPayLogFlag("2");
        fscPayConfigLogDetailInsert.setPayConfigType(payConfigType);
        fscPayConfigLogDetailInsert.setPayConfigHisOldId(payConfigHisOldId);
        fscPayConfigLogDetailInsert.setPayConfigHisNewId(null);
        fscPayConfigLogDetailInsert.setCreateTime(nowTime);
        fscPayConfigLogDetailInsert.setCreateUserId(userId);
        fscPayConfigLogDetailInsert.setCreateUserName(username);
        this.fscPayConfigLogDetailMapper.insert(fscPayConfigLogDetailInsert);
        return payLogDetailId;
    }

    private Long initPayConfigHis(Long payLogId, Long payConfigId) {
        long payConfigHisId = Sequence.getInstance().nextId();
        FscPayConfigHisPO excPayConfigHisBeforePo = new FscPayConfigHisPO();
        excPayConfigHisBeforePo.setPayConfigHisId(payConfigHisId);
        excPayConfigHisBeforePo.setPayLogId(payLogId);
        excPayConfigHisBeforePo.setPayLogFlag("2");
        excPayConfigHisBeforePo.setPayConfigId(payConfigId);
        this.fscPayConfigHisMapper.insertBySelect(excPayConfigHisBeforePo);
        return payConfigHisId;
    }

    private Long insertPayConfigLogPo(FscPayConfigDeleteBatchBusiReqBO reqBo, FscPayConfigPO fscPayConfigMain, Integer exceptionMain, Integer exceptionOrg, Integer exceptionAgr, Integer exceptionConn, Integer noControlAgr, Date nowTime) {
        FscPayConfigLogPO fscPayConfigLogPo = new FscPayConfigLogPO();
        fscPayConfigLogPo.setPayLogId(Sequence.getInstance().nextId());
        fscPayConfigLogPo.setVersionNo(fscPayConfigMain.getVersionNo());
        fscPayConfigLogPo.setPayLogFlag("2");
        fscPayConfigLogPo.setPayBusiType(fscPayConfigMain.getPayBusiType());
        fscPayConfigLogPo.setPaySubClass(fscPayConfigMain.getPaySubClass());
        fscPayConfigLogPo.setPaySubType(fscPayConfigMain.getPaySubType());
        fscPayConfigLogPo.setPayConfigMode(fscPayConfigMain.getPayConfigMode());
        fscPayConfigLogPo.setExceptionMain(exceptionMain);
        fscPayConfigLogPo.setExceptionOrg(exceptionOrg);
        fscPayConfigLogPo.setExceptionAgr(exceptionAgr);
        fscPayConfigLogPo.setExceptionConn(exceptionConn);
        fscPayConfigLogPo.setNoControlAgr(noControlAgr);
        fscPayConfigLogPo.setCreateTime(nowTime);
        fscPayConfigLogPo.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogPo.setCreateUserName(reqBo.getName());
        this.fscPayConfigLogMapper.insert(fscPayConfigLogPo);
        return fscPayConfigLogPo.getPayLogId();
    }

    private Integer getExceptionNum(Long payConfigId, String payConfigType) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setParentConfigId(payConfigId);
        fscPayConfigQry.setPayConfigType(payConfigType);
        return this.fscPayConfigMapper.getCheckBy(fscPayConfigQry);
    }
}

