/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.dao.FscPayConfigChannelHisMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigHisMapper;
import com.tydic.pfscext.dao.FscPayConfigLogDetailMapper;
import com.tydic.pfscext.dao.FscPayConfigLogMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigChannelHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogDetailPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigPayLogFlag;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.FscPayConfigDeleteBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigDeleteBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigDeleteBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfigDeleteBusiServiceImpl
implements FscPayConfigDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigDeleteBusiServiceImpl.class);
    @Resource
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;
    @Resource
    private FscPayConfigLogMapper fscPayConfigLogMapper;
    @Resource
    private FscPayConfigHisMapper fscPayConfigHisMapper;
    @Resource
    private FscPayConfigChannelHisMapper fscPayConfigChannelHisMapper;
    @Resource
    private FscPayConfigLogDetailMapper fscPayConfigLogDetailMapper;
    @Resource
    private FscCreditControlBusiService fscCreditControlBusiService;
    @Value(value="${FSC_PAY_CONFIG_DELETE_FLAG:true}")
    private boolean FSC_PAY_CONFIG_DELETE_FLAG;
    private final Integer YES = 1;
    private final Integer NO = 0;

    @Override
    public FscPayConfigDeleteBusiRspBO dealPayConfigDelete(FscPayConfigDeleteBusiReqBO reqBo) {
        FscPayConfigPO fscPayConfigAgrConnDelete;
        FscPayConfigDeleteBusiRspBO rspBo = FscRu.success(FscPayConfigDeleteBusiRspBO.class);
        FscPayConfigPO fscPayConfigPo = new FscPayConfigPO();
        fscPayConfigPo.setPayConfigId(reqBo.getPayConfigId());
        fscPayConfigPo = this.fscPayConfigMapper.getModelBy(fscPayConfigPo);
        if (fscPayConfigPo == null) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u914d\u7f6e\u4e3a\u7a7a");
        }
        Date nowTime = new Date();
        if (FscPayConfigType.MAIN.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            if (!this.FSC_PAY_CONFIG_DELETE_FLAG) {
                throw new PfscExtBusinessException("18000", "\u4e3b\u914d\u7f6e\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            FscPayConfigChannelPO fscPayConfigChannelQry = new FscPayConfigChannelPO();
            fscPayConfigChannelQry.setPayConfigId(fscPayConfigPo.getPayConfigId());
            List<FscPayConfigChannelPO> payChannelList = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
            this.dealDeleteMainConfig(reqBo, fscPayConfigPo, payChannelList, nowTime);
        } else if (FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            if (fscPayConfigPo.getParentConfigId() == null || 0L == fscPayConfigPo.getParentConfigId()) {
                throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u914d\u7f6e\u7684\u4e3b\u914d\u7f6eID\u4e3a\u7a7a");
            }
            this.dealDeleteExcOrgConfig(reqBo, fscPayConfigPo, nowTime);
        } else if (FscPayConfigType.EXT_AGR.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            fscPayConfigAgrConnDelete = new FscPayConfigPO();
            fscPayConfigAgrConnDelete.setPayConfigId(fscPayConfigPo.getPayConfigId());
            fscPayConfigAgrConnDelete.setPayConfigType(FscPayConfigType.EXT_AGR.getCode());
            this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
            this.addExcOrgAgrConnLog(reqBo, fscPayConfigPo, null, this.NO, this.YES, this.NO, this.NO, nowTime);
        } else if (FscPayConfigType.EXT_CONN.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            fscPayConfigAgrConnDelete = new FscPayConfigPO();
            fscPayConfigAgrConnDelete.setPayConfigId(fscPayConfigPo.getPayConfigId());
            fscPayConfigAgrConnDelete.setPayConfigType(FscPayConfigType.EXT_CONN.getCode());
            this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
            this.addExcOrgAgrConnLog(reqBo, fscPayConfigPo, null, this.NO, this.NO, this.YES, this.NO, nowTime);
        } else if (FscPayConfigType.NO_CREDIT_AGR.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            fscPayConfigAgrConnDelete = new FscPayConfigPO();
            fscPayConfigAgrConnDelete.setPayConfigId(fscPayConfigPo.getPayConfigId());
            fscPayConfigAgrConnDelete.setPayConfigType(FscPayConfigType.NO_CREDIT_AGR.getCode());
            this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
            this.addExcOrgAgrConnLog(reqBo, fscPayConfigPo, null, this.NO, this.NO, this.NO, this.YES, nowTime);
        } else if (FscPayConfigType.DEF.getCode().equals(fscPayConfigPo.getPayConfigType())) {
            FscPayConfigPO fscPayConfigDefDelete = new FscPayConfigPO();
            fscPayConfigDefDelete.setPayConfigId(fscPayConfigPo.getPayConfigId());
            fscPayConfigDefDelete.setDeleteFlag(this.YES);
            fscPayConfigDefDelete.setUpdateTime(nowTime);
            fscPayConfigDefDelete.setUpdateUserId(reqBo.getUserId());
            fscPayConfigDefDelete.setUpdateUserName(reqBo.getName());
            this.fscPayConfigMapper.updateById(fscPayConfigDefDelete);
        } else {
            log.error("\u652f\u4ed8\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)fscPayConfigPo));
            throw new PfscExtBusinessException("18000", "\u5220\u9664\u5931\u8d25\uff0c\u914d\u7f6e\u7c7b\u578b\u5f02\u5e38");
        }
        if (!FscPayConfigType.MAIN.getCode().equals(fscPayConfigPo.getPayConfigType()) && fscPayConfigPo.getParentConfigId() != null) {
            FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
            fscPayConfigUpdate.setPayConfigId(fscPayConfigPo.getParentConfigId());
            Integer exceptionOrgNum = this.getExceptionNum(fscPayConfigPo.getParentConfigId(), FscPayConfigType.EXT_ORG.getCode());
            fscPayConfigUpdate.setExceptionOrgNum(exceptionOrgNum);
            Integer exceptionAgrNum = this.getExceptionNum(fscPayConfigPo.getParentConfigId(), FscPayConfigType.EXT_AGR.getCode());
            fscPayConfigUpdate.setExceptionAgrNum(exceptionAgrNum);
            Integer exceptionConnNum = this.getExceptionNum(fscPayConfigPo.getParentConfigId(), FscPayConfigType.EXT_CONN.getCode());
            fscPayConfigUpdate.setExceptionConnNum(exceptionConnNum);
            Integer noControlAgrNum = this.getExceptionNum(fscPayConfigPo.getPayConfigId(), FscPayConfigType.NO_CREDIT_AGR.getCode());
            fscPayConfigUpdate.setNoControlAgrNum(noControlAgrNum);
            if (exceptionOrgNum + exceptionAgrNum + exceptionConnNum > 0) {
                fscPayConfigUpdate.setPayAllowExceptionFlag(this.YES);
            } else {
                fscPayConfigUpdate.setPayAllowExceptionFlag(this.NO);
            }
            fscPayConfigUpdate.setUpdateTime(nowTime);
            fscPayConfigUpdate.setUpdateUserId(reqBo.getUserId());
            fscPayConfigUpdate.setUpdateUserName(reqBo.getName());
            this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
        }
        return rspBo;
    }

    private void dealDeleteExcOrgConfig(FscPayConfigDeleteBusiReqBO reqBo, FscPayConfigPO fscPayConfigPo, Date nowTime) {
        FscPayConfigPO fscPayConfigMain = new FscPayConfigPO();
        fscPayConfigMain.setPayConfigId(fscPayConfigPo.getParentConfigId());
        fscPayConfigMain = this.fscPayConfigMapper.getModelBy(fscPayConfigMain);
        if (fscPayConfigMain == null) {
            throw new PfscExtBusinessException("18000", "\u672a\u67e5\u8be2\u5230\u4e3b\u914d\u7f6e\u4fe1\u606f");
        }
        FscPayConfigChannelPO fscPayConfigChannelQry = new FscPayConfigChannelPO();
        fscPayConfigChannelQry.setPayConfigId(fscPayConfigPo.getPayConfigId());
        List<FscPayConfigChannelPO> payChannelList = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
        if (FscPayConfigBusiType.FL.getCode().equals(fscPayConfigPo.getPayBusiType()) || FscPayConfigBusiType.EC.getCode().equals(fscPayConfigPo.getPayBusiType()) || FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigPo.getPayBusiType())) {
            FscPayConfigPO fscPayConfigAgrConnDelete = new FscPayConfigPO();
            fscPayConfigAgrConnDelete.setParentConfigId(fscPayConfigPo.getPayConfigId());
            fscPayConfigAgrConnDelete.setPayConfigTypeList(Arrays.asList(FscPayConfigType.EXT_AGR.getCode(), FscPayConfigType.EXT_CONN.getCode()));
            this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
        }
        FscPayConfigPO fscPayConfigOrgUpdate = new FscPayConfigPO();
        fscPayConfigOrgUpdate.setPayConfigId(fscPayConfigPo.getPayConfigId());
        fscPayConfigOrgUpdate.setPayConfigType(FscPayConfigType.DEF.getCode());
        fscPayConfigOrgUpdate.setExceptionOrgNum(0);
        fscPayConfigOrgUpdate.setExceptionAgrNum(0);
        fscPayConfigOrgUpdate.setExceptionConnNum(0);
        fscPayConfigOrgUpdate.setPayAllowExceptionFlag(this.NO);
        fscPayConfigOrgUpdate.setPayType(fscPayConfigMain.getPayType());
        fscPayConfigOrgUpdate.setPayUsedPeriodFlag(fscPayConfigPo.getPayUsedPeriodFlag());
        if (FscPayConfigPayType.YF_RATIO.getCode().equals(fscPayConfigMain.getPayType())) {
            fscPayConfigOrgUpdate.setDownPaymentRatio(fscPayConfigMain.getDownPaymentRatio());
            fscPayConfigOrgUpdate.setCheckPaymentRatio(fscPayConfigMain.getCheckPaymentRatio());
        } else if (FscPayConfigPayType.XY.getCode().equals(fscPayConfigMain.getPayType())) {
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigMain.getPayBusiType())) {
                fscPayConfigOrgUpdate.setPayNodeRule(fscPayConfigMain.getPayNodeRule());
                fscPayConfigOrgUpdate.setPaymentDays(fscPayConfigMain.getPaymentDays());
                fscPayConfigOrgUpdate.setDelayDays(fscPayConfigMain.getDelayDays());
            }
            fscPayConfigOrgUpdate.setPayUsedPeriodFlag(this.YES);
            fscPayConfigOrgUpdate.setCreditAmount(Optional.ofNullable(fscPayConfigMain.getCreditAmount()).orElse(BigDecimal.ZERO));
            fscPayConfigOrgUpdate.setUsedAmount(Optional.ofNullable(fscPayConfigPo.getUsedAmount()).orElse(BigDecimal.ZERO));
            fscPayConfigOrgUpdate.setBalanceAmount(fscPayConfigOrgUpdate.getCreditAmount().subtract(fscPayConfigOrgUpdate.getUsedAmount()));
            fscPayConfigOrgUpdate.setUsedWarningAmount(fscPayConfigMain.getUsedWarningAmount());
            fscPayConfigOrgUpdate.setOverdueStartAmount(fscPayConfigMain.getOverdueStartAmount());
            fscPayConfigOrgUpdate.setOverdueWarningRatio(fscPayConfigMain.getOverdueWarningRatio());
            fscPayConfigOrgUpdate.setOverdueControlRatio(fscPayConfigMain.getOverdueControlRatio());
            fscPayConfigOrgUpdate.setOverdueRecoveryRatio(fscPayConfigMain.getOverdueRecoveryRatio());
            fscPayConfigOrgUpdate.setOverdueIndexRatio(fscPayConfigMain.getOverdueIndexRatio());
            fscPayConfigOrgUpdate.setOverdueWarningIndex(fscPayConfigMain.getOverdueWarningIndex());
            fscPayConfigOrgUpdate.setOverdueControlIndex(fscPayConfigMain.getOverdueControlIndex());
            fscPayConfigOrgUpdate.setOverdueRecoveryIndex(fscPayConfigMain.getOverdueRecoveryIndex());
        } else if (FscPayConfigPayType.ZQ.getCode().equals(fscPayConfigMain.getPayType())) {
            fscPayConfigOrgUpdate.setPayNodeRule(fscPayConfigMain.getPayNodeRule());
            fscPayConfigOrgUpdate.setPaymentDays(fscPayConfigMain.getPaymentDays());
            fscPayConfigOrgUpdate.setDelayDays(fscPayConfigMain.getDelayDays());
            fscPayConfigOrgUpdate.setPayUsedPeriodFlag(this.YES);
            fscPayConfigOrgUpdate.setCreditAmount(Optional.ofNullable(fscPayConfigMain.getCreditAmount()).orElse(BigDecimal.ZERO));
            fscPayConfigOrgUpdate.setUsedAmount(Optional.ofNullable(fscPayConfigPo.getUsedAmount()).orElse(BigDecimal.ZERO));
            fscPayConfigOrgUpdate.setBalanceAmount(fscPayConfigOrgUpdate.getCreditAmount().subtract(fscPayConfigOrgUpdate.getUsedAmount()));
            fscPayConfigOrgUpdate.setUsedWarningAmount(fscPayConfigMain.getUsedWarningAmount());
            fscPayConfigOrgUpdate.setOverdueStartAmount(fscPayConfigMain.getOverdueStartAmount());
            fscPayConfigOrgUpdate.setOverdueWarningRatio(fscPayConfigMain.getOverdueWarningRatio());
            fscPayConfigOrgUpdate.setOverdueControlRatio(fscPayConfigMain.getOverdueControlRatio());
            fscPayConfigOrgUpdate.setOverdueRecoveryRatio(fscPayConfigMain.getOverdueRecoveryRatio());
            fscPayConfigOrgUpdate.setOverdueIndexRatio(fscPayConfigMain.getOverdueIndexRatio());
            fscPayConfigOrgUpdate.setOverdueWarningIndex(fscPayConfigMain.getOverdueWarningIndex());
            fscPayConfigOrgUpdate.setOverdueControlIndex(fscPayConfigMain.getOverdueControlIndex());
            fscPayConfigOrgUpdate.setOverdueRecoveryIndex(fscPayConfigMain.getOverdueRecoveryIndex());
        } else if (FscPayConfigPayType.YF_ALL.getCode().equals(fscPayConfigMain.getPayType())) {
            fscPayConfigOrgUpdate.setDownPaymentRatio(new BigDecimal("100"));
            fscPayConfigOrgUpdate.setCheckPaymentRatio(BigDecimal.ZERO);
        }
        fscPayConfigOrgUpdate.setDeleteFlag(this.NO);
        fscPayConfigOrgUpdate.setUpdateTime(nowTime);
        fscPayConfigOrgUpdate.setUpdateUserId(reqBo.getUserId());
        fscPayConfigOrgUpdate.setUpdateUserName(reqBo.getUsername());
        this.fscPayConfigMapper.updateById(fscPayConfigOrgUpdate);
        FscPayConfigChannelPO fscPayConfigChannelDelete = new FscPayConfigChannelPO();
        fscPayConfigChannelDelete.setPayConfigId(fscPayConfigPo.getPayConfigId());
        this.fscPayConfigChannelMapper.deleteBy(fscPayConfigChannelDelete);
        if (this.YES.equals(fscPayConfigOrgUpdate.getPayUsedPeriodFlag())) {
            FscCreditControlBusiReqBO creditControlBusiReqBo = new FscCreditControlBusiReqBO();
            creditControlBusiReqBo.setPayConfigId(fscPayConfigOrgUpdate.getPayConfigId());
            FscCreditControlBusiRspBO creditControlBusiRspBo = this.fscCreditControlBusiService.dealCreditControl(creditControlBusiReqBo);
            if (FscRu.isFailed(creditControlBusiRspBo.getRespCode()).booleanValue()) {
                throw new PfscExtBusinessException(creditControlBusiRspBo.getRespCode(), "\u66f4\u65b0\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001\u5f02\u5e38\uff1a" + creditControlBusiRspBo.getRespDesc());
            }
        }
        this.addExcOrgAgrConnLog(reqBo, fscPayConfigPo, payChannelList, this.YES, this.NO, this.NO, this.NO, nowTime);
    }

    private void addExcOrgAgrConnLog(FscPayConfigDeleteBusiReqBO reqBo, FscPayConfigPO fscPayConfigPo, List<FscPayConfigChannelPO> payChannelList, Integer exceptionOrg, Integer exceptionAgr, Integer exceptionConn, Integer noControlAgr, Date nowTime) {
        FscPayConfigLogPO fscPayConfigLogPo = new FscPayConfigLogPO();
        fscPayConfigLogPo.setPayLogId(Sequence.getInstance().nextId());
        fscPayConfigLogPo.setVersionNo(fscPayConfigPo.getVersionNo());
        fscPayConfigLogPo.setPayLogFlag("2");
        fscPayConfigLogPo.setPayBusiType(fscPayConfigPo.getPayBusiType());
        fscPayConfigLogPo.setPaySubClass(fscPayConfigPo.getPaySubClass());
        fscPayConfigLogPo.setPaySubType(fscPayConfigPo.getPaySubType());
        fscPayConfigLogPo.setPayConfigMode(fscPayConfigPo.getPayConfigMode());
        fscPayConfigLogPo.setExceptionMain(this.NO);
        fscPayConfigLogPo.setExceptionOrg(exceptionOrg);
        fscPayConfigLogPo.setExceptionAgr(exceptionAgr);
        fscPayConfigLogPo.setExceptionConn(exceptionConn);
        fscPayConfigLogPo.setNoControlAgr(noControlAgr);
        fscPayConfigLogPo.setCreateTime(nowTime);
        fscPayConfigLogPo.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogPo.setCreateUserName(reqBo.getName());
        this.fscPayConfigLogMapper.insert(fscPayConfigLogPo);
        FscPayConfigHisPO fscPayConfigHisBeforePo = new FscPayConfigHisPO();
        this.initFscPayConfigHisPo(fscPayConfigPo, fscPayConfigHisBeforePo);
        fscPayConfigHisBeforePo.setPayConfigHisId(Sequence.getInstance().nextId());
        fscPayConfigHisBeforePo.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigHisBeforePo.setPayLogFlag("2");
        this.fscPayConfigHisMapper.insert(fscPayConfigHisBeforePo);
        if (!CollectionUtils.isEmpty(payChannelList)) {
            ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
            for (FscPayConfigChannelPO payConfigChannel : payChannelList) {
                FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                his.setPayConfigHisId(fscPayConfigHisBeforePo.getPayConfigHisId());
                his.setPayConfigChannelId(payConfigChannel.getPayConfigChannelId());
                his.setPayConfigId(payConfigChannel.getPayConfigId());
                his.setPayConfigType(payConfigChannel.getPayConfigType());
                his.setPayChannels(payConfigChannel.getPayChannels());
                his.setPayMethod(payConfigChannel.getPayMethod());
                his.setCreateTime(payConfigChannel.getCreateTime());
                his.setRemark(payConfigChannel.getRemark());
                his.setHisCreateTime(nowTime);
                his.setHisCreateUserId(reqBo.getUserId());
                his.setHisCreateUserName(reqBo.getUsername());
                channelHisList.add(his);
            }
            this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
        }
        FscPayConfigLogDetailPO fscPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
        fscPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
        fscPayConfigLogDetailInsert.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.DEL.getCode());
        fscPayConfigLogDetailInsert.setPayConfigType(fscPayConfigPo.getPayConfigType());
        fscPayConfigLogDetailInsert.setPayConfigHisOldId(fscPayConfigHisBeforePo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setPayConfigHisNewId(null);
        fscPayConfigLogDetailInsert.setCreateTime(nowTime);
        fscPayConfigLogDetailInsert.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogDetailInsert.setCreateUserName(reqBo.getUsername());
        this.fscPayConfigLogDetailMapper.insert(fscPayConfigLogDetailInsert);
    }

    private void dealDeleteMainConfig(FscPayConfigDeleteBusiReqBO reqBo, FscPayConfigPO fscPayConfigPo, List<FscPayConfigChannelPO> payChannelList, Date nowTime) {
        ArrayList<FscPayConfigPO> excOrgList = new ArrayList<FscPayConfigPO>();
        ArrayList<FscPayConfigChannelPO> excOrgChannelList = new ArrayList<FscPayConfigChannelPO>();
        ArrayList<FscPayConfigPO> excAgrConnList = new ArrayList<FscPayConfigPO>();
        ArrayList<FscPayConfigPO> excOrgAgrConnList = new ArrayList<FscPayConfigPO>();
        FscPayConfigPO fscPayConfigExcOrgQry = new FscPayConfigPO();
        fscPayConfigExcOrgQry.setParentConfigId(fscPayConfigPo.getPayConfigId());
        fscPayConfigExcOrgQry.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
        fscPayConfigExcOrgQry.setDeleteFlag(this.NO);
        excOrgList.addAll(this.fscPayConfigMapper.getList(fscPayConfigExcOrgQry));
        if (FscPayConfigBusiType.FL.getCode().equals(fscPayConfigPo.getPayBusiType()) || FscPayConfigBusiType.EC.getCode().equals(fscPayConfigPo.getPayBusiType()) || FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigPo.getPayBusiType())) {
            FscPayConfigPO fscPayConfigExcAgrConnQry = new FscPayConfigPO();
            fscPayConfigExcAgrConnQry.setPayBusiType(fscPayConfigPo.getPayBusiType());
            fscPayConfigExcAgrConnQry.setPaySubClass(fscPayConfigPo.getPaySubClass());
            fscPayConfigExcAgrConnQry.setPaySubType(fscPayConfigPo.getPaySubType());
            fscPayConfigExcAgrConnQry.setPayConfigTypeList(Arrays.asList(FscPayConfigType.EXT_CONN.getCode(), FscPayConfigType.EXT_AGR.getCode()));
            fscPayConfigExcAgrConnQry.setDeleteFlag(this.NO);
            fscPayConfigExcAgrConnQry.setParentConfigId(fscPayConfigPo.getPayConfigId());
            excAgrConnList.addAll(this.fscPayConfigMapper.getList(fscPayConfigExcAgrConnQry));
        }
        if (!CollectionUtils.isEmpty(excOrgList)) {
            List<Long> payConfigIdList = excOrgList.stream().map(FscPayConfigPO::getPayConfigId).distinct().collect(Collectors.toList());
            FscPayConfigChannelPO fscPayConfigChannelExcQry = new FscPayConfigChannelPO();
            fscPayConfigChannelExcQry.setPayConfigIdList(payConfigIdList);
            excOrgChannelList.addAll(this.fscPayConfigChannelMapper.getList(fscPayConfigChannelExcQry));
            if ((FscPayConfigBusiType.FL.getCode().equals(fscPayConfigPo.getPayBusiType()) || FscPayConfigBusiType.EC.getCode().equals(fscPayConfigPo.getPayBusiType()) || FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigPo.getPayBusiType())) && !CollectionUtils.isEmpty(payConfigIdList)) {
                FscPayConfigPO fscPayConfigExcOrgExcAgrConnQry = new FscPayConfigPO();
                fscPayConfigExcOrgExcAgrConnQry.setPayBusiType(fscPayConfigPo.getPayBusiType());
                fscPayConfigExcOrgExcAgrConnQry.setPaySubClass(fscPayConfigPo.getPaySubClass());
                fscPayConfigExcOrgExcAgrConnQry.setPaySubType(fscPayConfigPo.getPaySubType());
                fscPayConfigExcOrgExcAgrConnQry.setPayConfigTypeList(Arrays.asList(FscPayConfigType.EXT_CONN.getCode(), FscPayConfigType.EXT_AGR.getCode()));
                fscPayConfigExcOrgExcAgrConnQry.setDeleteFlag(this.NO);
                fscPayConfigExcOrgExcAgrConnQry.setPayConfigIdList(payConfigIdList);
                excOrgAgrConnList.addAll(this.fscPayConfigMapper.getList(fscPayConfigExcOrgExcAgrConnQry));
            }
            if (!CollectionUtils.isEmpty(payConfigIdList)) {
                List batchList = ListUtil.batchList(payConfigIdList);
                for (List subList : batchList) {
                    FscPayConfigPO fscPayConfigExcOrgWhere = new FscPayConfigPO();
                    FscPayConfigPO fscPayConfigExcOrgSet = new FscPayConfigPO();
                    fscPayConfigExcOrgWhere.setPayConfigIdList(subList);
                    fscPayConfigExcOrgWhere.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
                    fscPayConfigExcOrgWhere.setDeleteFlag(this.NO);
                    fscPayConfigExcOrgWhere.setPayConfigType(FscPayConfigType.DEF.getCode());
                    fscPayConfigExcOrgSet.setUpdateTime(nowTime);
                    fscPayConfigExcOrgSet.setUpdateUserId(reqBo.getUserId());
                    fscPayConfigExcOrgSet.setUpdateUserName(reqBo.getUsername());
                    this.fscPayConfigMapper.updateBy(fscPayConfigExcOrgSet, fscPayConfigExcOrgWhere);
                    FscPayConfigChannelPO fscPayConfigChannelDelete = new FscPayConfigChannelPO();
                    fscPayConfigChannelDelete.setPayConfigIdList(subList);
                    this.fscPayConfigChannelMapper.deleteBy(fscPayConfigChannelDelete);
                }
                List excOrgAgrConnPayConfigIdList = excOrgAgrConnList.stream().map(FscPayConfigPO::getPayConfigId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(excOrgAgrConnPayConfigIdList)) {
                    for (List subList : ListUtil.batchList(excOrgAgrConnPayConfigIdList)) {
                        FscPayConfigPO fscPayConfigAgrConnDelete = new FscPayConfigPO();
                        fscPayConfigAgrConnDelete.setPayConfigIdList(subList);
                        fscPayConfigAgrConnDelete.setPayConfigTypeList(Arrays.asList(FscPayConfigType.EXT_AGR.getCode(), FscPayConfigType.EXT_CONN.getCode()));
                        this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
                    }
                }
            }
        }
        FscPayConfigPO fscPayConfigMainDelete = new FscPayConfigPO();
        fscPayConfigMainDelete.setPayConfigId(fscPayConfigPo.getPayConfigId());
        fscPayConfigMainDelete.setDeleteFlag(this.YES);
        fscPayConfigMainDelete.setUpdateTime(nowTime);
        fscPayConfigMainDelete.setUpdateUserId(reqBo.getUserId());
        fscPayConfigMainDelete.setUpdateUserName(reqBo.getUsername());
        this.fscPayConfigMapper.updateById(fscPayConfigMainDelete);
        if (!CollectionUtils.isEmpty(excAgrConnList)) {
            FscPayConfigPO fscPayConfigAgrConnDelete = new FscPayConfigPO();
            fscPayConfigAgrConnDelete.setParentConfigId(fscPayConfigPo.getPayConfigId());
            fscPayConfigAgrConnDelete.setPayConfigTypeList(Arrays.asList(FscPayConfigType.EXT_AGR.getCode(), FscPayConfigType.EXT_CONN.getCode()));
            this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
        }
        this.addMainLog(reqBo, fscPayConfigPo, payChannelList, excOrgList, excOrgChannelList, excAgrConnList, nowTime);
    }

    private void addMainLog(FscPayConfigDeleteBusiReqBO reqBo, FscPayConfigPO fscPayConfigPo, List<FscPayConfigChannelPO> payChannelList, List<FscPayConfigPO> excOrgList, List<FscPayConfigChannelPO> excOrgChannelList, List<FscPayConfigPO> excAgrConnList, Date nowTime) {
        FscPayConfigLogPO fscPayConfigLogPo = new FscPayConfigLogPO();
        fscPayConfigLogPo.setPayLogId(Sequence.getInstance().nextId());
        fscPayConfigLogPo.setVersionNo(fscPayConfigPo.getVersionNo());
        fscPayConfigLogPo.setPayLogFlag("2");
        fscPayConfigLogPo.setPayBusiType(fscPayConfigPo.getPayBusiType());
        fscPayConfigLogPo.setPaySubClass(fscPayConfigPo.getPaySubClass());
        fscPayConfigLogPo.setPaySubType(fscPayConfigPo.getPaySubType());
        fscPayConfigLogPo.setPayConfigMode(fscPayConfigPo.getPayConfigMode());
        fscPayConfigLogPo.setExceptionMain(this.YES);
        if (!CollectionUtils.isEmpty(excOrgList)) {
            fscPayConfigLogPo.setExceptionOrg(this.YES);
        } else {
            fscPayConfigLogPo.setExceptionOrg(this.NO);
        }
        if (!CollectionUtils.isEmpty(excAgrConnList)) {
            if (FscPayConfigType.EXT_AGR.getCode().equals(excAgrConnList.get(0).getPayConfigType())) {
                fscPayConfigLogPo.setExceptionAgr(this.YES);
                fscPayConfigLogPo.setExceptionConn(this.NO);
            } else {
                fscPayConfigLogPo.setExceptionAgr(this.NO);
                fscPayConfigLogPo.setExceptionConn(this.YES);
            }
        } else {
            fscPayConfigLogPo.setExceptionAgr(this.NO);
            fscPayConfigLogPo.setExceptionConn(this.NO);
        }
        fscPayConfigLogPo.setCreateTime(nowTime);
        fscPayConfigLogPo.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogPo.setCreateUserName(reqBo.getName());
        this.fscPayConfigLogMapper.insert(fscPayConfigLogPo);
        FscPayConfigHisPO fscPayConfigHisBeforePo = new FscPayConfigHisPO();
        BeanUtils.copyProperties((Object)fscPayConfigPo, (Object)fscPayConfigHisBeforePo);
        fscPayConfigHisBeforePo.setPayConfigHisId(Sequence.getInstance().nextId());
        fscPayConfigHisBeforePo.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigHisBeforePo.setPayLogFlag("2");
        this.fscPayConfigHisMapper.insert(fscPayConfigHisBeforePo);
        if (!CollectionUtils.isEmpty(payChannelList)) {
            ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
            for (FscPayConfigChannelPO fscPayConfigChannelPO : payChannelList) {
                FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                his.setPayConfigHisId(fscPayConfigHisBeforePo.getPayConfigHisId());
                his.setPayConfigChannelId(fscPayConfigChannelPO.getPayConfigChannelId());
                his.setPayConfigId(fscPayConfigChannelPO.getPayConfigId());
                his.setPayConfigType(fscPayConfigChannelPO.getPayConfigType());
                his.setPayChannels(fscPayConfigChannelPO.getPayChannels());
                his.setPayMethod(fscPayConfigChannelPO.getPayMethod());
                his.setCreateTime(fscPayConfigChannelPO.getCreateTime());
                his.setRemark(fscPayConfigChannelPO.getRemark());
                his.setHisCreateTime(nowTime);
                his.setHisCreateUserId(reqBo.getUserId());
                his.setHisCreateUserName(reqBo.getUsername());
                channelHisList.add(his);
            }
            this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
        }
        FscPayConfigLogDetailPO fscPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
        fscPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
        fscPayConfigLogDetailInsert.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.DEL.getCode());
        fscPayConfigLogDetailInsert.setPayConfigType(FscPayConfigType.MAIN.getCode());
        fscPayConfigLogDetailInsert.setPayConfigHisOldId(fscPayConfigHisBeforePo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setPayConfigHisNewId(null);
        fscPayConfigLogDetailInsert.setCreateTime(nowTime);
        fscPayConfigLogDetailInsert.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogDetailInsert.setCreateUserName(reqBo.getUsername());
        this.fscPayConfigLogDetailMapper.insert(fscPayConfigLogDetailInsert);
        if (!CollectionUtils.isEmpty(excOrgList)) {
            Map<Long, List<FscPayConfigChannelPO>> excOrgChannelMap = excOrgChannelList.stream().collect(Collectors.groupingBy(FscPayConfigChannelPO::getPayConfigId));
            for (FscPayConfigPO excPayConfig : excOrgList) {
                FscPayConfigHisPO excPayConfigHisBeforePo = new FscPayConfigHisPO();
                this.initFscPayConfigHisPo(excPayConfig, excPayConfigHisBeforePo);
                excPayConfigHisBeforePo.setPayConfigHisId(Sequence.getInstance().nextId());
                excPayConfigHisBeforePo.setPayLogId(fscPayConfigLogPo.getPayLogId());
                excPayConfigHisBeforePo.setPayLogFlag("2");
                this.fscPayConfigHisMapper.insert(excPayConfigHisBeforePo);
                List<FscPayConfigChannelPO> excConfigChannelList = excOrgChannelMap.get(excPayConfig.getPayConfigId());
                if (!CollectionUtils.isEmpty(excConfigChannelList)) {
                    ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
                    for (FscPayConfigChannelPO payConfigChannel : excConfigChannelList) {
                        FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                        his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                        his.setPayConfigHisId(fscPayConfigHisBeforePo.getPayConfigHisId());
                        his.setPayConfigChannelId(payConfigChannel.getPayConfigChannelId());
                        his.setPayConfigId(payConfigChannel.getPayConfigId());
                        his.setPayConfigType(payConfigChannel.getPayConfigType());
                        his.setPayChannels(payConfigChannel.getPayChannels());
                        his.setPayMethod(payConfigChannel.getPayMethod());
                        his.setCreateTime(payConfigChannel.getCreateTime());
                        his.setRemark(payConfigChannel.getRemark());
                        his.setHisCreateTime(nowTime);
                        his.setHisCreateUserId(reqBo.getUserId());
                        his.setHisCreateUserName(reqBo.getUsername());
                        channelHisList.add(his);
                    }
                    this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
                }
                FscPayConfigLogDetailPO excPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
                excPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
                excPayConfigLogDetailInsert.setPayLogId(fscPayConfigLogPo.getPayLogId());
                excPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.DEL.getCode());
                excPayConfigLogDetailInsert.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
                excPayConfigLogDetailInsert.setPayConfigHisOldId(excPayConfigHisBeforePo.getPayConfigHisId());
                excPayConfigLogDetailInsert.setPayConfigHisNewId(null);
                excPayConfigLogDetailInsert.setCreateTime(nowTime);
                excPayConfigLogDetailInsert.setCreateUserId(reqBo.getUserId());
                excPayConfigLogDetailInsert.setCreateUserName(reqBo.getUsername());
                this.fscPayConfigLogDetailMapper.insert(excPayConfigLogDetailInsert);
            }
        }
        if (!CollectionUtils.isEmpty(excAgrConnList)) {
            for (FscPayConfigPO fscPayConfigPO : excAgrConnList) {
                FscPayConfigHisPO excPayConfigHisBeforePo = new FscPayConfigHisPO();
                this.initFscPayConfigHisPo(fscPayConfigPO, excPayConfigHisBeforePo);
                excPayConfigHisBeforePo.setPayConfigHisId(Sequence.getInstance().nextId());
                excPayConfigHisBeforePo.setPayLogId(fscPayConfigLogPo.getPayLogId());
                excPayConfigHisBeforePo.setPayLogFlag("2");
                this.fscPayConfigHisMapper.insert(excPayConfigHisBeforePo);
                FscPayConfigLogDetailPO excPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
                excPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
                excPayConfigLogDetailInsert.setPayLogId(fscPayConfigLogPo.getPayLogId());
                excPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.DEL.getCode());
                excPayConfigLogDetailInsert.setPayConfigType(fscPayConfigPO.getPayConfigType());
                excPayConfigLogDetailInsert.setPayConfigHisOldId(excPayConfigHisBeforePo.getPayConfigHisId());
                excPayConfigLogDetailInsert.setPayConfigHisNewId(null);
                excPayConfigLogDetailInsert.setCreateTime(nowTime);
                excPayConfigLogDetailInsert.setCreateUserId(reqBo.getUserId());
                excPayConfigLogDetailInsert.setCreateUserName(reqBo.getUsername());
                this.fscPayConfigLogDetailMapper.insert(excPayConfigLogDetailInsert);
            }
        }
    }

    private void initFscPayConfigHisPo(FscPayConfigPO sourcePo, FscPayConfigHisPO targetPo) {
        targetPo.setPayConfigId(sourcePo.getPayConfigId());
        targetPo.setParentConfigId(sourcePo.getParentConfigId());
        targetPo.setVersionNo(sourcePo.getVersionNo());
        targetPo.setPayBusiType(sourcePo.getPayBusiType());
        targetPo.setPaySubClass(sourcePo.getPaySubClass());
        targetPo.setPaySubType(sourcePo.getPaySubType());
        targetPo.setPayConfigMode(sourcePo.getPayConfigMode());
        targetPo.setPayConfigType(sourcePo.getPayConfigType());
        targetPo.setPayUsedPeriodFlag(sourcePo.getPayUsedPeriodFlag());
        targetPo.setPayAllowExceptionFlag(sourcePo.getPayAllowExceptionFlag());
        targetPo.setExceptionOrgNum(sourcePo.getExceptionOrgNum());
        targetPo.setExceptionAgrNum(sourcePo.getExceptionAgrNum());
        targetPo.setExceptionConnNum(sourcePo.getExceptionConnNum());
        targetPo.setPayType(sourcePo.getPayType());
        if (FscPayConfigPayType.YF_RATIO.getCode().equals(sourcePo.getPayType())) {
            targetPo.setDownPaymentRatio(sourcePo.getDownPaymentRatio());
            targetPo.setCheckPaymentRatio(sourcePo.getCheckPaymentRatio());
        }
        if (FscPayConfigPayType.XY.getCode().equals(sourcePo.getPayType()) || FscPayConfigPayType.ZQ.getCode().equals(sourcePo.getPayType())) {
            if (!FscPayConfigBusiType.AGR_DW.getCode().equals(sourcePo.getPayBusiType())) {
                targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
                targetPo.setPaymentDays(sourcePo.getPaymentDays());
                targetPo.setDelayDays(sourcePo.getDelayDays());
            }
            targetPo.setCreditAmount(sourcePo.getCreditAmount());
            targetPo.setUsedAmount(sourcePo.getUsedAmount());
            targetPo.setBalanceAmount(sourcePo.getBalanceAmount());
            targetPo.setUsedWarningAmount(sourcePo.getUsedWarningAmount());
            targetPo.setOverdueStartAmount(sourcePo.getOverdueStartAmount());
            targetPo.setOverdueWarningRatio(sourcePo.getOverdueWarningRatio());
            targetPo.setOverdueControlRatio(sourcePo.getOverdueControlRatio());
            targetPo.setOverdueRecoveryRatio(sourcePo.getOverdueRecoveryRatio());
            targetPo.setOverdueIndexRatio(sourcePo.getOverdueIndexRatio());
            targetPo.setOverdueWarningIndex(sourcePo.getOverdueWarningIndex());
            targetPo.setOverdueControlIndex(sourcePo.getOverdueControlIndex());
            targetPo.setOverdueRecoveryIndex(sourcePo.getOverdueRecoveryIndex());
            targetPo.setCurrentOrgControlStatus(sourcePo.getCurrentOrgControlStatus());
            targetPo.setCurrentOrgControlTag(sourcePo.getCurrentOrgControlTag());
            targetPo.setCurrentOrgWarningTag(sourcePo.getCurrentOrgWarningTag());
            targetPo.setCurrentOverdueRatio(sourcePo.getCurrentOverdueRatio());
            targetPo.setCurrentOverdueAmount(sourcePo.getCurrentOverdueAmount());
            targetPo.setCurrentPenaltyAmount(sourcePo.getCurrentPenaltyAmount());
            targetPo.setCurrentOverdueIndex(sourcePo.getCurrentOverdueIndex());
        }
        if (FscPayConfigType.EXT_ORG.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayOrgId(sourcePo.getPayOrgId());
            targetPo.setPayOrgName(sourcePo.getPayOrgName());
            targetPo.setPayOrgPath(sourcePo.getPayOrgPath());
            targetPo.setPayUserId(sourcePo.getPayUserId());
            targetPo.setPayUserName(sourcePo.getPayUserName());
        }
        if (FscPayConfigType.EXT_AGR.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayAgrName(sourcePo.getPayAgrName());
            targetPo.setPayAgrNo(sourcePo.getPayAgrNo());
            targetPo.setPayAgrId(sourcePo.getPayAgrId());
            targetPo.setPayAgrEcpNo(sourcePo.getPayAgrEcpNo());
            targetPo.setPayAgrOrgNo(sourcePo.getPayAgrOrgNo());
            targetPo.setPayAgrSupName(sourcePo.getPayAgrSupName());
            targetPo.setPayAgrSupId(sourcePo.getPayAgrSupId());
            targetPo.setPayAgrProName(sourcePo.getPayAgrProName());
            targetPo.setPayAgrProId(sourcePo.getPayAgrProId());
            targetPo.setAgreementType(sourcePo.getAgreementType());
            targetPo.setAgreementTypeStr(sourcePo.getAgreementTypeStr());
            targetPo.setAgreementVariety(sourcePo.getAgreementVariety());
            targetPo.setAgreementVarietyStr(sourcePo.getAgreementVarietyStr());
        }
        if (FscPayConfigType.NO_CREDIT_AGR.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayAgrName(sourcePo.getPayAgrName());
            targetPo.setPayAgrNo(sourcePo.getPayAgrNo());
            targetPo.setPayAgrId(sourcePo.getPayAgrId());
            targetPo.setPayAgrEcpNo(sourcePo.getPayAgrEcpNo());
            targetPo.setPayAgrOrgNo(sourcePo.getPayAgrOrgNo());
            targetPo.setPayAgrSupName(sourcePo.getPayAgrSupName());
            targetPo.setPayAgrSupId(sourcePo.getPayAgrSupId());
            targetPo.setPayAgrProName(sourcePo.getPayAgrProName());
            targetPo.setPayAgrProId(sourcePo.getPayAgrProId());
            targetPo.setAgreementType(sourcePo.getAgreementType());
            targetPo.setAgreementTypeStr(sourcePo.getAgreementTypeStr());
            targetPo.setAgreementVariety(sourcePo.getAgreementVariety());
            targetPo.setAgreementVarietyStr(sourcePo.getAgreementVarietyStr());
            targetPo.setPayAgrHandlerId(sourcePo.getPayAgrHandlerId());
            targetPo.setPayAgrHandlerName(sourcePo.getPayAgrHandlerName());
        }
        if (FscPayConfigType.EXT_CONN.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayContractName(sourcePo.getPayContractName());
            targetPo.setPayContractNo(sourcePo.getPayContractNo());
            targetPo.setPayContractId(sourcePo.getPayContractId());
            targetPo.setPayContractSignOrgId(sourcePo.getPayContractSignOrgId());
            targetPo.setPayContractSignOrgName(sourcePo.getPayContractSignOrgName());
        }
        targetPo.setCreateTime(sourcePo.getCreateTime());
        targetPo.setCreateUserId(sourcePo.getCreateUserId());
        targetPo.setCreateUserName(sourcePo.getCreateUserName());
        targetPo.setUpdateTime(sourcePo.getUpdateTime());
        targetPo.setUpdateUserId(sourcePo.getUpdateUserId());
        targetPo.setUpdateUserName(sourcePo.getUpdateUserName());
        targetPo.setRemark(sourcePo.getRemark());
        targetPo.setStatus(sourcePo.getStatus());
        targetPo.setDeleteFlag(sourcePo.getDeleteFlag());
    }

    private Integer getExceptionNum(Long payConfigId, String payConfigType) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setParentConfigId(payConfigId);
        fscPayConfigQry.setPayConfigType(payConfigType);
        int checkBy = this.fscPayConfigMapper.getCheckBy(fscPayConfigQry);
        return checkBy;
    }
}

