/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.bo.FscPayConfigChannelBO;
import com.tydic.pfscext.dao.FscPayConfigChannelHisMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigHisMapper;
import com.tydic.pfscext.dao.FscPayConfigLogDetailMapper;
import com.tydic.pfscext.dao.FscPayConfigLogMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigChannelHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogDetailPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigPayLogFlag;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscPayConfigEditBusiService;
import com.tydic.pfscext.service.busi.bo.FscPayConfigEditBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigEditBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfigEditBusiServiceImpl
implements FscPayConfigEditBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigEditBusiServiceImpl.class);
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscPayConfigLogMapper fscPayConfigLogMapper;
    @Autowired
    private FscPayConfigHisMapper fscPayConfigHisMapper;
    @Autowired
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;
    @Autowired
    private FscPayConfigChannelHisMapper fscPayConfigChannelHisMapper;
    @Autowired
    private FscPayConfigLogDetailMapper fscPayConfigLogDetailMapper;

    @Override
    public FscPayConfigEditBusiRspBO dealPayConfigEdit(FscPayConfigEditBusiReqBO reqBo) {
        FscPayConfigEditBusiRspBO rspBo = FscRu.success(FscPayConfigEditBusiRspBO.class);
        FscPayConfigPO fscPayConfigOldPo = new FscPayConfigPO();
        fscPayConfigOldPo.setPayConfigId(reqBo.getPayConfigId());
        fscPayConfigOldPo = this.fscPayConfigMapper.getModelBy(fscPayConfigOldPo);
        if (fscPayConfigOldPo == null) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u652f\u4ed8\u914d\u7f6eID\u67e5\u8be2\u4e3a\u7a7a");
        }
        FscPayConfigPO fscPayConfigUpdatePo = new FscPayConfigPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)fscPayConfigUpdatePo);
        fscPayConfigUpdatePo.setPayOrgId(fscPayConfigOldPo.getPayOrgId());
        fscPayConfigUpdatePo.setParentConfigId(0L);
        fscPayConfigUpdatePo.setVersionNo(this.getMaxVersionNo(reqBo));
        fscPayConfigUpdatePo.setPayUsedPeriodFlag(fscPayConfigOldPo.getPayUsedPeriodFlag());
        if (FscPayConfigPayType.ZQ.getCode().equals(reqBo.getPayType())) {
            fscPayConfigUpdatePo.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
        }
        fscPayConfigUpdatePo.setStatus(FscPayConfigStatus.UPDATING.getCode());
        fscPayConfigUpdatePo.setUpdateTime(new Date());
        fscPayConfigUpdatePo.setUpdateUserId(reqBo.getUserId());
        fscPayConfigUpdatePo.setUpdateUserName(reqBo.getName());
        this.fscPayConfigMapper.updateById(fscPayConfigUpdatePo);
        FscPayConfigChannelPO fscPayConfigChannelQry = new FscPayConfigChannelPO();
        fscPayConfigChannelQry.setPayConfigId(reqBo.getPayConfigId());
        fscPayConfigChannelQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
        List<FscPayConfigChannelPO> oldPayConfigChannels = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
        List<FscPayConfigChannelPO> payConfigChannels = this.addPayConfigChannels(reqBo.getPayConfigChannels(), oldPayConfigChannels, fscPayConfigUpdatePo.getPayConfigId(), FscPayConfigType.MAIN.getCode());
        this.addLog(reqBo, fscPayConfigOldPo, fscPayConfigUpdatePo, payConfigChannels, oldPayConfigChannels);
        rspBo.setPayConfigId(fscPayConfigUpdatePo.getPayConfigId());
        rspBo.setVersionNo(fscPayConfigUpdatePo.getVersionNo());
        return rspBo;
    }

    private Long getMaxVersionNo(FscPayConfigEditBusiReqBO reqBo) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setPayBusiType(reqBo.getPayBusiType());
        fscPayConfigQry.setPaySubClass(reqBo.getPaySubClass());
        fscPayConfigQry.setPaySubType(reqBo.getPaySubType());
        fscPayConfigQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
        FscPayConfigPO modelBy = this.fscPayConfigMapper.getMaxVersionNo(fscPayConfigQry);
        return modelBy.getVersionNo() + 1L;
    }

    private void addLog(FscPayConfigEditBusiReqBO reqBo, FscPayConfigPO fscPayConfigOldPo, FscPayConfigPO fscPayConfigUpdatePo, List<FscPayConfigChannelPO> payConfigChannels, List<FscPayConfigChannelPO> oldPayConfigChannels) {
        Date nowTime = new Date();
        FscPayConfigLogPO fscPayConfigLogPo = new FscPayConfigLogPO();
        fscPayConfigLogPo.setPayLogId(Sequence.getInstance().nextId());
        fscPayConfigLogPo.setVersionNo(fscPayConfigUpdatePo.getVersionNo());
        fscPayConfigLogPo.setPayLogFlag("3");
        fscPayConfigLogPo.setPayBusiType(fscPayConfigOldPo.getPayBusiType());
        fscPayConfigLogPo.setPaySubClass(fscPayConfigOldPo.getPaySubClass());
        fscPayConfigLogPo.setPaySubType(fscPayConfigOldPo.getPaySubType());
        fscPayConfigLogPo.setPayConfigMode(fscPayConfigOldPo.getPayConfigMode());
        fscPayConfigLogPo.setExceptionMain(YesOrNo.YES.getCode());
        fscPayConfigLogPo.setExceptionOrg(YesOrNo.NO.getCode());
        fscPayConfigLogPo.setExceptionAgr(YesOrNo.NO.getCode());
        fscPayConfigLogPo.setExceptionConn(YesOrNo.NO.getCode());
        fscPayConfigLogPo.setCreateTime(nowTime);
        fscPayConfigLogPo.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogPo.setCreateUserName(reqBo.getName());
        this.fscPayConfigLogMapper.insert(fscPayConfigLogPo);
        FscPayConfigHisPO fscPayConfigHisBeforePo = new FscPayConfigHisPO();
        this.initFscPayConfigHisPo(fscPayConfigOldPo, fscPayConfigHisBeforePo);
        fscPayConfigHisBeforePo.setPayConfigHisId(Sequence.getInstance().nextId());
        fscPayConfigHisBeforePo.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigHisBeforePo.setPayLogFlag("4");
        int insert = this.fscPayConfigHisMapper.insert(fscPayConfigHisBeforePo);
        if (!CollectionUtils.isEmpty(oldPayConfigChannels)) {
            ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
            for (FscPayConfigChannelPO payConfigChannel : oldPayConfigChannels) {
                FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                his.setPayConfigHisId(fscPayConfigHisBeforePo.getPayConfigHisId());
                his.setPayConfigChannelId(payConfigChannel.getPayConfigChannelId());
                his.setPayConfigId(payConfigChannel.getPayConfigId());
                his.setPayConfigType(payConfigChannel.getPayConfigType());
                his.setPayChannels(payConfigChannel.getPayChannels());
                his.setPayMethod(payConfigChannel.getPayMethod());
                his.setCreateTime(payConfigChannel.getCreateTime());
                his.setRemark(payConfigChannel.getRemark());
                his.setHisCreateTime(nowTime);
                his.setHisCreateUserId(reqBo.getUserId());
                his.setHisCreateUserName(reqBo.getUsername());
                channelHisList.add(his);
            }
            this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
        }
        FscPayConfigPO fscPayConfigNew = new FscPayConfigPO();
        fscPayConfigNew.setPayConfigId(fscPayConfigUpdatePo.getPayConfigId());
        fscPayConfigNew = this.fscPayConfigMapper.getModelBy(fscPayConfigNew);
        FscPayConfigHisPO fscPayConfigHisAfterPo = new FscPayConfigHisPO();
        this.initFscPayConfigHisPo(fscPayConfigNew, fscPayConfigHisAfterPo);
        fscPayConfigHisAfterPo.setPayConfigHisId(Sequence.getInstance().nextId());
        fscPayConfigHisAfterPo.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigHisAfterPo.setPayLogFlag("5");
        this.fscPayConfigHisMapper.insert(fscPayConfigHisAfterPo);
        if (!CollectionUtils.isEmpty(payConfigChannels)) {
            ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
            for (FscPayConfigChannelPO payConfigChannel : payConfigChannels) {
                FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                his.setPayConfigHisId(fscPayConfigHisAfterPo.getPayConfigHisId());
                his.setPayConfigChannelId(payConfigChannel.getPayConfigChannelId());
                his.setPayConfigId(payConfigChannel.getPayConfigId());
                his.setPayConfigType(payConfigChannel.getPayConfigType());
                his.setPayChannels(payConfigChannel.getPayChannels());
                his.setPayMethod(payConfigChannel.getPayMethod());
                his.setCreateTime(payConfigChannel.getCreateTime());
                his.setRemark(payConfigChannel.getRemark());
                his.setHisCreateTime(nowTime);
                his.setHisCreateUserId(reqBo.getUserId());
                his.setHisCreateUserName(reqBo.getUsername());
                channelHisList.add(his);
            }
            this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
        }
        FscPayConfigLogDetailPO fscPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
        fscPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
        fscPayConfigLogDetailInsert.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.EDIT.getCode());
        fscPayConfigLogDetailInsert.setPayConfigType(FscPayConfigType.MAIN.getCode());
        fscPayConfigLogDetailInsert.setPayConfigHisOldId(fscPayConfigHisBeforePo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setPayConfigHisNewId(fscPayConfigHisAfterPo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setChangeFieldCollection(this.getChangeField(fscPayConfigHisBeforePo, fscPayConfigHisAfterPo));
        fscPayConfigLogDetailInsert.setCreateTime(nowTime);
        fscPayConfigLogDetailInsert.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogDetailInsert.setCreateUserName(reqBo.getUsername());
        this.fscPayConfigLogDetailMapper.insert(fscPayConfigLogDetailInsert);
    }

    private void initFscPayConfigHisPo(FscPayConfigPO sourcePo, FscPayConfigHisPO targetPo) {
        targetPo.setPayConfigId(sourcePo.getPayConfigId());
        targetPo.setParentConfigId(sourcePo.getParentConfigId());
        targetPo.setVersionNo(sourcePo.getVersionNo());
        targetPo.setPayBusiType(sourcePo.getPayBusiType());
        targetPo.setPaySubClass(sourcePo.getPaySubClass());
        targetPo.setPaySubType(sourcePo.getPaySubType());
        targetPo.setPayConfigMode(sourcePo.getPayConfigMode());
        targetPo.setPayConfigType(sourcePo.getPayConfigType());
        targetPo.setPayUsedPeriodFlag(sourcePo.getPayUsedPeriodFlag());
        targetPo.setPayAllowExceptionFlag(sourcePo.getPayAllowExceptionFlag());
        targetPo.setExceptionOrgNum(sourcePo.getExceptionOrgNum());
        targetPo.setExceptionAgrNum(sourcePo.getExceptionAgrNum());
        targetPo.setExceptionConnNum(sourcePo.getExceptionConnNum());
        targetPo.setPayType(sourcePo.getPayType());
        if (FscPayConfigPayType.YF_RATIO.getCode().equals(sourcePo.getPayType())) {
            targetPo.setDownPaymentRatio(sourcePo.getDownPaymentRatio());
            targetPo.setCheckPaymentRatio(sourcePo.getCheckPaymentRatio());
        }
        if (FscPayConfigPayType.XY.getCode().equals(sourcePo.getPayType()) || FscPayConfigPayType.ZQ.getCode().equals(sourcePo.getPayType())) {
            if (!FscPayConfigBusiType.AGR_DW.getCode().equals(sourcePo.getPayBusiType())) {
                targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
                targetPo.setPaymentDays(sourcePo.getPaymentDays());
                targetPo.setDelayDays(sourcePo.getDelayDays());
            }
            targetPo.setCreditAmount(sourcePo.getCreditAmount());
            targetPo.setUsedAmount(sourcePo.getUsedAmount());
            targetPo.setBalanceAmount(sourcePo.getBalanceAmount());
            targetPo.setUsedWarningAmount(sourcePo.getUsedWarningAmount());
            targetPo.setOverdueStartAmount(sourcePo.getOverdueStartAmount());
            targetPo.setOverdueWarningRatio(sourcePo.getOverdueWarningRatio());
            targetPo.setOverdueControlRatio(sourcePo.getOverdueControlRatio());
            targetPo.setOverdueRecoveryRatio(sourcePo.getOverdueRecoveryRatio());
            targetPo.setOverdueIndexRatio(sourcePo.getOverdueIndexRatio());
            targetPo.setOverdueWarningIndex(sourcePo.getOverdueWarningIndex());
            targetPo.setOverdueControlIndex(sourcePo.getOverdueControlIndex());
            targetPo.setOverdueRecoveryIndex(sourcePo.getOverdueRecoveryIndex());
            targetPo.setCurrentOrgControlStatus(sourcePo.getCurrentOrgControlStatus());
            targetPo.setCurrentOrgControlTag(sourcePo.getCurrentOrgControlTag());
            targetPo.setCurrentOrgWarningTag(sourcePo.getCurrentOrgWarningTag());
            targetPo.setCurrentOverdueRatio(sourcePo.getCurrentOverdueRatio());
            targetPo.setCurrentOverdueAmount(sourcePo.getCurrentOverdueAmount());
            targetPo.setCurrentPenaltyAmount(sourcePo.getCurrentPenaltyAmount());
            targetPo.setCurrentOverdueIndex(sourcePo.getCurrentOverdueIndex());
        }
        if (FscPayConfigType.EXT_ORG.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayOrgId(sourcePo.getPayOrgId());
            targetPo.setPayOrgName(sourcePo.getPayOrgName());
            targetPo.setPayOrgPath(sourcePo.getPayOrgPath());
            targetPo.setPayUserId(sourcePo.getPayUserId());
            targetPo.setPayUserName(sourcePo.getPayUserName());
        }
        if (FscPayConfigType.EXT_AGR.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayAgrName(sourcePo.getPayAgrName());
            targetPo.setPayAgrNo(sourcePo.getPayAgrNo());
            targetPo.setPayAgrId(sourcePo.getPayAgrId());
            targetPo.setPayAgrEcpNo(sourcePo.getPayAgrEcpNo());
            targetPo.setPayAgrOrgNo(sourcePo.getPayAgrOrgNo());
            targetPo.setPayAgrSupName(sourcePo.getPayAgrSupName());
            targetPo.setPayAgrSupId(sourcePo.getPayAgrSupId());
            targetPo.setPayAgrProName(sourcePo.getPayAgrProName());
            targetPo.setPayAgrProId(sourcePo.getPayAgrProId());
            targetPo.setAgreementType(sourcePo.getAgreementType());
            targetPo.setAgreementTypeStr(sourcePo.getAgreementTypeStr());
            targetPo.setAgreementVariety(sourcePo.getAgreementVariety());
            targetPo.setAgreementVarietyStr(sourcePo.getAgreementVarietyStr());
        }
        if (FscPayConfigType.EXT_CONN.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayContractName(sourcePo.getPayContractName());
            targetPo.setPayContractNo(sourcePo.getPayContractNo());
            targetPo.setPayContractId(sourcePo.getPayContractId());
            targetPo.setPayContractSignOrgId(sourcePo.getPayContractSignOrgId());
            targetPo.setPayContractSignOrgName(sourcePo.getPayContractSignOrgName());
        }
        targetPo.setCreateTime(sourcePo.getCreateTime());
        targetPo.setCreateUserId(sourcePo.getCreateUserId());
        targetPo.setCreateUserName(sourcePo.getCreateUserName());
        targetPo.setUpdateTime(sourcePo.getUpdateTime());
        targetPo.setUpdateUserId(sourcePo.getUpdateUserId());
        targetPo.setUpdateUserName(sourcePo.getUpdateUserName());
        targetPo.setRemark(sourcePo.getRemark());
        targetPo.setStatus(sourcePo.getStatus());
        targetPo.setDeleteFlag(sourcePo.getDeleteFlag());
    }

    private String getChangeField(FscPayConfigHisPO fscPayConfigHisOld, FscPayConfigHisPO fscPayConfigHisNew) {
        ArrayList changeField = new ArrayList();
        return JSON.toJSONString(changeField);
    }

    private List<FscPayConfigChannelPO> addPayConfigChannels(List<FscPayConfigChannelBO> payConfigChannels, List<FscPayConfigChannelPO> oldPayConfigChannels, Long payConfigId, String payConfigType) {
        List<Long> payConfigChannelIdList;
        if (!CollectionUtils.isEmpty(oldPayConfigChannels) && !CollectionUtils.isEmpty(payConfigChannelIdList = oldPayConfigChannels.stream().map(FscPayConfigChannelPO::getPayConfigChannelId).collect(Collectors.toList()))) {
            FscPayConfigChannelPO fscPayConfigChannelDel = new FscPayConfigChannelPO();
            fscPayConfigChannelDel.setPayConfigChannelIdList(payConfigChannelIdList);
            this.fscPayConfigChannelMapper.deleteBy(fscPayConfigChannelDel);
        }
        ArrayList<FscPayConfigChannelPO> payConfigChannelPos = new ArrayList<FscPayConfigChannelPO>();
        if (!CollectionUtils.isEmpty(payConfigChannels)) {
            for (FscPayConfigChannelBO channelBo : payConfigChannels) {
                FscPayConfigChannelPO po = new FscPayConfigChannelPO();
                po.setPayConfigChannelId(Sequence.getInstance().nextId());
                po.setPayConfigId(payConfigId);
                po.setPayConfigType(payConfigType);
                po.setPayChannels(channelBo.getPayChannels());
                po.setPayMethod(channelBo.getPayMethod());
                po.setCreateTime(new Date());
                po.setRemark(channelBo.getRemark());
                payConfigChannelPos.add(po);
            }
            this.fscPayConfigChannelMapper.insertBatch(payConfigChannelPos);
        }
        return payConfigChannelPos;
    }
}

