/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.bo.FscPayConfigChannelBO;
import com.tydic.pfscext.dao.FscPayConfigChannelHisMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigHisMapper;
import com.tydic.pfscext.dao.FscPayConfigLogDetailMapper;
import com.tydic.pfscext.dao.FscPayConfigLogMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigChannelHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogDetailPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigPayLogFlag;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.FscPayConfigExceptionEditBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigExceptionEditBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigExceptionEditBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfigExceptionEditBusiServiceImpl
implements FscPayConfigExceptionEditBusiService {
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;
    @Autowired
    private FscPayConfigLogMapper fscPayConfigLogMapper;
    @Autowired
    private FscPayConfigHisMapper fscPayConfigHisMapper;
    @Autowired
    private FscPayConfigChannelHisMapper fscPayConfigChannelHisMapper;
    @Autowired
    private FscPayConfigLogDetailMapper fscPayConfigLogDetailMapper;
    @Autowired
    private FscCreditControlBusiService fscCreditControlBusiService;

    @Override
    public FscPayConfigExceptionEditBusiRspBO dealPayConfigExceptionEdit(FscPayConfigExceptionEditBusiReqBO reqBo) {
        FscPayConfigExceptionEditBusiRspBO rspBo = FscRu.success(FscPayConfigExceptionEditBusiRspBO.class);
        FscPayConfigPO fscPayConfigParent = new FscPayConfigPO();
        fscPayConfigParent.setPayConfigId(reqBo.getParentConfigId());
        fscPayConfigParent = this.fscPayConfigMapper.getModelBy(fscPayConfigParent);
        if (fscPayConfigParent == null) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u5931\u8d25\uff0c\u7236\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        FscPayConfigPO fscPayConfigOld = new FscPayConfigPO();
        fscPayConfigOld.setPayConfigId(reqBo.getPayConfigId());
        fscPayConfigOld.setParentConfigId(reqBo.getParentConfigId());
        fscPayConfigOld.setPayConfigType(reqBo.getExceptionType());
        fscPayConfigOld.setPayBusiType(fscPayConfigParent.getPayBusiType());
        fscPayConfigOld.setPaySubType(fscPayConfigParent.getPaySubType());
        fscPayConfigOld.setPaySubClass(fscPayConfigParent.getPaySubClass());
        fscPayConfigOld.setPayOrgId(reqBo.getPayOrgId());
        fscPayConfigOld.setPayAgrId(reqBo.getPayAgrId());
        fscPayConfigOld.setPayContractId(reqBo.getPayContractId());
        fscPayConfigOld = this.fscPayConfigMapper.getModelBy(fscPayConfigOld);
        if (fscPayConfigOld == null) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u5931\u8d25\uff0c\u6839\u636e\u5165\u53c2\u4e3a\u67e5\u8be2\u5230\u4f8b\u5916\u6570\u636e\u4e3a\u7a7a");
        }
        FscPayConfigPO fscPayConfigUpdate = FscRu.js((Object)reqBo, FscPayConfigPO.class);
        fscPayConfigUpdate.setPayConfigId(fscPayConfigOld.getPayConfigId());
        fscPayConfigUpdate.setDeleteFlag(YesOrNo.NO.getCode());
        fscPayConfigUpdate.setUpdateTime(new Date());
        fscPayConfigUpdate.setUpdateUserId(reqBo.getUserId());
        fscPayConfigUpdate.setUpdateUserName(reqBo.getName());
        if (FscPayConfigType.EXT_ORG.getCode().equals(reqBo.getExceptionType())) {
            if (FscPayConfigSubType.GR.getCode().equals(reqBo.getPaySubType())) {
                ValUtil.isEmpty(reqBo.getPayUserId()).exception("\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
                ValUtil.isBlank(reqBo.getPayUserName()).exception("\u7528\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ValUtil.isEmpty(reqBo.getPayOrgId()).exception("\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isBlank(reqBo.getPayOrgName()).exception("\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isBlank(reqBo.getPayOrgPath()).exception("\u673a\u6784\u6811\u4e0d\u80fd\u4e3a\u7a7a");
            if (FscPayConfigPayType.ZQ.getCode().equals(reqBo.getPayType()) || FscPayConfigPayType.XY.getCode().equals(reqBo.getPayType())) {
                fscPayConfigUpdate.setUsedAmount(reqBo.getCreditAmount());
                fscPayConfigUpdate.setUsedAmount(Optional.ofNullable(fscPayConfigOld.getUsedAmount()).orElse(BigDecimal.ZERO));
                fscPayConfigUpdate.setBalanceAmount(fscPayConfigUpdate.getCreditAmount().subtract(fscPayConfigUpdate.getUsedAmount()));
            }
        }
        this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
        ArrayList<FscPayConfigChannelPO> oldPayConfigChannels = new ArrayList<FscPayConfigChannelPO>();
        FscPayConfigChannelPO fscPayConfigChannelQry = new FscPayConfigChannelPO();
        fscPayConfigChannelQry.setPayConfigId(fscPayConfigOld.getPayConfigId());
        fscPayConfigChannelQry.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
        List<FscPayConfigChannelPO> list = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
        if (!CollectionUtils.isEmpty(list)) {
            oldPayConfigChannels.addAll(list);
            this.fscPayConfigChannelMapper.deleteBy(fscPayConfigChannelQry);
        }
        List<FscPayConfigChannelPO> payConfigChannels = this.addPayConfigChannels(reqBo.getPayConfigChannels(), fscPayConfigOld.getPayConfigId(), FscPayConfigType.EXT_ORG.getCode());
        if (FscPayConfigType.EXT_ORG.getCode().equals(reqBo.getExceptionType())) {
            FscCreditControlBusiReqBO fscCreditControlBusiReqBo = new FscCreditControlBusiReqBO();
            fscCreditControlBusiReqBo.setPayConfigId(fscPayConfigUpdate.getPayConfigId());
            FscCreditControlBusiRspBO fscCreditControlBusiRspBo = this.fscCreditControlBusiService.dealCreditControl(fscCreditControlBusiReqBo);
            if (FscRu.isFailed(fscCreditControlBusiRspBo.getRespCode()).booleanValue()) {
                throw new PfscExtBusinessException(rspBo.getRespCode(), "\u66f4\u65b0\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001\u5f02\u5e38\uff1a" + fscCreditControlBusiRspBo.getRespDesc());
            }
        }
        FscPayConfigPO fscPayConfigParentUpdate = new FscPayConfigPO();
        fscPayConfigParentUpdate.setPayConfigId(fscPayConfigParent.getPayConfigId());
        fscPayConfigParentUpdate.setUpdateTime(new Date());
        fscPayConfigParentUpdate.setUpdateUserId(reqBo.getUserId());
        fscPayConfigParentUpdate.setUpdateUserName(reqBo.getName());
        this.fscPayConfigMapper.updateById(fscPayConfigParentUpdate);
        this.addLog(reqBo, fscPayConfigOld, fscPayConfigUpdate, payConfigChannels, oldPayConfigChannels);
        rspBo.setPayConfigId(fscPayConfigUpdate.getPayConfigId());
        rspBo.setParentConfigId(fscPayConfigUpdate.getParentConfigId());
        rspBo.setVersionNo(fscPayConfigOld.getVersionNo());
        return rspBo;
    }

    private List<FscPayConfigChannelPO> addPayConfigChannels(List<FscPayConfigChannelBO> payConfigChannels, Long payConfigId, String payConfigType) {
        ArrayList<FscPayConfigChannelPO> payConfigChannelPos = new ArrayList<FscPayConfigChannelPO>();
        if (!CollectionUtils.isEmpty(payConfigChannels)) {
            for (FscPayConfigChannelBO channelBo : payConfigChannels) {
                FscPayConfigChannelPO po = new FscPayConfigChannelPO();
                po.setPayConfigChannelId(Sequence.getInstance().nextId());
                po.setPayConfigId(payConfigId);
                po.setPayConfigType(payConfigType);
                po.setPayChannels(channelBo.getPayChannels());
                po.setPayMethod(channelBo.getPayMethod());
                po.setCreateTime(new Date());
                po.setRemark(channelBo.getRemark());
                payConfigChannelPos.add(po);
            }
            this.fscPayConfigChannelMapper.insertBatch(payConfigChannelPos);
        }
        return payConfigChannelPos;
    }

    private void addLog(FscPayConfigExceptionEditBusiReqBO reqBo, FscPayConfigPO fscPayConfigOldPo, FscPayConfigPO fscPayConfigUpdatePo, List<FscPayConfigChannelPO> payConfigChannels, List<FscPayConfigChannelPO> oldPayConfigChannels) {
        Date nowTime = new Date();
        FscPayConfigLogPO fscPayConfigLogPo = new FscPayConfigLogPO();
        fscPayConfigLogPo.setPayLogId(Sequence.getInstance().nextId());
        fscPayConfigLogPo.setVersionNo(fscPayConfigUpdatePo.getVersionNo());
        fscPayConfigLogPo.setPayLogFlag("3");
        fscPayConfigLogPo.setPayBusiType(fscPayConfigOldPo.getPayBusiType());
        fscPayConfigLogPo.setPaySubClass(fscPayConfigOldPo.getPaySubClass());
        fscPayConfigLogPo.setPaySubType(fscPayConfigOldPo.getPaySubType());
        fscPayConfigLogPo.setPayConfigMode(fscPayConfigOldPo.getPayConfigMode());
        fscPayConfigLogPo.setExceptionMain(YesOrNo.NO.getCode());
        fscPayConfigLogPo.setExceptionOrg(YesOrNo.NO.getCode());
        fscPayConfigLogPo.setExceptionAgr(YesOrNo.NO.getCode());
        fscPayConfigLogPo.setExceptionConn(YesOrNo.NO.getCode());
        if (FscPayConfigType.EXT_ORG.getCode().equals(reqBo.getExceptionType())) {
            fscPayConfigLogPo.setExceptionOrg(YesOrNo.YES.getCode());
        } else if (FscPayConfigType.EXT_AGR.getCode().equals(reqBo.getExceptionType())) {
            fscPayConfigLogPo.setExceptionAgr(YesOrNo.YES.getCode());
        } else if (FscPayConfigType.EXT_CONN.getCode().equals(reqBo.getExceptionType())) {
            fscPayConfigLogPo.setExceptionConn(YesOrNo.YES.getCode());
        }
        fscPayConfigLogPo.setCreateTime(nowTime);
        fscPayConfigLogPo.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogPo.setCreateUserName(reqBo.getName());
        this.fscPayConfigLogMapper.insert(fscPayConfigLogPo);
        FscPayConfigHisPO fscPayConfigHisBeforePo = new FscPayConfigHisPO();
        this.initFscPayConfigHisPo(fscPayConfigOldPo, fscPayConfigHisBeforePo);
        fscPayConfigHisBeforePo.setPayConfigHisId(Sequence.getInstance().nextId());
        fscPayConfigHisBeforePo.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigHisBeforePo.setPayLogFlag("4");
        this.fscPayConfigHisMapper.insert(fscPayConfigHisBeforePo);
        if (!CollectionUtils.isEmpty(oldPayConfigChannels)) {
            ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
            for (FscPayConfigChannelPO payConfigChannel : oldPayConfigChannels) {
                FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                his.setPayConfigHisId(fscPayConfigHisBeforePo.getPayConfigHisId());
                his.setPayConfigChannelId(payConfigChannel.getPayConfigChannelId());
                his.setPayConfigId(payConfigChannel.getPayConfigId());
                his.setPayConfigType(payConfigChannel.getPayConfigType());
                his.setPayChannels(payConfigChannel.getPayChannels());
                his.setPayMethod(payConfigChannel.getPayMethod());
                his.setCreateTime(payConfigChannel.getCreateTime());
                his.setRemark(payConfigChannel.getRemark());
                his.setHisCreateTime(nowTime);
                his.setHisCreateUserId(reqBo.getUserId());
                his.setHisCreateUserName(reqBo.getUsername());
                channelHisList.add(his);
            }
            this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
        }
        FscPayConfigPO fscPayConfigNew = new FscPayConfigPO();
        fscPayConfigNew.setPayConfigId(fscPayConfigUpdatePo.getPayConfigId());
        fscPayConfigNew = this.fscPayConfigMapper.getModelBy(fscPayConfigNew);
        FscPayConfigHisPO fscPayConfigHisAfterPo = new FscPayConfigHisPO();
        this.initFscPayConfigHisPo(fscPayConfigNew, fscPayConfigHisAfterPo);
        fscPayConfigHisAfterPo.setPayConfigHisId(Sequence.getInstance().nextId());
        fscPayConfigHisAfterPo.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigHisAfterPo.setPayLogFlag("5");
        this.fscPayConfigHisMapper.insert(fscPayConfigHisAfterPo);
        if (!CollectionUtils.isEmpty(payConfigChannels)) {
            ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
            for (FscPayConfigChannelPO payConfigChannel : payConfigChannels) {
                FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                his.setPayConfigHisId(fscPayConfigHisAfterPo.getPayConfigHisId());
                his.setPayConfigChannelId(payConfigChannel.getPayConfigChannelId());
                his.setPayConfigId(payConfigChannel.getPayConfigId());
                his.setPayConfigType(payConfigChannel.getPayConfigType());
                his.setPayChannels(payConfigChannel.getPayChannels());
                his.setPayMethod(payConfigChannel.getPayMethod());
                his.setCreateTime(payConfigChannel.getCreateTime());
                his.setRemark(payConfigChannel.getRemark());
                his.setHisCreateTime(nowTime);
                his.setHisCreateUserId(reqBo.getUserId());
                his.setHisCreateUserName(reqBo.getUsername());
                channelHisList.add(his);
            }
            this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
        }
        FscPayConfigLogDetailPO fscPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
        fscPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
        fscPayConfigLogDetailInsert.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.EDIT.getCode());
        fscPayConfigLogDetailInsert.setPayConfigType(reqBo.getExceptionType());
        fscPayConfigLogDetailInsert.setPayConfigHisOldId(fscPayConfigHisBeforePo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setPayConfigHisNewId(fscPayConfigHisAfterPo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setCreateTime(nowTime);
        fscPayConfigLogDetailInsert.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogDetailInsert.setCreateUserName(reqBo.getUsername());
        this.fscPayConfigLogDetailMapper.insert(fscPayConfigLogDetailInsert);
    }

    private void initFscPayConfigHisPo(FscPayConfigPO sourcePo, FscPayConfigHisPO targetPo) {
        targetPo.setPayConfigId(sourcePo.getPayConfigId());
        targetPo.setParentConfigId(sourcePo.getParentConfigId());
        targetPo.setVersionNo(sourcePo.getVersionNo());
        targetPo.setPayBusiType(sourcePo.getPayBusiType());
        targetPo.setPaySubClass(sourcePo.getPaySubClass());
        targetPo.setPaySubType(sourcePo.getPaySubType());
        targetPo.setPayConfigMode(sourcePo.getPayConfigMode());
        targetPo.setPayConfigType(sourcePo.getPayConfigType());
        targetPo.setPayUsedPeriodFlag(sourcePo.getPayUsedPeriodFlag());
        targetPo.setPayAllowExceptionFlag(sourcePo.getPayAllowExceptionFlag());
        targetPo.setExceptionOrgNum(sourcePo.getExceptionOrgNum());
        targetPo.setExceptionAgrNum(sourcePo.getExceptionAgrNum());
        targetPo.setExceptionConnNum(sourcePo.getExceptionConnNum());
        targetPo.setPayType(sourcePo.getPayType());
        if (FscPayConfigPayType.YF_RATIO.getCode().equals(sourcePo.getPayType())) {
            targetPo.setDownPaymentRatio(sourcePo.getDownPaymentRatio());
            targetPo.setCheckPaymentRatio(sourcePo.getCheckPaymentRatio());
        }
        if (FscPayConfigPayType.XY.getCode().equals(sourcePo.getPayType()) || FscPayConfigPayType.ZQ.getCode().equals(sourcePo.getPayType())) {
            if (!FscPayConfigBusiType.AGR_DW.getCode().equals(sourcePo.getPayBusiType())) {
                targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
                targetPo.setPaymentDays(sourcePo.getPaymentDays());
                targetPo.setDelayDays(sourcePo.getDelayDays());
            }
            targetPo.setCreditAmount(sourcePo.getCreditAmount());
            targetPo.setUsedAmount(sourcePo.getUsedAmount());
            targetPo.setBalanceAmount(sourcePo.getBalanceAmount());
            targetPo.setUsedWarningAmount(sourcePo.getUsedWarningAmount());
            targetPo.setOverdueStartAmount(sourcePo.getOverdueStartAmount());
            targetPo.setOverdueWarningRatio(sourcePo.getOverdueWarningRatio());
            targetPo.setOverdueControlRatio(sourcePo.getOverdueControlRatio());
            targetPo.setOverdueRecoveryRatio(sourcePo.getOverdueRecoveryRatio());
            targetPo.setOverdueIndexRatio(sourcePo.getOverdueIndexRatio());
            targetPo.setOverdueWarningIndex(sourcePo.getOverdueWarningIndex());
            targetPo.setOverdueControlIndex(sourcePo.getOverdueControlIndex());
            targetPo.setOverdueRecoveryIndex(sourcePo.getOverdueRecoveryIndex());
            targetPo.setCurrentOrgControlStatus(sourcePo.getCurrentOrgControlStatus());
            targetPo.setCurrentOrgControlTag(sourcePo.getCurrentOrgControlTag());
            targetPo.setCurrentOrgWarningTag(sourcePo.getCurrentOrgWarningTag());
            targetPo.setCurrentOverdueRatio(sourcePo.getCurrentOverdueRatio());
            targetPo.setCurrentOverdueAmount(sourcePo.getCurrentOverdueAmount());
            targetPo.setCurrentPenaltyAmount(sourcePo.getCurrentPenaltyAmount());
            targetPo.setCurrentOverdueIndex(sourcePo.getCurrentOverdueIndex());
        }
        if (FscPayConfigType.EXT_ORG.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayOrgId(sourcePo.getPayOrgId());
            targetPo.setPayOrgName(sourcePo.getPayOrgName());
            targetPo.setPayOrgPath(sourcePo.getPayOrgPath());
            targetPo.setPayUserId(sourcePo.getPayUserId());
            targetPo.setPayUserName(sourcePo.getPayUserName());
        }
        if (FscPayConfigType.EXT_AGR.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayAgrName(sourcePo.getPayAgrName());
            targetPo.setPayAgrNo(sourcePo.getPayAgrNo());
            targetPo.setPayAgrId(sourcePo.getPayAgrId());
            targetPo.setPayAgrEcpNo(sourcePo.getPayAgrEcpNo());
            targetPo.setPayAgrOrgNo(sourcePo.getPayAgrOrgNo());
            targetPo.setPayAgrSupName(sourcePo.getPayAgrSupName());
            targetPo.setPayAgrSupId(sourcePo.getPayAgrSupId());
            targetPo.setPayAgrProName(sourcePo.getPayAgrProName());
            targetPo.setPayAgrProId(sourcePo.getPayAgrProId());
            targetPo.setAgreementType(sourcePo.getAgreementType());
            targetPo.setAgreementTypeStr(sourcePo.getAgreementTypeStr());
            targetPo.setAgreementVariety(sourcePo.getAgreementVariety());
            targetPo.setAgreementVarietyStr(sourcePo.getAgreementVarietyStr());
        }
        if (FscPayConfigType.EXT_CONN.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayContractName(sourcePo.getPayContractName());
            targetPo.setPayContractNo(sourcePo.getPayContractNo());
            targetPo.setPayContractId(sourcePo.getPayContractId());
            targetPo.setPayContractSignOrgId(sourcePo.getPayContractSignOrgId());
            targetPo.setPayContractSignOrgName(sourcePo.getPayContractSignOrgName());
        }
        targetPo.setCreateTime(sourcePo.getCreateTime());
        targetPo.setCreateUserId(sourcePo.getCreateUserId());
        targetPo.setCreateUserName(sourcePo.getCreateUserName());
        targetPo.setUpdateTime(sourcePo.getUpdateTime());
        targetPo.setUpdateUserId(sourcePo.getUpdateUserId());
        targetPo.setUpdateUserName(sourcePo.getUpdateUserName());
        targetPo.setRemark(sourcePo.getRemark());
        targetPo.setStatus(sourcePo.getStatus());
        targetPo.setDeleteFlag(sourcePo.getDeleteFlag());
    }
}

