/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.bo.FscPayConfigChannelBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigExceptionSaveAgrConnInfoBO;
import com.tydic.pfscext.api.ability.bo.FscPayConfigExceptionSaveOrgInfoBO;
import com.tydic.pfscext.dao.FscPayConfigChannelHisMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigHisMapper;
import com.tydic.pfscext.dao.FscPayConfigLogDetailMapper;
import com.tydic.pfscext.dao.FscPayConfigLogMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigChannelHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogDetailPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigPayLogFlag;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.FscPayConfigExceptionSaveBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigExceptionSaveBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigExceptionSaveBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfigExceptionSaveBusiServiceImpl
implements FscPayConfigExceptionSaveBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigExceptionSaveBusiServiceImpl.class);
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;
    @Autowired
    private FscPayConfigLogMapper fscPayConfigLogMapper;
    @Autowired
    private FscPayConfigHisMapper fscPayConfigHisMapper;
    @Autowired
    private FscPayConfigChannelHisMapper fscPayConfigChannelHisMapper;
    @Autowired
    private FscPayConfigLogDetailMapper fscPayConfigLogDetailMapper;
    @Autowired
    private FscCreditControlBusiService fscCreditControlBusiService;

    @Override
    public FscPayConfigExceptionSaveBusiRspBO dealPayConfigExceptionSave(FscPayConfigExceptionSaveBusiReqBO reqBo) {
        FscPayConfigPO fscPayConfigParent = new FscPayConfigPO();
        fscPayConfigParent.setPayConfigId(reqBo.getParentConfigId());
        fscPayConfigParent.setPayBusiType(reqBo.getPayBusiType());
        fscPayConfigParent.setPaySubClass(reqBo.getPaySubClass());
        fscPayConfigParent.setPaySubType(reqBo.getPaySubType());
        fscPayConfigParent = this.fscPayConfigMapper.getModelBy(fscPayConfigParent);
        if (fscPayConfigParent == null) {
            throw new PfscExtBusinessException("18000", "\u65b0\u589e\u5931\u8d25\uff0c\u7236\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        if (FscPayConfigType.MAIN.getCode().equals(fscPayConfigParent.getPayConfigType())) {
            if (FscPayConfigType.EXT_ORG.getCode().equals(reqBo.getExceptionType())) {
                if (CollectionUtils.isEmpty(reqBo.getOrgInfoList())) {
                    throw new PfscExtBusinessException("0001", "\u673a\u6784\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                return this.dealExceptionCompany(reqBo, fscPayConfigParent);
            }
            if (FscPayConfigType.EXT_AGR.getCode().equals(reqBo.getExceptionType())) {
                if (!FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigParent.getPayBusiType())) {
                    throw new PfscExtBusinessException("0001", "\u4ec5[\u5e73\u53f0\u534f\u8bae\u4e1a\u52a1]\u53ef\u914d\u7f6e\u4f8b\u5916\u534f\u8bae");
                }
                return this.dealExceptionAgr(reqBo, fscPayConfigParent, true);
            }
            if (FscPayConfigType.EXT_CONN.getCode().equals(reqBo.getExceptionType())) {
                if (!FscPayConfigBusiType.EC.getCode().equals(fscPayConfigParent.getPayBusiType()) && !FscPayConfigBusiType.FL.getCode().equals(fscPayConfigParent.getPayBusiType())) {
                    throw new PfscExtBusinessException("0001", "\u4ec5[\u7b2c\u4e09\u65b9\u7535\u5546\u4e1a\u52a1\u3001\u5458\u5de5\u798f\u5229\u4e1a\u52a1]\u53ef\u914d\u7f6e\u4f8b\u5916\u5408\u540c");
                }
                return this.dealExceptionConn(reqBo, fscPayConfigParent, true);
            }
            if (FscPayConfigType.NO_CREDIT_AGR.getCode().equals(reqBo.getExceptionType())) {
                if (!FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigParent.getPayBusiType())) {
                    throw new PfscExtBusinessException("0001", "\u4ec5[\u5e73\u53f0\u534f\u8bae\u4e1a\u52a1]\u53ef\u914d\u7f6e\u4e0d\u7ba1\u63a7\u534f\u8bae");
                }
                return this.dealNoCreditAgr(reqBo, fscPayConfigParent);
            }
        } else if (FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigParent.getPayConfigType())) {
            if (FscPayConfigType.EXT_AGR.getCode().equals(reqBo.getExceptionType())) {
                if (!FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigParent.getPayBusiType())) {
                    throw new PfscExtBusinessException("0001", "\u4ec5[\u5e73\u53f0\u534f\u8bae\u4e1a\u52a1]\u53ef\u914d\u7f6e\u4f8b\u5916\u534f\u8bae");
                }
                return this.dealExceptionAgr(reqBo, fscPayConfigParent, false);
            }
            if (FscPayConfigType.EXT_CONN.getCode().equals(reqBo.getExceptionType())) {
                if (!FscPayConfigBusiType.EC.getCode().equals(fscPayConfigParent.getPayBusiType()) && !FscPayConfigBusiType.FL.getCode().equals(fscPayConfigParent.getPayBusiType())) {
                    throw new PfscExtBusinessException("0001", "\u4ec5[\u7b2c\u4e09\u65b9\u7535\u5546\u4e1a\u52a1\u3001\u5458\u5de5\u798f\u5229\u4e1a\u52a1]\u53ef\u914d\u7f6e\u4f8b\u5916\u5408\u540c");
                }
                return this.dealExceptionConn(reqBo, fscPayConfigParent, false);
            }
            if (FscPayConfigType.NO_CREDIT_AGR.getCode().equals(reqBo.getExceptionType())) {
                throw new PfscExtBusinessException("0001", "\u4ec5[\u5e73\u53f0\u534f\u8bae\u4e1a\u52a1]\u4e3b\u914d\u7f6e\u53ef\u914d\u7f6e\u4e0d\u7ba1\u63a7\u534f\u8bae");
            }
        } else {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2[parentConfigId]\u503c\u9519\u8bef\uff0c\u53ea\u6709\u4e3b\u914d\u7f6e\u548c\u4f8b\u5916\u5355\u4f4d\u53ef\u4ee5\u914d\u7f6e\u4f8b\u5916");
        }
        throw new PfscExtBusinessException("18000", "\u65b0\u589e\u4f8b\u5916\u5f02\u5e38");
    }

    private FscPayConfigExceptionSaveBusiRspBO dealNoCreditAgr(FscPayConfigExceptionSaveBusiReqBO reqBo, FscPayConfigPO fscPayConfigParent) {
        FscPayConfigExceptionSaveBusiRspBO rspBo = FscRu.success(FscPayConfigExceptionSaveBusiRspBO.class);
        FscPayConfigLogPO payConfigLogPo = this.addPayConfigLog(fscPayConfigParent, reqBo, YesOrNo.NO.getCode(), YesOrNo.NO.getCode(), YesOrNo.NO.getCode(), YesOrNo.NO.getCode(), YesOrNo.YES.getCode());
        for (FscPayConfigExceptionSaveAgrConnInfoBO agrConnInfoBo : reqBo.getAgrConnInfoList()) {
            FscPayConfigPO fscPayConfigExceptionQry = new FscPayConfigPO();
            fscPayConfigExceptionQry.setParentConfigId(fscPayConfigParent.getPayConfigId());
            fscPayConfigExceptionQry.setPayConfigType(FscPayConfigType.NO_CREDIT_AGR.getCode());
            fscPayConfigExceptionQry.setPayBusiType(fscPayConfigParent.getPayBusiType());
            fscPayConfigExceptionQry.setPaySubType(fscPayConfigParent.getPaySubType());
            fscPayConfigExceptionQry.setPaySubClass(fscPayConfigParent.getPaySubClass());
            fscPayConfigExceptionQry.setPayAgrId(agrConnInfoBo.getPayAgrId());
            FscPayConfigPO modelOld = this.fscPayConfigMapper.getModelBy(fscPayConfigExceptionQry);
            FscPayConfigPO modelNewPo = FscRu.js((Object)reqBo, FscPayConfigPO.class);
            modelNewPo.setPayAgrName(agrConnInfoBo.getPayAgrName());
            modelNewPo.setPayAgrNo(agrConnInfoBo.getPayAgrNo());
            modelNewPo.setPayAgrId(agrConnInfoBo.getPayAgrId());
            modelNewPo.setPayAgrEcpNo(agrConnInfoBo.getPayAgrEcpNo());
            modelNewPo.setPayAgrOrgNo(agrConnInfoBo.getPayAgrOrgNo());
            modelNewPo.setPayAgrSupName(agrConnInfoBo.getPayAgrSupName());
            modelNewPo.setPayAgrSupId(agrConnInfoBo.getPayAgrSupId());
            modelNewPo.setPayAgrProName(agrConnInfoBo.getPayAgrProName());
            modelNewPo.setPayAgrProId(agrConnInfoBo.getPayAgrProId());
            modelNewPo.setAgreementType(agrConnInfoBo.getAgreementType());
            modelNewPo.setAgreementTypeStr(agrConnInfoBo.getAgreementTypeStr());
            modelNewPo.setAgreementVariety(agrConnInfoBo.getAgreementVariety());
            modelNewPo.setAgreementVarietyStr(agrConnInfoBo.getAgreementVarietyStr());
            modelNewPo.setPayAgrHandlerId(agrConnInfoBo.getPayAgrHandlerId());
            modelNewPo.setPayAgrHandlerName(agrConnInfoBo.getPayAgrHandlerName());
            modelNewPo.setParentConfigId(fscPayConfigParent.getPayConfigId());
            modelNewPo.setDeleteFlag(YesOrNo.NO.getCode());
            modelNewPo.setPayConfigType(FscPayConfigType.NO_CREDIT_AGR.getCode());
            modelNewPo.setPayConfigMode(fscPayConfigParent.getPayConfigMode());
            modelNewPo.setPayBusiType(fscPayConfigParent.getPayBusiType());
            modelNewPo.setPaySubType(fscPayConfigParent.getPaySubType());
            modelNewPo.setPaySubClass(fscPayConfigParent.getPaySubClass());
            boolean isUpdate = true;
            if (modelOld == null) {
                isUpdate = false;
                modelNewPo.setPayConfigId(Sequence.getInstance().nextId());
                modelNewPo.setParentConfigId(fscPayConfigParent.getPayConfigId());
                modelNewPo.setCreateTime(new Date());
                modelNewPo.setCreateUserId(reqBo.getUserId());
                modelNewPo.setCreateUserName(reqBo.getUsername());
                modelNewPo.setStatus(FscPayConfigStatus.DRAFT.getCode());
                this.fscPayConfigMapper.insert(modelNewPo);
            } else {
                isUpdate = true;
                modelNewPo.setPayConfigId(modelOld.getPayConfigId());
                modelNewPo.setUpdateTime(new Date());
                modelNewPo.setUpdateUserId(reqBo.getUserId());
                modelNewPo.setUpdateUserName(reqBo.getUsername());
                this.fscPayConfigMapper.updateById(modelNewPo);
            }
            this.addExceptionAgrConnLog(payConfigLogPo, modelOld, modelNewPo, false, FscPayConfigType.NO_CREDIT_AGR.getCode());
            FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
            fscPayConfigUpdate.setPayConfigId(fscPayConfigParent.getPayConfigId());
            Integer exceptionNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.NO_CREDIT_AGR.getCode());
            fscPayConfigUpdate.setExceptionAgrNum(exceptionNum);
            if (exceptionNum > 0) {
                fscPayConfigUpdate.setPayAllowExceptionFlag(YesOrNo.YES.getCode());
            }
            fscPayConfigUpdate.setUpdateTime(new Date());
            fscPayConfigUpdate.setUpdateUserId(reqBo.getUserId());
            fscPayConfigUpdate.setUpdateUserName(reqBo.getName());
            this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
            rspBo.setPayConfigId(modelNewPo.getPayConfigId());
            rspBo.setVersionNo(modelNewPo.getVersionNo());
            rspBo.setParentConfigId(modelNewPo.getParentConfigId());
        }
        return rspBo;
    }

    private FscPayConfigExceptionSaveBusiRspBO dealExceptionConn(FscPayConfigExceptionSaveBusiReqBO reqBo, FscPayConfigPO fscPayConfigParent, Boolean isLog) {
        FscPayConfigExceptionSaveBusiRspBO rspBo = FscRu.success(FscPayConfigExceptionSaveBusiRspBO.class);
        FscPayConfigLogPO payConfigLogPo = null;
        if (isLog.booleanValue()) {
            payConfigLogPo = this.addPayConfigLog(fscPayConfigParent, reqBo, YesOrNo.NO.getCode(), YesOrNo.NO.getCode(), YesOrNo.NO.getCode(), YesOrNo.YES.getCode(), YesOrNo.NO.getCode());
        }
        for (FscPayConfigExceptionSaveAgrConnInfoBO agrConnInfoBo : reqBo.getAgrConnInfoList()) {
            FscPayConfigPO fscPayConfigExceptionQry = new FscPayConfigPO();
            fscPayConfigExceptionQry.setParentConfigId(fscPayConfigParent.getPayConfigId());
            fscPayConfigExceptionQry.setPayConfigType(FscPayConfigType.EXT_CONN.getCode());
            fscPayConfigExceptionQry.setPayBusiType(fscPayConfigParent.getPayBusiType());
            fscPayConfigExceptionQry.setPaySubType(fscPayConfigParent.getPaySubType());
            fscPayConfigExceptionQry.setPaySubClass(fscPayConfigParent.getPaySubClass());
            fscPayConfigExceptionQry.setPayContractId(agrConnInfoBo.getPayContractId());
            FscPayConfigPO modelOld = this.fscPayConfigMapper.getModelBy(fscPayConfigExceptionQry);
            FscPayConfigPO modelNewPo = FscRu.js((Object)reqBo, FscPayConfigPO.class);
            modelNewPo.setPayContractName(agrConnInfoBo.getPayContractName());
            modelNewPo.setPayContractNo(agrConnInfoBo.getPayContractNo());
            modelNewPo.setPayContractId(agrConnInfoBo.getPayContractId());
            modelNewPo.setPayContractSignOrgName(agrConnInfoBo.getPayContractSignOrgName());
            modelNewPo.setPayContractSignOrgId(agrConnInfoBo.getPayContractSignOrgId());
            modelNewPo.setParentConfigId(fscPayConfigParent.getPayConfigId());
            modelNewPo.setDeleteFlag(YesOrNo.NO.getCode());
            modelNewPo.setPayConfigType(FscPayConfigType.EXT_CONN.getCode());
            modelNewPo.setPayBusiType(fscPayConfigParent.getPayBusiType());
            modelNewPo.setPaySubType(fscPayConfigParent.getPaySubType());
            modelNewPo.setPaySubClass(fscPayConfigParent.getPaySubClass());
            modelNewPo.setPayConfigMode(fscPayConfigParent.getPayConfigMode());
            boolean isUpdate = true;
            if (modelOld == null) {
                isUpdate = false;
                modelNewPo.setPayConfigId(Sequence.getInstance().nextId());
                modelNewPo.setParentConfigId(fscPayConfigParent.getPayConfigId());
                modelNewPo.setCreateTime(new Date());
                modelNewPo.setCreateUserId(reqBo.getUserId());
                modelNewPo.setCreateUserName(reqBo.getName());
                modelNewPo.setStatus(FscPayConfigStatus.DRAFT.getCode());
                this.fscPayConfigMapper.insert(modelNewPo);
            } else {
                isUpdate = true;
                modelNewPo.setPayConfigId(modelOld.getPayConfigId());
                modelNewPo.setUpdateTime(new Date());
                modelNewPo.setUpdateUserId(reqBo.getUserId());
                modelNewPo.setUpdateUserName(reqBo.getName());
                this.fscPayConfigMapper.updateById(modelNewPo);
            }
            if (isLog.booleanValue()) {
                this.addExceptionAgrConnLog(payConfigLogPo, modelOld, modelNewPo, false, FscPayConfigType.EXT_CONN.getCode());
            }
            FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
            fscPayConfigUpdate.setPayConfigId(fscPayConfigParent.getPayConfigId());
            Integer exceptionNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.EXT_CONN.getCode());
            fscPayConfigUpdate.setExceptionConnNum(exceptionNum);
            if (exceptionNum > 0) {
                fscPayConfigUpdate.setPayAllowExceptionFlag(YesOrNo.YES.getCode());
            }
            fscPayConfigUpdate.setUpdateTime(new Date());
            fscPayConfigUpdate.setUpdateUserId(reqBo.getUserId());
            fscPayConfigUpdate.setUpdateUserName(reqBo.getName());
            this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
            rspBo.setPayConfigId(modelNewPo.getPayConfigId());
            rspBo.setVersionNo(modelNewPo.getVersionNo());
            rspBo.setParentConfigId(modelNewPo.getParentConfigId());
        }
        return rspBo;
    }

    private FscPayConfigExceptionSaveBusiRspBO dealExceptionAgr(FscPayConfigExceptionSaveBusiReqBO reqBo, FscPayConfigPO fscPayConfigParent, Boolean isLog) {
        FscPayConfigExceptionSaveBusiRspBO rspBo = FscRu.success(FscPayConfigExceptionSaveBusiRspBO.class);
        FscPayConfigLogPO payConfigLogPo = null;
        if (isLog.booleanValue()) {
            payConfigLogPo = this.addPayConfigLog(fscPayConfigParent, reqBo, YesOrNo.NO.getCode(), YesOrNo.NO.getCode(), YesOrNo.YES.getCode(), YesOrNo.NO.getCode(), YesOrNo.NO.getCode());
        }
        for (FscPayConfigExceptionSaveAgrConnInfoBO agrConnInfoBo : reqBo.getAgrConnInfoList()) {
            FscPayConfigPO fscPayConfigExceptionQry = new FscPayConfigPO();
            fscPayConfigExceptionQry.setParentConfigId(fscPayConfigParent.getPayConfigId());
            fscPayConfigExceptionQry.setPayConfigType(FscPayConfigType.EXT_AGR.getCode());
            fscPayConfigExceptionQry.setPayBusiType(fscPayConfigParent.getPayBusiType());
            fscPayConfigExceptionQry.setPaySubType(fscPayConfigParent.getPaySubType());
            fscPayConfigExceptionQry.setPaySubClass(fscPayConfigParent.getPaySubClass());
            fscPayConfigExceptionQry.setPayAgrId(agrConnInfoBo.getPayAgrId());
            FscPayConfigPO modelOld = this.fscPayConfigMapper.getModelBy(fscPayConfigExceptionQry);
            FscPayConfigPO modelNewPo = FscRu.js((Object)reqBo, FscPayConfigPO.class);
            modelNewPo.setPayAgrName(agrConnInfoBo.getPayAgrName());
            modelNewPo.setPayAgrNo(agrConnInfoBo.getPayAgrNo());
            modelNewPo.setPayAgrId(agrConnInfoBo.getPayAgrId());
            modelNewPo.setPayAgrEcpNo(agrConnInfoBo.getPayAgrEcpNo());
            modelNewPo.setPayAgrOrgNo(agrConnInfoBo.getPayAgrOrgNo());
            modelNewPo.setPayAgrSupName(agrConnInfoBo.getPayAgrSupName());
            modelNewPo.setPayAgrSupId(agrConnInfoBo.getPayAgrSupId());
            modelNewPo.setPayAgrProName(agrConnInfoBo.getPayAgrProName());
            modelNewPo.setPayAgrProId(agrConnInfoBo.getPayAgrProId());
            modelNewPo.setAgreementType(agrConnInfoBo.getAgreementType());
            modelNewPo.setAgreementTypeStr(agrConnInfoBo.getAgreementTypeStr());
            modelNewPo.setAgreementVariety(agrConnInfoBo.getAgreementVariety());
            modelNewPo.setAgreementVarietyStr(agrConnInfoBo.getAgreementVarietyStr());
            modelNewPo.setParentConfigId(fscPayConfigParent.getPayConfigId());
            modelNewPo.setDeleteFlag(YesOrNo.NO.getCode());
            modelNewPo.setPayConfigType(FscPayConfigType.EXT_AGR.getCode());
            modelNewPo.setPayConfigMode(fscPayConfigParent.getPayConfigMode());
            modelNewPo.setPayBusiType(fscPayConfigParent.getPayBusiType());
            modelNewPo.setPaySubType(fscPayConfigParent.getPaySubType());
            modelNewPo.setPaySubClass(fscPayConfigParent.getPaySubClass());
            boolean isUpdate = true;
            if (modelOld == null) {
                isUpdate = false;
                modelNewPo.setPayConfigId(Sequence.getInstance().nextId());
                modelNewPo.setParentConfigId(fscPayConfigParent.getPayConfigId());
                modelNewPo.setCreateTime(new Date());
                modelNewPo.setCreateUserId(reqBo.getUserId());
                modelNewPo.setCreateUserName(reqBo.getUsername());
                modelNewPo.setStatus(FscPayConfigStatus.DRAFT.getCode());
                this.fscPayConfigMapper.insert(modelNewPo);
            } else {
                isUpdate = true;
                modelNewPo.setPayConfigId(modelOld.getPayConfigId());
                modelNewPo.setUpdateTime(new Date());
                modelNewPo.setUpdateUserId(reqBo.getUserId());
                modelNewPo.setUpdateUserName(reqBo.getUsername());
                this.fscPayConfigMapper.updateById(modelNewPo);
            }
            if (isLog.booleanValue()) {
                this.addExceptionAgrConnLog(payConfigLogPo, modelOld, modelNewPo, false, FscPayConfigType.EXT_AGR.getCode());
            }
            FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
            fscPayConfigUpdate.setPayConfigId(fscPayConfigParent.getPayConfigId());
            Integer exceptionNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.EXT_AGR.getCode());
            fscPayConfigUpdate.setExceptionAgrNum(exceptionNum);
            if (exceptionNum > 0) {
                fscPayConfigUpdate.setPayAllowExceptionFlag(YesOrNo.YES.getCode());
            }
            fscPayConfigUpdate.setUpdateTime(new Date());
            fscPayConfigUpdate.setUpdateUserId(reqBo.getUserId());
            fscPayConfigUpdate.setUpdateUserName(reqBo.getName());
            this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
            rspBo.setPayConfigId(modelNewPo.getPayConfigId());
            rspBo.setVersionNo(modelNewPo.getVersionNo());
            rspBo.setParentConfigId(modelNewPo.getParentConfigId());
        }
        return rspBo;
    }

    private Integer getExceptionNum(Long payConfigId, String payConfigType) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setParentConfigId(payConfigId);
        fscPayConfigQry.setPayConfigType(payConfigType);
        int checkBy = this.fscPayConfigMapper.getCheckBy(fscPayConfigQry);
        return checkBy;
    }

    private FscPayConfigExceptionSaveBusiRspBO dealExceptionCompany(FscPayConfigExceptionSaveBusiReqBO reqBo, FscPayConfigPO fscPayConfigParent) {
        FscPayConfigExceptionSaveBusiRspBO rspBo = FscRu.success(FscPayConfigExceptionSaveBusiRspBO.class);
        FscPayConfigLogPO payConfigLogPo = this.addPayConfigLog(fscPayConfigParent, reqBo, YesOrNo.NO.getCode(), YesOrNo.YES.getCode(), YesOrNo.NO.getCode(), YesOrNo.NO.getCode(), YesOrNo.NO.getCode());
        for (FscPayConfigExceptionSaveOrgInfoBO orgInfoBo : reqBo.getOrgInfoList()) {
            FscPayConfigPO fscPayConfigExceptionQry = new FscPayConfigPO();
            fscPayConfigExceptionQry.setParentConfigId(fscPayConfigParent.getPayConfigId());
            fscPayConfigExceptionQry.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
            fscPayConfigExceptionQry.setPayBusiType(fscPayConfigParent.getPayBusiType());
            fscPayConfigExceptionQry.setPaySubType(fscPayConfigParent.getPaySubType());
            fscPayConfigExceptionQry.setPaySubClass(fscPayConfigParent.getPaySubClass());
            fscPayConfigExceptionQry.setPayOrgId(orgInfoBo.getPayOrgId());
            fscPayConfigExceptionQry.setPayUserId(orgInfoBo.getPayUserId());
            FscPayConfigPO modelOld = this.fscPayConfigMapper.getModelBy(fscPayConfigExceptionQry);
            boolean isUpdate = false;
            if (modelOld != null) {
                isUpdate = true;
                if (YesOrNo.NO.getCode().equals(modelOld.getDeleteFlag())) {
                    throw new PfscExtBusinessException("18000", "\u65b0\u589e\u4f8b\u5916\u5355\u4f4d\u5931\u8d25\uff0c\u4f8b\u5916\u5355\u4f4d[" + orgInfoBo.getPayOrgName() + "]\u5df2\u5b58\u5728");
                }
            } else {
                fscPayConfigExceptionQry.setPayConfigType(FscPayConfigType.DEF.getCode());
                fscPayConfigExceptionQry.setDeleteFlag(null);
                modelOld = this.fscPayConfigMapper.getModelBy(fscPayConfigExceptionQry);
                isUpdate = true;
                if (modelOld == null) {
                    isUpdate = false;
                }
            }
            FscPayConfigPO modelNewPo = FscRu.js((Object)reqBo, FscPayConfigPO.class);
            BeanUtils.copyProperties((Object)orgInfoBo, (Object)modelNewPo);
            modelNewPo.setParentConfigId(fscPayConfigParent.getPayConfigId());
            modelNewPo.setVersionNo(fscPayConfigParent.getVersionNo());
            modelNewPo.setDeleteFlag(YesOrNo.NO.getCode());
            modelNewPo.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
            if (FscPayConfigPayType.ZQ.getCode().equals(reqBo.getPayType())) {
                modelNewPo.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
            } else {
                modelNewPo.setPayUsedPeriodFlag(isUpdate ? modelOld.getPayUsedPeriodFlag() : fscPayConfigParent.getPayUsedPeriodFlag());
            }
            if (isUpdate) {
                modelNewPo.setPayConfigId(modelOld.getPayConfigId());
                modelNewPo.setPayAllowExceptionFlag(modelOld.getPayAllowExceptionFlag());
                BigDecimal creditAmount = Optional.ofNullable(reqBo.getCreditAmount()).orElse(Optional.ofNullable(modelOld.getCreditAmount()).orElse(BigDecimal.ZERO));
                modelNewPo.setCreditAmount(creditAmount);
                modelNewPo.setUsedAmount(Optional.ofNullable(modelOld.getUsedAmount()).orElse(BigDecimal.ZERO));
                modelNewPo.setBalanceAmount(modelNewPo.getCreditAmount().subtract(modelNewPo.getUsedAmount()));
                modelNewPo.setCurrentOrgControlStatus(modelOld.getCurrentOrgControlStatus());
                modelNewPo.setUpdateTime(new Date());
                modelNewPo.setUpdateUserId(reqBo.getUserId());
                modelNewPo.setUpdateUserName(reqBo.getUsername());
                this.fscPayConfigMapper.updateById(modelNewPo);
            } else {
                modelNewPo.setPayConfigId(Sequence.getInstance().nextId());
                modelNewPo.setPayAllowExceptionFlag(YesOrNo.NO.getCode());
                modelNewPo.setCreditAmount(Optional.ofNullable(reqBo.getCreditAmount()).orElse(BigDecimal.ZERO));
                modelNewPo.setUsedAmount(BigDecimal.ZERO);
                modelNewPo.setBalanceAmount(modelNewPo.getCreditAmount());
                modelNewPo.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
                modelNewPo.setCreateTime(new Date());
                modelNewPo.setCreateUserId(reqBo.getUserId());
                modelNewPo.setCreateUserName(reqBo.getUsername());
                modelNewPo.setStatus(FscPayConfigStatus.DRAFT.getCode());
                this.fscPayConfigMapper.insert(modelNewPo);
            }
            if (YesOrNo.YES.getCode().equals(modelNewPo.getPayUsedPeriodFlag())) {
                FscCreditControlBusiReqBO fscCreditControlBusiReqBo = new FscCreditControlBusiReqBO();
                fscCreditControlBusiReqBo.setPayConfigId(modelNewPo.getPayConfigId());
                FscCreditControlBusiRspBO fscCreditControlBusiRspBo = this.fscCreditControlBusiService.dealCreditControl(fscCreditControlBusiReqBo);
                if (FscRu.isFailed(fscCreditControlBusiRspBo.getRespCode()).booleanValue()) {
                    log.error("\u66f4\u65b0\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001\u5f02\u5e38\uff1a" + fscCreditControlBusiRspBo.getRespDesc());
                }
            }
            ArrayList<FscPayConfigChannelPO> oldPayConfigChannels = new ArrayList<FscPayConfigChannelPO>();
            if (isUpdate) {
                FscPayConfigChannelPO fscPayConfigChannelQry = new FscPayConfigChannelPO();
                fscPayConfigChannelQry.setPayConfigId(modelNewPo.getPayConfigId());
                fscPayConfigChannelQry.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
                List<FscPayConfigChannelPO> list = this.fscPayConfigChannelMapper.getList(fscPayConfigChannelQry);
                if (!CollectionUtils.isEmpty(list)) {
                    oldPayConfigChannels.addAll(list);
                }
                this.fscPayConfigChannelMapper.deleteBy(fscPayConfigChannelQry);
            }
            List<FscPayConfigChannelPO> payConfigChannels = this.addPayConfigChannels(reqBo.getPayConfigChannels(), modelNewPo.getPayConfigId(), FscPayConfigType.EXT_ORG.getCode());
            FscPayConfigPO fscPayConfigParentUpdate = new FscPayConfigPO();
            fscPayConfigParentUpdate.setPayConfigId(fscPayConfigParent.getPayConfigId());
            Integer exceptionNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.EXT_ORG.getCode());
            fscPayConfigParentUpdate.setExceptionOrgNum(exceptionNum);
            if (exceptionNum > 0) {
                fscPayConfigParentUpdate.setPayAllowExceptionFlag(YesOrNo.YES.getCode());
            }
            fscPayConfigParentUpdate.setUpdateTime(new Date());
            fscPayConfigParentUpdate.setUpdateUserId(reqBo.getUserId());
            fscPayConfigParentUpdate.setUpdateUserName(reqBo.getName());
            this.fscPayConfigMapper.updateById(fscPayConfigParentUpdate);
            this.addExceptionCompanyLog(payConfigLogPo, modelOld, modelNewPo, oldPayConfigChannels, payConfigChannels, false);
            rspBo.setPayConfigId(modelNewPo.getPayConfigId());
            rspBo.setVersionNo(modelNewPo.getVersionNo());
            rspBo.setParentConfigId(modelNewPo.getParentConfigId());
        }
        return rspBo;
    }

    private FscPayConfigLogPO addPayConfigLog(FscPayConfigPO fscPayConfigParent, FscPayConfigExceptionSaveBusiReqBO reqBo, Integer exceptionMain, Integer exceptionOrg, Integer exceptionAgr, Integer exceptionConn, Integer noControlAgr) {
        FscPayConfigLogPO fscPayConfigLogPo = new FscPayConfigLogPO();
        fscPayConfigLogPo.setPayLogId(Sequence.getInstance().nextId());
        fscPayConfigLogPo.setVersionNo(fscPayConfigParent.getVersionNo());
        fscPayConfigLogPo.setPayLogFlag("1");
        fscPayConfigLogPo.setPayBusiType(fscPayConfigParent.getPayBusiType());
        fscPayConfigLogPo.setPaySubClass(fscPayConfigParent.getPaySubClass());
        fscPayConfigLogPo.setPaySubType(fscPayConfigParent.getPaySubType());
        fscPayConfigLogPo.setPayConfigMode(fscPayConfigParent.getPayConfigMode());
        fscPayConfigLogPo.setExceptionMain(exceptionMain);
        fscPayConfigLogPo.setExceptionOrg(exceptionOrg);
        fscPayConfigLogPo.setExceptionAgr(exceptionAgr);
        fscPayConfigLogPo.setExceptionConn(exceptionConn);
        fscPayConfigLogPo.setNoControlAgr(noControlAgr);
        fscPayConfigLogPo.setCreateTime(new Date());
        fscPayConfigLogPo.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogPo.setCreateUserName(reqBo.getName());
        this.fscPayConfigLogMapper.insert(fscPayConfigLogPo);
        return fscPayConfigLogPo;
    }

    private void addExceptionCompanyLog(FscPayConfigLogPO payConfigLog, FscPayConfigPO modelOld, FscPayConfigPO modelNewPo, List<FscPayConfigChannelPO> oldPayConfigChannels, List<FscPayConfigChannelPO> payConfigChannels, boolean isUpdate) {
        FscPayConfigHisPO fscPayConfigHisBeforePo = new FscPayConfigHisPO();
        FscPayConfigHisPO fscPayConfigHisAfterPo = new FscPayConfigHisPO();
        if (isUpdate) {
            this.initFscPayConfigHisPo(modelOld, fscPayConfigHisBeforePo);
            fscPayConfigHisBeforePo.setPayConfigHisId(Sequence.getInstance().nextId());
            fscPayConfigHisBeforePo.setPayLogId(payConfigLog.getPayLogId());
            fscPayConfigHisBeforePo.setPayLogFlag("4");
            this.fscPayConfigHisMapper.insert(fscPayConfigHisBeforePo);
            if (!CollectionUtils.isEmpty(oldPayConfigChannels)) {
                ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
                for (FscPayConfigChannelPO payConfigChannel : oldPayConfigChannels) {
                    FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                    his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                    his.setPayConfigHisId(fscPayConfigHisBeforePo.getPayConfigHisId());
                    his.setPayConfigChannelId(payConfigChannel.getPayConfigChannelId());
                    his.setPayConfigId(payConfigChannel.getPayConfigId());
                    his.setPayConfigType(payConfigChannel.getPayConfigType());
                    his.setPayChannels(payConfigChannel.getPayChannels());
                    his.setPayMethod(payConfigChannel.getPayMethod());
                    his.setCreateTime(payConfigChannel.getCreateTime());
                    his.setRemark(payConfigChannel.getRemark());
                    his.setHisCreateTime(new Date());
                    his.setHisCreateUserId(payConfigLog.getCreateUserId());
                    his.setHisCreateUserName(payConfigLog.getCreateUserName());
                    channelHisList.add(his);
                }
                this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
            }
        }
        FscPayConfigPO fscPayConfigNew = new FscPayConfigPO();
        fscPayConfigNew.setPayConfigId(modelNewPo.getPayConfigId());
        fscPayConfigNew = this.fscPayConfigMapper.getModelBy(fscPayConfigNew);
        this.initFscPayConfigHisPo(fscPayConfigNew, fscPayConfigHisAfterPo);
        fscPayConfigHisAfterPo.setPayConfigHisId(Sequence.getInstance().nextId());
        fscPayConfigHisAfterPo.setPayLogId(payConfigLog.getPayLogId());
        if (isUpdate) {
            fscPayConfigHisAfterPo.setPayLogFlag("5");
        } else {
            fscPayConfigHisAfterPo.setPayLogFlag("1");
        }
        this.fscPayConfigHisMapper.insert(fscPayConfigHisAfterPo);
        if (!CollectionUtils.isEmpty(payConfigChannels)) {
            ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
            for (FscPayConfigChannelPO payConfigChannel : payConfigChannels) {
                FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                his.setPayConfigHisId(fscPayConfigHisAfterPo.getPayConfigHisId());
                his.setPayConfigChannelId(payConfigChannel.getPayConfigChannelId());
                his.setPayConfigId(payConfigChannel.getPayConfigId());
                his.setPayConfigType(payConfigChannel.getPayConfigType());
                his.setPayChannels(payConfigChannel.getPayChannels());
                his.setPayMethod(payConfigChannel.getPayMethod());
                his.setCreateTime(payConfigChannel.getCreateTime());
                his.setRemark(payConfigChannel.getRemark());
                his.setHisCreateTime(new Date());
                his.setHisCreateUserId(payConfigLog.getCreateUserId());
                his.setHisCreateUserName(payConfigLog.getCreateUserName());
                channelHisList.add(his);
            }
            this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
        }
        FscPayConfigLogDetailPO fscPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
        fscPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
        fscPayConfigLogDetailInsert.setPayLogId(payConfigLog.getPayLogId());
        if (isUpdate) {
            fscPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.EDIT.getCode());
        } else {
            fscPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.ADD.getCode());
        }
        fscPayConfigLogDetailInsert.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
        fscPayConfigLogDetailInsert.setPayConfigHisOldId(fscPayConfigHisBeforePo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setPayConfigHisNewId(fscPayConfigHisAfterPo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setCreateTime(new Date());
        fscPayConfigLogDetailInsert.setCreateUserId(payConfigLog.getCreateUserId());
        fscPayConfigLogDetailInsert.setCreateUserName(payConfigLog.getCreateUserName());
        this.fscPayConfigLogDetailMapper.insert(fscPayConfigLogDetailInsert);
    }

    private List<FscPayConfigChannelPO> addPayConfigChannels(List<FscPayConfigChannelBO> payConfigChannels, Long payConfigId, String payConfigType) {
        ArrayList<FscPayConfigChannelPO> payConfigChannelPos = new ArrayList<FscPayConfigChannelPO>();
        if (!CollectionUtils.isEmpty(payConfigChannels)) {
            for (FscPayConfigChannelBO channelBo : payConfigChannels) {
                FscPayConfigChannelPO po = new FscPayConfigChannelPO();
                po.setPayConfigChannelId(Sequence.getInstance().nextId());
                po.setPayConfigId(payConfigId);
                po.setPayConfigType(payConfigType);
                po.setPayChannels(channelBo.getPayChannels());
                po.setPayMethod(channelBo.getPayMethod());
                po.setCreateTime(new Date());
                po.setRemark(channelBo.getRemark());
                payConfigChannelPos.add(po);
            }
            this.fscPayConfigChannelMapper.insertBatch(payConfigChannelPos);
        }
        return payConfigChannelPos;
    }

    private void addExceptionAgrConnLog(FscPayConfigLogPO payConfigLog, FscPayConfigPO modelOld, FscPayConfigPO modelNewPo, boolean isUpdate, String payConfigType) {
        FscPayConfigHisPO fscPayConfigHisBeforePo = new FscPayConfigHisPO();
        FscPayConfigHisPO fscPayConfigHisAfterPo = new FscPayConfigHisPO();
        if (isUpdate) {
            this.initFscPayConfigHisPo(modelOld, fscPayConfigHisBeforePo);
            fscPayConfigHisBeforePo.setPayConfigHisId(Sequence.getInstance().nextId());
            fscPayConfigHisBeforePo.setPayLogId(payConfigLog.getPayLogId());
            fscPayConfigHisBeforePo.setPayLogFlag("4");
            this.fscPayConfigHisMapper.insert(fscPayConfigHisBeforePo);
        }
        FscPayConfigPO fscPayConfigNew = new FscPayConfigPO();
        fscPayConfigNew.setPayConfigId(modelNewPo.getPayConfigId());
        fscPayConfigNew = this.fscPayConfigMapper.getModelBy(fscPayConfigNew);
        this.initFscPayConfigHisPo(fscPayConfigNew, fscPayConfigHisAfterPo);
        fscPayConfigHisAfterPo.setPayConfigHisId(Sequence.getInstance().nextId());
        fscPayConfigHisAfterPo.setPayLogId(payConfigLog.getPayLogId());
        if (isUpdate) {
            fscPayConfigHisAfterPo.setPayLogFlag("5");
        } else {
            fscPayConfigHisAfterPo.setPayLogFlag("1");
        }
        this.fscPayConfigHisMapper.insert(fscPayConfigHisAfterPo);
        FscPayConfigLogDetailPO fscPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
        fscPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
        fscPayConfigLogDetailInsert.setPayLogId(payConfigLog.getPayLogId());
        if (isUpdate) {
            fscPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.EDIT_AF.getCode());
        } else {
            fscPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.ADD.getCode());
        }
        fscPayConfigLogDetailInsert.setPayConfigType(payConfigType);
        fscPayConfigLogDetailInsert.setPayConfigHisOldId(fscPayConfigHisBeforePo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setPayConfigHisNewId(fscPayConfigHisAfterPo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setCreateTime(new Date());
        fscPayConfigLogDetailInsert.setCreateUserId(payConfigLog.getCreateUserId());
        fscPayConfigLogDetailInsert.setCreateUserName(payConfigLog.getCreateUserName());
        this.fscPayConfigLogDetailMapper.insert(fscPayConfigLogDetailInsert);
    }

    private void initFscPayConfigHisPo(FscPayConfigPO sourcePo, FscPayConfigHisPO targetPo) {
        targetPo.setPayConfigId(sourcePo.getPayConfigId());
        targetPo.setParentConfigId(sourcePo.getParentConfigId());
        targetPo.setVersionNo(sourcePo.getVersionNo());
        targetPo.setPayBusiType(sourcePo.getPayBusiType());
        targetPo.setPaySubClass(sourcePo.getPaySubClass());
        targetPo.setPaySubType(sourcePo.getPaySubType());
        targetPo.setPayConfigMode(sourcePo.getPayConfigMode());
        targetPo.setPayConfigType(sourcePo.getPayConfigType());
        targetPo.setPayUsedPeriodFlag(sourcePo.getPayUsedPeriodFlag());
        targetPo.setPayAllowExceptionFlag(sourcePo.getPayAllowExceptionFlag());
        targetPo.setExceptionOrgNum(sourcePo.getExceptionOrgNum());
        targetPo.setExceptionAgrNum(sourcePo.getExceptionAgrNum());
        targetPo.setExceptionConnNum(sourcePo.getExceptionConnNum());
        targetPo.setPayType(sourcePo.getPayType());
        if (FscPayConfigPayType.YF_RATIO.getCode().equals(sourcePo.getPayType())) {
            targetPo.setDownPaymentRatio(sourcePo.getDownPaymentRatio());
            targetPo.setCheckPaymentRatio(sourcePo.getCheckPaymentRatio());
        }
        if (FscPayConfigPayType.XY.getCode().equals(sourcePo.getPayType()) || FscPayConfigPayType.ZQ.getCode().equals(sourcePo.getPayType())) {
            if (!FscPayConfigBusiType.AGR_DW.getCode().equals(sourcePo.getPayBusiType())) {
                targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
                targetPo.setPaymentDays(sourcePo.getPaymentDays());
                targetPo.setDelayDays(sourcePo.getDelayDays());
            }
            targetPo.setCreditAmount(sourcePo.getCreditAmount());
            targetPo.setUsedAmount(sourcePo.getUsedAmount());
            targetPo.setBalanceAmount(sourcePo.getBalanceAmount());
            targetPo.setUsedWarningAmount(sourcePo.getUsedWarningAmount());
            targetPo.setOverdueStartAmount(sourcePo.getOverdueStartAmount());
            targetPo.setOverdueWarningRatio(sourcePo.getOverdueWarningRatio());
            targetPo.setOverdueControlRatio(sourcePo.getOverdueControlRatio());
            targetPo.setOverdueRecoveryRatio(sourcePo.getOverdueRecoveryRatio());
            targetPo.setOverdueIndexRatio(sourcePo.getOverdueIndexRatio());
            targetPo.setOverdueWarningIndex(sourcePo.getOverdueWarningIndex());
            targetPo.setOverdueControlIndex(sourcePo.getOverdueControlIndex());
            targetPo.setOverdueRecoveryIndex(sourcePo.getOverdueRecoveryIndex());
            targetPo.setCurrentOrgControlStatus(sourcePo.getCurrentOrgControlStatus());
            targetPo.setCurrentOrgControlTag(sourcePo.getCurrentOrgControlTag());
            targetPo.setCurrentOrgWarningTag(sourcePo.getCurrentOrgWarningTag());
            targetPo.setCurrentOverdueRatio(sourcePo.getCurrentOverdueRatio());
            targetPo.setCurrentOverdueAmount(sourcePo.getCurrentOverdueAmount());
            targetPo.setCurrentPenaltyAmount(sourcePo.getCurrentPenaltyAmount());
            targetPo.setCurrentOverdueIndex(sourcePo.getCurrentOverdueIndex());
        }
        if (FscPayConfigType.EXT_ORG.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayOrgId(sourcePo.getPayOrgId());
            targetPo.setPayOrgName(sourcePo.getPayOrgName());
            targetPo.setPayOrgPath(sourcePo.getPayOrgPath());
            targetPo.setPayUserId(sourcePo.getPayUserId());
            targetPo.setPayUserName(sourcePo.getPayUserName());
        }
        if (FscPayConfigType.EXT_AGR.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayAgrName(sourcePo.getPayAgrName());
            targetPo.setPayAgrNo(sourcePo.getPayAgrNo());
            targetPo.setPayAgrId(sourcePo.getPayAgrId());
            targetPo.setPayAgrEcpNo(sourcePo.getPayAgrEcpNo());
            targetPo.setPayAgrOrgNo(sourcePo.getPayAgrOrgNo());
            targetPo.setPayAgrSupName(sourcePo.getPayAgrSupName());
            targetPo.setPayAgrSupId(sourcePo.getPayAgrSupId());
            targetPo.setPayAgrProName(sourcePo.getPayAgrProName());
            targetPo.setPayAgrProId(sourcePo.getPayAgrProId());
            targetPo.setAgreementType(sourcePo.getAgreementType());
            targetPo.setAgreementTypeStr(sourcePo.getAgreementTypeStr());
            targetPo.setAgreementVariety(sourcePo.getAgreementVariety());
            targetPo.setAgreementVarietyStr(sourcePo.getAgreementVarietyStr());
        }
        if (FscPayConfigType.EXT_CONN.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayContractName(sourcePo.getPayContractName());
            targetPo.setPayContractNo(sourcePo.getPayContractNo());
            targetPo.setPayContractId(sourcePo.getPayContractId());
            targetPo.setPayContractSignOrgId(sourcePo.getPayContractSignOrgId());
            targetPo.setPayContractSignOrgName(sourcePo.getPayContractSignOrgName());
        }
        if (FscPayConfigType.NO_CREDIT_AGR.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayAgrName(sourcePo.getPayAgrName());
            targetPo.setPayAgrNo(sourcePo.getPayAgrNo());
            targetPo.setPayAgrId(sourcePo.getPayAgrId());
            targetPo.setPayAgrEcpNo(sourcePo.getPayAgrEcpNo());
            targetPo.setPayAgrOrgNo(sourcePo.getPayAgrOrgNo());
            targetPo.setPayAgrSupName(sourcePo.getPayAgrSupName());
            targetPo.setPayAgrSupId(sourcePo.getPayAgrSupId());
            targetPo.setPayAgrProName(sourcePo.getPayAgrProName());
            targetPo.setPayAgrProId(sourcePo.getPayAgrProId());
            targetPo.setAgreementType(sourcePo.getAgreementType());
            targetPo.setAgreementTypeStr(sourcePo.getAgreementTypeStr());
            targetPo.setAgreementVariety(sourcePo.getAgreementVariety());
            targetPo.setAgreementVarietyStr(sourcePo.getAgreementVarietyStr());
            targetPo.setPayAgrHandlerId(sourcePo.getPayAgrHandlerId());
            targetPo.setPayAgrHandlerName(sourcePo.getPayAgrHandlerName());
        }
        targetPo.setCreateTime(sourcePo.getCreateTime());
        targetPo.setCreateUserId(sourcePo.getCreateUserId());
        targetPo.setCreateUserName(sourcePo.getCreateUserName());
        targetPo.setUpdateTime(sourcePo.getUpdateTime());
        targetPo.setUpdateUserId(sourcePo.getUpdateUserId());
        targetPo.setUpdateUserName(sourcePo.getUpdateUserName());
        targetPo.setRemark(sourcePo.getRemark());
        targetPo.setStatus(sourcePo.getStatus());
        targetPo.setDeleteFlag(sourcePo.getDeleteFlag());
    }
}

