/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.bo.FscPayConfigPayMethodBO;
import com.tydic.pfscext.api.busi.FscPayConfigExtOrgSaveImportBusiService;
import com.tydic.pfscext.api.busi.bo.FscPayConfigExtOrgSaveImportBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayConfigExtOrgSaveImportBusiRspBO;
import com.tydic.pfscext.dao.DicDictionaryMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelHisMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigHisMapper;
import com.tydic.pfscext.dao.FscPayConfigImportTempMapper;
import com.tydic.pfscext.dao.FscPayConfigLogDetailMapper;
import com.tydic.pfscext.dao.FscPayConfigLogMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.bo.DicDictionaryPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigImportTempPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogDetailPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigPayNodeRule;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FscPayConfigExtOrgSaveImportBusiServiceImpl
implements FscPayConfigExtOrgSaveImportBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigExtOrgSaveImportBusiServiceImpl.class);
    @Resource
    private FscPayConfigImportTempMapper fscPayConfigImportTempMapper;
    @Resource
    private FscPayConfigMapper fscPayConfigMapper;
    @Resource
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;
    @Resource
    private FscPayConfigLogMapper fscPayConfigLogMapper;
    @Resource
    private FscPayConfigHisMapper fscPayConfigHisMapper;
    @Resource
    private FscPayConfigChannelHisMapper fscPayConfigChannelHisMapper;
    @Resource
    private FscPayConfigLogDetailMapper fscPayConfigLogDetailMapper;
    @Resource
    private DicDictionaryMapper dicDictionaryMapper;
    @Resource
    private FscCreditControlBusiService fscCreditControlBusiService;
    private final Integer YES = 1;
    private final Integer NO = 0;

    public FscPayConfigExtOrgSaveImportBusiRspBO dealPayConfigExtOrgSaveImport(FscPayConfigExtOrgSaveImportBusiReqBO reqBo) {
        FscPayConfigPO fscPayConfigMain = new FscPayConfigPO();
        fscPayConfigMain.setPayConfigId(reqBo.getParentConfigId());
        fscPayConfigMain = this.fscPayConfigMapper.getModelBy(fscPayConfigMain);
        ValUtil.isEmpty(fscPayConfigMain).exception("\u7236\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
        if (FscPayConfigStatus.UPDATING.getCode().equals(fscPayConfigMain.getStatus())) {
            throw new PfscExtBusinessException("18000", "\u5f53\u524d\u4e3b\u652f\u4ed8\u914d\u7f6e\u6b63\u5728\u4fee\u6539\u4e2d\uff0c\u8bf7\u7a0d\u540e\u64cd\u4f5c\u6279\u91cf\u8c03\u6574\u4f8b\u5916\u5355\u4f4d");
        }
        if (!FscPayConfigType.MAIN.getCode().equals(fscPayConfigMain.getPayConfigType())) {
            throw new PfscExtBusinessException("18000", "\u4f8b\u5916\u5355\u4f4d\u5bfc\u5165\u5931\u8d25\uff0c\u7236\u652f\u4ed8\u914d\u7f6e\u4e0d\u662f\u4e3b\u914d\u7f6e");
        }
        Map<String, FscPayConfigPayMethodBO> payMethod = this.mapPayMethod();
        Long idGreaterThan = 0L;
        FscPayConfigImportTempPO fscPayConfigImportTempQry = new FscPayConfigImportTempPO();
        fscPayConfigImportTempQry.setParentConfigId(reqBo.getParentConfigId());
        fscPayConfigImportTempQry.setImpType(reqBo.getImpType());
        fscPayConfigImportTempQry.setImpId(reqBo.getImpId());
        fscPayConfigImportTempQry.setPayConfigIdIsNull(this.YES.toString());
        fscPayConfigImportTempQry.setLimitSize(500);
        fscPayConfigImportTempQry.setOrderBy(" ID ASC ");
        fscPayConfigImportTempQry.setIdGreaterThan(idGreaterThan);
        List<FscPayConfigImportTempPO> tempPos = this.fscPayConfigImportTempMapper.getList(fscPayConfigImportTempQry);
        int index = 0;
        Long payLogId = Sequence.getInstance().nextId();
        Date nowTime = new Date();
        ArrayList<Long> newPayConfigIdList = new ArrayList<Long>();
        while (CollUtil.isNotEmpty(tempPos) && index++ < 10000) {
            idGreaterThan = tempPos.stream().map(FscPayConfigImportTempPO::getId).max(Long::compare).orElse(Long.MAX_VALUE);
            if (index == 1) {
                this.insertPayConfigLogPo(payLogId, fscPayConfigMain, nowTime, reqBo.getUserId(), reqBo.getName());
            }
            for (FscPayConfigImportTempPO tempPo : tempPos) {
                Long payConfigId;
                Object fscPayConfigOldPo = new FscPayConfigPO();
                ((FscPayConfigPO)fscPayConfigOldPo).setParentConfigId(fscPayConfigMain.getPayConfigId());
                ((FscPayConfigPO)fscPayConfigOldPo).setPayBusiType(fscPayConfigMain.getPayBusiType());
                ((FscPayConfigPO)fscPayConfigOldPo).setPaySubType(fscPayConfigMain.getPaySubType());
                ((FscPayConfigPO)fscPayConfigOldPo).setPaySubClass(fscPayConfigMain.getPaySubClass());
                ((FscPayConfigPO)fscPayConfigOldPo).setPayOrgId(tempPo.getCompanyId());
                fscPayConfigOldPo = this.fscPayConfigMapper.getModelBy((FscPayConfigPO)fscPayConfigOldPo);
                if (fscPayConfigOldPo == null) {
                    payConfigId = this.insertDefaultPayConfig(fscPayConfigMain, tempPo, nowTime, reqBo.getUserId(), reqBo.getUsername());
                    this.savePayConfigChannel(tempPo, payConfigId, payMethod);
                    long payConfigHisNewId = this.savePayConfigHis(payLogId, payConfigId, "5");
                    this.savePayConfigChannelHis(payConfigHisNewId, payConfigId, nowTime, reqBo.getUserId(), reqBo.getName());
                    this.savePayConfigLogDetail("1", nowTime, payLogId, null, payConfigHisNewId, reqBo.getUserId(), reqBo.getUsername());
                } else {
                    payConfigId = ((FscPayConfigPO)fscPayConfigOldPo).getPayConfigId();
                    long payConfigHisOldId = this.savePayConfigHis(payLogId, payConfigId, "4");
                    this.savePayConfigChannelHis(payConfigHisOldId, payConfigId, nowTime, reqBo.getUserId(), reqBo.getUsername());
                    this.updateDefaultPayConfig((FscPayConfigPO)fscPayConfigOldPo, fscPayConfigMain, tempPo, nowTime, reqBo.getUserId(), reqBo.getName());
                    this.savePayConfigChannel(tempPo, payConfigId, payMethod);
                    if (FscPayConfigPayType.ZQ.getCode().equals(fscPayConfigMain.getPayType()) || FscPayConfigPayType.XY.getCode().equals(fscPayConfigMain.getPayType()) || FscPayConfigPayType.ZQ.getCode().equals(((FscPayConfigPO)fscPayConfigOldPo).getPayType()) || FscPayConfigPayType.XY.getCode().equals(((FscPayConfigPO)fscPayConfigOldPo).getPayType())) {
                        this.dealCreditControl(((FscPayConfigPO)fscPayConfigOldPo).getPayConfigId());
                    }
                    long payConfigHisNewId = this.savePayConfigHis(payLogId, payConfigId, "5");
                    this.savePayConfigChannelHis(payConfigHisNewId, payConfigId, nowTime, reqBo.getUserId(), reqBo.getName());
                    this.savePayConfigLogDetail("3", nowTime, payLogId, payConfigHisOldId, payConfigHisNewId, reqBo.getUserId(), reqBo.getUsername());
                }
                newPayConfigIdList.add(payConfigId);
                FscPayConfigImportTempPO fscPayConfigImportTempPo = new FscPayConfigImportTempPO();
                fscPayConfigImportTempPo.setId(tempPo.getId());
                fscPayConfigImportTempPo.setPayConfigId(payConfigId);
                this.fscPayConfigImportTempMapper.updateById(fscPayConfigImportTempPo);
            }
            fscPayConfigImportTempQry.setIdGreaterThan(idGreaterThan);
            tempPos = this.fscPayConfigImportTempMapper.getList(fscPayConfigImportTempQry);
        }
        FscPayConfigPO fscPayConfigDeletePoQry = new FscPayConfigPO();
        fscPayConfigDeletePoQry.setParentConfigId(fscPayConfigMain.getPayConfigId());
        fscPayConfigDeletePoQry.setPayBusiType(fscPayConfigMain.getPayBusiType());
        fscPayConfigDeletePoQry.setPaySubType(fscPayConfigMain.getPaySubType());
        fscPayConfigDeletePoQry.setPaySubClass(fscPayConfigMain.getPaySubClass());
        fscPayConfigDeletePoQry.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
        fscPayConfigDeletePoQry.setPayConfigIdNotInList(newPayConfigIdList);
        List<Long> deletePayConfigIdList = this.fscPayConfigMapper.getListPayConfigIfBy(fscPayConfigDeletePoQry);
        if (CollUtil.isNotEmpty(deletePayConfigIdList)) {
            for (Long payConfigId : deletePayConfigIdList) {
                long payConfigHisOldId = this.savePayConfigHis(payLogId, payConfigId, "2");
                this.savePayConfigChannelHis(payConfigHisOldId, payConfigId, nowTime, reqBo.getUserId(), reqBo.getUsername());
                FscPayConfigPO fscPayConfigOrgUpdate = new FscPayConfigPO();
                fscPayConfigOrgUpdate.setPayConfigId(payConfigId);
                fscPayConfigOrgUpdate.setParentConfigId(fscPayConfigMain.getPayConfigId());
                fscPayConfigOrgUpdate.setPayType(fscPayConfigMain.getPayType());
                fscPayConfigOrgUpdate.setPayBusiType(fscPayConfigMain.getPayBusiType());
                fscPayConfigOrgUpdate.setDeleteFlag(YesOrNo.NO.getCode());
                fscPayConfigOrgUpdate.setStatus(FscPayConfigStatus.EFFECT.getCode());
                fscPayConfigOrgUpdate.setUpdateTime(nowTime);
                fscPayConfigOrgUpdate.setUpdateUserId(reqBo.getUserId());
                fscPayConfigOrgUpdate.setUpdateUserName(reqBo.getName());
                int updateById = this.fscPayConfigMapper.updateExtOrgFromMainById(fscPayConfigOrgUpdate);
                if (updateById != 1) {
                    log.error("\u5f85\u66f4\u65b0\u6570\u636e.count:{}.po\uff1a{}", (Object)updateById, (Object)JSON.toJSONString((Object)fscPayConfigOrgUpdate));
                    throw new PfscExtBusinessException("18000", "\u5220\u9664\u4f8b\u5916\u5355\u4f4d\u5931\u8d25\uff0c\u66f4\u65b0\u4f8b\u5916\u5355\u4f4d\u4e3a\u9ed8\u8ba4\u914d\u7f6e\u5f02\u5e38");
                }
                this.savePayConfigLogDetail("2", nowTime, payLogId, payConfigHisOldId, null, reqBo.getUserId(), reqBo.getUsername());
                FscPayConfigPO fscPayConfigCheckPo = new FscPayConfigPO();
                fscPayConfigCheckPo.setPayConfigId(payConfigId);
                fscPayConfigCheckPo.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
                if (this.fscPayConfigMapper.getCheckBy(fscPayConfigCheckPo) <= 0) continue;
                FscCreditControlBusiReqBO creditControlBusiReqBo = new FscCreditControlBusiReqBO();
                creditControlBusiReqBo.setPayConfigId(fscPayConfigOrgUpdate.getPayConfigId());
                FscCreditControlBusiRspBO creditControlBusiRspBo = this.fscCreditControlBusiService.dealCreditControl(creditControlBusiReqBo);
                if (!FscRu.isFailed(creditControlBusiRspBo.getRespCode()).booleanValue()) continue;
                throw new PfscExtBusinessException(creditControlBusiRspBo.getRespCode(), "\u66f4\u65b0\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001\u5f02\u5e38\uff1a" + creditControlBusiRspBo.getRespDesc());
            }
            if (Arrays.asList(FscPayConfigBusiType.FL.getCode(), FscPayConfigBusiType.EC.getCode(), FscPayConfigBusiType.AGR_PT.getCode()).contains(fscPayConfigMain.getPayBusiType())) {
                FscPayConfigPO fscPayConfigAgrConnDelete = new FscPayConfigPO();
                fscPayConfigAgrConnDelete.setParentConfigIdList(deletePayConfigIdList);
                fscPayConfigAgrConnDelete.setPayConfigTypeList(Arrays.asList(FscPayConfigType.EXT_AGR.getCode(), FscPayConfigType.EXT_CONN.getCode()));
                this.fscPayConfigMapper.deleteBy(fscPayConfigAgrConnDelete);
            }
            FscPayConfigChannelPO fscPayConfigChannelDelete = new FscPayConfigChannelPO();
            fscPayConfigChannelDelete.setPayConfigIdList(deletePayConfigIdList);
            this.fscPayConfigChannelMapper.deleteBy(fscPayConfigChannelDelete);
        }
        this.updateParentExceptionNum(reqBo, fscPayConfigMain, nowTime);
        FscPayConfigExtOrgSaveImportBusiRspBO rspBo = new FscPayConfigExtOrgSaveImportBusiRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6279\u91cf\u5bfc\u5165\u6210\u529f");
        return rspBo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateDefaultPayConfig(FscPayConfigPO oldPo, FscPayConfigPO mainPo, FscPayConfigImportTempPO tempPo, Date nowTime, Long createUserId, String createUserName) {
        String configCombStr = FscPayConfigBusiType.desc((String)mainPo.getPayBusiType()) + FscPayConfigSubClass.desc((String)mainPo.getPaySubClass()) + FscPayConfigSubType.desc((String)mainPo.getPaySubType());
        FscPayConfigPO updatePo = new FscPayConfigPO();
        updatePo.setPayConfigId(oldPo.getPayConfigId());
        updatePo.setParentConfigId(mainPo.getPayConfigId());
        updatePo.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
        updatePo.setPayOrgName(tempPo.getCompanyName());
        updatePo.setPayOrgPath(tempPo.getCompanyTreePath());
        updatePo.setPayAllowExceptionFlag(oldPo.getPayAllowExceptionFlag());
        updatePo.setPayUsedPeriodFlag(Arrays.asList(1, 3).contains(tempPo.getPayType()) ? this.YES : oldPo.getPayUsedPeriodFlag());
        if (Objects.equals(1, tempPo.getPayType())) {
            updatePo.setPayType(FscPayConfigPayType.ZQ.getCode());
            if (Objects.equals(1, tempPo.getPayNodeRule())) {
                updatePo.setPayNodeRule(FscPayConfigPayNodeRule.YS.getCode());
            } else {
                if (!Objects.equals(2, tempPo.getPayNodeRule())) throw new PfscExtBusinessException("18000", tempPo.getCompanyName() + configCombStr + "\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u914d\u7f6e\u9519\u8bef");
                updatePo.setPayNodeRule(FscPayConfigPayNodeRule.QS.getCode());
            }
            updatePo.setPaymentDays(tempPo.getPaymentDays());
            updatePo.setDelayDays(tempPo.getDelayDays());
            updatePo.setUsedWarningAmount(tempPo.getUsedWarningAmount());
            updatePo.setOverdueStartAmount(tempPo.getOverdueStartAmount());
            updatePo.setOverdueWarningRatio(tempPo.getOverdueWarningRatio());
            updatePo.setOverdueControlRatio(tempPo.getOverdueControlRatio());
            updatePo.setOverdueRecoveryRatio(tempPo.getOverdueRecoveryRatio());
            updatePo.setOverdueIndexRatio(tempPo.getOverdueIndexRatio());
            updatePo.setOverdueWarningIndex(tempPo.getOverdueWarningIndex());
            updatePo.setOverdueControlIndex(tempPo.getOverdueControlIndex());
            updatePo.setOverdueRecoveryIndex(tempPo.getOverdueRecoveryIndex());
        } else if (Objects.equals(2, tempPo.getPayType())) {
            updatePo.setDownPaymentRatio(new BigDecimal("100"));
            updatePo.setCheckPaymentRatio(BigDecimal.ZERO);
            if (FscPayConfigBusiType.EC.getCode().equals(mainPo.getPayBusiType()) || FscPayConfigBusiType.AGR_NONE.getCode().equals(mainPo.getPayBusiType())) {
                updatePo.setPayType(FscPayConfigPayType.YF_RATIO.getCode());
            } else {
                if (!FscPayConfigBusiType.RY.getCode().equals(mainPo.getPayBusiType())) throw new PfscExtBusinessException("18000", tempPo.getCompanyName() + configCombStr + "\u4e0d\u53ef\u914d\u7f6e\u9884\u4ed8\u6b3e\u6309\u6bd4\u4f8b\u652f\u4ed8");
                updatePo.setPayType(FscPayConfigPayType.YF_ALL.getCode());
            }
        } else if (Objects.equals(3, tempPo.getPayType())) {
            updatePo.setPayType(FscPayConfigPayType.XY.getCode());
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(mainPo.getPayBusiType())) {
                if (Objects.equals(1, tempPo.getPayNodeRule())) {
                    updatePo.setPayNodeRule(FscPayConfigPayNodeRule.YS.getCode());
                } else {
                    if (!Objects.equals(2, tempPo.getPayNodeRule())) throw new PfscExtBusinessException("18000", tempPo.getCompanyName() + configCombStr + "\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u914d\u7f6e\u9519\u8bef");
                    updatePo.setPayNodeRule(FscPayConfigPayNodeRule.QS.getCode());
                }
                updatePo.setPaymentDays(tempPo.getPaymentDays());
                updatePo.setDelayDays(tempPo.getDelayDays());
            }
            updatePo.setUsedWarningAmount(tempPo.getUsedWarningAmount());
            updatePo.setOverdueStartAmount(tempPo.getOverdueStartAmount());
            updatePo.setOverdueWarningRatio(tempPo.getOverdueWarningRatio());
            updatePo.setOverdueControlRatio(tempPo.getOverdueControlRatio());
            updatePo.setOverdueRecoveryRatio(tempPo.getOverdueRecoveryRatio());
            updatePo.setOverdueIndexRatio(tempPo.getOverdueIndexRatio());
            updatePo.setOverdueWarningIndex(tempPo.getOverdueWarningIndex());
            updatePo.setOverdueControlIndex(tempPo.getOverdueControlIndex());
            updatePo.setOverdueRecoveryIndex(tempPo.getOverdueRecoveryIndex());
        }
        updatePo.setUpdateTime(nowTime);
        updatePo.setUpdateUserId(createUserId);
        updatePo.setUpdateUserName(createUserName);
        updatePo.setDeleteFlag(YesOrNo.NO.getCode());
        this.fscPayConfigMapper.updateById(updatePo);
        if (!Arrays.asList(1, 3).contains(tempPo.getPayType())) return;
        this.fscPayConfigMapper.updateCreditAmount(oldPo.getPayConfigId(), tempPo.getCreditAmount());
    }

    private void dealCreditControl(Long payConfigId) {
        FscCreditControlBusiReqBO reqBo = new FscCreditControlBusiReqBO();
        reqBo.setPayConfigId(payConfigId);
        FscCreditControlBusiRspBO rspBo = this.fscCreditControlBusiService.dealCreditControl(reqBo);
        if (FscRu.isFailed(rspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(rspBo.getRespCode(), "\u66f4\u65b0\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001\u5f02\u5e38\uff1a" + rspBo.getRespDesc());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Long insertDefaultPayConfig(FscPayConfigPO fscPayConfigMainPo, FscPayConfigImportTempPO tempPo, Date nowTime, Long createUserId, String createUserName) {
        String configCombStr = FscPayConfigBusiType.desc((String)fscPayConfigMainPo.getPayBusiType()) + FscPayConfigSubClass.desc((String)fscPayConfigMainPo.getPaySubClass()) + FscPayConfigSubType.desc((String)fscPayConfigMainPo.getPaySubType());
        FscPayConfigPO fscPayConfigInsert = new FscPayConfigPO();
        fscPayConfigInsert.setPayConfigId(Sequence.getInstance().nextId());
        fscPayConfigInsert.setParentConfigId(fscPayConfigMainPo.getPayConfigId());
        fscPayConfigInsert.setVersionNo(fscPayConfigMainPo.getVersionNo());
        fscPayConfigInsert.setPayBusiType(fscPayConfigMainPo.getPayBusiType());
        fscPayConfigInsert.setPaySubClass(fscPayConfigMainPo.getPaySubClass());
        fscPayConfigInsert.setPaySubType(fscPayConfigMainPo.getPaySubType());
        fscPayConfigInsert.setPayConfigMode(fscPayConfigMainPo.getPayConfigMode());
        fscPayConfigInsert.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
        fscPayConfigInsert.setPayUsedPeriodFlag(Arrays.asList(1, 3).contains(tempPo.getPayType()) ? this.YES : this.NO);
        fscPayConfigInsert.setPayOrgId(tempPo.getCompanyId());
        fscPayConfigInsert.setPayOrgName(tempPo.getCompanyName());
        fscPayConfigInsert.setPayOrgPath(tempPo.getCompanyTreePath());
        fscPayConfigInsert.setPayAllowExceptionFlag(this.NO);
        fscPayConfigInsert.setExceptionOrgNum(0);
        fscPayConfigInsert.setExceptionAgrNum(0);
        fscPayConfigInsert.setExceptionConnNum(0);
        if (Objects.equals(1, tempPo.getPayType())) {
            fscPayConfigInsert.setPayType(FscPayConfigPayType.ZQ.getCode());
            if (Objects.equals(1, tempPo.getPayNodeRule())) {
                fscPayConfigInsert.setPayNodeRule(FscPayConfigPayNodeRule.YS.getCode());
            } else {
                if (!Objects.equals(2, tempPo.getPayNodeRule())) throw new PfscExtBusinessException("18000", tempPo.getCompanyName() + configCombStr + "\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u914d\u7f6e\u9519\u8bef");
                fscPayConfigInsert.setPayNodeRule(FscPayConfigPayNodeRule.QS.getCode());
            }
            fscPayConfigInsert.setPaymentDays(tempPo.getPaymentDays());
            fscPayConfigInsert.setDelayDays(tempPo.getDelayDays());
            fscPayConfigInsert.setCreditAmount(Optional.ofNullable(tempPo.getCreditAmount()).orElse(BigDecimal.ZERO));
            fscPayConfigInsert.setUsedAmount(BigDecimal.ZERO);
            fscPayConfigInsert.setBalanceAmount(fscPayConfigInsert.getCreditAmount().subtract(fscPayConfigInsert.getUsedAmount()));
            fscPayConfigInsert.setUsedWarningAmount(tempPo.getUsedWarningAmount());
            fscPayConfigInsert.setOverdueStartAmount(tempPo.getOverdueStartAmount());
            fscPayConfigInsert.setOverdueWarningRatio(tempPo.getOverdueWarningRatio());
            fscPayConfigInsert.setOverdueControlRatio(tempPo.getOverdueControlRatio());
            fscPayConfigInsert.setOverdueRecoveryRatio(tempPo.getOverdueRecoveryRatio());
            fscPayConfigInsert.setOverdueIndexRatio(tempPo.getOverdueIndexRatio());
            fscPayConfigInsert.setOverdueWarningIndex(tempPo.getOverdueWarningIndex());
            fscPayConfigInsert.setOverdueControlIndex(tempPo.getOverdueControlIndex());
            fscPayConfigInsert.setOverdueRecoveryIndex(tempPo.getOverdueRecoveryIndex());
            fscPayConfigInsert.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
            fscPayConfigInsert.setCurrentOrgControlTag(JSON.toJSONString(new ArrayList()));
            fscPayConfigInsert.setCurrentOrgWarningTag(JSON.toJSONString(new ArrayList()));
            fscPayConfigInsert.setCurrentOverdueRatio(BigDecimal.ZERO);
            fscPayConfigInsert.setCurrentOverdueAmount(BigDecimal.ZERO);
            fscPayConfigInsert.setCurrentPenaltyAmount(BigDecimal.ZERO);
            fscPayConfigInsert.setCurrentOverdueIndex(BigDecimal.ZERO);
        } else if (Objects.equals(2, tempPo.getPayType())) {
            fscPayConfigInsert.setDownPaymentRatio(new BigDecimal("100"));
            fscPayConfigInsert.setCheckPaymentRatio(BigDecimal.ZERO);
            if (FscPayConfigBusiType.EC.getCode().equals(fscPayConfigMainPo.getPayBusiType()) || FscPayConfigBusiType.AGR_NONE.getCode().equals(fscPayConfigMainPo.getPayBusiType())) {
                fscPayConfigInsert.setPayType(FscPayConfigPayType.YF_RATIO.getCode());
            } else {
                if (!FscPayConfigBusiType.RY.getCode().equals(fscPayConfigMainPo.getPayBusiType())) throw new PfscExtBusinessException("18000", tempPo.getCompanyName() + configCombStr + "\u4e0d\u53ef\u914d\u7f6e\u9884\u4ed8\u6b3e\u6309\u6bd4\u4f8b\u652f\u4ed8");
                fscPayConfigInsert.setPayType(FscPayConfigPayType.YF_ALL.getCode());
            }
        } else if (Objects.equals(3, tempPo.getPayType())) {
            fscPayConfigInsert.setPayType(FscPayConfigPayType.XY.getCode());
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(fscPayConfigMainPo.getPayBusiType())) {
                if (Objects.equals(1, tempPo.getPayNodeRule())) {
                    fscPayConfigInsert.setPayNodeRule(FscPayConfigPayNodeRule.YS.getCode());
                } else {
                    if (!Objects.equals(2, tempPo.getPayNodeRule())) throw new PfscExtBusinessException("18000", tempPo.getCompanyName() + configCombStr + "\u8d26\u671f\u8d77\u7b97\u8282\u70b9\u914d\u7f6e\u9519\u8bef");
                    fscPayConfigInsert.setPayNodeRule(FscPayConfigPayNodeRule.QS.getCode());
                }
                fscPayConfigInsert.setPaymentDays(tempPo.getPaymentDays());
                fscPayConfigInsert.setDelayDays(tempPo.getDelayDays());
            }
            fscPayConfigInsert.setCreditAmount(Optional.ofNullable(fscPayConfigMainPo.getCreditAmount()).orElse(BigDecimal.ZERO));
            fscPayConfigInsert.setUsedAmount(BigDecimal.ZERO);
            fscPayConfigInsert.setBalanceAmount(fscPayConfigInsert.getCreditAmount());
            fscPayConfigInsert.setUsedWarningAmount(tempPo.getUsedWarningAmount());
            fscPayConfigInsert.setOverdueStartAmount(tempPo.getOverdueStartAmount());
            fscPayConfigInsert.setOverdueWarningRatio(tempPo.getOverdueWarningRatio());
            fscPayConfigInsert.setOverdueControlRatio(tempPo.getOverdueControlRatio());
            fscPayConfigInsert.setOverdueRecoveryRatio(tempPo.getOverdueRecoveryRatio());
            fscPayConfigInsert.setOverdueIndexRatio(tempPo.getOverdueIndexRatio());
            fscPayConfigInsert.setOverdueWarningIndex(tempPo.getOverdueWarningIndex());
            fscPayConfigInsert.setOverdueControlIndex(tempPo.getOverdueControlIndex());
            fscPayConfigInsert.setOverdueRecoveryIndex(tempPo.getOverdueRecoveryIndex());
            fscPayConfigInsert.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
            fscPayConfigInsert.setCurrentOrgControlTag(JSON.toJSONString(new ArrayList()));
            fscPayConfigInsert.setCurrentOrgWarningTag(JSON.toJSONString(new ArrayList()));
            fscPayConfigInsert.setCurrentOverdueRatio(BigDecimal.ZERO);
            fscPayConfigInsert.setCurrentOverdueAmount(BigDecimal.ZERO);
            fscPayConfigInsert.setCurrentPenaltyAmount(BigDecimal.ZERO);
            fscPayConfigInsert.setCurrentOverdueIndex(BigDecimal.ZERO);
        }
        fscPayConfigInsert.setCreateTime(nowTime);
        fscPayConfigInsert.setCreateUserId(createUserId);
        fscPayConfigInsert.setCreateUserName(createUserName);
        fscPayConfigInsert.setRemark("\u6279\u91cf\u5bfc\u5165\u65b0\u589e");
        fscPayConfigInsert.setStatus(fscPayConfigMainPo.getStatus());
        fscPayConfigInsert.setDeleteFlag(fscPayConfigMainPo.getDeleteFlag());
        this.fscPayConfigMapper.insert(fscPayConfigInsert);
        return fscPayConfigInsert.getPayConfigId();
    }

    private void insertPayConfigLogPo(Long payLogId, FscPayConfigPO fscPayConfigMain, Date nowTime, Long createUserId, String createUserName) {
        FscPayConfigLogPO fscPayConfigLogPo = new FscPayConfigLogPO();
        fscPayConfigLogPo.setPayLogId(payLogId);
        fscPayConfigLogPo.setVersionNo(fscPayConfigMain.getVersionNo());
        fscPayConfigLogPo.setPayLogFlag("3");
        fscPayConfigLogPo.setPayBusiType(fscPayConfigMain.getPayBusiType());
        fscPayConfigLogPo.setPaySubClass(fscPayConfigMain.getPaySubClass());
        fscPayConfigLogPo.setPaySubType(fscPayConfigMain.getPaySubType());
        fscPayConfigLogPo.setPayConfigMode(fscPayConfigMain.getPayConfigMode());
        fscPayConfigLogPo.setExceptionMain(this.NO);
        fscPayConfigLogPo.setExceptionOrg(this.YES);
        fscPayConfigLogPo.setExceptionAgr(this.NO);
        fscPayConfigLogPo.setExceptionConn(this.NO);
        fscPayConfigLogPo.setNoControlAgr(this.NO);
        fscPayConfigLogPo.setCreateTime(nowTime);
        fscPayConfigLogPo.setCreateUserId(createUserId);
        fscPayConfigLogPo.setCreateUserName(createUserName);
        this.fscPayConfigLogMapper.insert(fscPayConfigLogPo);
    }

    private void savePayConfigLogDetail(String payLogFlag, Date nowTime, Long payLogId, Long payConfigHisOldId, Long payConfigHisNewId, Long userId, String username) {
        FscPayConfigLogDetailPO fscPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
        fscPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
        fscPayConfigLogDetailInsert.setPayLogId(payLogId);
        fscPayConfigLogDetailInsert.setPayLogFlag(payLogFlag);
        fscPayConfigLogDetailInsert.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
        fscPayConfigLogDetailInsert.setPayConfigHisOldId(payConfigHisOldId);
        fscPayConfigLogDetailInsert.setPayConfigHisNewId(payConfigHisNewId);
        fscPayConfigLogDetailInsert.setCreateTime(nowTime);
        fscPayConfigLogDetailInsert.setCreateUserId(userId);
        fscPayConfigLogDetailInsert.setCreateUserName(username);
        this.fscPayConfigLogDetailMapper.insert(fscPayConfigLogDetailInsert);
    }

    private Long savePayConfigHis(Long payLogId, Long payConfigId, String payLogFlag) {
        long payConfigHisId = Sequence.getInstance().nextId();
        FscPayConfigHisPO excPayConfigHisBeforePo = new FscPayConfigHisPO();
        excPayConfigHisBeforePo.setPayConfigHisId(payConfigHisId);
        excPayConfigHisBeforePo.setPayLogId(payLogId);
        excPayConfigHisBeforePo.setPayLogFlag(payLogFlag);
        excPayConfigHisBeforePo.setPayConfigId(payConfigId);
        this.fscPayConfigHisMapper.insertBySelect(excPayConfigHisBeforePo);
        return payConfigHisId;
    }

    private void savePayConfigChannelHis(Long payConfigHisOldId, Long payConfigId, Date nowTime, Long createUserId, String createUserName) {
        FscPayConfigChannelHisPO fscPayConfigChannelHisPo = new FscPayConfigChannelHisPO();
        fscPayConfigChannelHisPo.setPayConfigHisId(payConfigHisOldId);
        fscPayConfigChannelHisPo.setPayConfigId(payConfigId);
        fscPayConfigChannelHisPo.setHisCreateTime(nowTime);
        fscPayConfigChannelHisPo.setHisCreateUserId(createUserId);
        fscPayConfigChannelHisPo.setHisCreateUserName(createUserName);
        this.fscPayConfigChannelHisMapper.insertBySelect(fscPayConfigChannelHisPo);
    }

    private void updateParentExceptionNum(FscPayConfigExtOrgSaveImportBusiReqBO reqBo, FscPayConfigPO fscPayConfigParent, Date nowTime) {
        FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
        fscPayConfigUpdate.setPayConfigId(fscPayConfigParent.getPayConfigId());
        Integer exceptionOrgNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.EXT_ORG.getCode());
        fscPayConfigUpdate.setExceptionOrgNum(exceptionOrgNum);
        Integer exceptionAgrNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.EXT_AGR.getCode());
        fscPayConfigUpdate.setExceptionAgrNum(exceptionAgrNum);
        Integer exceptionConnNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.EXT_CONN.getCode());
        fscPayConfigUpdate.setExceptionConnNum(exceptionConnNum);
        Integer noControlAgrNum = this.getExceptionNum(fscPayConfigParent.getPayConfigId(), FscPayConfigType.NO_CREDIT_AGR.getCode());
        fscPayConfigUpdate.setNoControlAgrNum(noControlAgrNum);
        int exceptionNum = exceptionOrgNum + exceptionAgrNum + exceptionConnNum;
        fscPayConfigUpdate.setPayAllowExceptionFlag(exceptionNum > 0 ? YesOrNo.YES.getCode() : YesOrNo.NO.getCode());
        fscPayConfigUpdate.setUpdateTime(nowTime);
        fscPayConfigUpdate.setUpdateUserId(reqBo.getUserId());
        fscPayConfigUpdate.setUpdateUserName(reqBo.getName());
        this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
    }

    private void savePayConfigChannel(FscPayConfigImportTempPO tempPo, Long payConfigId, Map<String, FscPayConfigPayMethodBO> payMethod) {
        List payMethodArr = Arrays.stream(Optional.ofNullable(tempPo.getPayMethod()).orElse("").replace(" ", "").split("[,\uff0c]")).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        if (payMethodArr.isEmpty()) {
            throw new PfscExtBusinessException("18000", tempPo.getCompanyName() + "\u5bfc\u5165\u5931\u8d25\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a");
        }
        List noneMatch = payMethodArr.stream().filter(i -> !payMethod.containsKey(i)).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(noneMatch)) {
            throw new PfscExtBusinessException("18000", tempPo.getCompanyName() + "\u5bfc\u5165\u5931\u8d25\uff0c\u652f\u4ed8\u65b9\u5f0f[" + noneMatch + "]\u5b57\u5178\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
        }
        Map<String, List<FscPayConfigPayMethodBO>> payConfigChannelMap = payMethod.entrySet().stream().filter(i -> payMethodArr.contains(i.getKey())).map(Map.Entry::getValue).collect(Collectors.groupingBy(FscPayConfigPayMethodBO::getChannel));
        ArrayList<FscPayConfigChannelPO> payConfigChannelPos = new ArrayList<FscPayConfigChannelPO>();
        for (Map.Entry<String, List<FscPayConfigPayMethodBO>> entry : payConfigChannelMap.entrySet()) {
            FscPayConfigChannelPO channelPo = new FscPayConfigChannelPO();
            channelPo.setPayConfigChannelId(Sequence.getInstance().nextId());
            channelPo.setPayConfigId(payConfigId);
            channelPo.setPayConfigType(FscPayConfigType.EXT_ORG.getCode());
            channelPo.setPayChannels(entry.getKey());
            channelPo.setPayMethod(entry.getValue().stream().map(FscPayConfigPayMethodBO::getMethod).collect(Collectors.joining(",")));
            channelPo.setRemark(entry.getValue().stream().map(FscPayConfigPayMethodBO::getMethodStr).collect(Collectors.joining(",")));
            channelPo.setCreateTime(new Date());
            payConfigChannelPos.add(channelPo);
        }
        FscPayConfigChannelPO fscPayConfigChannelDel = new FscPayConfigChannelPO();
        fscPayConfigChannelDel.setPayConfigId(payConfigId);
        this.fscPayConfigChannelMapper.deleteBy(fscPayConfigChannelDel);
        if (CollUtil.isNotEmpty(payConfigChannelPos)) {
            this.fscPayConfigChannelMapper.insertBatch(payConfigChannelPos);
        }
    }

    private Map<String, String> getDicMap(String pcode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StrUtil.isBlank((CharSequence)pcode)) {
            return map;
        }
        DicDictionaryPO dicDictionaryQry = new DicDictionaryPO();
        dicDictionaryQry.setPCode(pcode);
        List<DicDictionaryPO> dicList = this.dicDictionaryMapper.getListByCondition(dicDictionaryQry);
        if (CollUtil.isNotEmpty(dicList)) {
            map.putAll(dicList.stream().collect(Collectors.toMap(DicDictionaryPO::getCode, DicDictionaryPO::getDescrip, (c, n) -> c)));
        }
        return map;
    }

    private Map<String, FscPayConfigPayMethodBO> mapPayMethod() {
        Map<String, String> dicMap = this.getDicMap("FSC_PAY_CONFIG_PAY_METHOD_IMPORT");
        if (CollUtil.isEmpty(dicMap)) {
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u67e5\u8be2\u5b57\u5178\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
        }
        HashMap<String, FscPayConfigPayMethodBO> map = new HashMap<String, FscPayConfigPayMethodBO>();
        for (Map.Entry<String, String> entry : dicMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                map.put(key, (FscPayConfigPayMethodBO)JSON.parseObject((String)value, FscPayConfigPayMethodBO.class));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
            }
        }
        if (map.values().stream().anyMatch(i -> StrUtil.isBlank((CharSequence)i.getMethod()) || StrUtil.isBlank((CharSequence)i.getChannel()))) {
            log.error("\u652f\u4ed8\u65b9\u5f0f\u6216\u652f\u4ed8\u6e20\u9053\u5b58\u5728\u4e3a\u7a7a" + JSON.toJSONString(map));
            throw new PfscExtBusinessException("18000", "\u652f\u4ed8\u65b9\u5f0f\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5904\u7406");
        }
        return map;
    }

    private Integer getExceptionNum(Long payConfigId, String payConfigType) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setParentConfigId(payConfigId);
        fscPayConfigQry.setPayConfigType(payConfigType);
        return this.fscPayConfigMapper.getCheckBy(fscPayConfigQry);
    }
}

