/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.bo.FscPayConfigChannelBO;
import com.tydic.pfscext.api.ability.bo.FscUmcEnterpriseOrgBO;
import com.tydic.pfscext.constants.FscConstants;
import com.tydic.pfscext.dao.FscOrdExtMapMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelHisMapper;
import com.tydic.pfscext.dao.FscPayConfigChannelMapper;
import com.tydic.pfscext.dao.FscPayConfigHisMapper;
import com.tydic.pfscext.dao.FscPayConfigLogDetailMapper;
import com.tydic.pfscext.dao.FscPayConfigLogMapper;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscOrdExtMapPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigChannelPO;
import com.tydic.pfscext.dao.po.FscPayConfigHisPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogDetailPO;
import com.tydic.pfscext.dao.po.FscPayConfigLogPO;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigBusiType;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigPayLogFlag;
import com.tydic.pfscext.enums.FscPayConfigPayType;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscCreditControlBusiService;
import com.tydic.pfscext.service.busi.FscPayConfigSaveBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigSaveBasicBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigSaveBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigSaveBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigUpdateOverdueBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigUpdateOverdueBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigUpdateStatusBusiReqBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfigSaveBusiServiceImpl
implements FscPayConfigSaveBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigSaveBusiServiceImpl.class);
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscOrdExtMapMapper fscOrdExtMapMapper;
    @Autowired
    private FscPayConfigLogMapper fscPayConfigLogMapper;
    @Autowired
    private FscPayConfigHisMapper fscPayConfigHisMapper;
    @Autowired
    private FscPayConfigChannelMapper fscPayConfigChannelMapper;
    @Autowired
    private FscPayConfigChannelHisMapper fscPayConfigChannelHisMapper;
    @Autowired
    private FscPayConfigLogDetailMapper fscPayConfigLogDetailMapper;
    @Autowired
    private FscCreditControlBusiService fscCreditControlBusiService;

    @Override
    public FscPayConfigSaveBusiRspBO dealPayConfigSave(FscPayConfigSaveBusiReqBO reqBo) {
        this.parameterVerification(reqBo);
        FscPayConfigSaveBusiRspBO rspBo = FscRu.success(FscPayConfigSaveBusiRspBO.class);
        FscPayConfigPO fscPayConfigInsert = this.initInsertData(reqBo);
        this.fscPayConfigMapper.insert(fscPayConfigInsert);
        List<FscPayConfigChannelPO> payConfigChannels = this.addPayConfigChannels(reqBo.getPayConfigChannels(), fscPayConfigInsert.getPayConfigId(), FscPayConfigType.MAIN.getCode());
        this.addLog(reqBo, fscPayConfigInsert, payConfigChannels);
        rspBo.setPayConfigId(fscPayConfigInsert.getPayConfigId());
        rspBo.setVersionNo(fscPayConfigInsert.getVersionNo());
        return rspBo;
    }

    @Override
    public FscPayConfigSaveBusiRspBO dealPayConfigBasicSave(FscPayConfigSaveBasicBusiReqBO reqBo) {
        FscUmcEnterpriseOrgBO fscUmcOrgBo = reqBo.getFscUmcOrgBo();
        ValUtil.isEmpty(reqBo.getMainPayConfigId()).exception("\u4e3b\u914d\u7f6eID\u4e3a\u7a7a");
        ValUtil.isEmpty(fscUmcOrgBo).exception("\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOpeType()).exception("\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setPayConfigId(reqBo.getMainPayConfigId());
        FscPayConfigPO mainPayConfig = this.fscPayConfigMapper.getModelBy(fscPayConfigQry);
        if (mainPayConfig == null) {
            throw new PfscExtBusinessException("0001", "\u751f\u6210\u9ed8\u8ba4\u6570\u636e\u5f02\u5e38\uff0c\u4e3b\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        FscPayConfigPO fscPayConfigOldPo = new FscPayConfigPO();
        fscPayConfigOldPo.setParentConfigId(mainPayConfig.getPayConfigId());
        fscPayConfigOldPo.setPayBusiType(mainPayConfig.getPayBusiType());
        fscPayConfigOldPo.setPaySubType(mainPayConfig.getPaySubType());
        fscPayConfigOldPo.setPaySubClass(mainPayConfig.getPaySubClass());
        fscPayConfigOldPo.setPayOrgId(fscUmcOrgBo.getOrgId());
        if (FscPayConfigSubType.GR.getCode().equals(mainPayConfig.getPaySubType())) {
            fscPayConfigOldPo.setPayUserId(fscUmcOrgBo.getUserId());
        }
        if ((fscPayConfigOldPo = this.fscPayConfigMapper.getModelBy(fscPayConfigOldPo)) == null) {
            this.insertDefaultPayConfig(reqBo.getOpeType(), mainPayConfig, fscUmcOrgBo);
        } else if (!FscPayConfigType.EXT_ORG.getCode().equals(fscPayConfigOldPo.getPayConfigType())) {
            this.updateDefaultPayConfig(reqBo.getOpeType(), fscPayConfigOldPo, mainPayConfig, fscUmcOrgBo);
            if (FscPayConfigPayType.ZQ.getCode().equals(mainPayConfig.getPayType()) || FscPayConfigPayType.XY.getCode().equals(mainPayConfig.getPayType()) || FscPayConfigPayType.ZQ.getCode().equals(fscPayConfigOldPo.getPayType()) || FscPayConfigPayType.XY.getCode().equals(fscPayConfigOldPo.getPayType())) {
                this.dealCreditControl(fscPayConfigOldPo.getPayConfigId());
            }
        }
        return FscRu.success(FscPayConfigSaveBusiRspBO.class);
    }

    @Override
    public FscPayConfigUpdateOverdueBusiRspBO dealPayConfigUpdateOverdue(FscPayConfigUpdateOverdueBusiReqBO reqBo) {
        FscPayConfigUpdateOverdueBusiRspBO rspBo = FscRu.success(FscPayConfigUpdateOverdueBusiRspBO.class);
        if (reqBo.getPayConfigId() == null) {
            rspBo.setRespDesc("\u66f4\u65b0\u903e\u671f\u91d1\u989d\u5931\u8d25\uff0c\u652f\u4ed8\u914d\u7f6eID\u6216\u8005\u88ab\u66f4\u65b0\u9879\u4e3a\u7a7a" + reqBo.getPayConfigId());
            return rspBo;
        }
        if ("3".equals(reqBo.getChangeReason())) {
            FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
            fscPayConfigUpdate.setPayConfigId(reqBo.getPayConfigId());
            fscPayConfigUpdate.setCurrentOverdueAmount(reqBo.getOverdueAmount());
            fscPayConfigUpdate.setCurrentOverdueIndex(reqBo.getOverdueIndex());
            fscPayConfigUpdate.setCurrentPenaltyAmount(reqBo.getPenaltyAmount());
            int count = this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
            rspBo.setRespDesc("\u66f4\u65b0[" + reqBo.getPayConfigId() + "]\u903e\u671f\u91d1\u989d\u6307\u6570\u8fdd\u7ea6\u91d1\u5b8c\u6210\uff0c\u66f4\u65b0count\uff1a" + count);
            return rspBo;
        }
        boolean isUpdate = false;
        if (reqBo.getOverdueAmount().compareTo(BigDecimal.ZERO) != 0) {
            isUpdate = true;
        } else if (reqBo.getPenaltyAmount().compareTo(BigDecimal.ZERO) != 0) {
            isUpdate = true;
        } else if (reqBo.getOverdueIndex().compareTo(BigDecimal.ZERO) != 0) {
            isUpdate = true;
        }
        if (isUpdate) {
            BigDecimal overdueAmount = reqBo.getOverdueAmount();
            FscOrdExtMapPO fscOrdExtMapPo = new FscOrdExtMapPO();
            fscOrdExtMapPo.setObjId(reqBo.getInspectionId());
            fscOrdExtMapPo.setOrderId(reqBo.getOrderId());
            fscOrdExtMapPo.setObjType(FscConstants.FscOrdExtMapType.OVERDUE_TYPE);
            fscOrdExtMapPo.setFieldCode("overdueAmount");
            FscOrdExtMapPO modelBy = this.fscOrdExtMapMapper.getModelBy(fscOrdExtMapPo);
            if (modelBy != null && modelBy.getFieldValue() != null) {
                BigDecimal oldOverdueAmount = new BigDecimal(modelBy.getFieldValue());
                rspBo.setOldOverdueAmount(oldOverdueAmount);
                overdueAmount = overdueAmount.subtract(oldOverdueAmount);
                FscOrdExtMapPO fscOrdExtMapUpdate = new FscOrdExtMapPO();
                fscOrdExtMapUpdate.setId(modelBy.getId());
                fscOrdExtMapUpdate.setFieldValue(reqBo.getOverdueAmount().setScale(6, RoundingMode.HALF_UP).toPlainString());
                int count = this.fscOrdExtMapMapper.updateById(fscOrdExtMapUpdate);
                log.info("\u66f4\u65b0\u6269\u5c55\u8868count\uff1a{}", (Object)count);
            } else {
                rspBo.setOldOverdueAmount(reqBo.getOverdueAmount());
                fscOrdExtMapPo.setFieldName("\u903e\u671f\u91d1\u989d\u66f4\u65b0\u4e0a\u6b21\u903e\u671f\u91d1\u989d");
                fscOrdExtMapPo.setFieldValue(Optional.ofNullable(reqBo.getOverdueAmount()).orElse(BigDecimal.ZERO).toPlainString());
                fscOrdExtMapPo.setId(Sequence.getInstance().nextId());
                this.fscOrdExtMapMapper.insert(fscOrdExtMapPo);
            }
            int count = this.fscPayConfigMapper.updateOverdueAmount(reqBo.getPayConfigId(), null, overdueAmount, reqBo.getPenaltyAmount(), reqBo.getOverdueIndex());
            rspBo.setRespDesc("\u66f4\u65b0\u903e\u671f\u91d1\u989d\u5b8c\u6210\uff0c\u66f4\u65b0count\uff1a" + count);
        }
        return rspBo;
    }

    @Override
    public FscPayConfigSaveBusiRspBO dealPayConfigUpdateStatus(FscPayConfigUpdateStatusBusiReqBO reqBo) {
        int count;
        FscPayConfigSaveBusiRspBO rspBo = FscRu.success(FscPayConfigSaveBusiRspBO.class);
        FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
        fscPayConfigUpdate.setPayConfigId(reqBo.getMainPayConfigId());
        fscPayConfigUpdate.setStatus(FscPayConfigStatus.EFFECT.getCode());
        int exceptionOrgNum = this.getExceptionNum(reqBo.getMainPayConfigId(), FscPayConfigType.EXT_ORG.getCode());
        fscPayConfigUpdate.setExceptionOrgNum(exceptionOrgNum);
        int exceptionAgrNum = this.getExceptionNum(reqBo.getMainPayConfigId(), FscPayConfigType.EXT_AGR.getCode());
        fscPayConfigUpdate.setExceptionAgrNum(exceptionAgrNum);
        int exceptionConnNum = this.getExceptionNum(reqBo.getMainPayConfigId(), FscPayConfigType.EXT_CONN.getCode());
        fscPayConfigUpdate.setExceptionConnNum(exceptionConnNum);
        if (exceptionOrgNum + exceptionAgrNum + exceptionConnNum > 0) {
            fscPayConfigUpdate.setPayAllowExceptionFlag(YesOrNo.YES.getCode());
        }
        if ((count = this.fscPayConfigMapper.updateById(fscPayConfigUpdate)) > 1) {
            throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u4e3b\u914d\u7f6e\u751f\u6548\u5f02\u5e38");
        }
        rspBo.setPayConfigId(fscPayConfigUpdate.getPayConfigId());
        return rspBo;
    }

    private Integer getExceptionNum(Long payConfigId, String payConfigType) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setParentConfigId(payConfigId);
        fscPayConfigQry.setPayConfigType(payConfigType);
        int checkBy = this.fscPayConfigMapper.getCheckBy(fscPayConfigQry);
        return checkBy;
    }

    private void dealCreditControl(Long payConfigId) {
        FscCreditControlBusiReqBO reqBo = new FscCreditControlBusiReqBO();
        reqBo.setPayConfigId(payConfigId);
        FscCreditControlBusiRspBO rspBo = this.fscCreditControlBusiService.dealCreditControl(reqBo);
        if (FscRu.isFailed(rspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(rspBo.getRespCode(), "\u66f4\u65b0\u6388\u4fe1\u7ba1\u63a7\u72b6\u6001\u5f02\u5e38\uff1a" + rspBo.getRespDesc());
        }
    }

    private List<FscPayConfigChannelPO> addPayConfigChannels(List<FscPayConfigChannelBO> payConfigChannels, Long payConfigId, String payConfigType) {
        ArrayList<FscPayConfigChannelPO> payConfigChannelPos = new ArrayList<FscPayConfigChannelPO>();
        if (!CollectionUtils.isEmpty(payConfigChannels)) {
            for (FscPayConfigChannelBO channelBo : payConfigChannels) {
                FscPayConfigChannelPO po = new FscPayConfigChannelPO();
                po.setPayConfigChannelId(Sequence.getInstance().nextId());
                po.setPayConfigId(payConfigId);
                po.setPayConfigType(payConfigType);
                po.setPayChannels(channelBo.getPayChannels());
                po.setPayMethod(channelBo.getPayMethod());
                po.setCreateTime(new Date());
                po.setRemark(channelBo.getRemark());
                payConfigChannelPos.add(po);
            }
            this.fscPayConfigChannelMapper.insertBatch(payConfigChannelPos);
        }
        return payConfigChannelPos;
    }

    private void addLog(FscPayConfigSaveBusiReqBO reqBo, FscPayConfigPO fscPayConfigInsert, List<FscPayConfigChannelPO> payConfigChannels) {
        Date nowTime = new Date();
        FscPayConfigLogPO fscPayConfigLogPo = new FscPayConfigLogPO();
        fscPayConfigLogPo.setPayLogId(Sequence.getInstance().nextId());
        fscPayConfigLogPo.setVersionNo(fscPayConfigInsert.getVersionNo());
        fscPayConfigLogPo.setPayLogFlag("1");
        fscPayConfigLogPo.setPayBusiType(fscPayConfigInsert.getPayBusiType());
        fscPayConfigLogPo.setPaySubClass(fscPayConfigInsert.getPaySubClass());
        fscPayConfigLogPo.setPaySubType(fscPayConfigInsert.getPaySubType());
        fscPayConfigLogPo.setPayConfigMode(fscPayConfigInsert.getPayConfigMode());
        fscPayConfigLogPo.setExceptionMain(YesOrNo.YES.getCode());
        fscPayConfigLogPo.setExceptionOrg(YesOrNo.NO.getCode());
        fscPayConfigLogPo.setExceptionAgr(YesOrNo.NO.getCode());
        fscPayConfigLogPo.setExceptionConn(YesOrNo.NO.getCode());
        fscPayConfigLogPo.setCreateTime(nowTime);
        fscPayConfigLogPo.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogPo.setCreateUserName(reqBo.getName());
        this.fscPayConfigLogMapper.insert(fscPayConfigLogPo);
        FscPayConfigHisPO fscPayConfigHisPo = new FscPayConfigHisPO();
        this.initFscPayConfigHisPo(fscPayConfigInsert, fscPayConfigHisPo);
        fscPayConfigHisPo.setPayConfigHisId(Sequence.getInstance().nextId());
        fscPayConfigHisPo.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigHisPo.setPayLogFlag(FscPayConfigPayLogFlag.ADD.getCode());
        this.fscPayConfigHisMapper.insert(fscPayConfigHisPo);
        if (!CollectionUtils.isEmpty(payConfigChannels)) {
            ArrayList<FscPayConfigChannelHisPO> channelHisList = new ArrayList<FscPayConfigChannelHisPO>();
            for (FscPayConfigChannelPO payConfigChannel : payConfigChannels) {
                FscPayConfigChannelHisPO his = new FscPayConfigChannelHisPO();
                his.setPayConfigChannelHisId(Sequence.getInstance().nextId());
                his.setPayConfigHisId(fscPayConfigHisPo.getPayConfigHisId());
                his.setPayConfigChannelId(payConfigChannel.getPayConfigChannelId());
                his.setPayConfigId(payConfigChannel.getPayConfigId());
                his.setPayConfigType(payConfigChannel.getPayConfigType());
                his.setPayChannels(payConfigChannel.getPayChannels());
                his.setPayMethod(payConfigChannel.getPayMethod());
                his.setCreateTime(payConfigChannel.getCreateTime());
                his.setRemark(payConfigChannel.getRemark());
                his.setHisCreateTime(nowTime);
                his.setHisCreateUserId(reqBo.getUserId());
                his.setHisCreateUserName(reqBo.getUsername());
                channelHisList.add(his);
            }
            this.fscPayConfigChannelHisMapper.insertBatch(channelHisList);
        }
        FscPayConfigLogDetailPO fscPayConfigLogDetailInsert = new FscPayConfigLogDetailPO();
        fscPayConfigLogDetailInsert.setPayLogDetailId(Sequence.getInstance().nextId());
        fscPayConfigLogDetailInsert.setPayLogId(fscPayConfigLogPo.getPayLogId());
        fscPayConfigLogDetailInsert.setPayLogFlag(FscPayConfigPayLogFlag.ADD.getCode());
        fscPayConfigLogDetailInsert.setPayConfigType(FscPayConfigType.MAIN.getCode());
        fscPayConfigLogDetailInsert.setPayConfigHisOldId(0L);
        fscPayConfigLogDetailInsert.setPayConfigHisNewId(fscPayConfigHisPo.getPayConfigHisId());
        fscPayConfigLogDetailInsert.setChangeFieldCollection(this.getChangeField(null, fscPayConfigHisPo));
        fscPayConfigLogDetailInsert.setCreateTime(nowTime);
        fscPayConfigLogDetailInsert.setCreateUserId(reqBo.getUserId());
        fscPayConfigLogDetailInsert.setCreateUserName(reqBo.getUsername());
        this.fscPayConfigLogDetailMapper.insert(fscPayConfigLogDetailInsert);
    }

    private void initFscPayConfigHisPo(FscPayConfigPO sourcePo, FscPayConfigHisPO targetPo) {
        targetPo.setPayConfigId(sourcePo.getPayConfigId());
        targetPo.setParentConfigId(sourcePo.getParentConfigId());
        targetPo.setVersionNo(sourcePo.getVersionNo());
        targetPo.setPayBusiType(sourcePo.getPayBusiType());
        targetPo.setPaySubClass(sourcePo.getPaySubClass());
        targetPo.setPaySubType(sourcePo.getPaySubType());
        targetPo.setPayConfigMode(sourcePo.getPayConfigMode());
        targetPo.setPayConfigType(sourcePo.getPayConfigType());
        targetPo.setPayUsedPeriodFlag(sourcePo.getPayUsedPeriodFlag());
        targetPo.setPayAllowExceptionFlag(sourcePo.getPayAllowExceptionFlag());
        targetPo.setExceptionOrgNum(sourcePo.getExceptionOrgNum());
        targetPo.setExceptionAgrNum(sourcePo.getExceptionAgrNum());
        targetPo.setExceptionConnNum(sourcePo.getExceptionConnNum());
        targetPo.setPayType(sourcePo.getPayType());
        if (FscPayConfigPayType.YF_RATIO.getCode().equals(sourcePo.getPayType())) {
            targetPo.setDownPaymentRatio(sourcePo.getDownPaymentRatio());
            targetPo.setCheckPaymentRatio(sourcePo.getCheckPaymentRatio());
        }
        if (FscPayConfigPayType.XY.getCode().equals(sourcePo.getPayType()) || FscPayConfigPayType.ZQ.getCode().equals(sourcePo.getPayType())) {
            if (!FscPayConfigBusiType.AGR_DW.getCode().equals(sourcePo.getPayBusiType())) {
                targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
                targetPo.setPaymentDays(sourcePo.getPaymentDays());
                targetPo.setDelayDays(sourcePo.getDelayDays());
            }
            targetPo.setCreditAmount(sourcePo.getCreditAmount());
            targetPo.setUsedAmount(sourcePo.getUsedAmount());
            targetPo.setBalanceAmount(sourcePo.getBalanceAmount());
            targetPo.setUsedWarningAmount(sourcePo.getUsedWarningAmount());
            targetPo.setOverdueStartAmount(sourcePo.getOverdueStartAmount());
            targetPo.setOverdueWarningRatio(sourcePo.getOverdueWarningRatio());
            targetPo.setOverdueControlRatio(sourcePo.getOverdueControlRatio());
            targetPo.setOverdueRecoveryRatio(sourcePo.getOverdueRecoveryRatio());
            targetPo.setOverdueIndexRatio(sourcePo.getOverdueIndexRatio());
            targetPo.setOverdueWarningIndex(sourcePo.getOverdueWarningIndex());
            targetPo.setOverdueControlIndex(sourcePo.getOverdueControlIndex());
            targetPo.setOverdueRecoveryIndex(sourcePo.getOverdueRecoveryIndex());
            targetPo.setCurrentOrgControlStatus(sourcePo.getCurrentOrgControlStatus());
            targetPo.setCurrentOrgControlTag(sourcePo.getCurrentOrgControlTag());
            targetPo.setCurrentOrgWarningTag(sourcePo.getCurrentOrgWarningTag());
            targetPo.setCurrentOverdueRatio(sourcePo.getCurrentOverdueRatio());
            targetPo.setCurrentOverdueAmount(sourcePo.getCurrentOverdueAmount());
            targetPo.setCurrentPenaltyAmount(sourcePo.getCurrentPenaltyAmount());
            targetPo.setCurrentOverdueIndex(sourcePo.getCurrentOverdueIndex());
        }
        if (FscPayConfigType.EXT_ORG.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayOrgId(sourcePo.getPayOrgId());
            targetPo.setPayOrgName(sourcePo.getPayOrgName());
            targetPo.setPayOrgPath(sourcePo.getPayOrgPath());
            targetPo.setPayUserId(sourcePo.getPayUserId());
            targetPo.setPayUserName(sourcePo.getPayUserName());
        }
        if (FscPayConfigType.EXT_AGR.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayAgrName(sourcePo.getPayAgrName());
            targetPo.setPayAgrNo(sourcePo.getPayAgrNo());
            targetPo.setPayAgrId(sourcePo.getPayAgrId());
            targetPo.setPayAgrEcpNo(sourcePo.getPayAgrEcpNo());
            targetPo.setPayAgrOrgNo(sourcePo.getPayAgrOrgNo());
            targetPo.setPayAgrSupName(sourcePo.getPayAgrSupName());
            targetPo.setPayAgrSupId(sourcePo.getPayAgrSupId());
            targetPo.setPayAgrProName(sourcePo.getPayAgrProName());
            targetPo.setPayAgrProId(sourcePo.getPayAgrProId());
            targetPo.setAgreementType(sourcePo.getAgreementType());
            targetPo.setAgreementTypeStr(sourcePo.getAgreementTypeStr());
            targetPo.setAgreementVariety(sourcePo.getAgreementVariety());
            targetPo.setAgreementVarietyStr(sourcePo.getAgreementVarietyStr());
        }
        if (FscPayConfigType.EXT_CONN.getCode().equals(sourcePo.getPayConfigType())) {
            targetPo.setPayNodeRule(sourcePo.getPayNodeRule());
            targetPo.setPaymentDays(sourcePo.getPaymentDays());
            targetPo.setDelayDays(sourcePo.getDelayDays());
            targetPo.setPayContractName(sourcePo.getPayContractName());
            targetPo.setPayContractNo(sourcePo.getPayContractNo());
            targetPo.setPayContractId(sourcePo.getPayContractId());
            targetPo.setPayContractSignOrgId(sourcePo.getPayContractSignOrgId());
            targetPo.setPayContractSignOrgName(sourcePo.getPayContractSignOrgName());
        }
        targetPo.setCreateTime(sourcePo.getCreateTime());
        targetPo.setCreateUserId(sourcePo.getCreateUserId());
        targetPo.setCreateUserName(sourcePo.getCreateUserName());
        targetPo.setUpdateTime(sourcePo.getUpdateTime());
        targetPo.setUpdateUserId(sourcePo.getUpdateUserId());
        targetPo.setUpdateUserName(sourcePo.getUpdateUserName());
        targetPo.setRemark(sourcePo.getRemark());
        targetPo.setStatus(sourcePo.getStatus());
        targetPo.setDeleteFlag(sourcePo.getDeleteFlag());
    }

    private String getChangeField(FscPayConfigHisPO fscPayConfigHisOld, FscPayConfigHisPO fscPayConfigHisNew) {
        ArrayList changeField = new ArrayList();
        return JSON.toJSONString(changeField);
    }

    private void updateDefaultPayConfig(String operationType, FscPayConfigPO oldPo, FscPayConfigPO fscPayConfigMainPo, FscUmcEnterpriseOrgBO fscUmcEnterpriseOrgBo) {
        FscPayConfigPO fscPayConfigDefaultUpdatePo = new FscPayConfigPO();
        BeanUtils.copyProperties((Object)fscPayConfigMainPo, (Object)fscPayConfigDefaultUpdatePo);
        fscPayConfigDefaultUpdatePo.setPayConfigId(oldPo.getPayConfigId());
        fscPayConfigDefaultUpdatePo.setParentConfigId(fscPayConfigMainPo.getPayConfigId());
        String payConfigType = Optional.ofNullable(oldPo.getPayConfigType()).orElse(FscPayConfigType.DEF.getCode());
        fscPayConfigDefaultUpdatePo.setPayConfigType(payConfigType);
        fscPayConfigDefaultUpdatePo.setPayOrgId(fscUmcEnterpriseOrgBo.getOrgId());
        fscPayConfigDefaultUpdatePo.setPayOrgName(fscUmcEnterpriseOrgBo.getOrgName());
        fscPayConfigDefaultUpdatePo.setPayOrgPath(fscUmcEnterpriseOrgBo.getOrgTreePath());
        fscPayConfigDefaultUpdatePo.setPayUserId(fscUmcEnterpriseOrgBo.getUserId());
        fscPayConfigDefaultUpdatePo.setPayUserName(fscUmcEnterpriseOrgBo.getUsername());
        fscPayConfigDefaultUpdatePo.setPayAllowExceptionFlag(oldPo.getPayAllowExceptionFlag());
        fscPayConfigDefaultUpdatePo.setExceptionOrgNum(oldPo.getExceptionOrgNum());
        fscPayConfigDefaultUpdatePo.setExceptionAgrNum(oldPo.getExceptionAgrNum());
        fscPayConfigDefaultUpdatePo.setExceptionConnNum(oldPo.getExceptionConnNum());
        if (FscPayConfigPayType.ZQ.getCode().equals(fscPayConfigMainPo.getPayType()) || FscPayConfigPayType.XY.getCode().equals(fscPayConfigMainPo.getPayType())) {
            fscPayConfigDefaultUpdatePo.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
        } else {
            fscPayConfigDefaultUpdatePo.setPayUsedPeriodFlag(oldPo.getPayUsedPeriodFlag());
        }
        BigDecimal creditAmount = Optional.ofNullable(fscPayConfigMainPo.getCreditAmount()).orElse(Optional.ofNullable(oldPo.getCreditAmount()).orElse(BigDecimal.ZERO));
        fscPayConfigDefaultUpdatePo.setCreditAmount(creditAmount);
        fscPayConfigDefaultUpdatePo.setUsedAmount(Optional.ofNullable(oldPo.getUsedAmount()).orElse(BigDecimal.ZERO));
        BigDecimal balanceAmount = fscPayConfigDefaultUpdatePo.getCreditAmount().subtract(fscPayConfigDefaultUpdatePo.getUsedAmount());
        fscPayConfigDefaultUpdatePo.setBalanceAmount(balanceAmount);
        String controlStatus = Optional.ofNullable(oldPo.getCurrentOrgControlStatus()).orElse(FscPayConfigControlStatus.NORMAL.getCode());
        fscPayConfigDefaultUpdatePo.setCurrentOrgControlStatus(controlStatus);
        fscPayConfigDefaultUpdatePo.setCurrentOrgControlTag(oldPo.getCurrentOrgControlTag());
        fscPayConfigDefaultUpdatePo.setCurrentOrgWarningTag(oldPo.getCurrentOrgWarningTag());
        fscPayConfigDefaultUpdatePo.setCurrentOverdueRatio(oldPo.getCurrentOverdueRatio());
        fscPayConfigDefaultUpdatePo.setCurrentOverdueAmount(oldPo.getCurrentOverdueAmount());
        fscPayConfigDefaultUpdatePo.setCurrentPenaltyAmount(oldPo.getCurrentPenaltyAmount());
        fscPayConfigDefaultUpdatePo.setCurrentOverdueIndex(oldPo.getCurrentOverdueIndex());
        fscPayConfigDefaultUpdatePo.setCreateTime(oldPo.getCreateTime());
        fscPayConfigDefaultUpdatePo.setCreateUserId(oldPo.getCreateUserId());
        fscPayConfigDefaultUpdatePo.setCreateUserName(oldPo.getPayUserName());
        if ("1".equals(operationType)) {
            fscPayConfigDefaultUpdatePo.setUpdateTime(fscPayConfigMainPo.getCreateTime());
            fscPayConfigDefaultUpdatePo.setUpdateUserId(fscPayConfigMainPo.getCreateUserId());
            fscPayConfigDefaultUpdatePo.setUpdateUserName(fscPayConfigMainPo.getCreateUserName());
        } else if ("2".equals(operationType)) {
            fscPayConfigDefaultUpdatePo.setUpdateTime(fscPayConfigMainPo.getUpdateTime());
            fscPayConfigDefaultUpdatePo.setUpdateUserId(fscPayConfigMainPo.getUpdateUserId());
            fscPayConfigDefaultUpdatePo.setUpdateUserName(fscPayConfigMainPo.getUpdateUserName());
        }
        fscPayConfigDefaultUpdatePo.setDeleteFlag(YesOrNo.NO.getCode());
        this.fscPayConfigMapper.updateById(fscPayConfigDefaultUpdatePo);
    }

    private FscPayConfigPO insertDefaultPayConfig(String operationType, FscPayConfigPO fscPayConfigMainPo, FscUmcEnterpriseOrgBO fscUmcEnterpriseOrgBo) {
        FscPayConfigPO fscPayConfigInsert = new FscPayConfigPO();
        fscPayConfigInsert.setPayConfigId(Sequence.getInstance().nextId());
        fscPayConfigInsert.setParentConfigId(fscPayConfigMainPo.getPayConfigId());
        fscPayConfigInsert.setVersionNo(fscPayConfigMainPo.getVersionNo());
        fscPayConfigInsert.setPayBusiType(fscPayConfigMainPo.getPayBusiType());
        fscPayConfigInsert.setPaySubClass(fscPayConfigMainPo.getPaySubClass());
        fscPayConfigInsert.setPaySubType(fscPayConfigMainPo.getPaySubType());
        fscPayConfigInsert.setPayConfigMode(fscPayConfigMainPo.getPayConfigMode());
        fscPayConfigInsert.setPayConfigType(FscPayConfigType.DEF.getCode());
        fscPayConfigInsert.setPayUsedPeriodFlag(fscPayConfigMainPo.getPayUsedPeriodFlag());
        if (FscPayConfigPayType.ZQ.getCode().equals(fscPayConfigMainPo.getPayType()) || FscPayConfigPayType.XY.getCode().equals(fscPayConfigMainPo.getPayType())) {
            fscPayConfigInsert.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
        }
        fscPayConfigInsert.setPayOrgId(fscUmcEnterpriseOrgBo.getOrgId());
        fscPayConfigInsert.setPayOrgName(fscUmcEnterpriseOrgBo.getOrgName());
        fscPayConfigInsert.setPayOrgPath(fscUmcEnterpriseOrgBo.getOrgTreePath());
        fscPayConfigInsert.setPayUserId(fscUmcEnterpriseOrgBo.getUserId());
        fscPayConfigInsert.setPayUserName(fscUmcEnterpriseOrgBo.getUsername());
        fscPayConfigInsert.setPayAllowExceptionFlag(YesOrNo.NO.getCode());
        fscPayConfigInsert.setExceptionOrgNum(0);
        fscPayConfigInsert.setExceptionAgrNum(0);
        fscPayConfigInsert.setExceptionConnNum(0);
        fscPayConfigInsert.setPayType(fscPayConfigMainPo.getPayType());
        fscPayConfigInsert.setDownPaymentRatio(fscPayConfigMainPo.getDownPaymentRatio());
        fscPayConfigInsert.setCheckPaymentRatio(fscPayConfigMainPo.getCheckPaymentRatio());
        fscPayConfigInsert.setPayNodeRule(fscPayConfigMainPo.getPayNodeRule());
        fscPayConfigInsert.setPaymentDays(fscPayConfigMainPo.getPaymentDays());
        fscPayConfigInsert.setDelayDays(fscPayConfigMainPo.getDelayDays());
        fscPayConfigInsert.setCreditAmount(fscPayConfigMainPo.getCreditAmount());
        fscPayConfigInsert.setUsedAmount(fscPayConfigMainPo.getUsedAmount());
        fscPayConfigInsert.setBalanceAmount(fscPayConfigMainPo.getBalanceAmount());
        if (fscPayConfigMainPo.getCreditAmount() != null) {
            fscPayConfigInsert.setUsedAmount(Optional.ofNullable(fscPayConfigMainPo.getUsedAmount()).orElse(BigDecimal.ZERO));
            fscPayConfigInsert.setBalanceAmount(fscPayConfigInsert.getCreditAmount().subtract(fscPayConfigInsert.getUsedAmount()));
        }
        fscPayConfigInsert.setUsedWarningAmount(fscPayConfigMainPo.getUsedWarningAmount());
        fscPayConfigInsert.setOverdueStartAmount(fscPayConfigMainPo.getOverdueStartAmount());
        fscPayConfigInsert.setOverdueWarningRatio(fscPayConfigMainPo.getOverdueWarningRatio());
        fscPayConfigInsert.setOverdueControlRatio(fscPayConfigMainPo.getOverdueControlRatio());
        fscPayConfigInsert.setOverdueRecoveryRatio(fscPayConfigMainPo.getOverdueRecoveryRatio());
        fscPayConfigInsert.setOverdueIndexRatio(fscPayConfigMainPo.getOverdueIndexRatio());
        fscPayConfigInsert.setOverdueWarningIndex(fscPayConfigMainPo.getOverdueWarningIndex());
        fscPayConfigInsert.setOverdueControlIndex(fscPayConfigMainPo.getOverdueControlIndex());
        fscPayConfigInsert.setOverdueRecoveryIndex(fscPayConfigMainPo.getOverdueRecoveryIndex());
        fscPayConfigInsert.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
        fscPayConfigInsert.setCurrentOrgControlTag(JSON.toJSONString(new ArrayList()));
        fscPayConfigInsert.setCurrentOrgWarningTag(JSON.toJSONString(new ArrayList()));
        fscPayConfigInsert.setCurrentOverdueRatio(fscPayConfigMainPo.getCurrentOverdueRatio());
        fscPayConfigInsert.setCurrentOverdueAmount(fscPayConfigMainPo.getCurrentOverdueAmount());
        fscPayConfigInsert.setCurrentPenaltyAmount(fscPayConfigMainPo.getCurrentPenaltyAmount());
        fscPayConfigInsert.setCurrentOverdueIndex(fscPayConfigMainPo.getCurrentOverdueIndex());
        if ("1".equals(operationType)) {
            fscPayConfigInsert.setCreateTime(fscPayConfigMainPo.getCreateTime());
            fscPayConfigInsert.setCreateUserId(fscPayConfigMainPo.getCreateUserId());
            fscPayConfigInsert.setCreateUserName(fscPayConfigMainPo.getCreateUserName());
        } else if ("2".equals(operationType)) {
            fscPayConfigInsert.setCreateTime(fscPayConfigMainPo.getUpdateTime());
            fscPayConfigInsert.setCreateUserId(fscPayConfigMainPo.getUpdateUserId());
            fscPayConfigInsert.setCreateUserName(fscPayConfigMainPo.getUpdateUserName());
        }
        fscPayConfigInsert.setRemark("");
        fscPayConfigInsert.setStatus(fscPayConfigMainPo.getStatus());
        fscPayConfigInsert.setDeleteFlag(fscPayConfigMainPo.getDeleteFlag());
        this.fscPayConfigMapper.insert(fscPayConfigInsert);
        return fscPayConfigInsert;
    }

    private FscPayConfigPO initInsertData(FscPayConfigSaveBusiReqBO reqBo) {
        FscPayConfigPO fscPayConfigPo = new FscPayConfigPO();
        fscPayConfigPo.setPayConfigId(Sequence.getInstance().nextId());
        fscPayConfigPo.setParentConfigId(0L);
        fscPayConfigPo.setVersionNo(this.getMaxVersionNo(reqBo));
        fscPayConfigPo.setPayBusiType(reqBo.getPayBusiType());
        fscPayConfigPo.setPaySubClass(reqBo.getPaySubClass());
        fscPayConfigPo.setPaySubType(reqBo.getPaySubType());
        fscPayConfigPo.setPayConfigMode(reqBo.getPayConfigMode());
        fscPayConfigPo.setPayConfigType(FscPayConfigType.MAIN.getCode());
        if (FscPayConfigPayType.ZQ.getCode().equals(reqBo.getPayType()) || FscPayConfigPayType.XY.getCode().equals(reqBo.getPaySubType())) {
            fscPayConfigPo.setPayUsedPeriodFlag(YesOrNo.YES.getCode());
        } else {
            fscPayConfigPo.setPayUsedPeriodFlag(YesOrNo.NO.getCode());
        }
        fscPayConfigPo.setPayOrgId(null);
        fscPayConfigPo.setPayOrgName(null);
        fscPayConfigPo.setPayOrgPath(null);
        fscPayConfigPo.setPayUserId(null);
        fscPayConfigPo.setPayUserName(null);
        fscPayConfigPo.setPayAllowExceptionFlag(YesOrNo.NO.getCode());
        fscPayConfigPo.setExceptionOrgNum(0);
        fscPayConfigPo.setExceptionAgrNum(0);
        fscPayConfigPo.setExceptionConnNum(0);
        fscPayConfigPo.setPayType(reqBo.getPayType());
        fscPayConfigPo.setDownPaymentRatio(reqBo.getDownPaymentRatio());
        fscPayConfigPo.setCheckPaymentRatio(reqBo.getCheckPaymentRatio());
        fscPayConfigPo.setPayNodeRule(reqBo.getPayNodeRule());
        fscPayConfigPo.setPaymentDays(reqBo.getPaymentDays());
        fscPayConfigPo.setDelayDays(reqBo.getDelayDays());
        fscPayConfigPo.setCreditAmount(reqBo.getCreditAmount());
        fscPayConfigPo.setUsedAmount(BigDecimal.ZERO);
        fscPayConfigPo.setBalanceAmount(reqBo.getCreditAmount());
        fscPayConfigPo.setUsedWarningAmount(reqBo.getUsedWarningAmount());
        fscPayConfigPo.setOverdueStartAmount(reqBo.getOverdueStartAmount());
        fscPayConfigPo.setOverdueWarningRatio(reqBo.getOverdueWarningRatio());
        fscPayConfigPo.setOverdueControlRatio(reqBo.getOverdueControlRatio());
        fscPayConfigPo.setOverdueRecoveryRatio(reqBo.getOverdueRecoveryRatio());
        fscPayConfigPo.setOverdueIndexRatio(reqBo.getOverdueIndexRatio());
        fscPayConfigPo.setOverdueWarningIndex(reqBo.getOverdueWarningIndex());
        fscPayConfigPo.setOverdueControlIndex(reqBo.getOverdueControlIndex());
        fscPayConfigPo.setOverdueRecoveryIndex(reqBo.getOverdueRecoveryIndex());
        fscPayConfigPo.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
        fscPayConfigPo.setCurrentOrgControlTag(null);
        fscPayConfigPo.setCurrentOrgWarningTag(null);
        fscPayConfigPo.setCurrentOverdueRatio(null);
        fscPayConfigPo.setCurrentOverdueAmount(null);
        fscPayConfigPo.setCurrentPenaltyAmount(null);
        fscPayConfigPo.setCurrentOverdueIndex(null);
        fscPayConfigPo.setPayAgrName(null);
        fscPayConfigPo.setPayAgrNo(null);
        fscPayConfigPo.setPayAgrId(null);
        fscPayConfigPo.setPayAgrEcpNo(null);
        fscPayConfigPo.setPayAgrOrgNo(null);
        fscPayConfigPo.setPayAgrSupName(null);
        fscPayConfigPo.setPayAgrSupId(null);
        fscPayConfigPo.setPayAgrProName(null);
        fscPayConfigPo.setPayAgrProId(null);
        fscPayConfigPo.setPayContractName(null);
        fscPayConfigPo.setPayContractNo(null);
        fscPayConfigPo.setPayContractId(null);
        fscPayConfigPo.setPayContractSignOrgId(null);
        fscPayConfigPo.setPayContractSignOrgName(null);
        fscPayConfigPo.setCreateTime(new Date());
        fscPayConfigPo.setCreateUserId(reqBo.getUserId());
        fscPayConfigPo.setCreateUserName(reqBo.getName());
        fscPayConfigPo.setUpdateUserId(reqBo.getUserId());
        fscPayConfigPo.setUpdateUserName(reqBo.getName());
        fscPayConfigPo.setUpdateTime(new Date());
        fscPayConfigPo.setRemark("");
        fscPayConfigPo.setStatus(FscPayConfigStatus.UPDATING.getCode());
        fscPayConfigPo.setDeleteFlag(YesOrNo.NO.getCode());
        return fscPayConfigPo;
    }

    private Long getMaxVersionNo(FscPayConfigSaveBusiReqBO reqBo) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setPayBusiType(reqBo.getPayBusiType());
        fscPayConfigQry.setPaySubClass(reqBo.getPaySubClass());
        fscPayConfigQry.setPaySubType(reqBo.getPaySubType());
        fscPayConfigQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
        FscPayConfigPO modelBy = this.fscPayConfigMapper.getMaxVersionNo(fscPayConfigQry);
        return modelBy.getVersionNo() + 1L;
    }

    private void parameterVerification(FscPayConfigSaveBusiReqBO reqBo) {
        ValUtil.isEmpty((Object)reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getPayBusiType()).exception("\u5165\u53c2[payBusiType]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigBusiType busiType = FscPayConfigBusiType.instance((String)reqBo.getPayBusiType());
        ValUtil.isEmpty(busiType).exception("\u5165\u53c2[payBusiType]\u9519\u8bef\u503c");
        ValUtil.isBlank(reqBo.getPaySubClass()).exception("\u5165\u53c2[paySubClass]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigSubClass subClass = FscPayConfigSubClass.instance((String)reqBo.getPaySubClass());
        ValUtil.isEmpty(subClass).exception("\u5165\u53c2[paySubClass]\u503c\u9519\u8bef");
        ValUtil.isBlank(reqBo.getPaySubType()).exception("\u5165\u53c2[paySubType]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigSubType subType = FscPayConfigSubType.instance((String)reqBo.getPaySubType());
        ValUtil.isEmpty(subType).exception("\u5165\u53c2[paySubType]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isBlank(reqBo.getPayType()).exception("\u5165\u53c2[payType]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigPayType payType = FscPayConfigPayType.instance((String)reqBo.getPayType());
        ValUtil.isEmpty(payType).exception("\u5165\u53c2[payType]\u9519\u8bef\u503c");
        List<String> combination = Arrays.asList("0010", "0012", "0110", "0112", "0103", "1011", "1103", "1111", "2011", "2111", "3012", "3112", "6013", "6103", "6113", "8010", "8012", "8103", "8110", "8112");
        String reqComb = reqBo.getPayBusiType() + reqBo.getPaySubClass() + reqBo.getPaySubType() + reqBo.getPayType();
        if (!combination.contains(reqComb)) {
            log.error("\u7ec4\u5408\u503c\uff1a{}", (Object)reqComb);
            throw new PfscExtBusinessException("18000", "\u9519\u8bef\u7f16\u7801\uff1a" + reqComb + ",\u8bf7\u52ff\u7be1\u6539\u5165\u53c2\u503c");
        }
        BigDecimal hundred = new BigDecimal("100");
        if (FscPayConfigPayType.YF_RATIO.getCode().equals(reqBo.getPayType())) {
            ValUtil.isEmpty(reqBo.getDownPaymentRatio()).exception("\u5165\u53c2[downPaymentRatio]\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(reqBo.getCheckPaymentRatio()).exception("\u5165\u53c2[checkPaymentRatio]\u4e0d\u80fd\u4e3a\u7a7a");
            if (reqBo.getDownPaymentRatio().add(reqBo.getCheckPaymentRatio()).compareTo(hundred) != 0) {
                throw new PfscExtBusinessException("18000", "\u9884\u4ed8\u6b3e\u6bd4\u4f8b\u4e0e\u9a8c\u6536\u6b3e\u6bd4\u4f8b\u548c\u4e0d\u4e3a100%");
            }
        } else if (FscPayConfigPayType.XY.getCode().equals(reqBo.getPayType())) {
            if (FscPayConfigBusiType.AGR_PT.getCode().equals(reqBo.getPayBusiType())) {
                ValUtil.isEmpty(reqBo.getPayNodeRule()).exception("\u5165\u53c2[payNodeRule]\u4e0d\u80fd\u4e3a\u7a7a");
                ValUtil.isEmpty(reqBo.getPaymentDays()).exception("\u5165\u53c2[paymentDays]\u4e0d\u80fd\u4e3a\u7a7a");
                ValUtil.isEmpty(reqBo.getDelayDays()).exception("\u5165\u53c2[delayDays]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.creditParameterVerification(reqBo);
        } else if (FscPayConfigPayType.ZQ.getCode().equals(reqBo.getPayType())) {
            ValUtil.isEmpty(reqBo.getPayNodeRule()).exception("\u5165\u53c2[payNodeRule]\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(reqBo.getPaymentDays()).exception("\u5165\u53c2[paymentDays]\u4e0d\u80fd\u4e3a\u7a7a");
            ValUtil.isEmpty(reqBo.getDelayDays()).exception("\u5165\u53c2[delayDays]\u4e0d\u80fd\u4e3a\u7a7a");
            this.creditParameterVerification(reqBo);
        } else if (FscPayConfigPayType.YF_ALL.getCode().equals(reqBo.getPayType())) {
            reqBo.setDownPaymentRatio(hundred);
            reqBo.setCheckPaymentRatio(BigDecimal.ZERO);
        }
    }

    private void creditParameterVerification(FscPayConfigSaveBusiReqBO reqBo) {
        ValUtil.isEmpty(reqBo.getCreditAmount()).exception("\u5165\u53c2[creditAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getUsedWarningAmount()).exception("\u5165\u53c2[usedWarningAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOverdueStartAmount()).exception("\u5165\u53c2[overdueStartAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOverdueWarningRatio()).exception("\u5165\u53c2[overdueWarningRatio]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOverdueControlRatio()).exception("\u5165\u53c2[overdueControlRatio]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOverdueRecoveryRatio()).exception("\u5165\u53c2[overdueRecoveryRatio]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOverdueIndexRatio()).exception("\u5165\u53c2[overdueIndexRatio]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOverdueWarningIndex()).exception("\u5165\u53c2[overdueWarningIndex]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOverdueControlIndex()).exception("\u5165\u53c2[overdueControlIndex]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getOverdueRecoveryIndex()).exception("\u5165\u53c2[overdueRecoveryIndex]\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

