/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.order.extend.bo.order.PebExtPayResultReqBO;
import com.tydic.order.extend.bo.order.PebExtPayResultRspBO;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.pfscext.api.busi.FscPayableCallBackUocService;
import com.tydic.pfscext.api.busi.bo.FscPayableCallBackBO;
import com.tydic.pfscext.api.busi.bo.FscPayableCallBackUocReqBO;
import com.tydic.pfscext.api.busi.bo.FscPayableCallBackUocRspBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayMethod;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.external.uoc.api.FscPebExtFscPayResultExternalService;
import com.tydic.pfscext.utils.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.FscPayableCallBackUocService"})
public class FscPayableCallBackUocServiceImpl
implements FscPayableCallBackUocService {
    private static final Logger log = LoggerFactory.getLogger(FscPayableCallBackUocServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(FscPayableCallBackUocServiceImpl.class);
    @Value(value="${publicKey}")
    private String publicKey;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private FscPebExtFscPayResultExternalService fscPebExtFscPayResultExternalService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    private static final String SERVICE_NAME_DECODE = "FscPayableCallBackUoc-decode";
    private static final String SERVICE_NAME_ENCRY = "FscPayableCallBackUoc-encry";
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILURE = "FAILURE";
    @Value(value="${PAY_CALL_BACK_NOTIFY_UOC_ENABLE:true}")
    private boolean PAY_CALL_BACK_NOTIFY_UOC_ENABLE;

    @PostMapping(value={"dealCallBack"})
    public FscPayableCallBackUocRspBO dealCallBack(@RequestBody FscPayableCallBackUocReqBO reqBO) {
        FscPayableCallBackUocRspBO rspBO = new FscPayableCallBackUocRspBO();
        String content = PayCenterUtils.deCode((String)reqBO.getContent(), (String)this.publicKey);
        this.saveLog(SERVICE_NAME_ENCRY, JSON.toJSONString((Object)reqBO), null);
        FscPayableCallBackBO fscPayableCallBackBO = (FscPayableCallBackBO)JSON.parseObject((String)content, FscPayableCallBackBO.class);
        if (!SUCCESS.equals(fscPayableCallBackBO.getResultCode())) {
            this.saveLog(SERVICE_NAME_DECODE, content, null);
            return rspBO;
        }
        logger.info("\u4e8c\u6b21\u56de\u8c03\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)fscPayableCallBackBO));
        logger.info(fscPayableCallBackBO.toString());
        String payNo = fscPayableCallBackBO.getOutOrderId().replaceAll("PAYMENT-", "");
        if (PayMethod.ZHCQT_SF.getCode().equals(fscPayableCallBackBO.getPayMethod()) || PayMethod.GYLJR.getCode().equals(fscPayableCallBackBO.getPayMethod())) {
            logger.info("\u8d22\u4f01\u901a\u4e8c\u6b21\u652f\u4ed8\u56de\u8c03\u4e86");
            this.updatePayMethod(fscPayableCallBackBO, payNo);
            return rspBO;
        }
        if (PayMethod.OFFLINE_PAY.getCode().equals(fscPayableCallBackBO.getPayMethod())) {
            return rspBO;
        }
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(payNo);
        if (CollectionUtils.isEmpty(applyDetails)) {
            this.saveLog(SERVICE_NAME_DECODE, content, null);
            return rspBO;
        }
        ArrayList<String> payableNos = new ArrayList<String>(applyDetails.size());
        applyDetails.forEach(applyDetail -> payableNos.add(applyDetail.getPayableNo()));
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListByIds(payableNos);
        if (CollectionUtils.isEmpty(payableDetailPOS)) {
            this.saveLog(SERVICE_NAME_DECODE, content, null);
            return rspBO;
        }
        ApplyPayInfoPO applyPayInfoPO = this.applyPayInfoMapper.getModelById(payNo);
        if (null == applyPayInfoPO) {
            this.saveLog(SERVICE_NAME_DECODE, content, null);
            return rspBO;
        }
        this.updatePayStatus(fscPayableCallBackBO, payNo, payableNos, content);
        if (this.PAY_CALL_BACK_NOTIFY_UOC_ENABLE) {
            this.notifyUoc(content, reqBO, payableNos, rspBO, payableDetailPOS.get(0));
        }
        this.updateBillApplyInfo(payableDetailPOS);
        return rspBO;
    }

    private void updateBillApplyInfo(List<PayableDetailPO> payableDetailPOS) {
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            if (StringUtils.isEmpty((Object)payableDetailPO.getApplyNo())) continue;
            BillApplyInfo billApplyInfo = new BillApplyInfo();
            billApplyInfo.setApplyNo(payableDetailPO.getApplyNo());
            billApplyInfo.setIsPay(2);
            this.billApplyInfoMapper.updateByPrimaryKeySelective(billApplyInfo);
        }
    }

    private void updatePayMethod(FscPayableCallBackBO fscPayableCallBackBO, String payNo) {
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setExtJson(fscPayableCallBackBO.getOutOrderId());
        paymentFlowInfo.setPayType(fscPayableCallBackBO.getPayMethod());
        if (null != fscPayableCallBackBO.getPaymentInsId()) {
            if (PayChannel.PAY_OFFLINE.getCode().equals(fscPayableCallBackBO.getPaymentInsId())) {
                paymentFlowInfo.setPayChannel(PayChannel.PAY_OFFLINE.getCode());
            } else {
                paymentFlowInfo.setPayChannel(fscPayableCallBackBO.getPaymentInsId().toString());
            }
        }
        this.paymentFlowInfoMapper.updateByExtJson(paymentFlowInfo);
        PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.qryPaymentFlowByExtJson(fscPayableCallBackBO.getOutOrderId());
        String[] split = paymentFlowInfo1.getOutOrderId().split("-");
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setOperatorId(null);
        applyPayInfoPO.setPayno(split[1]);
        applyPayInfoPO.setPayMathod(fscPayableCallBackBO.getPayMethod());
        this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
    }

    private void saveLog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private void updatePayStatus(FscPayableCallBackBO fscPayableCallBackBO, String payNo, List<String> payableNos, String content) {
        String payStatus = PayResultStatus.SUCCESS.getCode();
        String payableStatus = PayableStatus.SUCCESS.getCode();
        if (!SUCCESS.equals(fscPayableCallBackBO.getResultCode())) {
            payStatus = PayResultStatus.FAILED.getCode();
            payableStatus = PayableStatus.PENDING.getCode();
        }
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayStatus(payStatus);
        applyPayInfoPO.setPayno(payNo);
        applyPayInfoPO.setPayMathod(fscPayableCallBackBO.getPayMethod());
        applyPayInfoPO.setRemark(fscPayableCallBackBO.getResultMsg());
        if (null != fscPayableCallBackBO.getPaymentInsId()) {
            applyPayInfoPO.setPayChannel(fscPayableCallBackBO.getPaymentInsId().toString());
        }
        applyPayInfoPO.setSsn(fscPayableCallBackBO.getPayNotifyTransId());
        this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
        ApplyDetail applyDetail = new ApplyDetail();
        applyDetail.setApplyNo(payNo);
        applyDetail.setStatus(payStatus);
        this.applyDetailMapper.updateByApplyNo(applyDetail);
        for (String payableNo : payableNos) {
            PayableDetailPO payableDetailPO = new PayableDetailPO();
            payableDetailPO.setPayableNo(payableNo);
            payableDetailPO.setPayableStatus(payableStatus);
            this.payableDetailMapper.updateCallBackResultByNo(payableDetailPO);
        }
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setOutOrderId(fscPayableCallBackBO.getOutOrderId());
        paymentFlowInfo.setPaymentStatus(fscPayableCallBackBO.getResultCode());
        paymentFlowInfo.setPaymentFlowId(fscPayableCallBackBO.getPayNotifyTransId());
        paymentFlowInfo.setPayOrderId(fscPayableCallBackBO.getPayOrderId());
        paymentFlowInfo.setResultJson(content);
        paymentFlowInfo.setPayType(fscPayableCallBackBO.getPayMethod());
        if (null != fscPayableCallBackBO.getPaymentInsId()) {
            if (PayChannel.PAY_OFFLINE.getCode().equals(fscPayableCallBackBO.getPaymentInsId())) {
                paymentFlowInfo.setPayChannel(PayChannel.PAY_OFFLINE.getCode());
            } else {
                paymentFlowInfo.setPayChannel(fscPayableCallBackBO.getPaymentInsId().toString());
            }
        }
        paymentFlowInfo.setPayTime(new Date());
        String tradeTime = fscPayableCallBackBO.getTradeTime();
        if (StringUtils.hasText((String)tradeTime)) {
            try {
                Date payTime = DateUtil.strToDate(tradeTime, "yyyyMMddHHmmss");
                if (payTime != null) {
                    paymentFlowInfo.setPayTime(payTime);
                }
            }
            catch (Exception e) {
                log.error("\u652f\u4ed8\u4e2d\u5fc3\u65f6\u95f4\u8bfb\u53d6\u9519\u8bef\uff1a{}", (Object)tradeTime);
            }
        }
        this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
    }

    private void notifyUoc(String content, FscPayableCallBackUocReqBO reqBO, List<String> payableNos, FscPayableCallBackUocRspBO rspBO, PayableDetailPO payableDetailPO) {
        PebExtPayResultReqBO extPayResultReqBO = (PebExtPayResultReqBO)JSON.parseObject((String)content, PebExtPayResultReqBO.class);
        extPayResultReqBO.setContent(reqBO.getContent());
        extPayResultReqBO.setBusiCode(reqBO.getBusiCode());
        ArrayList<Long> orders = new ArrayList<Long>();
        orders.add(payableDetailPO.getOrderId());
        payableDetailPO.setOrderIdList(orders);
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.querysumAmtByOrderId(payableDetailPO);
        PaymentFlowInfo paymentFlowInfo1 = this.paymentFlowInfoMapper.selectByOrderCodeRefund(payableDetailPO.getPurchaseOrderCode());
        logger.info("\u8ba1\u7b97\u9000\u6b3e" + paymentFlowInfo1);
        extPayResultReqBO.setTotalFee(payableDetailPOS.get(0).getPayableAmt().subtract(paymentFlowInfo1 == null ? BigDecimal.ZERO : paymentFlowInfo1.getOrderAmt()).toString());
        extPayResultReqBO.setPayableNos(payableNos);
        extPayResultReqBO.setPaymentFinishTime(this.getTradeTime(extPayResultReqBO.getTradeTime()));
        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u5165\u53c2 " + extPayResultReqBO);
        PebExtPayResultRspBO pebExtPayResultRspBO = this.fscPebExtFscPayResultExternalService.dealPayResult(extPayResultReqBO);
        logger.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1 \uff1a\u51fa\u53c2 " + pebExtPayResultRspBO);
        if (pebExtPayResultRspBO != null && SUCCESS.equals(pebExtPayResultRspBO.getResultCode())) {
            rspBO.setNotifyResult(SUCCESS);
        } else {
            rspBO.setNotifyResult(FAILURE);
        }
    }

    private Date getTradeTime(String tradeTime) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tradeTime)) {
            try {
                Date payTime = DateUtil.strToDate(tradeTime, "yyyyMMddHHmmss");
                return payTime;
            }
            catch (Exception e) {
                logger.error("\u652f\u4ed8\u4e2d\u5fc3\u65f6\u95f4\u8bfb\u53d6\u9519\u8bef\uff1a{}", (Object)tradeTime);
            }
        }
        return null;
    }
}

