/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.order.pec.ability.bo.UocPenaltyQueryRspBO;
import com.tydic.pfscext.dao.FscPayableDetailOverduePenaltyChangeMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.FscPayableDetailOverduePenaltyChangePO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.uoc.api.FscUocPenaltyQueryExternalService;
import com.tydic.pfscext.external.uoc.bo.FscUocPenaltyQueryExternalReqBO;
import com.tydic.pfscext.external.uoc.bo.FscUocPenaltyQueryExternalRspBO;
import com.tydic.pfscext.service.busi.FscPayableDetailUpdateBusiService;
import com.tydic.pfscext.service.busi.bo.FscPayableDetailUpdateOverduePenaltyBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayableDetailUpdateOverduePenaltyBusiRspBO;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.pfscext.utils.FscRu;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayableDetailUpdateBusiServiceImpl
implements FscPayableDetailUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayableDetailUpdateBusiServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private FscPayableDetailOverduePenaltyChangeMapper fscPayableDetailOverduePenaltyChangeMapper;
    @Autowired
    private FscUocPenaltyQueryExternalService fscUocPenaltyQueryExternalService;

    @Override
    public FscPayableDetailUpdateOverduePenaltyBusiRspBO dealOverduePenaltyUpdate(FscPayableDetailUpdateOverduePenaltyBusiReqBO reqBo) {
        FscPayableDetailUpdateOverduePenaltyBusiRspBO rspBo = FscRu.success(FscPayableDetailUpdateOverduePenaltyBusiRspBO.class);
        String payableNo = reqBo.getPayableNo();
        List<Long> inspectionIds = reqBo.getInspectionIds();
        if (!StringUtils.hasText((String)payableNo)) {
            rspBo.setRespDesc("\u5165\u53c2\u5e94\u4ed8\u5355\u53f7[payableNo]\u4e3a\u7a7a\u4e0d\u5904\u7406");
            return rspBo;
        }
        if (CollectionUtils.isEmpty(inspectionIds)) {
            rspBo.setRespDesc("\u5165\u53c2\u9a8c\u6536\u5355ID\u96c6\u5408[inspectionIds]\u4e3a\u7a7a\u4e0d\u5904\u7406");
            return rspBo;
        }
        PayableDetailPO payableDetailPo = this.payableDetailMapper.getModelById(payableNo);
        if (payableDetailPo == null) {
            rspBo.setRespDesc("\u5e94\u4ed8\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\u4e0d\u5904\u7406");
            return rspBo;
        }
        Date paidDate = payableDetailPo.getPaidDate();
        UocPenaltyQueryRspBO penaltyBo = this.getPenalty(inspectionIds, paidDate);
        if (penaltyBo == null) {
            rspBo.setRespDesc("\u5e94\u4ed8\u8bb0\u5f55\u5bf9\u5e94\u8fdd\u7ea6\u91d1\u548c\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u67e5\u8be2\u4e3a\u7a7a\u4e0d\u5904\u7406");
            return rspBo;
        }
        if (penaltyBo.getPenalty() == null && penaltyBo.getPaymentDueLatestTime() == null) {
            rspBo.setRespDesc("\u5e94\u4ed8\u8bb0\u5f55\u5bf9\u5e94\u8fdd\u7ea6\u91d1\u548c\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u90fd\u4e3a\u7a7a\u4e0d\u5904\u7406");
            return rspBo;
        }
        if (PayableType.NOTIFICATION.getCode().equals(payableDetailPo.getPayableType().toString()) && penaltyBo.getPaymentDueLatestTime() == null) {
            rspBo.setRespDesc("\u5f00\u7968\u901a\u77e5\u5e94\u4ed8\u8bb0\u5f55\u5bf9\u5e94\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u4e3a\u7a7a;\u4f9b\u5e94\u5546\u6536\u6b3e\u5e94\u4ed8\u4e0d\u6536\u53d6\u8fdd\u7ea6\u91d1,\u4e0d\u5904\u7406");
            return rspBo;
        }
        BigDecimal penalty = penaltyBo.getPenalty();
        Date newPaidDate = penaltyBo.getPaymentDueLatestTime();
        BigDecimal payableAmt = payableDetailPo.getPayableAmt();
        BigDecimal overduePenalty = payableDetailPo.getOverduePenalty();
        BigDecimal subtract = penalty.subtract(Optional.ofNullable(overduePenalty).orElse(BigDecimal.ZERO));
        if (PayableType.NOTIFICATION.getCode().equals(payableDetailPo.getPayableType().toString())) {
            subtract = BigDecimal.ZERO;
        }
        BigDecimal curPayableAmt = payableAmt.add(subtract);
        log.error("\u8fdd\u7ea6\u91d1\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u5f00\u7968\u901a\u77e5.\u7533\u8bf7\u5355\u53f7:{}.\u901a\u77e5\u5355\u53f7\uff1a{}.\u5e94\u4ed8\u5355:{}.\u8ba2\u5355\u91d1\u989d\uff1a{}.\u5e94\u4ed8\u91d1\u989d\uff1a{}.\u5386\u53f2\u8fdd\u7ea6\u91d1\uff1a{},\u5f53\u524d\u8fdd\u7ea6\u91d1\uff1a{},\u5dee\u989d\uff1a{}.\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f:{}", new Object[]{payableDetailPo.getApplyNo(), payableDetailPo.getNotificationNo(), payableDetailPo.getPayableNo(), payableDetailPo.getOrderAmt(), payableAmt, overduePenalty, penalty, subtract, newPaidDate});
        String changeReason = StrUtil.format((CharSequence)"\u5e94\u4ed8\u5355[{}]\u8fdd\u7ea6\u91d1\u6700\u8fdf\u5e94\u4ed8\u65e5\u671f\u53d8\u66f4", (Object[])new Object[]{payableDetailPo.getPayableNo()});
        PayableDetailPO payableDetailUpdate = new PayableDetailPO();
        payableDetailUpdate.setPayableNo(payableDetailPo.getPayableNo());
        if (PayableType.NOTIFICATION.getCode().equals(payableDetailPo.getPayableType().toString())) {
            payableDetailUpdate.setOverduePenalty(BigDecimal.ZERO);
        } else {
            payableDetailUpdate.setPayableAmt(curPayableAmt);
            payableDetailUpdate.setOverduePenalty(penalty);
        }
        payableDetailUpdate.setPaidDate(newPaidDate);
        int count = this.payableDetailMapper.updateSelective(payableDetailUpdate);
        if (count > 1) {
            throw new PfscExtBusinessException("8888", "\u5e94\u4ed8\u66f4\u65b0\u8fdd\u7ea6\u91d1\u6570\u636e\u5e93\u66f4\u65b0\u5f02\u5e38");
        }
        FscPayableDetailOverduePenaltyChangePO penaltyChangeInsertPo = new FscPayableDetailOverduePenaltyChangePO();
        penaltyChangeInsertPo.setLogId(Sequence.getInstance().nextId());
        penaltyChangeInsertPo.setPayableNo(payableDetailPo.getPayableNo());
        penaltyChangeInsertPo.setChangeType(subtract.signum() > 0 ? "1" : "2");
        penaltyChangeInsertPo.setPayableAmt(payableDetailPo.getPayableAmt());
        penaltyChangeInsertPo.setOrderAmt(payableDetailPo.getOrderAmt());
        penaltyChangeInsertPo.setOverduePenalty(payableDetailPo.getOverduePenalty());
        penaltyChangeInsertPo.setChangeAmt(subtract);
        penaltyChangeInsertPo.setNewPayableAmt(curPayableAmt);
        penaltyChangeInsertPo.setNewOverduePenalty(penalty);
        penaltyChangeInsertPo.setPaidDate(paidDate);
        penaltyChangeInsertPo.setNewPaidDate(newPaidDate);
        penaltyChangeInsertPo.setChangeReason(changeReason);
        penaltyChangeInsertPo.setUpdateTime(new Date());
        penaltyChangeInsertPo.setOrderCode(payableDetailPo.getPurchaseOrderCode());
        this.fscPayableDetailOverduePenaltyChangeMapper.insert(penaltyChangeInsertPo);
        return rspBo;
    }

    private UocPenaltyQueryRspBO getPenalty(List<Long> inspectionIds, Date paidDate) {
        UocPenaltyQueryRspBO penaltyBo = null;
        if (!CollectionUtils.isEmpty(inspectionIds)) {
            FscUocPenaltyQueryExternalReqBO uocReqBo = new FscUocPenaltyQueryExternalReqBO();
            uocReqBo.setInspectionVoucherIdList(inspectionIds);
            FscUocPenaltyQueryExternalRspBO uocRspBo = this.fscUocPenaltyQueryExternalService.queryPenalty(uocReqBo);
            if (!CollectionUtils.isEmpty((Collection)uocRspBo.getUocPenaltyQueryRspBOList())) {
                penaltyBo = new UocPenaltyQueryRspBO();
                BigDecimal penalty = uocRspBo.getUocPenaltyQueryRspBOList().stream().map(UocPenaltyQueryRspBO::getPenalty).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                penaltyBo.setPenalty(penalty);
                Optional<Date> optionalDate = uocRspBo.getUocPenaltyQueryRspBOList().stream().map(UocPenaltyQueryRspBO::getPaymentDueLatestTime).filter(Objects::nonNull).min(Comparator.comparing(Date::getTime));
                if (optionalDate.isPresent()) {
                    String pattern = "yyyy-MM-dd 00:00:00";
                    Date paymentTime = DateUtil.strToDateLong(DateUtil.dateToStr(optionalDate.get(), pattern));
                    log.debug("\u903e\u671f\u65f6\u95f4\uff1a{}", (Object)paymentTime);
                    if (paymentTime != null) {
                        if (paidDate == null) {
                            penaltyBo.setPaymentDueLatestTime(paymentTime);
                        } else if (paidDate.getTime() > paymentTime.getTime()) {
                            penaltyBo.setPaymentDueLatestTime(paymentTime);
                        }
                    }
                }
            }
        }
        return penaltyBo;
    }
}

