/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.uoc.constant.BusinessException;
import com.tydic.pfscext.api.busi.FscQryOutPushMsgBusiService;
import com.tydic.pfscext.api.busi.bo.FscQryOutPushMsgReqBO;
import com.tydic.pfscext.api.busi.bo.FscQryOutPushMsgRspBO;
import com.tydic.pfscext.api.busi.bo.MsgResultBO;
import com.tydic.pfscext.dao.MsgPoolMapper;
import com.tydic.pfscext.dao.po.MsgPool;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscQryOutPushMsgBusiServiceImpl
implements FscQryOutPushMsgBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscQryOutPushMsgBusiServiceImpl.class);
    @Autowired
    private MsgPoolMapper msgPoolMapper;

    public FscQryOutPushMsgRspBO createAndQryOutPushMsg(FscQryOutPushMsgReqBO reqBO) {
        FscQryOutPushMsgRspBO rspBO = new FscQryOutPushMsgRspBO();
        ArrayList<String> list = new ArrayList<String>();
        this.insertOutPushMsg(reqBO.getResultVOlist(), reqBO.getGoodsSupplierId(), list, reqBO.getType());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63a8\u9001\u6d88\u606f\u5904\u7406\u6210\u529f");
        rspBO.setList(list);
        return rspBO;
    }

    private void insertOutPushMsg(List<MsgResultBO> resultVOlist, Long supNo, List<String> msgList, String type) {
        for (MsgResultBO resultVO : resultVOlist) {
            if (resultVO.getResult() == null) {
                log.error("=======\u5916\u90e8\u7535\u5546\u672a\u8fd4\u56de\u5177\u4f53\u63a8\u9001\u7ed3\u679c=======");
                continue;
            }
            String orderId = null;
            if (StringUtils.isNotBlank((CharSequence)resultVO.getResult().getMarkId())) {
                orderId = resultVO.getResult().getMarkId();
            }
            MsgPool msgPool = this.assemblyMsgPoolPO(resultVO, supNo);
            this.addMsgPoolAndDelOutPushMsg(msgPool, resultVO, supNo, msgPool.getOrderId(), msgList);
        }
    }

    private MsgPool assemblyMsgPoolPO(MsgResultBO resultVO, Long supNo) {
        MsgPool msgPoolPO = new MsgPool();
        String jsonStr = JSONObject.toJSONString((Object)resultVO);
        msgPoolPO.setSupNo(supNo);
        msgPoolPO.setMsgId(resultVO.getId());
        msgPoolPO.setMsgType(resultVO.getType().toString());
        msgPoolPO.setMsgContent(jsonStr);
        msgPoolPO.setCreateTime(new Date());
        msgPoolPO.setPushTime(resultVO.getTime());
        msgPoolPO.setFailureCount(0);
        msgPoolPO.setRunResult(PecConstant.OUT_MSG_RUN_RESULT.WAIT_RUN);
        msgPoolPO.setOrderId(resultVO.getResult().getMarkId());
        msgPoolPO.setObjId(msgPoolPO.getOrderId());
        msgPoolPO.setObjType(1);
        msgPoolPO.setMsgState(resultVO.getResult().getState().toString());
        msgPoolPO.setReserve1(resultVO.getResult().getRemark());
        return msgPoolPO;
    }

    private void addMsgPoolAndDelOutPushMsg(MsgPool msgPool, MsgResultBO resultVO, Long supNo, String orderId, List<String> msgList) {
        block6: {
            MsgPool checkMsgPoolPo = new MsgPool();
            checkMsgPoolPo.setOrderId(orderId);
            checkMsgPoolPo.setSupNo(supNo);
            checkMsgPoolPo.setMsgId(resultVO.getId());
            try {
                int count = this.msgPoolMapper.getCheckBy(checkMsgPoolPo);
                if (count == 0) {
                    try {
                        int line = this.msgPoolMapper.insert(msgPool);
                        if (line < 1) {
                            log.error("\u6d88\u606f[" + msgPool.getMsgId() + "]\u5165\u5e93\u6d88\u606f\u6c60\u5931\u8d25!");
                            return;
                        }
                        msgList.add(msgPool.getMsgId());
                        break block6;
                    }
                    catch (Exception e) {
                        log.error("\u5916\u90e8\u63a8\u9001\u6d88\u606f\u5165\u5e93\u6d88\u606f\u6c60\u8868\u5f02\u5e38," + e);
                        throw new BusinessException("8888", "\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u4f9b\u5e94\u5546" + supNo + ":" + resultVO.getId() + "\u5165\u5e93\u6d88\u606f\u6c60\u8868\u5f02\u5e38" + e);
                    }
                }
                msgList.add(msgPool.getMsgId());
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u662f\u5426\u5df2\u5165\u5e93\u5f02\u5e38," + e);
                throw new BusinessException("8888", "\u6267\u884c\u5904\u7406\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u4f9b\u5e94\u5546" + supNo + ":" + resultVO.getId() + "\u67e5\u8be2\u6d88\u606f\u6c60\u8868\u5f02\u5e38");
            }
        }
    }
}

