/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.order.extend.ability.order.PebExtPayFscRefundAbilityService;
import com.tydic.order.extend.bo.order.PebExtPayRefundReqBO;
import com.tydic.order.extend.bo.order.PebExtPayRefundRspBO;
import com.tydic.payment.pay.sdk.PayCenterUtils;
import com.tydic.pfscext.api.busi.FscRefundCallBackService;
import com.tydic.pfscext.api.busi.bo.FscRefundCallBackBO;
import com.tydic.pfscext.api.busi.bo.FscRefundCallBackReqBO;
import com.tydic.pfscext.api.busi.bo.FscRefundCallBackRspBO;
import com.tydic.pfscext.api.busi.bo.PaymentFlowInfoExtJsonBO;
import com.tydic.pfscext.api.notify.SendRefundResultService;
import com.tydic.pfscext.api.notify.bo.SendRefundResultReq;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.PaymentFlowInfoMapper;
import com.tydic.pfscext.dao.PaymentLogMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ApplyPayInfoPO;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.PaymentFlowInfo;
import com.tydic.pfscext.dao.po.PaymentLog;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.FscRefundCallBackService"})
public class FscRefundCallBackServiceImpl
implements FscRefundCallBackService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscRefundCallBackServiceImpl.class);
    @Value(value="${publicKey}")
    private String publicKey;
    @Autowired
    private PaymentFlowInfoMapper paymentFlowInfoMapper;
    @Autowired
    private PaymentLogMapper paymentLogMapper;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    PebExtPayFscRefundAbilityService pebExtPayFscRefundAbilityService;
    private static final String SERVICE_NAME_DECODE = "FscRefundCallBackUoc-decode";
    private static final String SERVICE_NAME_ENCRY = "FscRefundCallBackUoc-encry";
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILURE = "FAILURE";
    @Value(value="${REFUND_CALL_BACK_NOTIFY_UOC_ENABLE:true}")
    private boolean PAY_CALL_BACK_NOTIFY_UOC_ENABLE;
    @Autowired
    private SendRefundResultService sendRefundResultService;

    @PostMapping(value={"callBack"})
    public FscRefundCallBackRspBO callBack(@RequestBody FscRefundCallBackReqBO reqBO) {
        FscRefundCallBackRspBO rspBO = new FscRefundCallBackRspBO();
        String content = PayCenterUtils.deCode((String)reqBO.getContent(), (String)this.publicKey);
        this.saveLog(SERVICE_NAME_ENCRY, JSON.toJSONString((Object)reqBO), null);
        FscRefundCallBackBO fscRefundCallBackBO = (FscRefundCallBackBO)JSON.parseObject((String)content, FscRefundCallBackBO.class);
        String payNo = fscRefundCallBackBO.getOutOrderId().replaceAll("PAYMENT-", "");
        List<ApplyDetail> applyDetails = this.applyDetailMapper.selectPayableList(payNo);
        ArrayList<String> payableNos = new ArrayList<String>(applyDetails.size());
        applyDetails.forEach(applyDetail -> payableNos.add(applyDetail.getPayableNo()));
        PaymentFlowInfo paymentFlowInfo = this.paymentFlowInfoMapper.selectByOutOrderId(fscRefundCallBackBO.getOutOrderId());
        if (null == paymentFlowInfo || StringUtils.isBlank((CharSequence)paymentFlowInfo.getExtJson())) {
            throw new PfscExtBusinessException("18000", "\u9000\u6b3e\u6d41\u6c34\u4fe1\u606f\u4e3a\u7a7a");
        }
        paymentFlowInfo.setPaymentStatus(SUCCESS);
        paymentFlowInfo.setPayTime(new Date());
        paymentFlowInfo.setPaymentFlowId(fscRefundCallBackBO.getPayNotifyTransId());
        this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
        PaymentFlowInfoExtJsonBO paymentFlowInfoExtJsonBO = (PaymentFlowInfoExtJsonBO)JSON.parseObject((String)paymentFlowInfo.getExtJson(), PaymentFlowInfoExtJsonBO.class);
        PaymentFlowInfo paymentFlowInfos = this.paymentFlowInfoMapper.qryPaymentFlowByRefundOrderId(paymentFlowInfoExtJsonBO.getOutRefundOrderSn());
        rspBO.setResultCode(SUCCESS);
        if (this.PAY_CALL_BACK_NOTIFY_UOC_ENABLE && paymentFlowInfos.getOrderAmt().compareTo(paymentFlowInfoExtJsonBO.getRefundAmt()) == 0) {
            this.notifyUoc(content, reqBO, payableNos, rspBO, paymentFlowInfoExtJsonBO, paymentFlowInfo);
        }
        return rspBO;
    }

    private void saveLog(String serviceName, String reqJson, String rspJson) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            PaymentLog paymentLog = new PaymentLog();
            paymentLog.setServiceName(serviceName);
            paymentLog.setReqJson(reqJson);
            paymentLog.setRspJson(rspJson);
            paymentLog.setCreateDate(new Date());
            this.paymentLogMapper.insert(paymentLog);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(status);
        }
    }

    private void updatePayStatus(FscRefundCallBackBO fscRefundCallBackBO, String payNo, String payableNo, String content) {
        String payStatus = PayResultStatus.SUCCESS.getCode();
        String payableStatus = PayableStatus.SUCCESS.getCode();
        if (!SUCCESS.equals(fscRefundCallBackBO.getResultCode())) {
            payStatus = PayResultStatus.FAILED.getCode();
            payableStatus = PayableStatus.PENDING.getCode();
        }
        ApplyPayInfoPO applyPayInfoPO = new ApplyPayInfoPO();
        applyPayInfoPO.setPayStatus(payStatus);
        applyPayInfoPO.setPayno(payNo);
        applyPayInfoPO.setPayMathod(fscRefundCallBackBO.getPayMethod());
        applyPayInfoPO.setRemark(fscRefundCallBackBO.getResultMsg());
        this.applyPayInfoMapper.updateStatus(applyPayInfoPO);
        ApplyDetail applyDetail = new ApplyDetail();
        applyDetail.setApplyNo(payNo);
        applyDetail.setStatus(payStatus);
        this.applyDetailMapper.updateByApplyNo(applyDetail);
        PayableDetailPO payableDetailPO = new PayableDetailPO();
        payableDetailPO.setPayableNo(payableNo);
        payableDetailPO.setPayableStatus(payableStatus);
        payableDetailPO.setRefundAmt(new BigDecimal(fscRefundCallBackBO.getRealFee()).negate());
        this.payableDetailMapper.updateCallBackRefundResultByNo(payableDetailPO);
        PaymentFlowInfo paymentFlowInfo = new PaymentFlowInfo();
        paymentFlowInfo.setPaymentFlowId(fscRefundCallBackBO.getTransactionsId());
        paymentFlowInfo.setOutOrderId(fscRefundCallBackBO.getOutOrderId());
        paymentFlowInfo.setPayType(fscRefundCallBackBO.getPayMethod());
        paymentFlowInfo.setResultJson(content);
        this.paymentFlowInfoMapper.updateByOutOrderId(paymentFlowInfo);
    }

    private void notifyUoc(String content, FscRefundCallBackReqBO reqBO, List<String> payableNos, FscRefundCallBackRspBO rspBO, PaymentFlowInfoExtJsonBO paymentFlowInfoExtJsonBO, PaymentFlowInfo paymentFlowInfo) {
        PebExtPayRefundReqBO pebExtPayRefundReqBO = (PebExtPayRefundReqBO)JSON.parseObject((String)content, PebExtPayRefundReqBO.class);
        pebExtPayRefundReqBO.setContent(reqBO.getContent());
        pebExtPayRefundReqBO.setBusiCode(reqBO.getBusiCode());
        pebExtPayRefundReqBO.setPayableNos(payableNos);
        LOGGER.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1\uff1a \u5165\u53c2" + pebExtPayRefundReqBO);
        pebExtPayRefundReqBO.setOutOrderId(paymentFlowInfoExtJsonBO.getOutRefundOrderSn());
        PebExtPayRefundRspBO pebExtPayRefundRspBO = this.pebExtPayFscRefundAbilityService.dealPayResult(pebExtPayRefundReqBO);
        LOGGER.info("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u670d\u52a1\uff1a \u51fa\u53c2" + pebExtPayRefundRspBO);
        if (pebExtPayRefundRspBO != null && SUCCESS.equals(pebExtPayRefundRspBO.getResultCode())) {
            SendRefundResultReq sendRefundResultReq = new SendRefundResultReq();
            sendRefundResultReq.setUserId(paymentFlowInfo.getCreateUserId());
            sendRefundResultReq.setOrderCode(paymentFlowInfo.getOrderCode());
            sendRefundResultReq.setType(Integer.valueOf(1));
            this.sendRefundResultService.send(sendRefundResultReq);
        } else {
            rspBO.setResultCode(FAILURE);
            SendRefundResultReq sendRefundResultReq = new SendRefundResultReq();
            sendRefundResultReq.setUserId(paymentFlowInfo.getCreateUserId());
            sendRefundResultReq.setOrderCode(paymentFlowInfo.getOrderCode());
            sendRefundResultReq.setType(Integer.valueOf(0));
            sendRefundResultReq.setOrderDesc(paymentFlowInfo.getOrderDesc());
            sendRefundResultReq.setPayOrgName(paymentFlowInfo.getPayName());
            sendRefundResultReq.setRecOrgName(paymentFlowInfo.getRecName());
            this.sendRefundResultService.send(sendRefundResultReq);
        }
    }
}

