/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.bo.FscUmcPayConfigAddAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUmcPayConfigAddAbilityRspBO;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscUmcPayConfigAddBusiService;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscUmcPayConfigAddBusiServiceImpl
implements FscUmcPayConfigAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscUmcPayConfigAddBusiServiceImpl.class);
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;

    @Override
    public FscUmcPayConfigAddAbilityRspBO dealAddPayConfig(FscUmcPayConfigAddAbilityReqBO reqBo) {
        ValUtil.isEmpty(reqBo.getExceptId()).exception("\u5165\u53c2[exceptId]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getExceptName()).exception("\u5165\u53c2[exceptName]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getExceptOrgPath()).exception("\u5165\u53c2[exceptOrgPath]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getExceptUserType()).exception("\u5165\u53c2[exceptUserType]\u4e0d\u80fd\u4e3a\u7a7a");
        FscPayConfigPO fscPayConfigMainQry = new FscPayConfigPO();
        if ("1".equals(reqBo.getExceptUserType())) {
            fscPayConfigMainQry.setPaySubClass(FscPayConfigSubClass.OUT.getCode());
            fscPayConfigMainQry.setPaySubType(FscPayConfigSubType.GR.getCode());
        } else if ("2".equals(reqBo.getExceptUserType())) {
            fscPayConfigMainQry.setPaySubClass(FscPayConfigSubClass.OUT.getCode());
            fscPayConfigMainQry.setPaySubType(FscPayConfigSubType.QY.getCode());
        } else if ("3".equals(reqBo.getExceptUserType())) {
            fscPayConfigMainQry.setPaySubClass(FscPayConfigSubClass.IN.getCode());
            fscPayConfigMainQry.setPaySubType(FscPayConfigSubType.GR.getCode());
        } else if ("4".equals(reqBo.getExceptUserType())) {
            fscPayConfigMainQry.setPaySubClass(FscPayConfigSubClass.IN.getCode());
            fscPayConfigMainQry.setPaySubType(FscPayConfigSubType.QY.getCode());
        } else {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2[exceptUserType]\u503c\u9519\u8bef");
        }
        fscPayConfigMainQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
        List<FscPayConfigPO> payConfigMainList = this.fscPayConfigMapper.getList(fscPayConfigMainQry);
        if (CollectionUtils.isEmpty(payConfigMainList)) {
            log.error("\u4f1a\u5458\u65b0\u589e\u91c7\u8d2d\u5355\u4f4d\u540c\u6b65\u7ed3\u7b97\u6388\u4fe1\u670d\u52a1\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u4e3b\u914d\u7f6e");
        } else {
            FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
            fscPayConfigQry.setPayOrgId(reqBo.getExceptId());
            List<FscPayConfigPO> payConfigListOld = this.fscPayConfigMapper.getList(fscPayConfigQry);
            if (CollectionUtils.isEmpty(payConfigListOld)) {
                this.addDefaultPayConfig(reqBo, payConfigMainList);
            } else {
                List payBusiTypeList = payConfigListOld.stream().map(FscPayConfigPO::getPayBusiType).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<FscPayConfigPO> payConfigMainListAdd = payConfigMainList.stream().filter(i -> !payBusiTypeList.contains(i.getPayBusiType())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(payConfigMainListAdd)) {
                    this.addDefaultPayConfig(reqBo, payConfigMainListAdd);
                }
                for (FscPayConfigPO fscPayConfigOld : payConfigListOld) {
                    if (!StringUtils.hasText((String)reqBo.getExceptName()) && !StringUtils.hasText((String)reqBo.getExceptOrgPath())) continue;
                    FscPayConfigPO fscPayConfigUpdate = new FscPayConfigPO();
                    fscPayConfigUpdate.setPayConfigId(fscPayConfigOld.getPayConfigId());
                    fscPayConfigUpdate.setPayOrgName(reqBo.getExceptName());
                    fscPayConfigUpdate.setPayOrgPath(reqBo.getExceptOrgPath());
                    int count = this.fscPayConfigMapper.updateById(fscPayConfigUpdate);
                    if (count <= 1) continue;
                    throw new PfscExtBusinessException("18000", "\u66f4\u65b0\u6570\u636e\u5f02\u5e38");
                }
            }
        }
        return FscRu.success(FscUmcPayConfigAddAbilityRspBO.class);
    }

    private void addDefaultPayConfig(FscUmcPayConfigAddAbilityReqBO reqBo, List<FscPayConfigPO> payConfigMainList) {
        ArrayList<FscPayConfigPO> addDefaultConfigList = new ArrayList<FscPayConfigPO>();
        for (FscPayConfigPO configPo : payConfigMainList) {
            FscPayConfigPO payConfigAdd = new FscPayConfigPO();
            BeanUtils.copyProperties((Object)configPo, (Object)payConfigAdd);
            payConfigAdd.setPayConfigId(Sequence.getInstance().nextId());
            payConfigAdd.setParentConfigId(configPo.getPayConfigId());
            payConfigAdd.setPayConfigType(FscPayConfigType.DEF.getCode());
            payConfigAdd.setExceptionOrgNum(0);
            payConfigAdd.setExceptionAgrNum(0);
            payConfigAdd.setExceptionConnNum(0);
            payConfigAdd.setPayAllowExceptionFlag(YesOrNo.NO.getCode());
            payConfigAdd.setCreditAmount(Optional.ofNullable(configPo.getCreditAmount()).orElse(BigDecimal.ZERO));
            payConfigAdd.setUsedAmount(BigDecimal.ZERO);
            payConfigAdd.setBalanceAmount(configPo.getCreditAmount());
            payConfigAdd.setCurrentOrgControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
            payConfigAdd.setPayOrgId(reqBo.getExceptId());
            payConfigAdd.setPayOrgName(reqBo.getExceptName());
            payConfigAdd.setPayOrgPath(reqBo.getExceptOrgPath());
            payConfigAdd.setDeleteFlag(YesOrNo.NO.getCode());
            payConfigAdd.setCreateTime(new Date());
            payConfigAdd.setCreateUserId(reqBo.getUserId());
            payConfigAdd.setCreateUserName("\u4f1a\u5458\u63a8\u9001");
            payConfigAdd.setStatus(FscPayConfigStatus.DRAFT.getCode());
            addDefaultConfigList.add(payConfigAdd);
        }
        if (!CollectionUtils.isEmpty(addDefaultConfigList)) {
            this.fscPayConfigMapper.insertBatch(addDefaultConfigList);
        }
    }
}

