/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.ability.bo.FscUmcEnterpriseOrgBO;
import com.tydic.pfscext.enums.FscPayConfigSubClass;
import com.tydic.pfscext.enums.FscPayConfigSubType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.umc.api.FscUmcQryAccountListExternalService;
import com.tydic.pfscext.external.umc.bo.FscUmcQryAccountListExternalReqBO;
import com.tydic.pfscext.external.umc.bo.FscUmcQryAccountListExternalRspBO;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalReqBO;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalRspBO;
import com.tydic.pfscext.service.busi.FscUmcQryAccountListBusiService;
import com.tydic.pfscext.service.busi.bo.FscUmcOrgListBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscUmcOrgListBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscUmcQryAccountListBusiServiceImpl
implements FscUmcQryAccountListBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscUmcQryAccountListBusiServiceImpl.class);
    @Value(value="${FSC_UMC_BASE_ORG_ID:305775845729763327}")
    private Long baseOrgIdWeb;
    @Autowired
    private FscUmcQryAccountListExternalService fscUmcQryAccountListExternalService;

    @Override
    public FscUmcOrgListBusiRspBO getUmcAllOrgList(FscUmcOrgListBusiReqBO reqBo) {
        FscUmcQryAccountListExternalReqBO umcReqBo;
        Integer pageSize = 1000;
        ArrayList<FscUmcEnterpriseOrgBO> fscUmcOrgList = new ArrayList<FscUmcEnterpriseOrgBO>();
        if (FscPayConfigSubType.QY.getCode().equals(reqBo.getPaySubType())) {
            umcReqBo = new FscUmcQryAccountListExternalReqBO();
            umcReqBo.setOrgIdWeb(this.baseOrgIdWeb);
            umcReqBo.setPageNo(Integer.valueOf(1));
            umcReqBo.setPageSize(pageSize);
            umcReqBo.setQueryType("03");
            umcReqBo.setOrgTypes(Arrays.asList("00", "01", "02", "04"));
            umcReqBo.setIsProfessionalOrgs(Arrays.asList("0", "1"));
            if (FscPayConfigSubClass.IN.getCode().equals(reqBo.getPaySubClass())) {
                umcReqBo.setIntExtPropertys(Collections.singletonList("101"));
            } else {
                umcReqBo.setIntExtPropertys(Collections.singletonList("102"));
            }
            FscUmcQryAccountListExternalRspBO umcRspBo = this.fscUmcQryAccountListExternalService.qryPurchaseUnitListByOperatio(umcReqBo);
            if (FscRu.isFailed(umcRspBo.getRespCode()).booleanValue()) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u4f01\u4e1a\u673a\u6784\u4fe1\u606f\u5f02\u5e38\uff1a" + umcRspBo.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)umcRspBo.getRows())) {
                fscUmcOrgList.addAll(umcRspBo.getRows().stream().filter(i -> i.getOrgId() != null).map(i -> {
                    FscUmcEnterpriseOrgBO orgBo = new FscUmcEnterpriseOrgBO();
                    orgBo.setOrgId(i.getOrgId());
                    orgBo.setOrgName(i.getOrgName());
                    orgBo.setOrgTreePath(i.getOrgTreePath());
                    orgBo.setOrgFullName(i.getOrgFullName());
                    return orgBo;
                }).collect(Collectors.toList()));
            }
            if (umcRspBo.getTotal() != null && umcRspBo.getTotal() > 1) {
                for (int pageNo = 2; pageNo < umcRspBo.getTotal() + 1; ++pageNo) {
                    umcReqBo.setPageNo(Integer.valueOf(pageNo));
                    umcReqBo.setPageSize(pageSize);
                    FscUmcQryAccountListExternalRspBO subUmcRspBo = this.fscUmcQryAccountListExternalService.qryPurchaseUnitListByOperatio(umcReqBo);
                    if (FscRu.isFailed(subUmcRspBo.getRespCode()).booleanValue()) {
                        throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u4f01\u4e1a\u673a\u6784\u4fe1\u606f\u5f02\u5e38\uff1a" + umcRspBo.getRespDesc());
                    }
                    if (CollectionUtils.isEmpty((Collection)subUmcRspBo.getRows())) continue;
                    fscUmcOrgList.addAll(subUmcRspBo.getRows().stream().filter(i -> i.getOrgId() != null).map(i -> {
                        FscUmcEnterpriseOrgBO orgBo = new FscUmcEnterpriseOrgBO();
                        orgBo.setOrgId(i.getOrgId());
                        orgBo.setOrgName(i.getOrgName());
                        orgBo.setOrgTreePath(i.getOrgTreePath());
                        orgBo.setOrgFullName(i.getOrgFullName());
                        return orgBo;
                    }).collect(Collectors.toList()));
                }
            }
        } else if (FscPayConfigSubType.GR.getCode().equals(reqBo.getPaySubType())) {
            FscUmcQryMemListExternalRspBO umcRspBo;
            umcReqBo = new FscUmcQryMemListExternalReqBO();
            umcReqBo.setPageNo(Integer.valueOf(1));
            umcReqBo.setPageSize(pageSize);
            umcReqBo.setOrgIdWeb(this.baseOrgIdWeb);
            umcReqBo.setQueryType("02");
            if (FscPayConfigSubClass.IN.getCode().equals(reqBo.getPaySubClass())) {
                umcReqBo.setMemUserType("3");
            } else if (FscPayConfigSubClass.OUT.getCode().equals(reqBo.getPaySubClass())) {
                umcReqBo.setMemUserType("1");
            }
            if (!CollectionUtils.isEmpty(reqBo.getUmcUserIdList())) {
                umcReqBo.setUserIds(reqBo.getUmcUserIdList());
            }
            if (FscRu.isFailed((umcRspBo = this.fscUmcQryAccountListExternalService.qryMem((FscUmcQryMemListExternalReqBO)umcReqBo)).getRespCode()).booleanValue()) {
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u4f1a\u5458\u5f02\u5e38\uff1a" + umcRspBo.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)umcRspBo.getRows())) {
                fscUmcOrgList.addAll(umcRspBo.getRows().stream().filter(i -> i.getOrgId() != null).map(i -> {
                    FscUmcEnterpriseOrgBO orgBo = new FscUmcEnterpriseOrgBO();
                    orgBo.setOrgId(i.getOrgId());
                    orgBo.setOrgName(i.getOrgName());
                    orgBo.setOrgTreePath(i.getOrgTreePath());
                    orgBo.setOrgFullName(i.getOrgFullName());
                    orgBo.setUserId(i.getUserId());
                    orgBo.setUsername(i.getLoginName());
                    return orgBo;
                }).collect(Collectors.toList()));
            }
            if (umcRspBo.getTotal() != null && umcRspBo.getTotal() > 1) {
                Integer pageNo = 2;
                while (pageNo < umcRspBo.getTotal() + 1) {
                    umcReqBo.setPageNo(pageNo);
                    umcReqBo.setPageSize(pageSize);
                    FscUmcQryMemListExternalRspBO subUmcRspBo = this.fscUmcQryAccountListExternalService.qryMem((FscUmcQryMemListExternalReqBO)umcReqBo);
                    if (FscRu.isFailed(subUmcRspBo.getRespCode()).booleanValue()) {
                        throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u4f1a\u5458\u5f02\u5e38\uff1a" + umcRspBo.getRespDesc());
                    }
                    if (!CollectionUtils.isEmpty((Collection)subUmcRspBo.getRows())) {
                        fscUmcOrgList.addAll(subUmcRspBo.getRows().stream().filter(i -> i.getOrgId() != null).map(i -> {
                            FscUmcEnterpriseOrgBO orgBo = new FscUmcEnterpriseOrgBO();
                            orgBo.setOrgId(i.getOrgId());
                            orgBo.setOrgName(i.getOrgName());
                            orgBo.setOrgTreePath(i.getOrgTreePath());
                            orgBo.setOrgFullName(i.getOrgFullName());
                            orgBo.setUserId(i.getUserId());
                            orgBo.setUsername(i.getLoginName());
                            return orgBo;
                        }).collect(Collectors.toList()));
                    }
                    Integer n = pageNo;
                    Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
                }
            }
        }
        if (CollectionUtils.isEmpty(fscUmcOrgList)) {
            log.error("\u67e5\u8be2\u4f1a\u5458\u4e2d\u5fc3\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a");
        } else {
            log.error("\u67e5\u8be2\u4f1a\u5458\u4e2d\u5fc3\u673a\u6784\u4fe1\u606f\u7ed3\u679c\u6570\u91cf" + fscUmcOrgList.size());
        }
        FscUmcOrgListBusiRspBO rspBo = FscRu.success(FscUmcOrgListBusiRspBO.class);
        rspBo.setUmcOrgList(fscUmcOrgList);
        return rspBo;
    }
}

