/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigDeleteAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigDeleteAbilityRspBO;
import com.tydic.pfscext.dao.FscUserOverdueControlConfigMapper;
import com.tydic.pfscext.dao.FscUserOverdueStatisticsMapper;
import com.tydic.pfscext.dao.po.FscUserOverdueControlConfigPO;
import com.tydic.pfscext.dao.po.FscUserOverdueStatisticsPO;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscUserOverdueControlConfigDeleteBusiService;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import com.tydic.pfscext.utils.ValUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscUserOverdueControlConfigDeleteBusiServiceImpl
implements FscUserOverdueControlConfigDeleteBusiService {
    @Autowired
    private FscUserOverdueControlConfigMapper fscUserOverdueControlConfigMapper;
    @Autowired
    private FscUserOverdueStatisticsMapper fscUserOverdueStatisticsMapper;

    @Override
    public FscUserOverdueControlConfigDeleteAbilityRspBO dealUserOverdueConfigDelete(FscUserOverdueControlConfigDeleteAbilityReqBO reqBo) {
        FscUserOverdueControlConfigDeleteAbilityRspBO rspBo = FscRu.success(FscUserOverdueControlConfigDeleteAbilityRspBO.class);
        rspBo.setConfigUserIdList(new ArrayList());
        ArrayList<FscUserOverdueControlConfigPO> exceptionList = new ArrayList<FscUserOverdueControlConfigPO>();
        List batchList = ListUtil.batchList((List)reqBo.getConfigIdList());
        for (List subList : batchList) {
            FscUserOverdueControlConfigPO fscUserOverdueControlConfigQry = new FscUserOverdueControlConfigPO();
            fscUserOverdueControlConfigQry.setConfigType("2");
            fscUserOverdueControlConfigQry.setConfigIdList(subList);
            exceptionList.addAll(this.fscUserOverdueControlConfigMapper.getList(fscUserOverdueControlConfigQry));
        }
        if (!CollectionUtils.isEmpty(exceptionList)) {
            FscUserOverdueControlConfigPO configMainPo = new FscUserOverdueControlConfigPO();
            configMainPo.setConfigType("1");
            configMainPo.setDeleteFlag(YesOrNo.NO.getCode());
            configMainPo = this.fscUserOverdueControlConfigMapper.getModelBy(configMainPo);
            ValUtil.isEmpty(configMainPo).exception("\u5220\u9664\u5931\u8d25\uff0c\u4e3b\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
            for (FscUserOverdueControlConfigPO item : exceptionList) {
                FscUserOverdueControlConfigPO fscUserOverdueControlConfigDelete = new FscUserOverdueControlConfigPO();
                fscUserOverdueControlConfigDelete.setConfigId(item.getConfigId());
                int deleteBy = this.fscUserOverdueControlConfigMapper.deleteBy(fscUserOverdueControlConfigDelete);
                if (deleteBy > 1) {
                    throw new PfscExtBusinessException("18000", "\u5220\u9664\u5931\u8d25");
                }
                FscUserOverdueStatisticsPO fscUserOverdueStatisticsQry = new FscUserOverdueStatisticsPO();
                fscUserOverdueStatisticsQry.setConfigUserId(item.getConfigUserId());
                List<FscUserOverdueStatisticsPO> statisticsList = this.fscUserOverdueStatisticsMapper.getList(fscUserOverdueStatisticsQry);
                if (CollectionUtils.isEmpty(statisticsList)) continue;
                for (FscUserOverdueStatisticsPO statistics : statisticsList) {
                    FscUserOverdueStatisticsPO statisticsUpdate = new FscUserOverdueStatisticsPO();
                    statisticsUpdate.setStatisticsId(statistics.getStatisticsId());
                    statisticsUpdate.setConfigType("0");
                    statisticsUpdate.setConfigId(configMainPo.getConfigId());
                    Integer currentOrderOverdueNum = Optional.ofNullable(statistics.getCurrentOrderOverdueNum()).orElse(0);
                    if (currentOrderOverdueNum > configMainPo.getOrderWarningNum()) {
                        statistics.setCurrentUserControlStatus(FscPayConfigControlStatus.WARNING.getCode());
                    }
                    if (currentOrderOverdueNum >= configMainPo.getOrderControlNum()) {
                        statistics.setCurrentUserControlStatus(FscPayConfigControlStatus.RESTRICTED.getCode());
                    }
                    if (currentOrderOverdueNum < configMainPo.getOrderRecoveryNum() && FscPayConfigControlStatus.RESTRICTED.getCode().equals(statistics.getCurrentUserControlStatus())) {
                        statistics.setCurrentUserControlStatus(FscPayConfigControlStatus.NORMAL.getDesc());
                    }
                    this.fscUserOverdueStatisticsMapper.updateById(statisticsUpdate);
                    rspBo.getConfigUserIdList().add(statisticsUpdate.getConfigUserId());
                }
            }
        }
        return rspBo;
    }
}

