/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigModifyAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigModifyAbilityRspBO;
import com.tydic.pfscext.dao.FscUserOverdueControlConfigMapper;
import com.tydic.pfscext.dao.FscUserOverdueStatisticsMapper;
import com.tydic.pfscext.dao.po.FscUserOverdueControlConfigPO;
import com.tydic.pfscext.dao.po.FscUserOverdueStatisticsPO;
import com.tydic.pfscext.enums.FscPayConfigControlStatus;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscUserOverdueControlConfigExceptionSaveBusiService;
import com.tydic.pfscext.service.busi.bo.FscUserOverdueControlConfigImportBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscUserOverdueControlConfigImportBusiRspBO;
import com.tydic.pfscext.utils.FscRu;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscUserOverdueControlConfigExceptionSaveBusiServiceImpl
implements FscUserOverdueControlConfigExceptionSaveBusiService {
    @Autowired
    private FscUserOverdueControlConfigMapper fscUserOverdueControlConfigMapper;
    @Autowired
    private FscUserOverdueStatisticsMapper fscUserOverdueStatisticsMapper;

    @Override
    public FscUserOverdueControlConfigModifyAbilityRspBO dealUserOverdueControlConfigExceptionSave(FscUserOverdueControlConfigModifyAbilityReqBO reqBo) {
        FscUserOverdueControlConfigModifyAbilityRspBO rspBo = new FscUserOverdueControlConfigModifyAbilityRspBO();
        FscUserOverdueControlConfigPO configPo = new FscUserOverdueControlConfigPO();
        if ("4".equals(reqBo.getOperationType())) {
            configPo.setConfigId(reqBo.getConfigId());
            configPo.setConfigType("2");
            configPo.setDeleteFlag(YesOrNo.NO.getCode());
            FscUserOverdueControlConfigPO oldConfig = this.fscUserOverdueControlConfigMapper.getModelBy(configPo);
            if (null == oldConfig) {
                throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u539f\u914d\u7f6e\u4fe1\u606f");
            }
            rspBo.setConfigId(Long.valueOf(this.modifyConfig(reqBo, oldConfig)));
        } else {
            configPo.setConfigUserId(reqBo.getConfigUserId());
            configPo.setConfigType("2");
            FscUserOverdueControlConfigPO oldConfig = this.fscUserOverdueControlConfigMapper.getModelBy(configPo);
            rspBo.setConfigId(Long.valueOf(this.modifyConfig(reqBo, oldConfig)));
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    @Override
    public FscUserOverdueControlConfigImportBusiRspBO dealUserOverdueConfigImport(FscUserOverdueControlConfigImportBusiReqBO reqBo) {
        return FscRu.success(FscUserOverdueControlConfigImportBusiRspBO.class);
    }

    private long modifyConfig(FscUserOverdueControlConfigModifyAbilityReqBO reqBo, FscUserOverdueControlConfigPO oldConfig) {
        Date now = new Date();
        FscUserOverdueControlConfigPO fscUserOverdueControlConfigPo = new FscUserOverdueControlConfigPO();
        fscUserOverdueControlConfigPo.setConfigType("2");
        fscUserOverdueControlConfigPo.setDeleteFlag(YesOrNo.NO.getCode());
        fscUserOverdueControlConfigPo.setOrderWarningNum(reqBo.getWarningNum());
        fscUserOverdueControlConfigPo.setOrderControlNum(reqBo.getControlNum());
        fscUserOverdueControlConfigPo.setOrderRecoveryNum(reqBo.getRecoveryNum());
        fscUserOverdueControlConfigPo.setConfigOrgId(reqBo.getConfigOrgId());
        fscUserOverdueControlConfigPo.setConfigOrgName(reqBo.getConfigOrgName());
        fscUserOverdueControlConfigPo.setConfigOrgPath(reqBo.getConfigOrgPath());
        fscUserOverdueControlConfigPo.setConfigOrgFullName(reqBo.getConfigOrgFullName());
        fscUserOverdueControlConfigPo.setConfigUserId(reqBo.getConfigUserId());
        fscUserOverdueControlConfigPo.setConfigUserAccount(reqBo.getConfigUserAccount());
        fscUserOverdueControlConfigPo.setConfigUserName(reqBo.getConfigUserName());
        fscUserOverdueControlConfigPo.setConfigAuthRole(reqBo.getConfigAuthRole());
        if (oldConfig != null) {
            fscUserOverdueControlConfigPo.setUpdateTime(now);
            fscUserOverdueControlConfigPo.setUpdateUserId(reqBo.getUserId());
            fscUserOverdueControlConfigPo.setUpdateUserName(reqBo.getName());
            fscUserOverdueControlConfigPo.setConfigId(oldConfig.getConfigId());
            this.fscUserOverdueControlConfigMapper.updateById(fscUserOverdueControlConfigPo);
        } else {
            fscUserOverdueControlConfigPo.setConfigId(Sequence.getInstance().nextId());
            fscUserOverdueControlConfigPo.setCreateTime(now);
            fscUserOverdueControlConfigPo.setCreateUserId(reqBo.getUserId());
            fscUserOverdueControlConfigPo.setCreateUserName(reqBo.getName());
            fscUserOverdueControlConfigPo.setUpdateTime(now);
            fscUserOverdueControlConfigPo.setUpdateUserId(reqBo.getUserId());
            fscUserOverdueControlConfigPo.setUpdateUserName(reqBo.getName());
            this.fscUserOverdueControlConfigMapper.insert(fscUserOverdueControlConfigPo);
        }
        this.createUserOverdueStatistics(reqBo, fscUserOverdueControlConfigPo.getConfigId(), now);
        return fscUserOverdueControlConfigPo.getConfigId();
    }

    private void createUserOverdueStatistics(FscUserOverdueControlConfigModifyAbilityReqBO reqBo, Long configId, Date now) {
        FscUserOverdueControlConfigPO configPo = new FscUserOverdueControlConfigPO();
        configPo.setConfigId(configId);
        configPo = this.fscUserOverdueControlConfigMapper.getModelBy(configPo);
        if (configPo == null) {
            throw new PfscExtBusinessException("18000", "\u57fa\u7840\u914d\u7f6e\u67e5\u8be2\u4e3a\u7a7a");
        }
        FscUserOverdueStatisticsPO statisticsPo = new FscUserOverdueStatisticsPO();
        statisticsPo.setConfigUserId(configPo.getConfigUserId());
        statisticsPo = this.fscUserOverdueStatisticsMapper.getModelBy(statisticsPo);
        FscUserOverdueStatisticsPO fscUserOverdueStatisticsPo = new FscUserOverdueStatisticsPO();
        fscUserOverdueStatisticsPo.setConfigId(configPo.getConfigId());
        fscUserOverdueStatisticsPo.setConfigType("2");
        fscUserOverdueStatisticsPo.setDeleteFlag(YesOrNo.NO.getCode());
        fscUserOverdueStatisticsPo.setConfigOrgId(configPo.getConfigOrgId());
        fscUserOverdueStatisticsPo.setConfigOrgName(configPo.getConfigOrgName());
        fscUserOverdueStatisticsPo.setConfigOrgPath(configPo.getConfigOrgPath());
        fscUserOverdueStatisticsPo.setConfigOrgFullName(configPo.getConfigOrgFullName());
        fscUserOverdueStatisticsPo.setConfigUserName(configPo.getConfigUserName());
        fscUserOverdueStatisticsPo.setConfigAuthRole(configPo.getConfigAuthRole());
        if (statisticsPo == null) {
            fscUserOverdueStatisticsPo.setStatisticsId(Sequence.getInstance().nextId());
            fscUserOverdueStatisticsPo.setConfigUserId(configPo.getConfigUserId());
            fscUserOverdueStatisticsPo.setConfigUserAccount(configPo.getConfigUserAccount());
            fscUserOverdueStatisticsPo.setCurrentOrderOverdueNum(0);
            fscUserOverdueStatisticsPo.setCurrentOrderCreditNum(0);
            fscUserOverdueStatisticsPo.setOrderCreditAmount(BigDecimal.ZERO);
            fscUserOverdueStatisticsPo.setOrderOverdueAmount(BigDecimal.ZERO);
            fscUserOverdueStatisticsPo.setCurrentUserControlStatus(FscPayConfigControlStatus.NORMAL.getCode());
            fscUserOverdueStatisticsPo.setCreateTime(now);
            fscUserOverdueStatisticsPo.setCreateUserId(reqBo.getUserId());
            fscUserOverdueStatisticsPo.setCreateUserName(reqBo.getUsername());
            this.fscUserOverdueStatisticsMapper.insert(fscUserOverdueStatisticsPo);
        } else {
            int DEFAULT_ZERO = 0;
            Integer currentOrderOverdueNum = Optional.ofNullable(statisticsPo.getCurrentOrderOverdueNum()).orElse(DEFAULT_ZERO);
            Integer orderWarningNum = Optional.ofNullable(configPo.getOrderWarningNum()).orElse(DEFAULT_ZERO);
            Integer orderControlNum = Optional.ofNullable(configPo.getOrderControlNum()).orElse(DEFAULT_ZERO);
            Integer orderRecoveryNum = Optional.ofNullable(configPo.getOrderRecoveryNum()).orElse(DEFAULT_ZERO);
            FscPayConfigControlStatus userControlStatus = FscPayConfigControlStatus.NORMAL;
            if (currentOrderOverdueNum >= orderControlNum) {
                userControlStatus = FscPayConfigControlStatus.RESTRICTED;
            } else if (currentOrderOverdueNum >= orderWarningNum) {
                userControlStatus = FscPayConfigControlStatus.WARNING;
            }
            fscUserOverdueStatisticsPo.setStatisticsId(statisticsPo.getStatisticsId());
            fscUserOverdueStatisticsPo.setCurrentOrderOverdueNum(statisticsPo.getCurrentOrderOverdueNum());
            fscUserOverdueStatisticsPo.setCurrentOrderCreditNum(statisticsPo.getCurrentOrderCreditNum());
            fscUserOverdueStatisticsPo.setOrderCreditAmount(statisticsPo.getOrderCreditAmount());
            fscUserOverdueStatisticsPo.setOrderOverdueAmount(statisticsPo.getOrderOverdueAmount());
            fscUserOverdueStatisticsPo.setCurrentUserControlStatus(userControlStatus.getCode());
            fscUserOverdueStatisticsPo.setUpdateTime(now);
            fscUserOverdueStatisticsPo.setUpdateUserId(reqBo.getUserId());
            fscUserOverdueStatisticsPo.setUpdateUserName(reqBo.getUsername());
            this.fscUserOverdueStatisticsMapper.updateById(fscUserOverdueStatisticsPo);
        }
    }
}

