/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigModifyAbilityReqBO;
import com.tydic.pfscext.api.ability.bo.FscUserOverdueControlConfigModifyAbilityRspBO;
import com.tydic.pfscext.dao.FscUserOverdueControlConfigMapper;
import com.tydic.pfscext.dao.FscUserOverdueControlConfigModifyLogMapper;
import com.tydic.pfscext.dao.po.FscUserOverdueControlConfigModifyLogPO;
import com.tydic.pfscext.dao.po.FscUserOverdueControlConfigPO;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscUserOverdueControlConfigModifyBusiService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscUserOverdueControlConfigModifyBusiServiceImpl
implements FscUserOverdueControlConfigModifyBusiService {
    @Autowired
    private FscUserOverdueControlConfigMapper fscUserOverdueControlConfigMapper;
    @Autowired
    private FscUserOverdueControlConfigModifyLogMapper fscUserOverdueControlConfigModifyLogMapper;

    @Override
    public FscUserOverdueControlConfigModifyAbilityRspBO modifyUserOverdueControlConfig(FscUserOverdueControlConfigModifyAbilityReqBO reqBo) {
        FscUserOverdueControlConfigModifyAbilityRspBO rspBo = new FscUserOverdueControlConfigModifyAbilityRspBO();
        rspBo.setConfigId(reqBo.getConfigId());
        if (reqBo.getConfigId() == null) {
            long configId = this.createConfig(reqBo);
            rspBo.setConfigId(Long.valueOf(configId));
        } else {
            FscUserOverdueControlConfigPO configPo = new FscUserOverdueControlConfigPO();
            configPo.setConfigId(reqBo.getConfigId());
            configPo.setConfigType("1");
            configPo.setDeleteFlag(YesOrNo.NO.getCode());
            FscUserOverdueControlConfigPO oldConfig = this.fscUserOverdueControlConfigMapper.getModelBy(configPo);
            if (null == oldConfig) {
                throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u539f\u914d\u7f6e\u4fe1\u606f");
            }
            this.modifyConfig(reqBo, oldConfig);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void modifyConfig(FscUserOverdueControlConfigModifyAbilityReqBO reqBo, FscUserOverdueControlConfigPO oldConfig) {
        Date now = new Date();
        FscUserOverdueControlConfigPO setPo = new FscUserOverdueControlConfigPO();
        setPo.setOrderWarningNum(reqBo.getWarningNum());
        setPo.setOrderControlNum(reqBo.getControlNum());
        setPo.setOrderRecoveryNum(reqBo.getRecoveryNum());
        setPo.setUpdateUserId(reqBo.getUserId());
        setPo.setUpdateUserName(reqBo.getUsername());
        setPo.setUpdateTime(now);
        FscUserOverdueControlConfigPO wherePo = new FscUserOverdueControlConfigPO();
        wherePo.setConfigId(reqBo.getConfigId());
        this.fscUserOverdueControlConfigMapper.updateBy(setPo, wherePo);
        this.createLog(reqBo, oldConfig, now);
    }

    private long createConfig(FscUserOverdueControlConfigModifyAbilityReqBO reqBo) {
        long id = Sequence.getInstance().nextId();
        Date now = new Date();
        FscUserOverdueControlConfigPO fscUserOverdueControlConfigPo = new FscUserOverdueControlConfigPO();
        fscUserOverdueControlConfigPo.setConfigId(id);
        fscUserOverdueControlConfigPo.setConfigType("1");
        fscUserOverdueControlConfigPo.setDeleteFlag(YesOrNo.NO.getCode());
        fscUserOverdueControlConfigPo.setCreateUserId(reqBo.getUserId());
        fscUserOverdueControlConfigPo.setCreateUserName(reqBo.getUsername());
        fscUserOverdueControlConfigPo.setCreateTime(now);
        fscUserOverdueControlConfigPo.setOrderWarningNum(reqBo.getWarningNum());
        fscUserOverdueControlConfigPo.setOrderControlNum(reqBo.getControlNum());
        fscUserOverdueControlConfigPo.setOrderRecoveryNum(reqBo.getRecoveryNum());
        this.fscUserOverdueControlConfigMapper.insert(fscUserOverdueControlConfigPo);
        this.createLog(reqBo, null, now);
        return id;
    }

    private void createLog(FscUserOverdueControlConfigModifyAbilityReqBO reqBo, FscUserOverdueControlConfigPO oldConfig, Date now) {
        FscUserOverdueControlConfigModifyLogPO modifyLogPo = new FscUserOverdueControlConfigModifyLogPO();
        modifyLogPo.setUserOverdueLogId(Sequence.getInstance().nextId());
        modifyLogPo.setOrderWarningNum(reqBo.getWarningNum());
        modifyLogPo.setOrderControlNum(reqBo.getControlNum());
        modifyLogPo.setOrderRecoveryNum(reqBo.getRecoveryNum());
        if (oldConfig != null) {
            modifyLogPo.setOldOrderWarningNum(oldConfig.getOrderWarningNum());
            modifyLogPo.setOldOrderControlNum(oldConfig.getOrderControlNum());
            modifyLogPo.setOldOrderRecoveryNum(oldConfig.getOrderRecoveryNum());
        }
        modifyLogPo.setCreateTime(now);
        modifyLogPo.setCreateUserId(reqBo.getUserId());
        modifyLogPo.setCreateUserName(reqBo.getUsername());
        this.fscUserOverdueControlConfigModifyLogMapper.insert(modifyLogPo);
    }
}

