/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.BusiUpdateNotificationExcepService;
import com.tydic.pfscext.api.busi.NotificationSendRequestService;
import com.tydic.pfscext.api.busi.bo.NotificationSendRequestReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.constants.FscCommonConstants;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.SupplierInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.SupplierInfo;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.NotificationInvoiceStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.external.api.BusiApplyInvoiceService;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceReqBO;
import com.tydic.pfscext.external.api.bo.BusiApplyInvoiceRspBO;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.utils.FscCommonUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotificationSendRequestServiceImpl
implements NotificationSendRequestService {
    private static final Logger logger = LoggerFactory.getLogger(NotificationSendRequestServiceImpl.class);
    @Autowired
    private BusiApplyInvoiceService busiApplyInvoiceService;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private BusiUpdateNotificationExcepService busiUpdateNotificationExcepService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    private static final Long SUPPLIER_ID = 100055L;
    private static final Long SUPPLIER_ID_JD_FL = 2022081501L;
    private static final Long SUPPLIER_ID_JD_PC = 1000550L;

    public PfscExtRspBaseBO processPushInfo(NotificationSendRequestReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u7968\u901a\u77e5\u53d1\u9001\u8bf7\u6c42\u670d\u52a1\u5165\u53c2:" + reqBO);
        }
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        billNotificationInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        billNotificationInfo.setBatchNo(reqBO.getBatchNo());
        billNotificationInfo.setNotificationNo(reqBO.getNotificationNo());
        if (NotificationInvoiceStatus.SUBMITED_FAIL.getCode().equals(reqBO.getNotificationInvoiceStatus())) {
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED_FAIL.getCode());
        } else {
            billNotificationInfo.setInvoiceStatus(NotificationInvoiceStatus.NO_SUBMITED.getCode());
        }
        List<BillNotificationInfo> billNotificationInfoList = this.billNotificationInfoMapper.selectList(billNotificationInfo);
        for (BillNotificationInfo notification : billNotificationInfoList) {
            BusiApplyInvoiceReqBO jdIntfceReqBO = new BusiApplyInvoiceReqBO();
            BusiApplyInvoiceRspBO jdIntfceRspBO = new BusiApplyInvoiceRspBO();
            try {
                Object orderBusiModel;
                jdIntfceReqBO.setSupplierId(notification.getSupplierNo());
                List<PayPurchaseOrderInfo> orders = this.payPurchaseOrderInfoMapper.selectByNotifNo(notification.getNotificationNo());
                LinkedList<String> orderIdCombStr = new LinkedList<String>();
                LinkedList<String> eorderIds = new LinkedList<String>();
                LinkedList<BigDecimal> orderAmt = new LinkedList<BigDecimal>();
                if (null != orders && orders.size() > 0 && null != notification.getSupplierNo() && (SUPPLIER_ID.equals(notification.getSupplierNo()) || SUPPLIER_ID_JD_FL.equals(notification.getSupplierNo()) || SUPPLIER_ID_JD_PC.equals(notification.getSupplierNo())) && StringUtils.isNotBlank((CharSequence)(orderBusiModel = orders.get(0).getBusiModel())) && BusiModel.MATCH_UP_MODEL.getCode().equals(orderBusiModel)) {
                    jdIntfceReqBO.setJdOrgId(orders.get(0).getJdOrgId());
                }
                orderBusiModel = orders.iterator();
                while (orderBusiModel.hasNext()) {
                    PayPurchaseOrderInfo singleOrder = orderBusiModel.next();
                    orderIdCombStr.add(singleOrder.getExtOrderId());
                    eorderIds.add(singleOrder.getPurchaseOrderCode());
                    orderAmt.add(singleOrder.getOrderAmt());
                }
                jdIntfceReqBO.setSupplierOrder(orderIdCombStr);
                jdIntfceReqBO.setEorderId(eorderIds);
                jdIntfceReqBO.setSettleAmt(orderAmt);
                jdIntfceReqBO.setMarkId(notification.getNotificationNo());
                jdIntfceReqBO.setSettlementId(notification.getNotificationNo());
                String curBatchStr = notification.getNotificationNo();
                String regEx = "[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(curBatchStr);
                curBatchStr = m.replaceAll("").trim();
                curBatchStr = curBatchStr.substring(curBatchStr.length() - 6, curBatchStr.length());
                jdIntfceReqBO.setCurrentBatch(curBatchStr);
                SimpleDateFormat sfWithSlash = new SimpleDateFormat("yyyy-MM-dd");
                String dateWithSlashStr = sfWithSlash.format(new Date());
                jdIntfceReqBO.setInvoiceDate(dateWithSlashStr);
                jdIntfceReqBO.setInvoiceNum(Integer.valueOf(orderIdCombStr.size()));
                jdIntfceReqBO.setTotalBatch(FscCommonConstants.BASIC_INVOICE_BATCH_NUM);
                if (notification.getInvoceType() == 1) {
                    jdIntfceReqBO.setInvoiceType(Integer.valueOf(3));
                } else {
                    jdIntfceReqBO.setInvoiceType(notification.getInvoceType());
                }
                SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(notification.getSupplierNo());
                if (supplierInfo == null) {
                    throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546\u5f00\u7968\u9650\u989d\u914d\u7f6e\u8868\uff0c\u4f9b\u5e94\u5546ID:" + String.valueOf(notification.getSupplierNo()) + "\u627e\u4e0d\u5230\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f");
                }
                String invoiceOrgSetting = supplierInfo.getBillOrg();
                jdIntfceReqBO.setInvoiceOrg(invoiceOrgSetting);
                jdIntfceReqBO.setTitle(notification.getInvoceName());
                jdIntfceReqBO.setBizInvoiceContent(Integer.valueOf(1));
                jdIntfceReqBO.setInvoicePrice(notification.getAmt());
                jdIntfceReqBO.setTotalBatchInvoiceAmount(notification.getAmt());
                jdIntfceReqBO.setEnterpriseTaxpayer(notification.getTaxNo());
                String accountStr = notification.getBankAccNo();
                accountStr = accountStr.replaceAll("\\s*", "");
                if (SUPPLIER_ID.equals(notification.getSupplierNo()) || SUPPLIER_ID_JD_FL.equals(notification.getSupplierNo()) || SUPPLIER_ID_JD_PC.equals(notification.getSupplierNo())) {
                    jdIntfceReqBO.setEnterpriseRegAddress(notification.getAddr());
                    jdIntfceReqBO.setEnterpriseRegPhone(notification.getPhone());
                    jdIntfceReqBO.setEnterpriseBankName(notification.getBankName());
                    jdIntfceReqBO.setEnterpriseBankAccount(accountStr);
                } else {
                    jdIntfceReqBO.setAddress(notification.getAddr());
                    jdIntfceReqBO.setTel(notification.getPhone());
                    jdIntfceReqBO.setBank(notification.getBankName());
                    jdIntfceReqBO.setAccount(accountStr);
                }
                jdIntfceReqBO.setBillToParty(notification.getCompany());
                jdIntfceReqBO.setBillToer(notification.getName());
                jdIntfceReqBO.setBillToContact(notification.getMobile());
                jdIntfceReqBO.setBillToProvince(FscCommonUtils.long2Integer((Long)notification.getProvId()));
                jdIntfceReqBO.setBillToCity(FscCommonUtils.long2Integer((Long)notification.getCityId()));
                jdIntfceReqBO.setBillToCounty(Integer.valueOf(FscCommonUtils.long2Integer((Long)notification.getCountyId()) == null ? 0 : FscCommonUtils.long2Integer((Long)notification.getCountyId())));
                jdIntfceReqBO.setBillToTown(Integer.valueOf(FscCommonUtils.long2Integer((Long)notification.getTownId()) == null ? 0 : FscCommonUtils.long2Integer((Long)notification.getTownId())));
                jdIntfceReqBO.setBillToAddress(notification.getAddrDesc());
                jdIntfceReqBO.setInvoiceRemark(notification.getInvoiceRemark());
                jdIntfceReqBO.setOpenSwitch(this.enumsService.queryOpenSwitch(jdIntfceReqBO.getSupplierId()));
                logger.debug("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u3002\u5165\u53c2\uff1a" + jdIntfceReqBO);
                jdIntfceRspBO = this.busiApplyInvoiceService.applyInvoice(jdIntfceReqBO);
            }
            catch (Exception e) {
                logger.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u51fa\u9519\u3002\u5165\u53c2\uff1a" + jdIntfceReqBO, (Throwable)e);
                this.rollbackBillNotificationInfo(notification.getNotificationNo());
                continue;
            }
            if (jdIntfceRspBO == null) {
                logger.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u51fa\u9519\u3002\u5165\u53c2\uff1a" + jdIntfceReqBO);
                this.rollbackBillNotificationInfo(notification.getNotificationNo());
                continue;
            }
            if (!jdIntfceRspBO.getSuccess().booleanValue()) {
                logger.error("\u5f00\u7968\u901a\u77e5\u4e1a\u52a1\u670d\u52a1-\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u51fa\u9519\u3002\u5165\u53c2\uff1a" + jdIntfceReqBO + "\u3002\u51fa\u53c2\uff1a" + jdIntfceRspBO);
                this.rollbackBillNotificationInfo(notification.getNotificationNo());
                continue;
            }
            BillNotificationInfo updateBill = new BillNotificationInfo();
            updateBill.setNotificationNo(notification.getNotificationNo());
            updateBill.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
            this.billNotificationInfoMapper.updateByPrimaryKeySelective(updateBill);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void rollbackBillNotificationInfo(String notificationNo) {
        PayPurchaseOrderInfo payOrderInfo = new PayPurchaseOrderInfo();
        payOrderInfo.setNotificationNo(notificationNo);
        payOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        this.payPurchaseOrderInfoMapper.updateStatus(payOrderInfo);
        PayItemInfo item = new PayItemInfo();
        item.setNotificationNo(notificationNo);
        this.payItemInfoMapper.updateBackToInit(item);
        this.billNotificationInfoMapper.deleteByPrimaryKey(notificationNo);
    }
}

