/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.PayLoadPlatUseFeeInfoService;
import com.tydic.pfscext.api.busi.bo.PayLoadPlatUseFeeInfoReqBO;
import com.tydic.pfscext.api.busi.bo.PayLoadPlatUseFeeInfoRspBO;
import com.tydic.pfscext.dao.InquiryPayOrderMapper;
import com.tydic.pfscext.dao.po.InquiryPayOrder;
import com.tydic.pfscext.dao.po.InquiryPayOrderExt;
import com.tydic.pfscext.enums.InquiryB2BBANK;
import com.tydic.pfscext.enums.InquiryB2CBANK;
import com.tydic.pfscext.enums.InquiryCriticalValue;
import com.tydic.pfscext.enums.InquiryPayFeeType;
import com.tydic.pfscext.enums.InquiryPayPass;
import com.tydic.pfscext.enums.InquiryPaymentStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayLoadPlatUseFeeInfoServiceImpl
implements PayLoadPlatUseFeeInfoService {
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public PayLoadPlatUseFeeInfoRspBO payLoadOrderInfo(PayLoadPlatUseFeeInfoReqBO reqBO) {
        PayLoadPlatUseFeeInfoRspBO rspBO = new PayLoadPlatUseFeeInfoRspBO();
        if (null == reqBO.getPayOrderNo()) {
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u8ba2\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
        }
        InquiryPayOrderExt payOrderInfoExt = new InquiryPayOrderExt();
        payOrderInfoExt.setPayFeeType(InquiryPayFeeType.PLAT_USE_FEE.getCode());
        payOrderInfoExt.setPayOrderNo(reqBO.getPayOrderNo());
        InquiryPayOrder payOrderInfo = this.inquiryPayOrderMapper.selectByPrimaryKey(payOrderInfoExt);
        if (null == payOrderInfo || InquiryPaymentStatus.ALREADY_PAID.getCode().equals(payOrderInfo.getPaymentStatus()) || InquiryPaymentStatus.TERMINATED.getCode().equals(payOrderInfo.getPaymentStatus()) || InquiryPaymentStatus.REC_CONFIRMED.getCode().equals(payOrderInfo.getPaymentStatus()) || InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(payOrderInfo.getPaymentStatus())) {
            throw new PfscExtBusinessException("18000", "\u6240\u9009\u8ba2\u5355\u4e0d\u53ef\u8fdb\u884c\u7f34\u8d39\u64cd\u4f5c");
        }
        if (BigDecimal.ZERO.equals(payOrderInfo.getPayMoney())) {
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\u9700\u7f34\u8d39\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u7f34\u8d39");
        }
        rspBO.setInquiryNo(payOrderInfo.getInquiryNo());
        rspBO.setPayMoney(payOrderInfo.getPayMoney());
        String supplierName = this.organizationInfoService.querySupplierName(payOrderInfo.getSupplierId());
        rspBO.setSupplierName(supplierName);
        rspBO.setMaterialsClass(payOrderInfo.getMaterialsClass());
        rspBO.setPaymentStatus(payOrderInfo.getPaymentStatus());
        double money = Double.parseDouble(InquiryCriticalValue.CRITICAL_MONEY.getCode());
        double payMoney = rspBO.getPayMoney().doubleValue();
        if (money >= payMoney) {
            rspBO.setDefaultPass(InquiryPayPass.B2CBANK.getCode());
        } else {
            rspBO.setDefaultPass(InquiryPayPass.B2BBANK.getCode());
        }
        LinkedList<String> b2cBankList = new LinkedList<String>();
        for (InquiryB2CBANK e : InquiryB2CBANK.values()) {
            b2cBankList.add(e.toString());
        }
        rspBO.setB2cBankList(b2cBankList);
        LinkedList<String> b2bBankList = new LinkedList<String>();
        for (InquiryB2BBANK e : InquiryB2BBANK.values()) {
            b2bBankList.add(e.toString());
        }
        rspBO.setB2bBankList(b2bBankList);
        return rspBO;
    }
}

