/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.PayOfflinePaidService;
import com.tydic.pfscext.api.busi.bo.PayOfflinePaidReqBO;
import com.tydic.pfscext.api.busi.bo.PayOfflinePaidRspBO;
import com.tydic.pfscext.dao.InquiryPayOrderMapper;
import com.tydic.pfscext.dao.po.InquiryPayOrder;
import com.tydic.pfscext.dao.po.InquiryPayOrderExt;
import com.tydic.pfscext.enums.InquiryApprovalStatus;
import com.tydic.pfscext.enums.InquiryPaymentStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayOfflinePaidServiceImpl
implements PayOfflinePaidService {
    private static final Logger logger = LoggerFactory.getLogger(PayOfflinePaidServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    public PayOfflinePaidRspBO modifyOfflinePaid(PayOfflinePaidReqBO reqBO) {
        if (reqBO == null || reqBO.getPayOrderNos() == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u3010payOrderNos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.debug("\u7f34\u8d39\u5355\u7ebf\u4e0b\u4ed8\u6b3e\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        List payOrderNos = reqBO.getPayOrderNos();
        List<InquiryPayOrder> payOrderList = this.inquiryPayOrderMapper.selectByPayOrderNos(payOrderNos);
        for (InquiryPayOrder inquiryPayOrder : payOrderList) {
            if (!InquiryPaymentStatus.IN_PAYMENT.getCode().equals(inquiryPayOrder.getPaymentStatus()) && !InquiryPaymentStatus.ALREADY_PAID.getCode().equals(inquiryPayOrder.getPaymentStatus()) && !InquiryPaymentStatus.TERMINATED.getCode().equals(inquiryPayOrder.getPaymentStatus()) && !InquiryPaymentStatus.REC_CONFIRMED.getCode().equals(inquiryPayOrder.getPaymentStatus()) && !InquiryPaymentStatus.CHECK_SUCCEED.getCode().equals(inquiryPayOrder.getPaymentStatus()) && !InquiryPaymentStatus.OFFLINE_PAID.getCode().equals(inquiryPayOrder.getPaymentStatus()) && !InquiryPaymentStatus.FREE_ORDER.getCode().equals(inquiryPayOrder.getPaymentStatus())) continue;
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355\uff1a" + inquiryPayOrder.getInquiryNo() + "\u4e0d\u53ef\u8fdb\u884c\u7ebf\u4e0b\u7f34\u8d39\u64cd\u4f5c");
        }
        for (String payOrderNo : payOrderNos) {
            InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
            inquiryPayOrderExt.setPayOrderNo(payOrderNo);
            inquiryPayOrderExt.setPayStartTime(new Date());
            inquiryPayOrderExt.setPaymentStatus(InquiryPaymentStatus.OFFLINE_PAY_REGISTERED.getCode());
            inquiryPayOrderExt.setApprovalStatus(InquiryApprovalStatus.IN_THE_AUDIT.getCode());
            this.inquiryPayOrderMapper.updateState(inquiryPayOrderExt);
        }
        return new PayOfflinePaidRspBO();
    }
}

