/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.tydic.pfscext.api.busi.PlatfUseFeeUpdateInvoiceCheckService;
import com.tydic.pfscext.api.busi.bo.PlatfUseFeeUpdateInvoiceCheckReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillPrechooseMapper;
import com.tydic.pfscext.dao.InquiryPayOrderMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillPrechoose;
import com.tydic.pfscext.dao.po.InquiryPayOrder;
import com.tydic.pfscext.dao.po.InquiryPayOrderExt;
import com.tydic.pfscext.dao.vo.BillPrechooseVO;
import com.tydic.pfscext.enums.BillStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PlatfUseFeeUpdateInvoiceCheckServiceImpl
implements PlatfUseFeeUpdateInvoiceCheckService {
    private static final Logger logger = LoggerFactory.getLogger(PlatfUseFeeUpdateInvoiceCheckServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private BillPrechooseMapper billPrechooseMapper;

    public PfscExtRspBaseBO query(PlatfUseFeeUpdateInvoiceCheckReqBO reqBO) {
        String applyNo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5e73\u53f0\u4f7f\u7528\u8d39\u66f4\u65b0\u53d1\u7968\u4fe1\u606f\u6821\u9a8c\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)(applyNo = reqBO.getApplyNo()))) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (null == billApplyInfo) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
        }
        if (!BillStatus.NO_APPLY.getCode().equals(billApplyInfo.getBillStatus()) && !BillStatus.APPLIED.getCode().equals(billApplyInfo.getBillStatus())) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u72b6\u6001\u4e3a\u5df2\u7533\u8bf7\u548c\u5df2\u53d7\u7406\u7684\u5f00\u7968\u7533\u8bf7\u5355\u624d\u80fd\u66f4\u65b0\u53d1\u7968\u4fe1\u606f");
        }
        InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
        inquiryPayOrderExt.setApplyNo(applyNo);
        List<InquiryPayOrder> orderList = this.inquiryPayOrderMapper.getList(inquiryPayOrderExt);
        if (CollectionUtils.isEmpty(orderList)) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u53f7" + applyNo + "\u5bf9\u5e94\u7684\u7f34\u8d39\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        BillPrechooseVO billPrechooseVO = new BillPrechooseVO();
        billPrechooseVO.setOrderId(orderList.get(0).getPayOrderNo());
        List<BillPrechoose> billPrechooseList = this.billPrechooseMapper.getList(billPrechooseVO);
        if (CollectionUtils.isEmpty(billPrechooseList)) {
            throw new PfscExtBusinessException("18000", "\u53d1\u7968\u9884\u9009\u4fe1\u606f\u4e0d\u5b58\u5728,\u4e0d\u5141\u8bb8\u66f4\u65b0\u53d1\u7968\u4fe1\u606f");
        }
        return new PfscExtRspBaseBO();
    }
}

