/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryApplyPayInfoService;
import com.tydic.pfscext.api.busi.bo.ApplyPayInfoBO;
import com.tydic.pfscext.api.busi.bo.BusiTabNumbersQryBO;
import com.tydic.pfscext.api.busi.bo.CountTabVO;
import com.tydic.pfscext.api.busi.bo.QueryApplyPayInfoNewRspBO;
import com.tydic.pfscext.api.busi.bo.QueryApplyPayInfoReqBO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.DApplyPayInfoExtMapMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.DApplyPayInfoExtMapPO;
import com.tydic.pfscext.dao.vo.ApplyPayInfoVO;
import com.tydic.pfscext.enums.ApplyPayStatus;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.FinancialStatus;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.PayChannel;
import com.tydic.pfscext.enums.PayResultStatus;
import com.tydic.pfscext.enums.PayableType;
import com.tydic.pfscext.enums.WFStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.service.atom.UserInfoService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import com.tydic.umcext.ability.org.UmcZhEnterpriseOrgQueryAbilityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryApplyPayInfoService"})
public class QueryApplyPayInfoServiceImpl
implements QueryApplyPayInfoService {
    private static final Logger logger = LoggerFactory.getLogger(QueryApplyPayInfoServiceImpl.class);
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private DApplyPayInfoExtMapMapper applyPayInfoExtMapMapper;
    @Autowired
    private UmcZhEnterpriseOrgQueryAbilityService umcZhEnterpriseOrgQueryAbilityService;
    @Value(value="${FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES:014,019,001}")
    private String FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES;
    @Value(value="${FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES:002}")
    private String FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES;

    /*
     * Enabled aggressive block sorting
     */
    @PostMapping(value={"queryListPage"})
    public QueryApplyPayInfoNewRspBO queryListPage(@RequestBody QueryApplyPayInfoReqBO queryApplyPayInfoReqBO) {
        String orderBy;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u670d\u52a1\u5165\u53c2\uff1a" + queryApplyPayInfoReqBO.toString());
        }
        QueryApplyPayInfoNewRspBO rspPageBO = new QueryApplyPayInfoNewRspBO();
        ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
        if (queryApplyPayInfoReqBO.getSource() != null && !"".equals(queryApplyPayInfoReqBO.getSource())) {
            applyPayInfoVO.setSource(queryApplyPayInfoReqBO.getSource());
        }
        if (!StringUtils.isEmpty((CharSequence)queryApplyPayInfoReqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)queryApplyPayInfoReqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(queryApplyPayInfoReqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(queryApplyPayInfoReqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = queryApplyPayInfoReqBO.getSortName() + " " + queryApplyPayInfoReqBO.getSortOrder();
        } else {
            orderBy = " PAYNO desc";
        }
        if (StringUtils.isEmpty((CharSequence)queryApplyPayInfoReqBO.getPayStatus()) && StringUtils.isNotEmpty((CharSequence)queryApplyPayInfoReqBO.getTabId())) {
            ArrayList<String> payStatusCodes = new ArrayList<String>();
            ConfTabStatePO confTabStatePO = this.confTabStateMapper.selectByTabId(Integer.valueOf(queryApplyPayInfoReqBO.getTabId()));
            Collections.addAll(payStatusCodes, confTabStatePO.getStatusCode().split(","));
            applyPayInfoVO.setPayStatusCodes(payStatusCodes);
        }
        Page page = new Page(queryApplyPayInfoReqBO.getPageNo() < 1 ? 1 : queryApplyPayInfoReqBO.getPageNo(), queryApplyPayInfoReqBO.getPageSize() < 1 ? 10 : queryApplyPayInfoReqBO.getPageSize());
        BeanUtils.copyProperties((Object)queryApplyPayInfoReqBO, (Object)applyPayInfoVO);
        if (queryApplyPayInfoReqBO.getPurchaseId() != null) {
            applyPayInfoVO.setPurchaseNo(queryApplyPayInfoReqBO.getPurchaseId());
        }
        logger.debug("\u4f9b\u5e94\u5546\uff1a" + queryApplyPayInfoReqBO.getSupId());
        logger.debug("\u4f9b\u5e94\u5546\uff1a" + queryApplyPayInfoReqBO.getIsProfessionalOrgExt());
        ArrayList<Integer> payableTypes = new ArrayList<Integer>();
        ArrayList<Integer> busiModels = new ArrayList<Integer>();
        applyPayInfoVO.setCompanyId(null);
        applyPayInfoVO.setCompanyName(queryApplyPayInfoReqBO.getCompanyNameNew());
        if ("2".equals(queryApplyPayInfoReqBO.getIsProfessionalOrgExt())) {
            busiModels.add(1);
            payableTypes.add(1);
            applyPayInfoVO.setSupplierId(queryApplyPayInfoReqBO.getSupId());
        }
        if ("0".equals(queryApplyPayInfoReqBO.getIsProfessionalOrgExt())) {
            busiModels.add(0);
            payableTypes.add(2);
            payableTypes.add(3);
            payableTypes.add(4);
            payableTypes.add(5);
            payableTypes.add(6);
            payableTypes.add(7);
            payableTypes.add(8);
            payableTypes.add(9);
            payableTypes.add(10);
            payableTypes.add(11);
            payableTypes.add(12);
            if ("2".equals(queryApplyPayInfoReqBO.getPurchaseOrSupplier())) {
                applyPayInfoVO.setReceiptCompany(queryApplyPayInfoReqBO.getCompanyId());
            }
        }
        if ("1".equals(queryApplyPayInfoReqBO.getIsProfessionalOrgExt())) {
            applyPayInfoVO.setPurchaseNo(queryApplyPayInfoReqBO.getCompanyId());
            if ("2".equals(queryApplyPayInfoReqBO.getPurchaseOrSupplier())) {
                if (queryApplyPayInfoReqBO.getPurchaseId() == null) {
                    applyPayInfoVO.setPurchaseNo(null);
                } else {
                    applyPayInfoVO.setPurchaseNo(queryApplyPayInfoReqBO.getPurchaseId());
                }
                applyPayInfoVO.setSupplierId(queryApplyPayInfoReqBO.getOrgId());
            } else if (this.checkPurchaserId(queryApplyPayInfoReqBO)) {
                applyPayInfoVO.setPurchaserId(queryApplyPayInfoReqBO.getUserId().toString());
            }
        }
        logger.debug("\u4ed8\u6b3e\u67e5\u8be2\u5165\u53c2===" + applyPayInfoVO.toString());
        List<Object> applyPayInfoVOs = new ArrayList();
        if ("1".equals(queryApplyPayInfoReqBO.getIsSelect())) {
            if (CollectionUtils.isEmpty((Collection)queryApplyPayInfoReqBO.getPayNoList())) {
                logger.error("\u5bfc\u51fa\u53c2\u6570\u5f02\u5e38\uff01");
                throw new PfscExtBusinessException("18000", "\u5bfc\u51fa\u53c2\u6570\u5f02\u5e38");
            }
            applyPayInfoVOs = this.applyPayInfoMapper.queryExportByPayNo(queryApplyPayInfoReqBO.getPayNoList());
        } else {
            applyPayInfoVOs = this.applyPayInfoMapper.selectListPayableList(applyPayInfoVO, (Page<Map<String, Object>>)page, orderBy, payableTypes, busiModels);
        }
        if (!"1".equals(queryApplyPayInfoReqBO.getIsExport())) {
            ArrayList<BusiTabNumbersQryBO> tabCountList = new ArrayList<BusiTabNumbersQryBO>();
            if (!CollectionUtils.isEmpty((Collection)queryApplyPayInfoReqBO.getTabIdList())) {
                List<CountTabVO> countTabVOList = this.applyPayInfoMapper.selectListPayableListToCount(applyPayInfoVO, payableTypes, busiModels);
                ConfTabStatePO po = new ConfTabStatePO();
                po.setTabIdList(queryApplyPayInfoReqBO.getTabIdList());
                po.setObjType(4);
                List<ConfTabStatePO> tabStatePOS = this.confTabStateMapper.getList(po);
                if (!CollectionUtils.isEmpty(tabStatePOS)) {
                    for (ConfTabStatePO tabStatePO : tabStatePOS) {
                        BusiTabNumbersQryBO bo = new BusiTabNumbersQryBO();
                        for (CountTabVO countTabVO : countTabVOList) {
                            if (!tabStatePO.getStatusCode().contains(countTabVO.getPayStatus())) continue;
                            if (bo.getTabsCount() != null) {
                                bo.setTabsCount(Integer.valueOf(bo.getTabsCount() + countTabVO.getCountNum()));
                                continue;
                            }
                            bo.setTabsCount(countTabVO.getCountNum());
                        }
                        bo.setTabId(tabStatePO.getTabId());
                        bo.setTabName(tabStatePO.getTabName());
                        tabCountList.add(bo);
                    }
                }
            }
            rspPageBO.setTabCountList(tabCountList);
        }
        LinkedList<ApplyPayInfoBO> applyPayInfoBOs = new LinkedList<ApplyPayInfoBO>();
        HashMap<Long, String> purchaseMap = new HashMap<Long, String>();
        if (!applyPayInfoVOs.isEmpty()) {
            Iterator<Object> iterator = applyPayInfoVOs.iterator();
            while (iterator.hasNext()) {
                PayResultStatus sta;
                String s;
                ApplyPayInfoVO payInfoVO;
                applyPayInfoVO = payInfoVO = (ApplyPayInfoVO)iterator.next();
                ApplyPayInfoBO applyPayInfoBO = new ApplyPayInfoBO();
                BeanUtils.copyProperties((Object)applyPayInfoVO, (Object)applyPayInfoBO);
                applyPayInfoBO.setPayableNo(payInfoVO.getPayableNo());
                if (applyPayInfoVO.getPaytableType() != null && PayableType.getInstance(s = applyPayInfoVO.getPaytableType().toString()) != null) {
                    applyPayInfoBO.setPaytableTypeStr(PayableType.getInstance(s).getDescr());
                }
                OrderSource orderSourceEnum = OrderSource.getInstance((String)String.valueOf(applyPayInfoBO.getSource()));
                applyPayInfoBO.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
                applyPayInfoBO.setSupplierStr(applyPayInfoBO.getSupplierName());
                if (applyPayInfoVO.getPayStatus() != null) {
                    applyPayInfoBO.setPayStatusStr(ApplyPayStatus.getInstance(applyPayInfoVO.getPayStatus().toString()).getDescr());
                }
                if (payInfoVO.getPurchaseNo() != null) {
                    if (purchaseMap.get(payInfoVO.getPurchaseNo()) != null) {
                        applyPayInfoBO.setPurchaseName((String)purchaseMap.get(payInfoVO.getPurchaseNo()));
                    } else {
                        String purcahseName = this.organizationInfoService.queryOrgName(payInfoVO.getPurchaseNo());
                        purchaseMap.put(payInfoVO.getPurchaseNo(), purcahseName);
                        applyPayInfoBO.setPurchaseName(purcahseName);
                    }
                }
                if ((sta = PayResultStatus.getInstance(applyPayInfoBO.getPayStatus())) == PayResultStatus.CANCEL || sta == PayResultStatus.SUCCESS) {
                    applyPayInfoBO.setApplyClosed("Y");
                } else {
                    applyPayInfoBO.setApplyClosed("N");
                }
                if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getFinancialStatus())) {
                    applyPayInfoBO.setFinancialStatusDescr(this.enumsService.getDescr(FinancialStatus.getInstance(applyPayInfoBO.getFinancialStatus())));
                }
                if (StringUtils.isNotEmpty((CharSequence)payInfoVO.getPayChannel())) {
                    applyPayInfoBO.setPayChannel(Integer.valueOf(payInfoVO.getPayChannel()));
                    applyPayInfoBO.setPayChannelStr(PayChannel.getInstance(payInfoVO.getPayChannel()).getDescr());
                }
                if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getApprovalStatus())) {
                    applyPayInfoBO.setApprovalStatusDescr(this.enumsService.getDescr(WFStatus.getInstance(applyPayInfoBO.getApprovalStatus())));
                    if (WFStatus.APPROVAL_COMPLETE.getCode().equals(applyPayInfoBO.getApprovalStatus())) {
                        if (StringUtils.isNotBlank((CharSequence)applyPayInfoBO.getFinancialStatusDescr())) {
                            applyPayInfoBO.setApprovalStatusDescr(applyPayInfoBO.getApprovalStatusDescr() + "(" + applyPayInfoBO.getFinancialStatusDescr() + ")");
                        } else {
                            applyPayInfoBO.setApprovalStatusDescr(applyPayInfoBO.getApprovalStatusDescr() + "(\u53d1\u9001\u8d22\u52a1\u4e2d)");
                        }
                    }
                }
                if (applyPayInfoBO.getPayChannel() != null && (PayChannel.WECHAT.getCode().equals(applyPayInfoBO.getPayChannel().toString()) || PayChannel.ZFB.getCode().equals(applyPayInfoBO.getPayChannel().toString()))) {
                    applyPayInfoBO.setReceiptAcctNo(null);
                    applyPayInfoBO.setRecAcctName(null);
                    applyPayInfoBO.setOpenBankName(null);
                }
                if (applyPayInfoBO.getPayChannel() != null && StrUtil.isNotBlank((CharSequence)applyPayInfoBO.getPayno())) {
                    Map<String, String> mapCodeValue;
                    if (PayChannel.WECHAT.getCode().equals(applyPayInfoBO.getPayChannel().toString()) || PayChannel.ZFB.getCode().equals(applyPayInfoBO.getPayChannel().toString())) {
                        applyPayInfoBO.setRecAcctName(applyPayInfoBO.getSupplierName());
                        applyPayInfoBO.setOpenBankName(null);
                        applyPayInfoBO.setReceiptAcctNo(null);
                    } else if (PayChannel.GYLJR.getCode().equals(applyPayInfoBO.getPayChannel().toString())) {
                        mapCodeValue = this.mapApplyPayInfoCodeValue(applyPayInfoBO.getPayno());
                        if (!mapCodeValue.isEmpty()) {
                            applyPayInfoBO.setRecAcctName(Optional.ofNullable(mapCodeValue.get("corpNameAccept")).orElse(""));
                            applyPayInfoBO.setOpenBankName(null);
                            applyPayInfoBO.setReceiptAcctNo(null);
                        }
                    } else if (PayChannel.ZGYH.getCode().equals(applyPayInfoBO.getPayChannel().toString())) {
                        mapCodeValue = this.mapApplyPayInfoCodeValue(applyPayInfoBO.getPayno());
                        if (!mapCodeValue.isEmpty()) {
                            applyPayInfoBO.setRecAcctName(Optional.ofNullable(mapCodeValue.get("chinaBankAccountName")).orElse(""));
                            applyPayInfoBO.setOpenBankName(null);
                            applyPayInfoBO.setReceiptAcctNo(Optional.ofNullable(mapCodeValue.get("chinaBankAccountNo")).orElse(""));
                        }
                    } else if (PayChannel.ZGGSYH.getCode().equals(applyPayInfoBO.getPayChannel().toString())) {
                        mapCodeValue = this.mapApplyPayInfoCodeValue(applyPayInfoBO.getPayno());
                        if (!mapCodeValue.isEmpty()) {
                            applyPayInfoBO.setRecAcctName(Optional.ofNullable(mapCodeValue.get("accountName")).orElse(""));
                            applyPayInfoBO.setOpenBankName(Optional.ofNullable(mapCodeValue.get("icbcBankName")).orElse(""));
                            applyPayInfoBO.setReceiptAcctNo(Optional.ofNullable(mapCodeValue.get("accountNo")).orElse(""));
                        }
                    } else if (PayChannel.ZHCQT.getCode().equals(applyPayInfoBO.getPayChannel().toString()) && !(mapCodeValue = this.mapApplyPayInfoCodeValue(applyPayInfoBO.getPayno())).isEmpty()) {
                        applyPayInfoBO.setRecAcctName(Optional.ofNullable(mapCodeValue.get("cnncPayeeAcctName")).orElse(""));
                        applyPayInfoBO.setOpenBankName(Optional.ofNullable(mapCodeValue.get("cnncRemitBankName")).orElse(""));
                        applyPayInfoBO.setReceiptAcctNo(Optional.ofNullable(mapCodeValue.get("cnncPayeeAcctNo")).orElse(""));
                    }
                }
                applyPayInfoBOs.add(applyPayInfoBO);
            }
        }
        rspPageBO.setRows(applyPayInfoBOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }

    private Map<String, String> mapApplyPayInfoCodeValue(String payno) {
        DApplyPayInfoExtMapPO applyPayInfoExtMapQry = new DApplyPayInfoExtMapPO();
        applyPayInfoExtMapQry.setObjId(payno);
        applyPayInfoExtMapQry.setObjType(1);
        List<DApplyPayInfoExtMapPO> payInfoExtMapList = this.applyPayInfoExtMapMapper.getList(applyPayInfoExtMapQry);
        HashMap<String, String> mapCodeValue = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(payInfoExtMapList)) {
            mapCodeValue.putAll(payInfoExtMapList.stream().collect(Collectors.toMap(DApplyPayInfoExtMapPO::getFieldCode, DApplyPayInfoExtMapPO::getFieldValue, (c, n) -> c)));
        }
        return mapCodeValue;
    }

    private boolean checkPurchaserId(QueryApplyPayInfoReqBO queryApplyPayInfoReqBO) {
        List roleIds;
        if (!CollectionUtils.isEmpty((Collection)queryApplyPayInfoReqBO.getPermission()) && !CollectionUtils.isEmpty(roleIds = queryApplyPayInfoReqBO.getPermission().stream().map(AuthorityInfo::getKey).distinct().collect(Collectors.toList()))) {
            if (StrUtil.isBlank((CharSequence)this.FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES)) {
                return false;
            }
            List purchaserRoles = Arrays.stream(this.FSC_AUTH_PUR_PAYMENT_PURCHASER_ROLES.split("[,\uff0c]")).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
            if (roleIds.stream().anyMatch(purchaserRoles::contains)) {
                if (StrUtil.isBlank((CharSequence)this.FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES)) {
                    return true;
                }
                List companyRoles = Arrays.stream(this.FSC_AUTH_PUR_PAYMENT_COMPANY_ROLES.split("[,\uff0c]")).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
                return roleIds.stream().noneMatch(companyRoles::contains);
            }
        }
        return false;
    }
}

