/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.pfscext.api.aisino.bo.BusiUpdateBillApplyFileUrlReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiUpdateBillApplyFileUrlRspBO;
import com.tydic.pfscext.api.busi.QueryBillApplyInfoExportService;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyInfoExportReqBO;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyInfoExportRspBO;
import com.tydic.pfscext.api.busi.vo.SaleItemInfoExportVO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryBillApplyInfoExportService"})
public class QueryBillApplyInfoExportServiceImpl
implements QueryBillApplyInfoExportService {
    @Autowired
    BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    SaleItemInfoMapper saleItemInfoMapper;

    @PostMapping(value={"queryBillApplyInfoForExport"})
    public QueryBillApplyInfoExportRspBO queryBillApplyInfoForExport(@RequestBody QueryBillApplyInfoExportReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u4fe1\u606f\u670d\u52a1-[applyNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPurchaseNo())) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u4fe1\u606f\u670d\u52a1-[purchaseNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryBillApplyInfoExportRspBO rspBO = new QueryBillApplyInfoExportRspBO();
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("applyNo", reqBO.getApplyNo());
        p.put("purchaseNo", reqBO.getPurchaseNo());
        rspBO = this.billApplyInfoMapper.queryBillApplyInfo(p);
        if (null != rspBO) {
            InvoiceType instance;
            if (StringUtils.isNotEmpty((CharSequence)rspBO.getInvoiceType()) && null != (instance = InvoiceType.getInstance(Integer.valueOf(rspBO.getInvoiceType())))) {
                rspBO.setInvoiceTypeStr(instance.getCodeDescr());
            }
            rspBO.setAddrDesc(rspBO.getProvince() + rspBO.getCity() + rspBO.getCounty() + rspBO.getAddrDesc());
            List<SaleItemInfoExportVO> itemInfoList = this.saleItemInfoMapper.getSaleItemInfoByApplyNo(rspBO.getApplyNo());
            if (!CollectionUtils.isEmpty(itemInfoList)) {
                rspBO.setItemInfoList(itemInfoList);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u4fe1\u606f\u6210\u529f\uff01");
        return rspBO;
    }

    @PostMapping(value={"updateBillApplyInfoFileUrl"})
    public BusiUpdateBillApplyFileUrlRspBO updateBillApplyInfoFileUrl(@RequestBody BusiUpdateBillApplyFileUrlReqBO reqBO) {
        if (null == reqBO) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("18000", "\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getFileName()) && StringUtils.isEmpty((CharSequence)reqBO.getFileUrl()) && StringUtils.isEmpty((CharSequence)reqBO.getTemplateStatus())) {
            throw new PfscExtBusinessException("18000", "\u6587\u4ef6\u5730\u5740\u548c\u540d\u79f0\u548c\u72b6\u6001\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        BusiUpdateBillApplyFileUrlRspBO rspBO = new BusiUpdateBillApplyFileUrlRspBO();
        String reqStr = JSONObject.toJSONString((Object)reqBO);
        BillApplyInfo info = (BillApplyInfo)JSONObject.parseObject((String)reqStr, BillApplyInfo.class);
        if (!StringUtils.isEmpty((CharSequence)reqBO.getFileUrl())) {
            info.setTemplateFileUrl(reqBO.getFileUrl());
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getFileName())) {
            info.setTemplateFileName(reqBO.getFileName());
        }
        this.billApplyInfoMapper.updateByPrimaryKeySelective(info);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

