/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryPayPurchaseOrderInfoForPurchaseOrgService;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoForPurchaseOrgReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoForPurchaseOrgRspBO;
import com.tydic.pfscext.api.busi.vo.PayItemInfoExtVO;
import com.tydic.pfscext.dao.PayItemInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayItemInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryPayPurchaseOrderInfoForPurchaseOrgServiceImpl
implements QueryPayPurchaseOrderInfoForPurchaseOrgService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayPurchaseOrderInfoForPurchaseOrgServiceImpl.class);
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public QueryPayPurchaseOrderInfoForPurchaseOrgRspBO queryListPage(QueryPayPurchaseOrderInfoForPurchaseOrgReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u7968\u5f85\u7533\u8bf7\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getOrderDateEnd()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u5f85\u7533\u8bf7\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u8ba2\u5355\u65e5\u671f\uff08\u7ed3\u675f\uff09[orderDateEnd]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u5f85\u7533\u8bf7\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u8fd0\u8425\u5546\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierNo()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u5f85\u7533\u8bf7\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u4f9b\u5e94\u5546[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryPayPurchaseOrderInfoForPurchaseOrgRspBO rspBO = new QueryPayPurchaseOrderInfoForPurchaseOrgRspBO();
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        BeanUtils.copyProperties((Object)reqBO, (Object)payPurchaseOrderInfo);
        payPurchaseOrderInfo.setSource(OrderSource.ELECTRIC_MARKET.getCode());
        payPurchaseOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        payPurchaseOrderInfo.setPurchaseNo(reqBO.getCompanyId());
        if (reqBO.getPurchaseOrderCode() != null) {
            payPurchaseOrderInfo.setPurchaseOrderCode(reqBO.getPurchaseOrderCode());
        }
        if (reqBO.getSupplierNo() != null) {
            payPurchaseOrderInfo.setSupplierNo(reqBO.getSupplierNo());
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = "ORDER_DATE,ORDER_ID desc";
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        LinkedList<PayPurchaseOrderInfoBO> boList = new LinkedList<PayPurchaseOrderInfoBO>();
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        BeanUtils.copyProperties((Object)payPurchaseOrderInfo, (Object)vo);
        vo.setOrderDateStart(reqBO.getOrderDateStart());
        vo.setOrderDateEnd(reqBO.getOrderDateEnd());
        vo.setOrderBy(orderBy);
        vo.setReconcilitionStatus("1");
        List<PayPurchaseOrderInfo> payPurchaseOrderInfoPOs = this.payPurchaseOrderInfoMapper.getListPageExcludePurchase(vo, (Page<Map<String, Object>>)page);
        for (PayPurchaseOrderInfo singlePO : payPurchaseOrderInfoPOs) {
            PayPurchaseOrderInfoBO singleBO = new PayPurchaseOrderInfoBO();
            BeanUtils.copyProperties((Object)singlePO, (Object)singleBO);
            singleBO.setParentOrderId(String.valueOf(singlePO.getParentOrderId()));
            singleBO.setOrderId(String.valueOf(singlePO.getOrderId()));
            singleBO.setInspectionId(String.valueOf(singlePO.getInspectionId()));
            LinkedList<PayItemInfoExtVO> itemVOList = new LinkedList<PayItemInfoExtVO>();
            List<PayItemInfo> itemList = this.payItemInfoMapper.selectByOrderId(singlePO.getOrderId());
            for (PayItemInfo singleItem : itemList) {
                PayItemInfoExtVO sinleItemVO = new PayItemInfoExtVO();
                BeanUtils.copyProperties((Object)singleItem, (Object)sinleItemVO);
                sinleItemVO.setSeq(String.valueOf(singleItem.getSeq()));
                itemVOList.add(sinleItemVO);
            }
            singleBO.setItemInfos(itemVOList);
            OrderStatus orderStatusEnum = OrderStatus.getInstance(singleBO.getOrderStatus());
            singleBO.setOrderStatusStr(this.enumsService.getDescr(orderStatusEnum));
            boList.add(singleBO);
        }
        payPurchaseOrderInfo = this.payPurchaseOrderInfoMapper.sumUpExcludePurchase(vo);
        rspBO.setRows(boList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotalAmt(payPurchaseOrderInfo.getOrderAmt());
        return rspBO;
    }
}

