/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.pfscext.api.busi.QueryPayableDetailService;
import com.tydic.pfscext.api.busi.bo.BusiTabNumbersQryBO;
import com.tydic.pfscext.api.busi.bo.CountTabVO;
import com.tydic.pfscext.api.busi.bo.PayableDetailBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailNewRspBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableDetailReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayableOrderReqBO;
import com.tydic.pfscext.api.busi.bo.SaleOrderInfoBO;
import com.tydic.pfscext.base.PfscExtRspPageBaseBO;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.ApplyPayInfoMapper;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.PayableDetailChangeMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.SaleOrderInfoMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.PayableDetailChange;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.po.SaleOrderInfo;
import com.tydic.pfscext.dao.vo.ApplyPayInfoVO;
import com.tydic.pfscext.enums.BaseEnums;
import com.tydic.pfscext.enums.OrderSource;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.PayablePayType;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.EnumsService;
import com.tydic.pfscext.service.atom.OrderService;
import com.tydic.pfscext.service.atom.OrganizationInfoService;
import com.tydic.pfscext.utils.AntiSqlInjectionManage;
import com.tydic.pfscext.utils.BusinessUtils;
import com.tydic.pfscext.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.QueryPayableDetailService"})
public class QueryPayableDetailServiceImpl
implements QueryPayableDetailService {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayableDetailServiceImpl.class);
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private PayableDetailChangeMapper payableDetailChangeMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private ApplyPayInfoMapper applyPayInfoMapper;

    @PostMapping(value={"queryListPage"})
    public QueryPayableDetailNewRspBO queryListPage(@RequestBody QueryPayableDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9884\u4ed8\u5e94\u4ed8\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getSource()) || reqBO.getSource() == null) {
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getTabId()) && "7777".equals(reqBO.getTabId())) {
            ArrayList<String> payableStatusCodeList = new ArrayList<String>(2);
            payableStatusCodeList.add(PayableStatus.PENDING.getCode());
            payableStatusCodeList.add(PayableStatus.PAYING.getCode());
            reqBO.setPayableStatusCodes(payableStatusCodeList);
        }
        if (null != reqBO.getIsShop() && 0 == reqBO.getIsShop()) {
            reqBO.setSource(OrderSource.PRICE_FRAME.getCode());
        }
        ArrayList<Integer> payableTypes = new ArrayList<Integer>();
        ArrayList<Integer> busiModels = new ArrayList<Integer>();
        ArrayList<Integer> countPayableTypes = new ArrayList<Integer>();
        ApplyPayInfoVO applyPayInfoVO = new ApplyPayInfoVO();
        if (reqBO.getIsProfessionalOrgExt().equals("0")) {
            payableTypes.add(1);
            payableTypes.add(8);
            reqBO.setPayableTypes(payableTypes);
            busiModels.add(0);
            countPayableTypes.add(2);
            countPayableTypes.add(3);
            countPayableTypes.add(4);
            countPayableTypes.add(5);
            countPayableTypes.add(6);
            countPayableTypes.add(7);
            countPayableTypes.add(8);
            countPayableTypes.add(9);
            countPayableTypes.add(10);
            countPayableTypes.add(11);
            countPayableTypes.add(12);
        }
        applyPayInfoVO.setSource(reqBO.getSource());
        Long operUnitNo = BusinessUtils.judgeOperUnitNo(reqBO.getOperUnitNo(), reqBO.getCompanyId(), false);
        reqBO.setCompanyId(operUnitNo);
        QueryPayableDetailNewRspBO rspPageBO = new QueryPayableDetailNewRspBO();
        String orderBy = null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        } else {
            orderBy = " PAYABLE_NO desc";
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<PayableDetailPO> payableDetailPOs = this.payableDetailMapper.getListPageByTerms(reqBO, (Page<Map<String, Object>>)page, orderBy);
        ArrayList<BusiTabNumbersQryBO> tabCountList = new ArrayList<BusiTabNumbersQryBO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTabIdList())) {
            logger.debug("----\u67e5\u8be2\u9875\u7b7e\u7684\u6570\u91cf----");
            List<CountTabVO> countTabVOList = this.applyPayInfoMapper.selectListPayableListToCount(applyPayInfoVO, countPayableTypes, busiModels);
            ConfTabStatePO po = new ConfTabStatePO();
            po.setTabIdList(reqBO.getTabIdList());
            po.setObjType(4);
            List<ConfTabStatePO> tabStatePOS = this.confTabStateMapper.getList(po);
            if (!CollectionUtils.isEmpty(tabStatePOS)) {
                for (ConfTabStatePO tabStatePO : tabStatePOS) {
                    BusiTabNumbersQryBO bo = new BusiTabNumbersQryBO();
                    for (CountTabVO countTabVO : countTabVOList) {
                        if (!tabStatePO.getStatusCode().contains(countTabVO.getPayStatus())) continue;
                        if (bo.getTabsCount() != null) {
                            bo.setTabsCount(Integer.valueOf(bo.getTabsCount() + countTabVO.getCountNum()));
                            continue;
                        }
                        bo.setTabsCount(countTabVO.getCountNum());
                    }
                    bo.setTabId(tabStatePO.getTabId());
                    bo.setTabName(tabStatePO.getTabName());
                    tabCountList.add(bo);
                }
            }
            if (reqBO.getTabIdList().contains("7777")) {
                BusiTabNumbersQryBO bo = new BusiTabNumbersQryBO();
                bo.setTabName("\u5f85\u4ed8\u6b3e");
                bo.setTabId("7777");
                bo.setTabsCount(Integer.valueOf(page.getTotalCount()));
                tabCountList.add(bo);
            }
        }
        rspPageBO.setTabCountList(tabCountList);
        LinkedList<PayableDetailBO> payableDetailBOs = new LinkedList<PayableDetailBO>();
        HashSet<Long> purchaseOrderIdsSet = null;
        if (!CollectionUtils.isEmpty(payableDetailPOs)) {
            purchaseOrderIdsSet = new HashSet<Long>();
            for (PayableDetailPO payableDetailPO : payableDetailPOs) {
                PayableDetailBO singleDetail = new PayableDetailBO();
                BeanUtils.copyProperties((Object)payableDetailPO, (Object)singleDetail);
                singleDetail.setOrderId(FscStringUtils.valueOf(payableDetailPO.getOrderId()));
                if (payableDetailPO.getOrderId() != null) {
                    purchaseOrderIdsSet.add(payableDetailPO.getOrderId());
                }
                PayableStatus payableEnum = PayableStatus.getInstance(singleDetail.getPayableStatus());
                singleDetail.setPayableStatusStr(this.enumsService.getDescr(payableEnum));
                OrderSource orderSourceEnum = OrderSource.getInstance((String)singleDetail.getSource());
                singleDetail.setSourceStr(this.enumsService.getDescr((BaseEnums)orderSourceEnum));
                singleDetail.setSupplierStr(payableDetailPO.getSupplierName());
                String orgNameStr = this.organizationInfoService.queryOrgName(singleDetail.getOperatorId());
                singleDetail.setOperatorStr(orgNameStr);
                PayablePayType payTypeEnum = PayablePayType.getInstance(singleDetail.getPayType());
                singleDetail.setPayTypeStr(this.enumsService.getDescr(payTypeEnum));
                singleDetail.setPayTypeName(this.enumsService.getDescr(payTypeEnum));
                singleDetail.setAllInPaying("N");
                if (PayableStatus.SUCCESS.getCode().equals(singleDetail.getPayableStatus()) || PayableStatus.TERMINATION.getCode().equals(singleDetail.getPayableStatus()) || singleDetail.getPayableAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    singleDetail.setAllInPaying("Y");
                } else {
                    ApplyDetail applyDetail = this.applyDetailMapper.selectAmtByPayableNo(singleDetail.getPayableNo());
                    if (singleDetail.getPayableAmt().subtract(applyDetail != null ? applyDetail.getAmt() : BigDecimal.ZERO).subtract(singleDetail.getPaidAmt()).compareTo(BigDecimal.ZERO) == 0) {
                        singleDetail.setAllInPaying("Y");
                    }
                }
                PayableDetailChange change = new PayableDetailChange();
                change.setPayableNo(payableDetailPO.getPayableNo());
                change.setChangeType("2");
                List<PayableDetailChange> changeList = this.payableDetailChangeMapper.getList(change);
                if (!CollectionUtils.isEmpty(changeList)) {
                    singleDetail.setShowChangeFlag("1");
                } else {
                    singleDetail.setShowChangeFlag("0");
                }
                payableDetailBOs.add(singleDetail);
            }
        }
        rspPageBO.setRows(payableDetailBOs);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        logger.debug("\u67e5\u8be2\u9884\u4ed8\u5e94\u4ed8\u670d\u52a1\u51fa\u53c2-->{}", (Object)JSON.toJSONString((Object)rspPageBO));
        return rspPageBO;
    }

    @PostMapping(value={"queryPayableOrder"})
    public PfscExtRspPageBaseBO<SaleOrderInfoBO> queryPayableOrder(@RequestBody QueryPayableOrderReqBO reqBO) {
        logger.info("\u5e94\u4ed8\u5355\u67e5\u8be2\u4e0b\u6e38\u5f00\u7968\u4fe1\u606f\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        if (StringUtils.isEmpty((Object)reqBO.getNotificationNo())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PfscExtRspPageBaseBO rspBO = new PfscExtRspPageBaseBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        String orderBy = "t.SALE_ORDER_CODE DESC";
        List<SaleOrderInfo> saleOrderInfos = this.saleOrderInfoMapper.getListByNotiNo(reqBO.getNotificationNo(), (Page<Map<String, Object>>)page, orderBy);
        LinkedList<SaleOrderInfoBO> rows = new LinkedList<SaleOrderInfoBO>();
        for (SaleOrderInfo saleOrderInfo : saleOrderInfos) {
            SaleOrderInfoBO bo = new SaleOrderInfoBO();
            BeanUtils.copyProperties((Object)saleOrderInfo, (Object)bo);
            bo.setInspectionId(saleOrderInfo.getInspectionId().toString());
            bo.setOrderStatusStr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus()).getDescr());
            rows.add(bo);
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

