/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.active.app.ability.ActQryActivitiesByConditionAbilityService;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityReqBO;
import com.tydic.active.app.ability.bo.ActQryActivitiesByConditionAbilityRspBO;
import com.tydic.active.app.common.bo.ActivitiesBO;
import com.tydic.pfscext.api.busi.VerifyPurchaseOrderInfoService;
import com.tydic.pfscext.api.busi.bo.PurchaseOrderVerifyReqBO;
import com.tydic.pfscext.api.busi.bo.QueryPayPurchaseOrderInfoAwaitReqBO;
import com.tydic.pfscext.api.busi.bo.VerifyPurchaseOrderRspBO;
import com.tydic.pfscext.base.AuthorityInfo;
import com.tydic.pfscext.dao.ConfTabStateMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.ConfTabStatePO;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.YesNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.busi.VerifyPurchaseOrderInfoService"})
public class VerifyPurchaseOrderInfoServiceImpl
implements VerifyPurchaseOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(VerifyPurchaseOrderInfoServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(VerifyPurchaseOrderInfoServiceImpl.class);
    @Autowired
    private ConfTabStateMapper confTabStateMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private ActQryActivitiesByConditionAbilityService actQryActivitiesByConditionAbilityService;
    @Value(value="${FSC_MATCH_UP_FL_GLY_ROLE:119,020}")
    private String fscMatchFlRoles;
    @Value(value="${FSC_UMC_OPER_UNIT_NO:494330226086400000}")
    private Long operUnitNo;

    @PostMapping(value={"purchaseOrderVerify"})
    public VerifyPurchaseOrderRspBO purchaseOrderVerify(@RequestBody PurchaseOrderVerifyReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u8fd0\u8425\u5546\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VerifyPurchaseOrderRspBO rspBO = new VerifyPurchaseOrderRspBO();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getVerifyFrom())) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u6821\u9a8c\u6765\u6e90\u3010verifyFrom\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        logger.debug("\u6821\u9a8cverifyFrom\u5165\u53c2\uff1a" + reqBO.getVerifyFrom());
        List<Object> payPurchaseOrderInfoList = new ArrayList();
        if ("0".equals(reqBO.getIsSelectOrder())) {
            QueryPayPurchaseOrderInfoAwaitReqBO pageReqBO = reqBO.getQueryPayPurchaseOrderInfoAwaitReqBO();
            if (null == pageReqBO) {
                throw new PfscExtBusinessException("0001", "\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u9875\u9762\u53c2\u6570\u5bf9\u8c61[queryPayPurchaseOrderInfoAwaitReqBO]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String isProfessionalOrgExt = reqBO.getIsProfessionalOrgExt();
            PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
            Long excludeOrg = null;
            if ("0".equals(isProfessionalOrgExt)) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pageReqBO.getBusiModel())) {
                    vo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
                } else {
                    vo.setBusiModel(pageReqBO.getBusiModel());
                }
                vo.setOperUnitNo(reqBO.getCompanyId());
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaseNo())) {
                    vo.setPurchaseNo(Long.valueOf(pageReqBO.getPurchaseNo()));
                } else {
                    excludeOrg = reqBO.getCompanyId();
                }
                vo.setExcludeOrg(excludeOrg);
            } else if ("1".equals(isProfessionalOrgExt)) {
                vo.setPurchaseNo(reqBO.getCompanyId());
                vo.setBusiModel(BusiModel.MATCH_UP_MODEL.getCode());
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaserId())) {
                    vo.setPurchaserId(Long.valueOf(pageReqBO.getPurchaserId()));
                }
                if (pageReqBO.getIsActivity() != null && YesNo.YES.getCode().equals(pageReqBO.getIsActivity())) {
                    vo.setOperUnitNo(this.operUnitNo);
                    List<String> activityIds = this.getActivityIds(reqBO, pageReqBO);
                    if (CollectionUtils.isEmpty(activityIds)) {
                        rspBO.setRespCode("18000");
                        rspBO.setRespDesc("\u6d3b\u52a8\u67e5\u8be2\u4e3a\u7a7a\uff01");
                        return rspBO;
                    }
                    vo.setActivityIdList(activityIds);
                    if (!CollectionUtils.isEmpty((Collection)reqBO.getPermission()) && StringUtils.hasText((String)this.fscMatchFlRoles)) {
                        List<String> list = Arrays.asList(this.fscMatchFlRoles.split(","));
                        if (reqBO.getPermission().stream().map(AuthorityInfo::getKey).anyMatch(list::contains)) {
                            vo.setPurchaserId(null);
                        }
                    }
                }
            } else if ("2".equals(isProfessionalOrgExt)) {
                vo.setSupplierNo(reqBO.getSupId());
                vo.setPurchaserId(null);
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaseNo())) {
                vo.setPurchaseNo(Long.valueOf(pageReqBO.getPurchaseNo()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pageReqBO.getPurchaseProjectId())) {
                vo.setPurchaseProjectId(Long.valueOf(pageReqBO.getPurchaseProjectId()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pageReqBO.getSupplierNo())) {
                vo.setSupplierNo(Long.valueOf(pageReqBO.getSupplierNo()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pageReqBO.getActivityId())) {
                vo.setActivityId(Long.parseLong(pageReqBO.getActivityId()));
            }
            ArrayList orderStatusCodes = Lists.newArrayList();
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pageReqBO.getHandUpStatus())) {
                orderStatusCodes.add(pageReqBO.getHandUpStatus());
            } else if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pageReqBO.getTabId())) {
                ConfTabStatePO confTabStatePO = this.confTabStateMapper.selectByTabId(Integer.valueOf(pageReqBO.getTabId()));
                Collections.addAll(orderStatusCodes, confTabStatePO.getStatusCode().split(","));
            } else {
                orderStatusCodes.add(OrderStatus.NO_APPLY.getCode());
                orderStatusCodes.add(OrderStatus.HANGING.getCode());
                orderStatusCodes.add(OrderStatus.AUTO_HANG_UP.getCode());
                orderStatusCodes.add(OrderStatus.SENDING.getCode());
            }
            vo.setOrderStatusCodes(orderStatusCodes);
            vo.setPurchaseOrderCode(pageReqBO.getPurchaseOrderCode());
            vo.setExtOrderId(pageReqBO.getExtOrderId());
            vo.setOrderDateStart(pageReqBO.getOrderDateStart());
            vo.setOrderDateEnd(pageReqBO.getOrderDateEnd());
            vo.setPayType(pageReqBO.getPayType());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pageReqBO.getInspectionId())) {
                vo.setInspectionId(Long.valueOf(pageReqBO.getInspectionId()));
            }
            vo.setPurchaserName(pageReqBO.getPurchaserName());
            vo.setSource(pageReqBO.getSource());
            vo.setReconciliationStatus(pageReqBO.getReconciliationStatus());
            if ("1".equals(reqBO.getVerifyFrom())) {
                vo.setNoRedundancy("1");
            } else if ("2".equals(reqBO.getVerifyFrom())) {
                vo.setOnlyRedundancy("1");
            }
            payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.getPurchaseOrderListPage(vo, (Page<Map<String, Object>>)new Page(-1, -1));
        } else if ("1".equals(reqBO.getIsSelectOrder())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getInspectionIdList())) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u52fe\u9009\u8ba2\u5355\u5217\u8868[inspectionIdList]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList inspectionIds = Lists.newArrayList();
            reqBO.getInspectionIdList().stream().forEach(inspectionIdStr -> inspectionIds.add(Long.valueOf(inspectionIdStr)));
            payPurchaseOrderInfoList = this.payPurchaseOrderInfoMapper.getListPurchaseOrderInfo(inspectionIds);
        } else {
            throw new PfscExtBusinessException("0001", "\u5206\u7b7e\u7ed3\u7b97\u5f00\u7968\u901a\u77e5\u6821\u9a8c-\u662f\u5426\u52fe\u9009\u8ba2\u5355[isSelectOrder]\u4e0d\u6b63\u786e");
        }
        if (CollectionUtils.isEmpty(payPurchaseOrderInfoList)) {
            throw new PfscExtBusinessException("0001", "\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        HashSet<Long> purchaseNoSet = new HashSet<Long>();
        HashSet<Long> purchaseProjectIdSet = new HashSet<Long>();
        HashSet<String> supplierNameSet = new HashSet<String>();
        ArrayList<String> purchaserIdList = new ArrayList<String>();
        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfoList) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)payPurchaseOrderInfo.getSupplierName())) {
                supplierNameSet.add(payPurchaseOrderInfo.getSupplierName());
            }
            if (payPurchaseOrderInfo.getPurchaserId() != null) {
                purchaserIdList.add(payPurchaseOrderInfo.getPurchaserId().toString());
            }
            purchaseNoSet.add(payPurchaseOrderInfo.getPurchaseNo());
            purchaseProjectIdSet.add(payPurchaseOrderInfo.getPurchaseProjectId());
            if (OrderStatus.NO_APPLY.getCode().equals(payPurchaseOrderInfo.getOrderStatus())) continue;
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("1001");
            return rspBO;
        }
        if ("1".equals(reqBO.getVerifyFrom()) || "2".equals(reqBO.getVerifyFrom())) {
            if (purchaseNoSet.size() != 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("1002");
                return rspBO;
            }
            if (purchaseProjectIdSet.size() != 1) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("1003");
                return rspBO;
            }
        }
        if (!CollectionUtils.isEmpty(supplierNameSet)) {
            String supplierNameArr = ((Object)supplierNameSet).toString();
            rspBO.setSupplierNameArr(supplierNameArr.substring(1, supplierNameArr.length() - 1));
        }
        if (((PayPurchaseOrderInfo)payPurchaseOrderInfoList.get(0)).getPurchaseNo() != null) {
            rspBO.setPurchaseNo(((PayPurchaseOrderInfo)payPurchaseOrderInfoList.get(0)).getPurchaseNo().toString());
        }
        rspBO.setPurchaserIdList(purchaserIdList.stream().distinct().collect(Collectors.toList()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("1000");
        return rspBO;
    }

    private List<String> getActivityIds(PurchaseOrderVerifyReqBO reqBO, QueryPayPurchaseOrderInfoAwaitReqBO pageReqBO) {
        ArrayList<String> activityIds = new ArrayList<String>();
        ActQryActivitiesByConditionAbilityReqBO activitiesByConditionAbilityReqBO = new ActQryActivitiesByConditionAbilityReqBO();
        activitiesByConditionAbilityReqBO.setCreateLoginId(reqBO.getMemIdExt().toString());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)pageReqBO.getActivityId())) {
            activitiesByConditionAbilityReqBO.setActiveId(Long.valueOf(Long.parseLong(pageReqBO.getActivityId())));
        }
        activitiesByConditionAbilityReqBO.setPageNo(Integer.valueOf(-1));
        activitiesByConditionAbilityReqBO.setPageSize(Integer.valueOf(-1));
        log.error("\u5458\u5de5\u798f\u5229\u5206\u7b7e\u6d3b\u52a8\u7ed3\u7b97\u5f00\u7968\u67e5\u8be2\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSON((Object)activitiesByConditionAbilityReqBO));
        ActQryActivitiesByConditionAbilityRspBO actQryActivitiesByConditionAbilityRspBO = this.actQryActivitiesByConditionAbilityService.qryActivitiesByCondition(activitiesByConditionAbilityReqBO);
        log.error("\u5458\u5de5\u798f\u5229\u5206\u7b7e\u6d3b\u52a8\u7ed3\u7b97\u5f00\u7968\u67e5\u8be2\u8c03\u7528\u6d3b\u52a8\u4e2d\u5fc3\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSON((Object)actQryActivitiesByConditionAbilityRspBO.getRecordsTotal()));
        if (actQryActivitiesByConditionAbilityRspBO != null && "0000".equals(actQryActivitiesByConditionAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)actQryActivitiesByConditionAbilityRspBO.getRows())) {
            for (ActivitiesBO activitiesBO : actQryActivitiesByConditionAbilityRspBO.getRows()) {
                if (activitiesBO.getActiveId() == null) continue;
                activityIds.add(activitiesBO.getActiveId() + "");
            }
        }
        return activityIds;
    }
}

