/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.order.pec.ability.bo.UocCreditInfoBO;
import com.tydic.pfscext.external.umc.api.FscUmcQryAccountListExternalService;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalReqBO;
import com.tydic.pfscext.external.umc.bo.FscUmcQryMemListExternalRspBO;
import com.tydic.pfscext.external.uoc.api.FscUocOrderCreditInfoStatisticsQryExternalService;
import com.tydic.pfscext.external.uoc.bo.FscUocOrderCreditInfoStatisticsQryExternalReqBO;
import com.tydic.pfscext.external.uoc.bo.FscUocOrderCreditInfoStatisticsQryExternalRspBO;
import com.tydic.pfscext.service.busi.FscCreditControlUserOverdueBusiService;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserOverdueBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscCreditControlUserOverdueBusiRspBO;
import com.tydic.pfscext.service.comb.api.FscCreditControlUserOverdueCombService;
import com.tydic.pfscext.service.comb.bo.FscCreditControlUserOverdueCombReqBO;
import com.tydic.pfscext.service.comb.bo.FscCreditControlUserOverdueCombRspBO;
import com.tydic.pfscext.service.comb.bo.FscUserOverdueInfoBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ListUtil;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscCreditControlUserOverdueCombServiceImpl
implements FscCreditControlUserOverdueCombService {
    private static final Logger log = LoggerFactory.getLogger(FscCreditControlUserOverdueCombServiceImpl.class);
    @Autowired
    private FscUocOrderCreditInfoStatisticsQryExternalService fscUocOrderCreditInfoStatisticsQryExternalService;
    @Autowired
    private FscCreditControlUserOverdueBusiService fscCreditControlUserOverdueBusiService;
    @Autowired
    private FscUmcQryAccountListExternalService fscUmcQryAccountListExternalService;

    @Override
    public FscCreditControlUserOverdueCombRspBO dealCreditControlUser(FscCreditControlUserOverdueCombReqBO reqBo) {
        FscCreditControlUserOverdueCombRspBO rspBo = FscRu.success(FscCreditControlUserOverdueCombRspBO.class);
        if (CollectionUtils.isEmpty(reqBo.getConfigUserIdList())) {
            rspBo.setRespDesc("\u5165\u53c2[configUserIdList]\u4e3a\u7a7a");
            return rspBo;
        }
        FscUocOrderCreditInfoStatisticsQryExternalReqBO externalReqBo = new FscUocOrderCreditInfoStatisticsQryExternalReqBO();
        externalReqBo.setUserIdList(reqBo.getConfigUserIdList());
        FscUocOrderCreditInfoStatisticsQryExternalRspBO externalRspBo = this.fscUocOrderCreditInfoStatisticsQryExternalService.listUserCreditInfoStatistics(externalReqBo);
        List uocCreditInfoList = externalRspBo.getCreditInfoBOList();
        if (CollectionUtils.isEmpty((Collection)uocCreditInfoList)) {
            log.error("\u7528\u6237\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u66f4\u65b0\u4e2d\u6b62\uff0c\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u8ba2\u5355\u8d26\u671f\u6570\u636e\u4e3a\u7a7a.\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)externalRspBo));
            rspBo.setRespDesc("\u7528\u6237\u903e\u671f\u8ba2\u5355\u7ba1\u63a7\u66f4\u65b0\u4e2d\u6b62\uff0c\u6839\u636e\u7528\u6237ID\u67e5\u8be2\u8ba2\u5355\u8d26\u671f\u6570\u636e\u4e3a\u7a7a.");
            return rspBo;
        }
        List<Long> userIdList = uocCreditInfoList.stream().map(UocCreditInfoBO::getPurNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Long, UmcMemDetailInfoAbilityBO> mapUocUserRole = this.mapUocUserRole(userIdList);
        FscCreditControlUserOverdueBusiReqBO busiReqBo = new FscCreditControlUserOverdueBusiReqBO();
        busiReqBo.setInfoList(uocCreditInfoList.stream().map(uocCreditInfoBo -> {
            FscUserOverdueInfoBO infoBo = new FscUserOverdueInfoBO();
            infoBo.setUserId(uocCreditInfoBo.getPurNo());
            infoBo.setOrderCount(uocCreditInfoBo.getOrderCount());
            infoBo.setOverdueCount(uocCreditInfoBo.getOverdueCount());
            infoBo.setSaleFeeTotal(uocCreditInfoBo.getSalefeeTotal());
            infoBo.setOverdueSaleFeeTotal(uocCreditInfoBo.getOverdueSaleFeeTotal());
            if (mapUocUserRole.containsKey(uocCreditInfoBo.getPurNo())) {
                UmcMemDetailInfoAbilityBO umcUserBo = (UmcMemDetailInfoAbilityBO)mapUocUserRole.get(uocCreditInfoBo.getPurNo());
                infoBo.setConfigOrgId(umcUserBo.getOrgId());
                infoBo.setConfigOrgName(umcUserBo.getOrgName());
                infoBo.setConfigOrgPath(umcUserBo.getOrgTreePath());
                infoBo.setConfigOrgFullName(umcUserBo.getOrgFullName());
                infoBo.setConfigUserAccount(umcUserBo.getRegAccount());
                infoBo.setConfigUserName(umcUserBo.getMemName2());
                infoBo.setConfigAuthRole(umcUserBo.getUserFullRoleName());
            }
            return infoBo;
        }).collect(Collectors.toList()));
        FscCreditControlUserOverdueBusiRspBO busiRspBo = this.fscCreditControlUserOverdueBusiService.dealCreditControlUser(busiReqBo);
        return FscRu.js((Object)busiRspBo, FscCreditControlUserOverdueCombRspBO.class);
    }

    private Map<Long, UmcMemDetailInfoAbilityBO> mapUocUserRole(List<Long> userIdList) {
        HashMap<Long, UmcMemDetailInfoAbilityBO> mapUserInfo = new HashMap<Long, UmcMemDetailInfoAbilityBO>();
        for (List subUserIdList : ListUtil.batchList(userIdList)) {
            if (CollUtil.isEmpty((Collection)subUserIdList)) continue;
            FscUmcQryMemListExternalReqBO umcReqBo = new FscUmcQryMemListExternalReqBO();
            umcReqBo.setPageNo(Integer.valueOf(1));
            umcReqBo.setPageSize(Integer.valueOf(subUserIdList.size() * 2));
            umcReqBo.setUserIds(subUserIdList);
            FscUmcQryMemListExternalRspBO umcRspBo = this.fscUmcQryAccountListExternalService.qryMem(umcReqBo);
            if (CollUtil.isEmpty((Collection)umcRspBo.getRows())) continue;
            mapUserInfo.putAll(umcRspBo.getRows().stream().collect(Collectors.toMap(UmcMemDetailInfoAbilityBO::getUserId, Function.identity(), (c, o) -> c)));
        }
        return mapUserInfo;
    }
}

