/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.comb.FscNotificationAutoSignCombService;
import com.tydic.pfscext.api.comb.bo.FscNotificationAutoSignCombReqBO;
import com.tydic.pfscext.api.comb.bo.FscNotificationAutoSignCombRspBO;
import com.tydic.pfscext.dao.AutoInvoiceConfigMapper;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.po.AutoInvoiceConfigInfo;
import com.tydic.pfscext.dao.po.BillApplyInfo;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.vo.BillApplyInfoVO;
import com.tydic.pfscext.service.busi.BusiInvoiceAutoSignService;
import com.tydic.pfscext.service.busi.bo.BusiInvoiceAutoSignReqBO;
import com.tydic.pfscext.service.busi.bo.BusiInvoiceAutoSignRspBO;
import com.tydic.pfscext.utils.RedisLock;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.comb.FscNotificationAutoSignCombService"})
public class FscNotificationAutoSignCombServiceImpl
implements FscNotificationAutoSignCombService {
    private static final Logger log = LoggerFactory.getLogger(FscNotificationAutoSignCombServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private BusiInvoiceAutoSignService busiInvoiceAutoSignService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private AutoInvoiceConfigMapper autoInvoiceConfigMapper;
    @Value(value="${AUTO_SIGN_DAYS:7}")
    private Integer autoSignDay;
    @Value(value="${AUTO_SIGN_LIMIT_NUM:10}")
    private Long limitNum;
    @Value(value="${SIGN_FAIL_MAX_COUNT:3}")
    private Long signFailMaxCount;
    @Resource
    private RedisLock redisLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealNotificationAutoSign"})
    public FscNotificationAutoSignCombRspBO dealNotificationAutoSign(@RequestBody FscNotificationAutoSignCombReqBO reqBo) {
        FscNotificationAutoSignCombRspBO rspBo = new FscNotificationAutoSignCombRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5b8c\u6210");
        if (this.redisLock.getLock("FSC_NOTIFICATION_AUTO_SIGN_LOCK", 7200)) {
            log.error("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5f02\u5e38,\u7b7e\u6536\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d" + DateUtil.formatBetween((long)this.redisLock.getExpireTime("FSC_NOTIFICATION_AUTO_SIGN_LOCK")));
            rspBo.setRespDesc("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5f02\u5e38,\u7b7e\u6536\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d");
            return rspBo;
        }
        try {
            Integer signDay = this.dealAutoSignDay(6L);
            log.error("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u65f6\u95f4\uff1a{}", (Object)signDay);
            if (signDay == null) {
                rspBo.setRespDesc("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5f02\u5e38,\u81ea\u52a8\u7b7e\u6536\u65f6\u95f4\u4e3a\u7a7a");
                FscNotificationAutoSignCombRspBO fscNotificationAutoSignCombRspBO = rspBo;
                return fscNotificationAutoSignCombRspBO;
            }
            List<BillNotificationInfo> billNotificationInfos = this.billNotificationInfoMapper.qryNotificationAutoSign(signDay, this.limitNum, this.signFailMaxCount);
            if (CollectionUtils.isEmpty(billNotificationInfos)) {
                rspBo.setRespDesc("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5b8c\u6210,\u672a\u67e5\u8be2\u5230\u672a\u7b7e\u6536\u901a\u77e5\u5355");
                FscNotificationAutoSignCombRspBO fscNotificationAutoSignCombRspBO = rspBo;
                return fscNotificationAutoSignCombRspBO;
            }
            for (String notificationNo : billNotificationInfos.stream().map(BillNotificationInfo::getNotificationNo).filter(Objects::nonNull).distinct().collect(Collectors.toList())) {
                log.info("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u901a\u77e5\u5355[{}]\u5f00\u59cb\u7b7e\u6536", (Object)notificationNo);
                BusiInvoiceAutoSignReqBO busiInvoiceAutoSignReqBO = new BusiInvoiceAutoSignReqBO();
                busiInvoiceAutoSignReqBO.setNotificationNo(notificationNo);
                BusiInvoiceAutoSignRspBO busiInvoiceAutoSignRspBo = this.busiInvoiceAutoSignService.dealNotifitionSign(busiInvoiceAutoSignReqBO);
                log.info("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u901a\u77e5\u5355[{}]\u7b7e\u6536\u5b8c\u6210.rsp:{}", (Object)notificationNo, (Object)JSON.toJSONString((Object)((Object)busiInvoiceAutoSignRspBo)));
            }
        }
        catch (Exception e) {
            log.error("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.redisLock.unLock("FSC_NOTIFICATION_AUTO_SIGN_LOCK");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u64ae\u5408\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5b8c\u6210");
        return rspBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealApplyAutoSign"})
    public FscNotificationAutoSignCombRspBO dealApplyAutoSign(@RequestBody FscNotificationAutoSignCombReqBO reqBo) {
        FscNotificationAutoSignCombRspBO rspBo = new FscNotificationAutoSignCombRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u5b8c\u6210");
        if (this.redisLock.getLock("FSC_APPLY_AUTO_SIGN_LOCK", 7200)) {
            log.error("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5f02\u5e38,\u7b7e\u6536\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d" + DateUtil.formatBetween((long)this.redisLock.getExpireTime("FSC_APPLY_AUTO_SIGN_LOCK")));
            rspBo.setRespDesc("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5f02\u5e38,\u7b7e\u6536\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d");
            return rspBo;
        }
        try {
            Integer signDay = this.dealAutoSignDay(7L);
            if (signDay == null) {
                rspBo.setRespDesc("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5f02\u5e38,\u81ea\u52a8\u7b7e\u6536\u65f6\u95f4\u4e3a\u7a7a");
                FscNotificationAutoSignCombRspBO fscNotificationAutoSignCombRspBO = rspBo;
                return fscNotificationAutoSignCombRspBO;
            }
            List<BillApplyInfoVO> billApplyInfos = this.billApplyInfoMapper.qryApplyAutoSign(signDay, this.limitNum, this.signFailMaxCount);
            if (CollectionUtils.isEmpty(billApplyInfos)) {
                rspBo.setRespDesc("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5b8c\u6210,\u672a\u67e5\u8be2\u5230\u672a\u7b7e\u6536\u901a\u77e5\u5355");
                FscNotificationAutoSignCombRspBO fscNotificationAutoSignCombRspBO = rspBo;
                return fscNotificationAutoSignCombRspBO;
            }
            for (String applyNo : billApplyInfos.stream().map(BillApplyInfo::getApplyNo).filter(Objects::nonNull).distinct().collect(Collectors.toList())) {
                log.info("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u901a\u77e5\u5355[{}]\u5f00\u59cb\u7b7e\u6536", (Object)applyNo);
                BusiInvoiceAutoSignReqBO busiInvoiceAutoSignReqBo = new BusiInvoiceAutoSignReqBO();
                busiInvoiceAutoSignReqBo.setApplyNo(applyNo);
                BusiInvoiceAutoSignRspBO busiInvoiceAutoSignRspBo = this.busiInvoiceAutoSignService.dealApplySign(busiInvoiceAutoSignReqBo);
                log.info("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u901a\u77e5\u5355[{}]\u7b7e\u6536\u5b8c\u6210.rsp:{}", (Object)applyNo, (Object)JSON.toJSONString((Object)((Object)busiInvoiceAutoSignRspBo)));
            }
        }
        catch (Exception e) {
            log.error("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.redisLock.unLock("FSC_APPLY_AUTO_SIGN_LOCK");
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u7edf\u7b7e\u4e0b\u6e38\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u5b8c\u6210");
        return rspBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealApplyActAutoSign"})
    public FscNotificationAutoSignCombRspBO dealApplyActAutoSign(@RequestBody FscNotificationAutoSignCombReqBO reqBo) {
        FscNotificationAutoSignCombRspBO rspBo = new FscNotificationAutoSignCombRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u5458\u5de5\u798f\u5229\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u5b8c\u6210");
        if (this.redisLock.getLock("FSC_APPLY_ACT_AUTO_SIGN_LOCK", 7200)) {
            log.error("\u5458\u5de5\u798f\u5229\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5f02\u5e38,\u7b7e\u6536\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d" + DateUtil.formatBetween((long)this.redisLock.getExpireTime("FSC_APPLY_ACT_AUTO_SIGN_LOCK")));
            rspBo.setRespDesc("\u5458\u5de5\u798f\u5229\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5f02\u5e38,\u7b7e\u6536\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d");
            return rspBo;
        }
        try {
            Integer signDay = this.dealAutoSignDay(8L);
            if (signDay == null) {
                rspBo.setRespDesc("\u5458\u5de5\u798f\u5229\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5f02\u5e38,\u81ea\u52a8\u7b7e\u6536\u65f6\u95f4\u4e3a\u7a7a");
                FscNotificationAutoSignCombRspBO fscNotificationAutoSignCombRspBO = rspBo;
                return fscNotificationAutoSignCombRspBO;
            }
            List<BillApplyInfoVO> billApplyInfos = this.billApplyInfoMapper.qryApplyActAutoSign(signDay, this.limitNum, this.signFailMaxCount);
            if (CollectionUtils.isEmpty(billApplyInfos)) {
                rspBo.setRespDesc("\u5458\u5de5\u798f\u5229\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5b8c\u6210,\u672a\u67e5\u8be2\u5230\u672a\u7b7e\u6536\u7533\u8bf7\u5355");
                FscNotificationAutoSignCombRspBO fscNotificationAutoSignCombRspBO = rspBo;
                return fscNotificationAutoSignCombRspBO;
            }
            for (String applyNo : billApplyInfos.stream().map(BillApplyInfo::getApplyNo).filter(Objects::nonNull).distinct().collect(Collectors.toList())) {
                log.info("\u5458\u5de5\u798f\u5229\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u7533\u8bf7\u5355[{}]\u5f00\u59cb\u7b7e\u6536", (Object)applyNo);
                BusiInvoiceAutoSignReqBO busiInvoiceAutoSignReqBo = new BusiInvoiceAutoSignReqBO();
                busiInvoiceAutoSignReqBo.setApplyNo(applyNo);
                BusiInvoiceAutoSignRspBO busiInvoiceAutoSignRspBo = this.busiInvoiceAutoSignService.dealApplySign(busiInvoiceAutoSignReqBo);
                log.info("\u5458\u5de5\u798f\u5229\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u7533\u8bf7\u5355[{}]\u7b7e\u6536\u5b8c\u6210.rsp:{}", (Object)applyNo, (Object)JSON.toJSONString((Object)((Object)busiInvoiceAutoSignRspBo)));
            }
        }
        catch (Exception e) {
            log.error("\u5458\u5de5\u798f\u5229\u5f00\u7968\u81ea\u52a8\u7b7e\u6536\u53d1\u7968\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.redisLock.unLock("FSC_APPLY_ACT_AUTO_SIGN_LOCK");
        }
        return rspBo;
    }

    public Integer dealAutoSignDay(Long configId) {
        if (configId == null) {
            return null;
        }
        AutoInvoiceConfigInfo configInfo = this.autoInvoiceConfigMapper.queryAutoInvoiceConfigInfoById(configId);
        if (configInfo == null) {
            return null;
        }
        if ("1".equals(configInfo.getConfigStatus())) {
            return configInfo.getInvoiceDay();
        }
        return null;
    }
}

