/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.pfscext.api.ability.bo.FscUmcEnterpriseOrgBO;
import com.tydic.pfscext.base.PfscExtReqBaseBO;
import com.tydic.pfscext.dao.FscPayConfigMapper;
import com.tydic.pfscext.dao.po.FscPayConfigPO;
import com.tydic.pfscext.enums.FscPayConfigStatus;
import com.tydic.pfscext.enums.FscPayConfigType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.busi.FscPayConfigSaveBusiService;
import com.tydic.pfscext.service.busi.FscUmcQryAccountListBusiService;
import com.tydic.pfscext.service.busi.bo.FscPayConfigSaveBasicBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigSaveBusiRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayConfigUpdateStatusBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscUmcOrgListBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscUmcOrgListBusiRspBO;
import com.tydic.pfscext.service.comb.api.FscPayConfigBasicSaveCombService;
import com.tydic.pfscext.service.comb.bo.FscPayConfigSaveBasicCombReqBO;
import com.tydic.pfscext.service.comb.bo.FscPayConfigSaveBasicCombRspBO;
import com.tydic.pfscext.utils.FscRu;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayConfigBasicSaveCombServiceImpl
implements FscPayConfigBasicSaveCombService {
    private static final Logger log = LoggerFactory.getLogger(FscPayConfigBasicSaveCombServiceImpl.class);
    @Autowired
    private FscPayConfigMapper fscPayConfigMapper;
    @Autowired
    private FscPayConfigSaveBusiService fscPayConfigSaveBusiService;
    @Autowired
    private FscUmcQryAccountListBusiService fscUmcQryAccountListBusiService;

    @Override
    public FscPayConfigSaveBasicCombRspBO dealPayConfigBasicSave(FscPayConfigSaveBasicCombReqBO reqBo) {
        FscPayConfigPO fscPayConfigQry = new FscPayConfigPO();
        fscPayConfigQry.setPayConfigId(reqBo.getPayConfigId());
        fscPayConfigQry.setPayBusiType(reqBo.getPayBusiType());
        fscPayConfigQry.setPaySubClass(reqBo.getPaySubClass());
        fscPayConfigQry.setPaySubType(reqBo.getPaySubType());
        fscPayConfigQry.setPayConfigType(FscPayConfigType.MAIN.getCode());
        fscPayConfigQry.setStatus(FscPayConfigStatus.UPDATING.getCode());
        fscPayConfigQry.setDeleteFlag(YesOrNo.NO.getCode());
        FscPayConfigPO mainPayConfig = this.fscPayConfigMapper.getModelBy(fscPayConfigQry);
        if (mainPayConfig == null) {
            throw new PfscExtBusinessException("0001", "\u751f\u6210\u9ed8\u8ba4\u6570\u636e\u5f02\u5e38\uff0c\u4e3b\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        List<FscUmcEnterpriseOrgBO> fscUmcEnterpriseOrgBos = this.getUmcOrgList(reqBo.getPaySubType(), reqBo.getPaySubClass());
        PfscExtReqBaseBO baseBo = FscRu.js((Object)reqBo, PfscExtReqBaseBO.class);
        if (!CollectionUtils.isEmpty(fscUmcEnterpriseOrgBos)) {
            for (FscUmcEnterpriseOrgBO fscUmcEnterpriseOrgBo : fscUmcEnterpriseOrgBos) {
                FscPayConfigSaveBasicBusiReqBO busiReqBo = new FscPayConfigSaveBasicBusiReqBO();
                BeanUtils.copyProperties((Object)baseBo, (Object)((Object)busiReqBo));
                busiReqBo.setMainPayConfigId(mainPayConfig.getPayConfigId());
                busiReqBo.setFscUmcOrgBo(fscUmcEnterpriseOrgBo);
                busiReqBo.setOpeType(reqBo.getOpeType());
                FscPayConfigSaveBusiRspBO fscPayConfigSaveBusiRspBO = this.fscPayConfigSaveBusiService.dealPayConfigBasicSave(busiReqBo);
            }
        }
        FscPayConfigUpdateStatusBusiReqBO updateStatusBusiReqBo = new FscPayConfigUpdateStatusBusiReqBO();
        BeanUtils.copyProperties((Object)baseBo, (Object)((Object)updateStatusBusiReqBo));
        updateStatusBusiReqBo.setMainPayConfigId(mainPayConfig.getPayConfigId());
        FscPayConfigSaveBusiRspBO saveBusiRspBO = this.fscPayConfigSaveBusiService.dealPayConfigUpdateStatus(updateStatusBusiReqBo);
        if (FscRu.isFailed(saveBusiRspBO.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(saveBusiRspBO.getRespCode(), saveBusiRspBO.getRespDesc());
        }
        return FscRu.success(FscPayConfigSaveBasicCombRspBO.class);
    }

    private List<FscUmcEnterpriseOrgBO> getUmcOrgList(String paySubType, String paySubClass) {
        FscUmcOrgListBusiReqBO fscUmcOrgListBusiReqBo = new FscUmcOrgListBusiReqBO();
        fscUmcOrgListBusiReqBo.setPaySubClass(paySubClass);
        fscUmcOrgListBusiReqBo.setPaySubType(paySubType);
        FscUmcOrgListBusiRspBO umcAllOrgList = this.fscUmcQryAccountListBusiService.getUmcAllOrgList(fscUmcOrgListBusiReqBo);
        if (FscRu.isFailed(umcAllOrgList.getRespCode()).booleanValue()) {
            log.error("\u67e5\u8be2\u4f1a\u5458\u4e2d\u5fc3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)((Object)umcAllOrgList)));
        }
        ArrayList<FscUmcEnterpriseOrgBO> fscUmcOrgList = new ArrayList<FscUmcEnterpriseOrgBO>();
        if (!CollectionUtils.isEmpty(umcAllOrgList.getUmcOrgList())) {
            fscUmcOrgList.addAll(umcAllOrgList.getUmcOrgList());
        }
        return fscUmcOrgList;
    }
}

