/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import com.tydic.pfscext.api.busi.BusiSaleInvoiceInfoService;
import com.tydic.pfscext.api.busi.BusiSyncPushErpService;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoReqBO;
import com.tydic.pfscext.api.busi.bo.BusiSaleInvoiceInfoRspBO;
import com.tydic.pfscext.api.busi.bo.BusiSyncPushErpReqBO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.comb.api.FscSaleInvoiceInfoCombService;
import com.tydic.pfscext.utils.FscRu;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscSaleInvoiceInfoCombServiceImpl
implements FscSaleInvoiceInfoCombService {
    @Autowired
    private BusiSaleInvoiceInfoService busiSaleInvoiceInfoService;
    @Autowired
    private BusiSyncPushErpService busiSyncPushErpService;

    @Override
    public BusiSaleInvoiceInfoRspBO dealManualInvoice(BusiSaleInvoiceInfoReqBO reqBo) {
        BusiSaleInvoiceInfoReqBO busiReqBo = FscRu.js(reqBo, BusiSaleInvoiceInfoReqBO.class);
        BusiSaleInvoiceInfoRspBO busiRspBo = this.busiSaleInvoiceInfoService.dealManualInvoice(busiReqBo);
        if (FscRu.isFailed(busiRspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(busiRspBo.getRespCode(), busiRspBo.getRespDesc());
        }
        BusiSyncPushErpReqBO pushErpReqBO = new BusiSyncPushErpReqBO();
        pushErpReqBO.setApplyNoList(Collections.singletonList(reqBo.getApplyNo()));
        this.busiSyncPushErpService.syncPushErp(pushErpReqBO);
        return busiRspBo;
    }
}

