/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.comb.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.RichTextStringData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfscext.api.aisino.bo.BusiUpdateBillApplyFileUrlReqBO;
import com.tydic.pfscext.api.aisino.bo.BusiUpdateBillApplyFileUrlRspBO;
import com.tydic.pfscext.api.busi.QueryBillApplyInfoExportService;
import com.tydic.pfscext.api.busi.bo.QueryBillApplyInfoExportRspBO;
import com.tydic.pfscext.api.busi.vo.SaleItemInfoExportVO;
import com.tydic.pfscext.dao.BillApplyInfoMapper;
import com.tydic.pfscext.dao.SaleItemInfoMapper;
import com.tydic.pfscext.enums.InvoiceType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.comb.api.FscSaleInvoiceInfoExportCombService;
import com.tydic.pfscext.service.comb.bo.FscBillApplyInvoicingExportDataBO;
import com.tydic.pfscext.service.comb.bo.FscBillApplyInvoicingExportDataItemBO;
import com.tydic.pfscext.service.comb.bo.FscSaleInvoiceInfoExportCombReqBO;
import com.tydic.pfscext.service.comb.bo.FscSaleInvoiceInfoExportCombRspBO;
import com.tydic.pfscext.service.comb.bo.FscSaleInvoiceInfoExportExcelCombReqBO;
import com.tydic.pfscext.service.comb.bo.FscSaleInvoiceInfoExportExcelCombRspBO;
import com.tydic.pfscext.utils.FscRu;
import com.tydic.pfscext.utils.ValUtil;
import com.tydic.pfscext.utils.excel.bo.FscBillApplyInvoicingExcelBillInfoBO;
import com.tydic.pfscext.utils.excel.bo.FscBillApplyInvoicingExcelBillItemBO;
import com.tydic.pfscext.utils.excel.bo.FscBillApplyInvoicingExcelMailingInfoBO;
import com.tydic.pfscext.utils.excel.bo.FscBillApplyInvoicingExcelTipInfoBO;
import com.tydic.pfscext.utils.excel.hander.FscBillApplyInvoicingExportSheetWriteHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscSaleInvoiceInfoExportCombServiceImpl
implements FscSaleInvoiceInfoExportCombService {
    private static final Logger log = LoggerFactory.getLogger(FscSaleInvoiceInfoExportCombServiceImpl.class);
    @Autowired
    private QueryBillApplyInfoExportService queryBillApplyInfoExportService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${fastdfs.removePort:true}")
    private boolean fastdfsRemovePort;
    private final String FILE_TYPE_OSS = "OSS";
    private final String FILE_TYPE_FASTDFS = "FASTDFS";

    @Override
    public FscSaleInvoiceInfoExportCombRspBO queryManualInvoiceExportData(FscSaleInvoiceInfoExportCombReqBO reqBo) {
        List<SaleItemInfoExportVO> itemInfoList;
        ValUtil.isEmpty((Object)reqBo).exception("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getApplyNo()).exception("\u5165\u53c2[\u7533\u8bf7\u5355\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        ValUtil.isEmpty(reqBo.getPurchaseNo()).exception("\u5165\u53c2[\u91c7\u8d2d\u5355\u4f4d]\u4e0d\u80fd\u4e3a\u7a7a");
        FscBillApplyInvoicingExportDataBO dataBo = new FscBillApplyInvoicingExportDataBO();
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("applyNo", reqBo.getApplyNo());
        p.put("purchaseNo", reqBo.getPurchaseNo());
        QueryBillApplyInfoExportRspBO billApplyInfo = this.billApplyInfoMapper.queryBillApplyInfo(p);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u548c\u91c7\u8d2d\u5355\u4f4d\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
        }
        BeanUtils.copyProperties((Object)billApplyInfo, (Object)dataBo);
        if (StringUtils.hasText((String)billApplyInfo.getInvoiceType())) {
            try {
                dataBo.setInvoiceTypeStr(InvoiceType.desc(Integer.valueOf(billApplyInfo.getInvoiceType())));
            }
            catch (NumberFormatException e) {
                log.error("\u53d1\u7968\u7c7b\u578b\u8f6c\u4e49\u4e2d\u6587\u51fa\u9519", (Throwable)e);
            }
        }
        dataBo.setAddrDesc(Optional.ofNullable(billApplyInfo.getProvince()).orElse("") + Optional.ofNullable(billApplyInfo.getCity()).orElse("") + Optional.ofNullable(billApplyInfo.getCounty()).orElse("") + Optional.ofNullable(billApplyInfo.getTown()).orElse("") + Optional.ofNullable(billApplyInfo.getAddrDesc()).orElse(""));
        if (YesOrNo.YES.getCode().toString().equals(reqBo.getDetailFlag()) && !CollectionUtils.isEmpty(itemInfoList = this.saleItemInfoMapper.getSaleItemInfoByApplyNo(reqBo.getApplyNo()))) {
            dataBo.setItemInfoList(FscRu.jsl(itemInfoList, FscBillApplyInvoicingExportDataItemBO.class));
        }
        dataBo.setDetailFlag(reqBo.getDetailFlag());
        FscSaleInvoiceInfoExportCombRspBO rspBo = FscRu.success(FscSaleInvoiceInfoExportCombRspBO.class);
        rspBo.setDataBo(dataBo);
        return rspBo;
    }

    @Override
    public FscSaleInvoiceInfoExportExcelCombRspBO dealManualInvoiceExportExcel(FscSaleInvoiceInfoExportExcelCombReqBO reqBo) {
        if (!StringUtils.hasText((String)reqBo.getApplyNo())) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a\uff0c\u5bfc\u51fa\u5931\u8d25");
        }
        FscSaleInvoiceInfoExportExcelCombRspBO rspBo = FscRu.success(FscSaleInvoiceInfoExportExcelCombRspBO.class);
        try {
            if (reqBo.getDataBo() == null) {
                throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u53d1\u7968\u6570\u636e\u4e3a\u7a7a\uff0c\u5bfc\u51fa\u5931\u8d25");
            }
            String url = this.dealGenerateExcel(reqBo);
            rspBo.setFileUrl(url);
            if (StringUtils.hasText((String)url)) {
                this.updateBillFileUrl(reqBo.getApplyNo(), "\u624b\u52a8\u5f00\u7968\u6a21\u677f\u5bfc\u51fa" + reqBo.getApplyNo() + ".xlsx", url, "2");
            } else {
                log.error("{}\u624b\u52a8\u5f00\u7968\u6a21\u677f\u5bfc\u51fa\u5f02\u5e38\uff0c\u4e0a\u4f20\u7684\u5730\u5740\u4e3a\u7a7a", (Object)reqBo.getApplyNo());
                this.updateBillFileUrl(reqBo.getApplyNo(), "\u624b\u52a8\u5f00\u7968\u6a21\u677f\u5bfc\u51fa" + reqBo.getApplyNo() + ".xlsx", "", "3");
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u53d1\u7968\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)e));
            this.updateBillFileUrl(reqBo.getApplyNo(), "\u624b\u52a8\u5f00\u7968\u6a21\u677f\u5bfc\u51fa" + reqBo.getApplyNo() + ".xlsx", "", "3");
            throw new PfscExtBusinessException("18000", "\u5bfc\u51fa\u53d1\u7968\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rspBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dealGenerateExcel(FscSaleInvoiceInfoExportExcelCombReqBO reqBo) {
        URL rootPath = FscSaleInvoiceInfoExportCombServiceImpl.class.getResource("/");
        String rootPathStr = rootPath.getPath() + "temp" + System.currentTimeMillis();
        File directoryFile = new File(rootPathStr);
        if (!directoryFile.exists()) {
            directoryFile.mkdir();
        }
        String fileName = StrUtil.format((CharSequence)"\u624b\u52a8\u5f00\u7968\u7533\u8bf7\u6a21\u62df\u5bfc\u51fa{}.xlsx", (Object[])new Object[]{reqBo.getApplyNo()});
        String writePath = rootPathStr + "/" + fileName;
        log.info("{}\u624b\u52a8\u5f00\u7968\u5bfc\u51fa\u6a21\u677f\u6587\u4ef6\u5730\u5740\uff1a{}", (Object)reqBo.getApplyNo(), (Object)writePath);
        String uploadPath = "fsc";
        String[] sheetNames = new String[]{"\u586b\u5199\u8bf4\u660e", "\u5f00\u7968\u901a\u77e5\u5355\u4fe1\u606f", "\u5f00\u7968\u660e\u7ec6", "\u90ae\u5bc4\u4fe1\u606f"};
        ExcelWriterBuilder excelWriterBuilder = ((ExcelWriterBuilder)EasyExcel.write((String)writePath).registerWriteHandler((WriteHandler)new FscBillApplyInvoicingExportSheetWriteHandler())).inMemory(Boolean.valueOf(false));
        try (ExcelWriter excelWriter = excelWriterBuilder.build();){
            int sheetNo = 0;
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)sheetNo, (String)sheetNames[sheetNo]).head(FscBillApplyInvoicingExcelTipInfoBO.class)).build();
            writeSheet.setNeedHead(Boolean.valueOf(false));
            excelWriter.write(this.dataSheetFirst(), writeSheet);
            sheetNo = 1;
            WriteSheet writeSheetSecond = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)sheetNo, (String)sheetNames[sheetNo]).head(FscBillApplyInvoicingExcelBillInfoBO.class)).build();
            writeSheetSecond.setNeedHead(Boolean.valueOf(true));
            excelWriter.write(this.dataSheetSecond(reqBo.getDataBo()), writeSheetSecond);
            sheetNo = 2;
            WriteSheet writeSheetThird = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)sheetNo, (String)sheetNames[sheetNo]).head(FscBillApplyInvoicingExcelBillItemBO.class)).build();
            writeSheetThird.setNeedHead(Boolean.valueOf(true));
            if (StrUtil.isNotBlank((CharSequence)reqBo.getDataBo().getApplyNo())) {
                if (YesOrNo.YES.getCode().toString().equals(reqBo.getDataBo().getDetailFlag())) {
                    List<FscBillApplyInvoicingExportDataItemBO> itemInfoList = reqBo.getDataBo().getItemInfoList();
                    if (!CollectionUtils.isEmpty(itemInfoList)) {
                        excelWriter.write(FscRu.jsl(itemInfoList, FscBillApplyInvoicingExcelBillItemBO.class), writeSheetThird);
                    }
                } else {
                    int pageSize = 1000;
                    Page pager = new Page(1, pageSize);
                    SaleItemInfoExportVO saleItemInfoExportQry = new SaleItemInfoExportVO();
                    saleItemInfoExportQry.setApplyNo(reqBo.getDataBo().getApplyNo());
                    List<SaleItemInfoExportVO> itemInfoList = this.saleItemInfoMapper.getPageSaleItemInfoByApplyNo(saleItemInfoExportQry, (Page<SaleItemInfoExportVO>)pager);
                    List<FscBillApplyInvoicingExcelBillItemBO> dataList = this.dataSheetThird(itemInfoList);
                    if (!CollectionUtils.isEmpty(dataList)) {
                        log.info("\u5f00\u59cb\u5199\u7b2c3\u4e2aSheet\u7b2c1\u7247.size:" + dataList.size());
                        excelWriter.write(dataList, writeSheetThird);
                    }
                    if (pager.getTotalPages() > 1) {
                        for (int pageNo = 2; pageNo <= pager.getTotalPages(); ++pageNo) {
                            Page pagerTwo = new Page(pageNo, pageSize);
                            List<SaleItemInfoExportVO> itemInfoListTwo = this.saleItemInfoMapper.getPageSaleItemInfoByApplyNo(saleItemInfoExportQry, (Page<SaleItemInfoExportVO>)pagerTwo);
                            List<FscBillApplyInvoicingExcelBillItemBO> dataListTwo = this.dataSheetThird(itemInfoListTwo);
                            if (CollectionUtils.isEmpty(dataListTwo)) continue;
                            log.info("\u5f00\u59cb\u5199\u7b2c3\u4e2aSheet\u7b2c" + pageNo + "\u7247.size:" + dataListTwo.size());
                            excelWriter.write(dataListTwo, writeSheetThird);
                        }
                    }
                }
            }
            sheetNo = 3;
            WriteSheet writeSheetFourth = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)sheetNo, (String)sheetNames[sheetNo]).head(FscBillApplyInvoicingExcelMailingInfoBO.class)).build();
            writeSheetFourth.setNeedHead(Boolean.valueOf(false));
            excelWriter.write(this.dataSheetFourth(reqBo.getDataBo()), writeSheetFourth);
        }
        String fileUrl = "";
        try {
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)new FileInputStream(writePath));
            log.info("\u4e0a\u4f20\u540e\u8fd4\u56de\u7684\u5730\u5740\uff1a{}", (Object)result);
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                String httphead = "https://";
                if (result.endsWith(".jpg") || result.endsWith(".jpeg") || result.endsWith(".png")) {
                    httphead = "http://";
                }
                fileUrl = httphead + this.ossFileUrl + result;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)result);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            log.info("{}\u624b\u52a8\u5f00\u7968\u5bfc\u51fafileUrl\uff1a{}", (Object)reqBo.getApplyNo(), (Object)fileUrl);
            log.info("{}\u624b\u52a8\u5f00\u7968\u5bfc\u51fainnerFileUrl\uff1a{}", (Object)reqBo.getApplyNo(), innerFileUrl);
            String string = fileUrl;
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                FileUtil.del((File)directoryFile);
            }
            catch (IORuntimeException e) {
                log.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        }
        return fileUrl;
    }

    private List<FscBillApplyInvoicingExcelMailingInfoBO> dataSheetFourth(FscBillApplyInvoicingExportDataBO dataBo) {
        ArrayList<FscBillApplyInvoicingExcelMailingInfoBO> list = new ArrayList<FscBillApplyInvoicingExcelMailingInfoBO>();
        ArrayList<String[]> listData = new ArrayList<String[]>();
        listData.add(new String[]{"\u90ae\u5bc4\u5730\u5740", dataBo.getAddrDesc()});
        listData.add(new String[]{"\u6536\u4ef6\u4eba", dataBo.getName()});
        if ("4".equals(dataBo.getSource())) {
            listData.add(new String[]{"\u7535\u8bdd", dataBo.getTel()});
        } else {
            listData.add(new String[]{"\u7535\u8bdd", dataBo.getMobile()});
        }
        for (String[] data : listData) {
            FscBillApplyInvoicingExcelMailingInfoBO infoBo = new FscBillApplyInvoicingExcelMailingInfoBO();
            infoBo.setTitle(data[0]);
            infoBo.setContent(data[1]);
            list.add(infoBo);
        }
        return list;
    }

    private List<FscBillApplyInvoicingExcelBillItemBO> dataSheetThird(List<SaleItemInfoExportVO> itemInfoList) {
        ArrayList<FscBillApplyInvoicingExcelBillItemBO> dataList = new ArrayList<FscBillApplyInvoicingExcelBillItemBO>();
        if (!CollectionUtils.isEmpty(itemInfoList)) {
            for (SaleItemInfoExportVO saleItemInfo : itemInfoList) {
                FscBillApplyInvoicingExcelBillItemBO sheetThirdItemBo = new FscBillApplyInvoicingExcelBillItemBO();
                sheetThirdItemBo.setApplyNo(saleItemInfo.getApplyNo());
                sheetThirdItemBo.setInvoiceCode("");
                sheetThirdItemBo.setInvoiceNo("");
                sheetThirdItemBo.setInvoiceDate("");
                sheetThirdItemBo.setPurchaseOrderId(Optional.ofNullable(saleItemInfo.getPurchaseOrderId()).map(String::valueOf).orElse(null));
                String identify = Optional.ofNullable(saleItemInfo.getItemNo()).map(String::valueOf).orElse("") + "-" + Optional.ofNullable(saleItemInfo.getSeq()).map(String::valueOf).orElse("");
                sheetThirdItemBo.setIdentify(identify);
                sheetThirdItemBo.setSkuId(Optional.ofNullable(saleItemInfo.getSkuId()).map(String::valueOf).orElse(null));
                sheetThirdItemBo.setTaxCatCode(Optional.ofNullable(saleItemInfo.getTaxCatCode()).map(String::valueOf).orElse(null));
                sheetThirdItemBo.setSkuName(saleItemInfo.getSkuName());
                String specModelFigureNo = Optional.ofNullable(saleItemInfo.getSpec()).map(String::valueOf).orElse("") + Optional.ofNullable(saleItemInfo.getModel()).map(String::valueOf).orElse("") + Optional.ofNullable(saleItemInfo.getFigureNo()).map(String::valueOf).orElse("");
                sheetThirdItemBo.setSpecModelFigureNo(specModelFigureNo);
                sheetThirdItemBo.setUnitName(saleItemInfo.getUnitName());
                sheetThirdItemBo.setQuantity(saleItemInfo.getQuantity());
                sheetThirdItemBo.setSaleUnitPrice(saleItemInfo.getSaleUnitPrice());
                if (saleItemInfo.getUnTaxAmt() != null && saleItemInfo.getQuantity() != null && saleItemInfo.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    sheetThirdItemBo.setPriceUnTax(saleItemInfo.getUnTaxAmt().divide(saleItemInfo.getQuantity(), 8, 4));
                }
                sheetThirdItemBo.setAmount(saleItemInfo.getAmount());
                sheetThirdItemBo.setUnTaxAmt(saleItemInfo.getUnTaxAmt());
                sheetThirdItemBo.setTaxAmt(saleItemInfo.getTaxAmt());
                sheetThirdItemBo.setTaxRate(saleItemInfo.getTaxRate());
                dataList.add(sheetThirdItemBo);
            }
        }
        return dataList;
    }

    private List<FscBillApplyInvoicingExcelBillInfoBO> dataSheetSecond(FscBillApplyInvoicingExportDataBO dataBo) {
        ArrayList<FscBillApplyInvoicingExcelBillInfoBO> sheetSecondList = new ArrayList<FscBillApplyInvoicingExcelBillInfoBO>();
        FscBillApplyInvoicingExcelBillInfoBO sheetSecondDataBo = new FscBillApplyInvoicingExcelBillInfoBO();
        sheetSecondDataBo.setApplyNo(dataBo.getApplyNo());
        sheetSecondDataBo.setInvoiceTypeStr(dataBo.getInvoiceTypeStr());
        sheetSecondDataBo.setInvoiceName(dataBo.getInvoiceName());
        sheetSecondDataBo.setTaxNo(dataBo.getTaxNo());
        sheetSecondDataBo.setAddr(dataBo.getAddr());
        sheetSecondDataBo.setPhone(dataBo.getPhone());
        sheetSecondDataBo.setBankName(dataBo.getBankName());
        sheetSecondDataBo.setBankAcctNo(dataBo.getBankAcctNo());
        sheetSecondDataBo.setAmt(dataBo.getAmt());
        sheetSecondList.add(sheetSecondDataBo);
        return sheetSecondList;
    }

    private List<FscBillApplyInvoicingExcelTipInfoBO> dataSheetFirst() {
        ArrayList<FscBillApplyInvoicingExcelTipInfoBO> list = new ArrayList<FscBillApplyInvoicingExcelTipInfoBO>();
        ArrayList<String[]> listData = new ArrayList<String[]>();
        listData.add(new String[]{"\u3010\u5f00\u7968\u660e\u7ec6\u586b\u5199\u8bf4\u660e\u3011", null});
        listData.add(new String[]{"\u5546\u54c1\u4fe1\u606f\uff1a", "\u6d45\u9ec4\u8272\u6807\u9898\u5217\u4e3a\u5546\u54c1\u4fe1\u606f\uff0c\u6309\u8be5\u533a\u57df\u6570\u636e\u8fdb\u884c\u5f00\u7968\uff0c\u6b64\u533a\u57df\u6570\u636e\u5207\u52ff\u6539\u52a8"});
        listData.add(new String[]{"\u586b\u5199\u683c\u5f0f\uff1a", "\u4fdd\u6301\u539f\u5bfc\u51fa\u5355\u5143\u683c\u683c\u5f0f\uff0c\u586b\u5199\u65f6\u5207\u52ff\u66f4\u6539\u5355\u5143\u683c\u683c\u5f0f"});
        listData.add(new String[]{"*\u53d1\u7968\u4ee3\u7801", "\u5b9e\u9645\u5f00\u51fa\u53d1\u7968\u4ee3\u7801"});
        listData.add(new String[]{"*\u53d1\u7968\u53f7\u7801", "\u5b9e\u9645\u5f00\u51fa\u53d1\u7968\u53f7\u7801"});
        listData.add(new String[]{"*\u5f00\u7968\u65e5\u671f", "\u5b9e\u9645\u5f00\u7968\u65e5\u671f\uff0c\u683c\u5f0f\u4f8b\u5982\uff1a1900-01-01"});
        listData.add(new String[]{"*\u5355\u4ef7(\u4e0d\u542b\u7a0e)", "\u5b9e\u9645\u4e0d\u542b\u7a0e\u5355\u4ef7"});
        listData.add(new String[]{"*\u91d1\u989d(\u4e0d\u542b\u7a0e)", "\u5b9e\u9645\u4e0d\u542b\u7a0e\u91d1\u989d"});
        listData.add(new String[]{"*\u7a0e  \u989d", "\u5b9e\u9645\u7a0e\u989d"});
        listData.add(new String[]{"*\u7a0e \u7387", "\u5b9e\u9645\u7a0e\u7387"});
        listData.add(new String[]{"*\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", "\u6309\u6bcf\u4e2a\u7269\u8d44\u540d\u79f0\u586b\u5199\u7a0e\u6536\u5206\u7c7b\u7f16\u7801"});
        for (String[] data : listData) {
            FscBillApplyInvoicingExcelTipInfoBO item = new FscBillApplyInvoicingExcelTipInfoBO();
            item.setTitle(this.getWriteCellData(data[0], CellDataTypeEnum.STRING, 3));
            item.setContent(data[1]);
            list.add(item);
        }
        return list;
    }

    private WriteCellData<String> getWriteCellData(String title, CellDataTypeEnum type, int flag) {
        WriteCellData writeCellStyle = new WriteCellData(title);
        writeCellStyle.setType(type);
        if (flag == 1) {
            WriteCellStyle writeCellStyleData = new WriteCellStyle();
            writeCellStyleData.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
            writeCellStyleData.setFillForegroundColor(Short.valueOf(IndexedColors.YELLOW.getIndex()));
            writeCellStyle.setWriteCellStyle(writeCellStyleData);
        } else if (flag == 2) {
            WriteCellStyle writeCellStyleData = new WriteCellStyle();
            writeCellStyleData.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
            writeCellStyleData.setFillForegroundColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
            writeCellStyle.setWriteCellStyle(writeCellStyleData);
        } else if (flag == 3 && StringUtils.hasText((String)title) && title.startsWith("*")) {
            writeCellStyle = new WriteCellData();
            writeCellStyle.setType(CellDataTypeEnum.RICH_TEXT_STRING);
            RichTextStringData richTextStringData = new RichTextStringData();
            writeCellStyle.setRichTextStringDataValue(richTextStringData);
            richTextStringData.setTextString(title);
            WriteFont writeFont = new WriteFont();
            writeFont.setColor(Short.valueOf(IndexedColors.RED.getIndex()));
            writeFont.setBold(Boolean.TRUE);
            richTextStringData.applyFont(0, 1, writeFont);
        }
        return writeCellStyle;
    }

    private void updateBillFileUrl(String applyNo, String fileName, String fileUrl, String templateStatus) {
        BusiUpdateBillApplyFileUrlReqBO updateFileReqBo = new BusiUpdateBillApplyFileUrlReqBO();
        updateFileReqBo.setApplyNo(applyNo);
        updateFileReqBo.setFileName(fileName);
        updateFileReqBo.setFileUrl(fileUrl);
        updateFileReqBo.setTemplateStatus(templateStatus);
        BusiUpdateBillApplyFileUrlRspBO rspBo = this.queryBillApplyInfoExportService.updateBillApplyInfoFileUrl(updateFileReqBo);
        if (FscRu.isFailed(rspBo.getRespCode()).booleanValue()) {
            throw new PfscExtBusinessException(rspBo.getRespCode(), rspBo.getRespDesc());
        }
    }
}

