/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.tydic.pfscext.api.deal.AutoInvoiceConfigExceptService;
import com.tydic.pfscext.api.deal.bo.DealAutoInvoiceAddExceptReqBO;
import com.tydic.pfscext.api.deal.bo.DealAutoInvoiceAddExceptRspBO;
import com.tydic.pfscext.api.deal.bo.DealAutoInvoiceConfigReqBO;
import com.tydic.pfscext.api.deal.bo.DealAutoInvoiceConfigRspBO;
import com.tydic.pfscext.api.deal.bo.DealAutoInvoiceDeleteExceptReqBO;
import com.tydic.pfscext.api.deal.bo.DealAutoInvoiceDeleteExceptRspBO;
import com.tydic.pfscext.dao.AutoInvoiceConfigMapper;
import com.tydic.pfscext.dao.vo.DealAutoInvoiceAddExceptVO;
import com.tydic.pfscext.dao.vo.DealAutoInvoiceConfigVO;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.AutoInvoiceConfigExceptService"})
public class AutoInvoiceConfigExceptServiceImpl
implements AutoInvoiceConfigExceptService {
    private static final Logger logger = LoggerFactory.getLogger(AutoInvoiceConfigExceptServiceImpl.class);
    @Resource
    private AutoInvoiceConfigMapper autoInvoiceConfigMapper;

    @PostMapping(value={"updateAutoInvoiceConfig"})
    public DealAutoInvoiceConfigRspBO updateAutoInvoiceConfig(@RequestBody DealAutoInvoiceConfigReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u66f4\u65b0\u81ea\u52a8\u5f00\u7968\u914d\u7f6e\u5165\u53c2\uff1a{}", (Object)reqBO);
        }
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getConfigId() || reqBO.getConfigId() == 0L) {
            throw new PfscExtBusinessException("0001", "\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getConfigType())) {
            throw new PfscExtBusinessException("0001", "\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DealAutoInvoiceConfigRspBO rspBO = new DealAutoInvoiceConfigRspBO();
        try {
            int a;
            DealAutoInvoiceConfigVO vo = new DealAutoInvoiceConfigVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)vo);
            vo.setOperatorName(reqBO.getName());
            vo.setUpdateTime(new Date());
            if ("2".equals(reqBO.getConfigType())) {
                vo.setTakeUpInvoice(null);
            }
            if ((a = this.autoInvoiceConfigMapper.updateAutoInvoiceConfig(vo)) > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u66f4\u65b0\u4e86" + a + "\u6761\u6570\u636e\uff01");
            } else {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u6ca1\u6709\u66f4\u65b0\u6570\u636e\uff01");
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff01\uff01", (Throwable)e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u66f4\u65b0\u6570\u636e\u5931\u8d252\uff01");
        }
        return rspBO;
    }

    @PostMapping(value={"addAutoInvoiceConfigExcept"})
    public DealAutoInvoiceAddExceptRspBO addAutoInvoiceConfigExcept(@RequestBody DealAutoInvoiceAddExceptReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6dfb\u52a0\u81ea\u52a8\u5f00\u7968\u4f8b\u5916\u5165\u53c2\uff1a{}", (Object)reqBO);
        }
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getConfigId() || reqBO.getConfigId() == 0L) {
            throw new PfscExtBusinessException("0001", "\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getPurchaseNo() || reqBO.getPurchaseNo() == 0L) {
            throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPurchaseName())) {
            throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getStatus())) {
            throw new PfscExtBusinessException("0001", "\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getInvoiceDay() || reqBO.getInvoiceDay() < 0) {
            throw new PfscExtBusinessException("0001", "\u81ea\u52a8\u53d1\u8d77\u5f00\u7968\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DealAutoInvoiceAddExceptRspBO rspBO = new DealAutoInvoiceAddExceptRspBO();
        try {
            int count = this.autoInvoiceConfigMapper.checkPurchaseNo(reqBO.getConfigId(), reqBO.getPurchaseNo());
            if (count > 0) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u8be5\u4e1a\u52a1\u6a21\u5f0f\u4f8b\u5916\u4e2d\u5df2\u7ecf\u5b58\u5728\u8be5\u91c7\u8d2d\u5355\uff01");
                return rspBO;
            }
            DealAutoInvoiceAddExceptVO vo = new DealAutoInvoiceAddExceptVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)vo);
            vo.setCreateTime(new Date());
            vo.setOperatorName(reqBO.getName());
            int a = this.autoInvoiceConfigMapper.addAutoInvoiceConfigExcept(vo);
            if (a > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u65b0\u589e\u4e86" + a + "\u6761\u4f8b\u5916\uff01");
            } else {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u6dfb\u52a0\u4f8b\u5916\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u4f8b\u5916\u5931\u8d25\uff01\uff01", (Throwable)e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u6dfb\u52a0\u4f8b\u5916\u5931\u8d252\uff01");
        }
        return rspBO;
    }

    @PostMapping(value={"updateAutoInvoiceConfigExcept"})
    public DealAutoInvoiceAddExceptRspBO updateAutoInvoiceConfigExcept(@RequestBody DealAutoInvoiceAddExceptReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4fee\u6539\u81ea\u52a8\u5f00\u7968\u4f8b\u5916\u5165\u53c2\uff1a{}", (Object)reqBO);
        }
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getConfigId() || reqBO.getConfigId() == 0L) {
            throw new PfscExtBusinessException("0001", "\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getPurchaseNo() || reqBO.getPurchaseNo() == 0L) {
            throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getStatus())) {
            throw new PfscExtBusinessException("0001", "\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getInvoiceDay() || reqBO.getInvoiceDay() < 0) {
            throw new PfscExtBusinessException("0001", "\u81ea\u52a8\u53d1\u8d77\u5f00\u7968\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        DealAutoInvoiceAddExceptRspBO rspBO = new DealAutoInvoiceAddExceptRspBO();
        try {
            DealAutoInvoiceAddExceptVO vo = new DealAutoInvoiceAddExceptVO();
            BeanUtils.copyProperties((Object)reqBO, (Object)vo);
            vo.setOperatorName(reqBO.getName());
            vo.setCreateTime(new Date());
            int a = this.autoInvoiceConfigMapper.updateAutoInvoiceConfigExcept(vo);
            if (a > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u66f4\u65b0\u4e86" + a + "\u6761\u4f8b\u5916\uff01");
            } else {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u6ca1\u6709\u66f4\u65b0\u4f8b\u5916\u6570\u636e\uff01\uff01");
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u4f8b\u5916\u5931\u8d25\uff01\uff01", (Throwable)e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u66f4\u65b0\u4f8b\u5916\u5931\u8d25Catch\uff01");
        }
        return rspBO;
    }

    @PostMapping(value={"deleteAutoInvoiceConfigExcept"})
    public DealAutoInvoiceDeleteExceptRspBO deleteAutoInvoiceConfigExcept(@RequestBody DealAutoInvoiceDeleteExceptReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5220\u9664\u81ea\u52a8\u5f00\u7968\u4f8b\u5916\u5165\u53c2\uff1a{}", (Object)reqBO);
        }
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (null == reqBO.getConfigId() || reqBO.getConfigId() == 0L) {
            throw new PfscExtBusinessException("0001", "\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPurchaseNoList())) {
            throw new PfscExtBusinessException("0001", "\u8981\u5220\u9664\u91c7\u8d2d\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DealAutoInvoiceDeleteExceptRspBO rspBO = new DealAutoInvoiceDeleteExceptRspBO();
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("configId", reqBO.getConfigId());
            param.put("purchaseNoList", reqBO.getPurchaseNoList());
            int a = this.autoInvoiceConfigMapper.deleteAutoInvoiceConfigExcept(param);
            if (a > 0) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5220\u9664\u4e86" + a + "\u6761\u4f8b\u5916\uff01");
            } else {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u6ca1\u6709\u5220\u9664\u4f8b\u5916\u6570\u636e\uff01\uff01");
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4f8b\u5916\u5931\u8d25\uff01\uff01", (Throwable)e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5220\u9664\u4f8b\u5916\u5931\u8d25Catch\uff01");
        }
        return rspBO;
    }
}

