/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoDetailBO;
import com.tydic.pfscext.api.deal.BatchExceptionBillService;
import com.tydic.pfscext.api.deal.bo.ExportExceptionBillReqBO;
import com.tydic.pfscext.api.deal.bo.ExportExceptionBillRspBO;
import com.tydic.pfscext.api.deal.bo.ImportExceptionBillReqBO;
import com.tydic.pfscext.api.deal.bo.ImportExceptionBillRspBO;
import com.tydic.pfscext.common.ExcelFile;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.BusiModel;
import com.tydic.pfscext.enums.OrderStatus;
import com.tydic.pfscext.enums.SaleOrderPayType;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.service.atom.PayableService;
import com.tydic.pfscext.service.busi.BusiGenerateNotificationService;
import com.tydic.pfscext.service.busi.FscPayableDetailUpdateBusiService;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationReqBO;
import com.tydic.pfscext.service.busi.bo.BusiGenerateNotificationRspBO;
import com.tydic.pfscext.service.busi.bo.FscPayableDetailUpdateOverduePenaltyBusiReqBO;
import com.tydic.pfscext.service.busi.bo.FscPayableDetailUpdateOverduePenaltyBusiRspBO;
import com.tydic.pfscext.utils.ExcelUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.BatchExceptionBillService"})
public class BatchExceptionBillServiceImpl
implements BatchExceptionBillService {
    private static final Logger log = LoggerFactory.getLogger(BatchExceptionBillServiceImpl.class);
    @Autowired
    private PayableService payableService;
    @Autowired
    private BusiGenerateNotificationService busiGenerateNotificationService;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private FscPayableDetailUpdateBusiService fscPayableDetailUpdateBusiService;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;
    private final String HEAD_STR = "\u6ce8\u610f\u4e8b\u9879\uff1a\u8ba2\u5355\u53f7\u548c\u4f9b\u5e94\u5546\u8ba2\u5355\u7f16\u53f7\u4e8c\u9009\u4e00\u586b\u5199\uff0c\u4e24\u9879\u90fd\u586b\u5199\u65f6\u53ea\u53d6\u8ba2\u5355\u53f7\uff0c\u5bfc\u5165\u540e\u5c06\u89c6\u4e3a\u8ba2\u5355\u5f00\u7968\u5b8c\u6210";
    private final String SHEET_NAME = "\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406";

    @PostMapping(value={"exportExceptionBill"})
    public ExportExceptionBillRspBO exportExceptionBill(@RequestBody ExportExceptionBillReqBO reqBO) {
        log.info("\u7ed3\u7b97\u5f02\u5e38\u6279\u91cf\u5bfc\u51fa\u8ba2\u5355\u6a21\u677f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        ExportExceptionBillRspBO rspBO = new ExportExceptionBillRspBO();
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
        item.put("\u8ba2\u5355\u53f7", null);
        item.put("\u4f9b\u5e94\u5546\u8ba2\u5355\u7f16\u53f7", null);
        exportData.add(item);
        this.uploadFile(exportData, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setFileUrl(fullFilePath);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<PayPurchaseOrderInfo> queryOrder(ExportExceptionBillReqBO reqBO) {
        LinkedList<Long> inspectionIds = new LinkedList<Long>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getInspectionIdList())) {
            reqBO.getInspectionIdList().forEach(s1 -> inspectionIds.add(Long.valueOf(s1)));
        }
        if (null == reqBO.getOrderDateEnd()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5f85\u7533\u8bf7\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u8ba2\u5355\u65e5\u671f\uff08\u7ed3\u675f\uff09[orderDateEnd]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5f85\u7533\u8bf7\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u8fd0\u8425\u5546\u7f16\u53f7[companyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSource()) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5f85\u7533\u8bf7\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1-\u6765\u6e90[source]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String isProfessionalOrgExt = reqBO.getIsProfessionalOrgExt();
        PayPurchaseOrderInfo payPurchaseOrderInfo = new PayPurchaseOrderInfo();
        BeanUtils.copyProperties((Object)reqBO, (Object)payPurchaseOrderInfo);
        payPurchaseOrderInfo.setSource(String.valueOf(reqBO.getSource()));
        if (null != reqBO.getSupplierNo()) {
            payPurchaseOrderInfo.setSupplierNo(reqBO.getSupplierNo());
        }
        if ("0".equals(isProfessionalOrgExt)) {
            payPurchaseOrderInfo.setOperUnitNo(reqBO.getCompanyId());
            payPurchaseOrderInfo.setBusiModel(BusiModel.TRADE_MODEL.getCode());
        } else if ("1".equals(isProfessionalOrgExt)) {
            payPurchaseOrderInfo.setPurchaseNo(reqBO.getCompanyId());
            payPurchaseOrderInfo.setBusiModel(BusiModel.MATCH_UP_MODEL.getCode());
        } else if ("2".equals(isProfessionalOrgExt)) {
            payPurchaseOrderInfo.setBusiModel(BusiModel.MATCH_UP_MODEL.getCode());
            payPurchaseOrderInfo.setSupplierNo(reqBO.getSupId());
            payPurchaseOrderInfo.setPurchaseId(null);
        }
        Long excludeOrg = null;
        if ("0".equals(isProfessionalOrgExt)) {
            if (null != reqBO.getPurchaseNo()) {
                payPurchaseOrderInfo.setPurchaseNo(reqBO.getPurchaseNo());
            } else {
                excludeOrg = reqBO.getCompanyId();
            }
        }
        String orderBy = "t.ORDER_DATE DESC";
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        BeanUtils.copyProperties((Object)payPurchaseOrderInfo, (Object)vo);
        vo.setOrderDateStart(reqBO.getOrderDateStart());
        vo.setOrderDateEnd(reqBO.getOrderDateEnd());
        vo.setRecvDateStart(reqBO.getRecvDateStart());
        vo.setRecvDateEnd(reqBO.getRecvDateEnd());
        vo.setExcludeOrg(excludeOrg);
        vo.setInspectionIds(inspectionIds);
        vo.setOrderBy(orderBy);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqBO.getMinOrderAmt())) {
            vo.setMinOrderAmt(new BigDecimal(reqBO.getMinOrderAmt()));
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqBO.getMaxOrderAmt())) {
            vo.setMaxOrderAmt(new BigDecimal(reqBO.getMaxOrderAmt()));
        }
        if (reqBO.getBusiModel() != null && !"".equals(reqBO.getBusiModel())) {
            vo.setBusiModel(reqBO.getBusiModel());
        }
        vo.setSource(String.valueOf(reqBO.getSource()));
        log.debug("\u5f00\u7968\u901a\u77e5\u53d1\u8d77\u67e5\u8be2\u5165\u53c2\uff1a" + vo.toString());
        return this.payPurchaseOrderInfoMapper.getExceptionExportOrder(vo);
    }

    @PostMapping(value={"importExceptionBill"})
    public ImportExceptionBillRspBO importExceptionBill(@RequestBody ImportExceptionBillReqBO reqBO) {
        ExcelFile excel;
        ImportExceptionBillRspBO rspBO = new ImportExceptionBillRspBO();
        LinkedList<String> extOrderIdList = new LinkedList<String>();
        LinkedList<String> purchaseOrderCodeList = new LinkedList<String>();
        try {
            URL url = new URL(reqBO.getFileUrl());
            URLConnection connection = url.openConnection();
            excel = new ExcelFile(connection.getInputStream(), true);
            if (!excel.isReady()) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6");
                return rspBO;
            }
            if (excel.getSheetCount() != 1) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u4e0a\u4f20\u7684Excel\u5e94\u53ea\u67091\u9875");
                return rspBO;
            }
            if (!"\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406".equals(excel.getSheetName(0))) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u7b2c\"+(i+1)+\"\u4e2a\u6570\u636e\u9875\u7684\u540d\u79f0[\"+excel.getSheetName(0)+\"]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0");
                return rspBO;
            }
        }
        catch (IOException e) {
            throw new PfscExtBusinessException("18000", "\u5bfc\u5165\u7ed3\u7b97\u5f02\u5e38\u6587\u4ef6\u5931\u8d25");
        }
        List dataRows = excel.readRows(0, 2, -1);
        for (int i = 0; i < dataRows.size(); ++i) {
            String[] fields = (String[])dataRows.get(i);
            List<String> list = Arrays.asList(fields);
            if (CollectionUtils.isEmpty(list) || StringUtils.isEmpty((Object)list.get(0)) && StringUtils.isEmpty((Object)list.get(1))) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u7b2c" + i + 1 + "\u884c\u6570\u636e\u7f3a\u5c11\u76f8\u5e94\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                return rspBO;
            }
            if (!StringUtils.isEmpty((Object)list.get(0))) {
                purchaseOrderCodeList.add(list.get(0));
                continue;
            }
            if (StringUtils.isEmpty((Object)list.get(1))) continue;
            extOrderIdList.add(list.get(1));
        }
        log.error("\u8ba2\u5355\u53f7{}" + JSON.toJSONString(purchaseOrderCodeList));
        log.error("\u5916\u90e8\u8ba2\u5355\u53f7{}" + JSON.toJSONString(extOrderIdList));
        List<Object> payPurchaseOrderInfos = new ArrayList();
        try {
            payPurchaseOrderInfos = this.checkOrder(purchaseOrderCodeList, extOrderIdList, reqBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e76\u68c0\u9a8c\u8ba2\u5355\u5f02\u5e38" + e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        for (PayPurchaseOrderInfo payPurchaseOrderInfo : payPurchaseOrderInfos) {
            List<PayableDetailPO> payableList;
            ArrayList<PayPurchaseOrderInfo> orderInfos = new ArrayList<PayPurchaseOrderInfo>();
            orderInfos.add(payPurchaseOrderInfo);
            BusiGenerateNotificationReqBO notificationReqBO = new BusiGenerateNotificationReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)((Object)notificationReqBO), (String[])new String[0]);
            notificationReqBO.setOrderInfoList(orderInfos);
            BusiGenerateNotificationRspBO notificationRspBO = this.busiGenerateNotificationService.generateNotificationException(notificationReqBO);
            if (!"0000".equals(notificationRspBO.getRespCode())) continue;
            String notificationNo = notificationRspBO.getNotificationNo();
            String busiModel = "1";
            String payType = "";
            Long purchaseNo = 0L;
            log.debug("\u51c6\u5907\u4ea7\u751f\u5e94\u4ed8\u6b3e\u5355,\u901a\u77e5\u5355\u53f7=" + notificationNo);
            List<PayPurchaseOrderInfoDetailBO> payPurchaseOrderInfoDetailBOs = this.payPurchaseOrderInfoMapper.getListByNo(notificationNo);
            if (payPurchaseOrderInfoDetailBOs != null && payPurchaseOrderInfoDetailBOs.size() > 0) {
                busiModel = payPurchaseOrderInfoDetailBOs.get(0).getBusiModel();
                payType = payPurchaseOrderInfoDetailBOs.get(0).getPayType();
                purchaseNo = payPurchaseOrderInfoDetailBOs.get(0).getPurchaseNo();
            }
            Long companyId = reqBO.getCompanyId();
            if (busiModel.equals("1")) {
                companyId = purchaseNo;
            }
            log.error("notificationNo:{}.busiModel:{}.payType:{}", new Object[]{notificationNo, busiModel, payType});
            if (!"1".equals(busiModel) || !SaleOrderPayType.BILL_RECEIVE.getCode().equals(payType) || CollectionUtils.isEmpty(payableList = this.payableService.createPayableBill(notificationNo, companyId, reqBO.getIsProfessionalOrgExt(), busiModel))) continue;
            this.updatePayableDetailOverduePenalty(payableList.get(0), Collections.singletonList(payPurchaseOrderInfo.getInspectionId()));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<PayPurchaseOrderInfo> checkOrder(List<String> purchaseOrderCodeList, List<String> extOrderIdList, ImportExceptionBillReqBO reqBO) {
        List<PayPurchaseOrderInfo> orderInfos;
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        LinkedList<PayPurchaseOrderInfo> payPurchaseOrderInfos = new LinkedList<PayPurchaseOrderInfo>();
        if ("2".equals(reqBO.getIsProfessionalOrgExt())) {
            vo.setSupplierNo(reqBO.getSupId());
        }
        if (!CollectionUtils.isEmpty(purchaseOrderCodeList)) {
            vo.setPurchaseOrderCodes(purchaseOrderCodeList);
            orderInfos = this.payPurchaseOrderInfoMapper.getListByVO(vo);
            payPurchaseOrderInfos.addAll(orderInfos);
        }
        if (!CollectionUtils.isEmpty(extOrderIdList)) {
            vo.setExtOrderIds(extOrderIdList);
            vo.setPurchaseOrderCodes(null);
            orderInfos = this.payPurchaseOrderInfoMapper.getListByVO(vo);
            payPurchaseOrderInfos.addAll(orderInfos);
        }
        if (CollectionUtils.isEmpty(payPurchaseOrderInfos)) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u65e0\u8ba2\u5355");
        }
        for (PayPurchaseOrderInfo orderInfo : payPurchaseOrderInfos) {
            if (!(OrderStatus.NO_APPLY.getCode().equals(orderInfo.getOrderStatus()) || OrderStatus.AUTO_HANG_UP.getCode().equals(orderInfo.getOrderStatus()) || OrderStatus.HANGING.getCode().equals(orderInfo.getOrderStatus()))) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355[" + orderInfo.getPurchaseOrderCode() + "]\uff0c\u4f9b\u5e94\u5546\u8ba2\u5355[" + orderInfo.getExtOrderId() + "]\u72b6\u6001\u4e0d\u4e3a\u672a\u63d0\u4ea4\u6216\u6302\u8d77\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u5f55\u5165");
            }
            if (!BusiModel.MATCH_UP_MODEL.getCode().equals(orderInfo.getBusiModel())) {
                throw new PfscExtBusinessException("18000", "\u8ba2\u5355[" + orderInfo.getPurchaseOrderCode() + "]\uff0c\u4f9b\u5e94\u5546\u8ba2\u5355[" + orderInfo.getExtOrderId() + "]\u6a21\u5f0f\u4e0d\u4e3a\u64ae\u5408\u6a21\u5f0f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u5f55\u5165");
            }
            if (StringUtils.isEmpty((Object)orderInfo.getNotificationNo())) continue;
            throw new PfscExtBusinessException("18000", "\u8ba2\u5355[" + orderInfo.getPurchaseOrderCode() + "]\uff0c\u4f9b\u5e94\u5546\u8ba2\u5355[" + orderInfo.getExtOrderId() + "]\u5df2\u5b58\u5728\u901a\u77e5\u5355\u53f7\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u5f55\u5165");
        }
        return payPurchaseOrderInfos;
    }

    private void uploadFile(List<Map<String, Object>> data, ExportExceptionBillRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.createWorkbookWithHead(data, "\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406", "\u6ce8\u610f\u4e8b\u9879\uff1a\u8ba2\u5355\u53f7\u548c\u4f9b\u5e94\u5546\u8ba2\u5355\u7f16\u53f7\u4e8c\u9009\u4e00\u586b\u5199\uff0c\u4e24\u9879\u90fd\u586b\u5199\u65f6\u53ea\u53d6\u8ba2\u5355\u53f7\uff0c\u5bfc\u5165\u540e\u5c06\u89c6\u4e3a\u8ba2\u5355\u5f00\u7968\u5b8c\u6210");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "fsc";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        String date = df.format(new Date());
        String name = "\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406" + date;
        String fileName = name + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            rspBO.setFileName(fileName);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new BusinessException("0001", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }

    private void updatePayableDetailOverduePenalty(PayableDetailPO payableDetailPo, List<Long> inspectionIds) {
        if (!CollectionUtils.isEmpty(inspectionIds)) {
            FscPayableDetailUpdateOverduePenaltyBusiReqBO reqBo = new FscPayableDetailUpdateOverduePenaltyBusiReqBO();
            reqBo.setPayableNo(payableDetailPo.getPayableNo());
            reqBo.setInspectionIds(inspectionIds);
            FscPayableDetailUpdateOverduePenaltyBusiRspBO rspBo = this.fscPayableDetailUpdateBusiService.dealOverduePenaltyUpdate(reqBo);
            log.debug("\u66f4\u65b0\u8fdd\u7ea6\u91d1\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)((Object)rspBo), (int)SerializerFeature.WRITE_MAP_NULL_FEATURES, (SerializerFeature[])new SerializerFeature[0]));
        }
    }
}

