/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pfscext.api.ability.FscApplyPayAbilityService;
import com.tydic.pfscext.api.busi.bo.ApplyPayBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyPayServiceRspBO;
import com.tydic.pfscext.api.deal.BatchExceptionPayService;
import com.tydic.pfscext.api.deal.bo.ExportExceptionPayReqBO;
import com.tydic.pfscext.api.deal.bo.ExportExceptionPayRspBO;
import com.tydic.pfscext.api.deal.bo.ImportExceptionPayReqBO;
import com.tydic.pfscext.api.deal.bo.ImportExceptionPayRspBO;
import com.tydic.pfscext.api.trade.PayableService;
import com.tydic.pfscext.api.trade.bo.PayableDetailExcelBO;
import com.tydic.pfscext.common.ExcelFile;
import com.tydic.pfscext.dao.ApplyDetailMapper;
import com.tydic.pfscext.dao.PayableDetailMapper;
import com.tydic.pfscext.dao.po.ApplyDetail;
import com.tydic.pfscext.dao.po.PayableDetailPO;
import com.tydic.pfscext.enums.PayableStatus;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.ExcelUtils;
import com.tydic.pfscext.utils.FscRu;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.BatchExceptionPayService"})
public class BatchExceptionPayServiceImpl
implements BatchExceptionPayService {
    private static final Logger log = LoggerFactory.getLogger(BatchExceptionPayServiceImpl.class);
    @Autowired
    private PayableService payableService;
    @Autowired
    private FscApplyPayAbilityService fscApplyPayAbilityService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private ApplyDetailMapper applyDetailMapper;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers}")
    private String fastdfsTrackerServers;
    @Value(value="${export.file.public.url}")
    private String exportFilePublicUrl;
    private final String HEAD_STR = "\u6ce8\u610f\u4e8b\u9879\uff1a\u4ee5\u5e94\u4ed8\u5355\u53f7\u4fe1\u606f\u4e3a\u51c6\uff0c\u5bfc\u5165\u540e\u5c06\u89c6\u4e3a\u5e94\u4ed8\u5355\u5168\u989d\u4ed8\u6b3e\u5b8c\u6210";
    private final String SHEET_NAME = "\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406";

    @PostMapping(value={"exportExceptionPay"})
    public ExportExceptionPayRspBO exportExceptionPay(@RequestBody ExportExceptionPayReqBO reqBO) {
        String s = JSON.toJSONString((Object)reqBO);
        ExportExceptionPayRspBO rspBO = new ExportExceptionPayRspBO();
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
        item.put("\u5e94\u4ed8\u5355\u53f7", null);
        if (reqBO.getDown().booleanValue()) {
            item.put("\u5f00\u7968\u7533\u8bf7\u5355\u53f7", null);
        } else {
            item.put("\u5f00\u7968\u901a\u77e5\u5355\u53f7", null);
        }
        item.put("\u8ba2\u5355\u53f7", null);
        item.put("\u4f9b\u5e94\u5546\u8ba2\u5355\u7f16\u53f7", null);
        item.put("\u5e94\u4ed8\u91d1\u989d", null);
        item.put("\u5f85\u4ed8\u91d1\u989d", null);
        exportData.add(item);
        this.uploadFile(exportData, rspBO);
        String fullFilePath = "";
        if ("OSS".equals(this.fileType)) {
            fullFilePath = rspBO.getFilePath();
        } else if ("FASTDFS".equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)rspBO.getFilePath());
            fullFilePath = this.exportFilePublicUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        }
        rspBO.setFileUrl(fullFilePath);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"importExceptionPay"})
    public ImportExceptionPayRspBO importExceptionPay(@RequestBody ImportExceptionPayReqBO reqBO) {
        log.debug("\u5f02\u5e38\u53d8\u66f4\u64cd\u4f5c\u56de\u6b3e--\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        ExcelFile excel = this.getExcelFile(reqBO);
        Map<String, PayableDetailExcelBO> mapReadData = this.readExcelToMap(reqBO, excel);
        ArrayList<String> payableNoList = new ArrayList<String>(mapReadData.keySet());
        log.error("\u6279\u91cf\u56de\u6b3e\u5e94\u4ed8\u5355\u53f7\uff1a{}", payableNoList);
        if (CollectionUtils.isEmpty(payableNoList)) {
            throw new PfscExtBusinessException("18000", "\u6570\u636e\u8bfb\u53d6\u7ed3\u679c\u5e94\u4ed8\u5355\u53f7\u4e3a\u7a7a");
        }
        if (reqBO.getDown() != null && reqBO.getDown().booleanValue()) {
            return this.importExceptionPayOperator(reqBO, mapReadData);
        }
        return this.importExceptionPaySup(reqBO, mapReadData);
    }

    private ImportExceptionPayRspBO importExceptionPaySup(ImportExceptionPayReqBO reqBO, Map<String, PayableDetailExcelBO> mapReadData) {
        List<PayableDetailPO> payableDetailPOS;
        ImportExceptionPayRspBO rspBO = new ImportExceptionPayRspBO();
        ArrayList<String> payableNos = new ArrayList<String>(mapReadData.keySet());
        try {
            payableDetailPOS = this.checkPayableDetail(payableNos, reqBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e76\u68c0\u9a8c\u5e94\u4ed8\u5355\u5f02\u5e38" + e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        HashMap<String, String> errorMap = new HashMap<String, String>();
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            BusiApplyPayServiceReqBO applyPayServiceReqBO = new BusiApplyPayServiceReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)applyPayServiceReqBO, (String[])new String[0]);
            ArrayList<ApplyPayBO> applyPayBOS = new ArrayList<ApplyPayBO>();
            ApplyPayBO applyPayBO = new ApplyPayBO();
            applyPayBO.setPayableNo(payableDetailPO.getPayableNo());
            applyPayBO.setSource(payableDetailPO.getSource());
            applyPayBO.setPayAmt(payableDetailPO.getPayableAmt());
            applyPayBOS.add(applyPayBO);
            applyPayServiceReqBO.setApplyPayBOList(applyPayBOS);
            if (payableDetailPO.getSupplierId() != null) {
                applyPayServiceReqBO.setSupplierId(payableDetailPO.getSupplierId());
            } else if (!StringUtils.isEmpty((Object)payableDetailPO.getSupplierNoList())) {
                applyPayServiceReqBO.setSupplierId(Long.valueOf(payableDetailPO.getSupplierNoList()));
            }
            applyPayServiceReqBO.setSupplierName(payableDetailPO.getSupplierName());
            applyPayServiceReqBO.setUocEsSyncVersionId(Long.valueOf(Sequence.getInstance().nextId()));
            BusiApplyPayServiceRspBO busiApplyPayServiceRspBo = this.fscApplyPayAbilityService.applyExpetionPay(applyPayServiceReqBO);
            if (!FscRu.isFailed(busiApplyPayServiceRspBo.getRespCode()).booleanValue()) continue;
            errorMap.put(payableDetailPO.getPayableNo(), busiApplyPayServiceRspBo.getRespDesc());
        }
        if (!errorMap.isEmpty()) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25\u7684\u5e94\u4ed8\u5355\uff1a" + errorMap);
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private ImportExceptionPayRspBO importExceptionPayOperator(ImportExceptionPayReqBO reqBO, Map<String, PayableDetailExcelBO> mapReadData) {
        ImportExceptionPayRspBO rspBO = FscRu.success(ImportExceptionPayRspBO.class);
        ArrayList<String> payableNoList = new ArrayList<String>(mapReadData.keySet());
        List<PayableDetailPO> payableDetailPos = this.payableDetailMapper.getListByIds(payableNoList);
        try {
            this.checkAndGetPayableDetail(payableDetailPos, mapReadData, reqBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5e76\u68c0\u9a8c\u5e94\u4ed8\u5355\u5f02\u5e38" + e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        HashMap<String, String> errorMap = new HashMap<String, String>();
        for (PayableDetailPO payableDetailPO : payableDetailPos) {
            BusiApplyPayServiceReqBO applyPayServiceReqBO = new BusiApplyPayServiceReqBO();
            BeanUtil.copyProperties((Object)reqBO, (Object)applyPayServiceReqBO, (String[])new String[0]);
            ArrayList<ApplyPayBO> applyPayBOS = new ArrayList<ApplyPayBO>();
            ApplyPayBO applyPayBO = new ApplyPayBO();
            applyPayBO.setPayableNo(payableDetailPO.getPayableNo());
            applyPayBO.setSource(payableDetailPO.getSource());
            applyPayBO.setPayAmt(payableDetailPO.getPayableAmt());
            applyPayBOS.add(applyPayBO);
            applyPayServiceReqBO.setApplyPayBOList(applyPayBOS);
            if (payableDetailPO.getSupplierId() != null) {
                applyPayServiceReqBO.setSupplierId(payableDetailPO.getSupplierId());
            } else {
                String supplierNoList = payableDetailPO.getSupplierNoList();
                String regex = "[0-9]{1,}";
                if (!StringUtils.isEmpty((Object)supplierNoList) && supplierNoList.replace(" ", "").matches(regex)) {
                    applyPayServiceReqBO.setSupplierId(Long.valueOf(supplierNoList));
                }
            }
            applyPayServiceReqBO.setSupplierName(payableDetailPO.getSupplierName());
            BusiApplyPayServiceRspBO busiApplyPayServiceRspBo = this.fscApplyPayAbilityService.applyExpetionPay(applyPayServiceReqBO);
            if (!FscRu.isFailed(busiApplyPayServiceRspBo.getRespCode()).booleanValue()) continue;
            errorMap.put(payableDetailPO.getPayableNo(), busiApplyPayServiceRspBo.getRespDesc());
        }
        if (!errorMap.isEmpty()) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u5931\u8d25\u7684\u5e94\u4ed8\u5355\uff1a" + errorMap);
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkAndGetPayableDetail(List<PayableDetailPO> payableDetailPos, Map<String, PayableDetailExcelBO> mapReadData, ImportExceptionPayReqBO reqBo) {
        if (CollectionUtils.isEmpty(payableDetailPos)) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5e94\u4ed8\u5355\u4e3a\u7a7a");
        }
        ArrayList<String> payableNoList = new ArrayList<String>(mapReadData.keySet());
        for (PayableDetailPO payableDetailPO : payableDetailPos) {
            Integer busiModel = payableDetailPO.getBusiModel();
            if (!Arrays.asList(0, 1).contains(busiModel)) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355[" + payableDetailPO.getPayableNo() + "]\u7ed3\u7b97\u6a21\u5f0f[" + busiModel + "]\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u5f55\u5165");
            }
            if (!payableDetailPO.getBusiModel().equals(0) || Arrays.asList(1, 8).contains(payableDetailPO.getPayableType())) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355[" + payableDetailPO.getPayableNo() + "]\u7ed3\u7b97\u6a21\u5f0f\u6216\u8005\u5e94\u4ed8\u7c7b\u578b\u9519\u8bef\uff0c\u4e0d\u53ef\u4f7f\u7528\u8fd0\u8425\u56de\u6b3e");
            }
            BigDecimal payableAmt = payableDetailPO.getPayableAmt();
            if (PayableStatus.SUCCESS.getCode().equals(payableDetailPO.getPayableStatus()) || PayableStatus.TERMINATION.getCode().equals(payableDetailPO.getPayableStatus()) || payableAmt.compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355[" + payableDetailPO.getPayableNo() + "]\u5df2\u6ee1\u8db3\u4ed8\u6b3e\u72b6\u6001\uff0c\u4e0d\u53ef\u91cd\u590d\u4ed8\u6b3e\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u5f55\u5165");
            }
            ApplyDetail applyDetail = this.applyDetailMapper.selectAmtByPayableNo(payableDetailPO.getPayableNo());
            if (payableAmt.subtract(Optional.ofNullable(applyDetail).map(ApplyDetail::getAmt).orElse(BigDecimal.ZERO)).subtract(payableDetailPO.getPaidAmt()).compareTo(BigDecimal.ZERO) != 0) continue;
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355[" + payableDetailPO.getPayableNo() + "]\u5df2\u6ee1\u8db3\u4ed8\u6b3e\u72b6\u6001\uff0c\u4e0d\u53ef\u91cd\u590d\u4ed8\u6b3e\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u5f55\u5165");
        }
    }

    private Map<String, PayableDetailExcelBO> readExcelToMap(ImportExceptionPayReqBO reqBO, ExcelFile excel) {
        int headRowsNum = 2;
        List dataRows = excel.readRows(0, 2, -1);
        if (CollectionUtils.isEmpty((Collection)dataRows)) {
            throw new PfscExtBusinessException("18000", "\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u540e\u518d\u4e0a\u4f20");
        }
        HashMap<String, PayableDetailExcelBO> mapData = new HashMap<String, PayableDetailExcelBO>();
        ArrayList<String> errorList = new ArrayList<String>();
        for (int i = 0; i < dataRows.size(); ++i) {
            String[] fields = (String[])dataRows.get(i);
            List<String> row = Arrays.asList(fields);
            PayableDetailExcelBO itemBo = new PayableDetailExcelBO();
            int index = 2 + i + 1;
            itemBo.setLineNum(Integer.valueOf(index));
            if (CollectionUtils.isEmpty(row)) {
                errorList.add("\u7b2c" + index + "\u884c\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                continue;
            }
            String payableNo = row.get(0);
            if (!StringUtils.hasText((String)payableNo)) {
                errorList.add("\u7b2c" + index + "\u884c\u7f3a\u5c11\u5e94\u4ed8\u5355\u53f7\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                continue;
            }
            itemBo.setPayableNo(payableNo);
            if (mapData.containsKey(payableNo)) {
                errorList.add("\u7b2c" + index + "\u884c\u6570\u636e\u5e94\u4ed8\u5355\u53f7[" + payableNo + "]\u91cd\u590d\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5");
                continue;
            }
            mapData.put(payableNo, itemBo);
        }
        if (!CollectionUtils.isEmpty(errorList)) {
            throw new PfscExtBusinessException("18000", String.join((CharSequence)";", errorList));
        }
        return mapData;
    }

    private ExcelFile getExcelFile(ImportExceptionPayReqBO reqBO) {
        ExcelFile excel = null;
        try {
            URL url = new URL(reqBO.getFileUrl());
            URLConnection connection = url.openConnection();
            excel = new ExcelFile(connection.getInputStream(), true);
        }
        catch (IOException e) {
            log.error("\u5bfc\u5165\u7ed3\u7b97\u5f02\u5e38\u6587\u4ef6\u5931\u8d25:{}", (Object)e.getMessage());
            throw new PfscExtBusinessException("18000", "\u5bfc\u5165\u7ed3\u7b97\u5f02\u5e38\u6587\u4ef6\u5931\u8d25");
        }
        if (!excel.isReady()) {
            throw new PfscExtBusinessException("18000", "\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6");
        }
        if (excel.getSheetCount() != 1) {
            throw new PfscExtBusinessException("18000", "\u4e0a\u4f20\u7684Excel\u5e94\u53ea\u67091\u9875");
        }
        if (!"\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406".equals(excel.getSheetName(0))) {
            throw new PfscExtBusinessException("18000", "\u7b2c1\u4e2a\u6570\u636e\u9875\u7684\u540d\u79f0[" + excel.getSheetName(0) + "]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0");
        }
        return excel;
    }

    private List<PayableDetailPO> checkPayableDetail(List<String> payableNos, ImportExceptionPayReqBO reqBO) {
        List<PayableDetailPO> payableDetailPOS = this.payableDetailMapper.getListByIds(payableNos);
        if (CollectionUtils.isEmpty(payableDetailPOS)) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5e94\u4ed8\u5355\u4e3a\u7a7a");
        }
        for (PayableDetailPO payableDetailPO : payableDetailPOS) {
            if ("2".equals(reqBO.getIsProfessionalOrgExt()) && !payableDetailPO.getSupplierId().equals(reqBO.getSupId()) && !payableDetailPO.getSupplierNoList().equals(reqBO.getSupId() + "")) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355[" + payableDetailPO.getPayableNo() + "]\u4e0d\u5c5e\u4e8e\u8be5\u4f9b\u5e94\u5546\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u5f55\u5165");
            }
            if (payableDetailPO.getBusiModel() == null || !payableDetailPO.getBusiModel().equals(1)) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355[" + payableDetailPO.getPayableNo() + "]\u7ed3\u7b97\u6a21\u5f0f\u9519\u8bef\uff0c\u4e0d\u53ef\u4f7f\u7528\u4f9b\u5e94\u5546\u56de\u6b3e");
            }
            if (PayableStatus.SUCCESS.getCode().equals(payableDetailPO.getPayableStatus()) || PayableStatus.TERMINATION.getCode().equals(payableDetailPO.getPayableStatus()) || payableDetailPO.getPayableAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355[" + payableDetailPO.getPayableNo() + "]\u5df2\u6ee1\u8db3\u4ed8\u6b3e\u72b6\u6001\uff0c\u4e0d\u53ef\u91cd\u590d\u4ed8\u6b3e\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u5f55\u5165");
            }
            ApplyDetail applyDetail = this.applyDetailMapper.selectAmtByPayableNo(payableDetailPO.getPayableNo());
            if (payableDetailPO.getPayableAmt().subtract(applyDetail != null ? applyDetail.getAmt() : BigDecimal.ZERO).subtract(payableDetailPO.getPaidAmt()).compareTo(BigDecimal.ZERO) != 0) continue;
            throw new PfscExtBusinessException("18000", "\u5e94\u4ed8\u5355[" + payableDetailPO.getPayableNo() + "]\u5df2\u6ee1\u8db3\u4ed8\u6b3e\u72b6\u6001\uff0c\u4e0d\u53ef\u91cd\u590d\u4ed8\u6b3e\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u6b21\u5f55\u5165");
        }
        return payableDetailPOS;
    }

    private void uploadFile(List<Map<String, Object>> data, ExportExceptionPayRspBO rspBO) {
        SXSSFWorkbook workbook = ExcelUtils.createWorkbookWithHead(data, "\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406", "\u6ce8\u610f\u4e8b\u9879\uff1a\u4ee5\u5e94\u4ed8\u5355\u53f7\u4fe1\u606f\u4e3a\u51c6\uff0c\u5bfc\u5165\u540e\u5c06\u89c6\u4e3a\u5e94\u4ed8\u5355\u5168\u989d\u4ed8\u6b3e\u5b8c\u6210");
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        String uploadPath = "fsc";
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
        String date = df.format(new Date());
        String name = "\u7ed3\u7b97\u5f02\u5e38\u53d8\u66f4\u6279\u5904\u7406" + date;
        String fileName = name + ".xlsx";
        try {
            out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            byte[] buff = out.toByteArray();
            in = new ByteArrayInputStream(buff);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)in);
            rspBO.setFilePath(result);
            rspBO.setFileClientType(this.fileType);
            rspBO.setFileName(fileName);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new PfscExtBusinessException("0001", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((Closeable)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)in);
        IOUtils.closeQuietly((Closeable)out);
    }
}

