/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfscext.service.deal.impl;

import com.tydic.pfscext.api.aisino.FscSendApplyAdviceMsgService;
import com.tydic.pfscext.api.aisino.bo.SendApplyAdviceMsgReqBO;
import com.tydic.pfscext.api.busi.bo.PayPurchaseOrderInfoBO;
import com.tydic.pfscext.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfscext.api.busi.vo.BusiProcessInvoiceInOutVO;
import com.tydic.pfscext.api.deal.BusiBillNotificationService;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.dao.BillNotificationInfoMapper;
import com.tydic.pfscext.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfscext.dao.po.BillNotificationInfo;
import com.tydic.pfscext.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfscext.dao.vo.PayPurchaseOrderInfoVO;
import com.tydic.pfscext.enums.SendApplyAdviceType;
import com.tydic.pfscext.enums.YesOrNo;
import com.tydic.pfscext.exception.PfscExtBusinessException;
import com.tydic.pfscext.utils.DateUtil;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgAbilityBO;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umc.ability.org.UmcEnterpriseOrgQueryAbilityService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfscext.api.deal.BusiBillNotificationService"})
public class BusiBillNotificationServiceImpl
implements BusiBillNotificationService {
    private static final Logger log = LoggerFactory.getLogger(BusiBillNotificationServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private UmcEnterpriseOrgQueryAbilityService umcEnterpriseOrgQueryAbilityService;
    @Autowired
    private FscSendApplyAdviceMsgService fscSendApplyAdviceMsgService;
    @Value(value="${UNC_MESSAGE_SENDING_FLAG:0}")
    private String UNC_MESSAGE_SENDING_FLAG;

    @PostMapping(value={"selectByPrimaryAndCompany"})
    public BillNotificationInfoVO selectByPrimaryAndCompany(@RequestBody BusiProcessInvoiceInOutVO data) {
        BillNotificationInfoVO billVO = new BillNotificationInfoVO();
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryAndCompany(data.getNotificationNo(), data.getCompanyId());
        if (bill == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)bill, (Object)billVO);
        if (null != bill.getStartOrgId() && !"".equals(bill.getStartOrgId())) {
            UmcEnterpriseOrgAbilityBO umcEnterpriseOrgAbilityBO;
            UmcEnterpriseOrgQueryAbilityReqBO umcEnterpriseOrgAbilityReqPageBO = new UmcEnterpriseOrgQueryAbilityReqBO();
            umcEnterpriseOrgAbilityReqPageBO.setOrgIdWeb(Long.valueOf(bill.getStartOrgId()));
            UmcEnterpriseOrgDetailAbilityRspBO umcEnterpriseOrgDetailAbilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcEnterpriseOrgAbilityReqPageBO);
            if (null != umcEnterpriseOrgDetailAbilityRspBO && null != (umcEnterpriseOrgAbilityBO = umcEnterpriseOrgDetailAbilityRspBO.getUmcEnterpriseOrgAbilityBO())) {
                billVO.setStartOrgName(umcEnterpriseOrgAbilityBO.getOrgName());
            }
        }
        return billVO;
    }

    @PostMapping(value={"updateByPrimaryKeySelective"})
    public BillNotificationInfoVO updateByPrimaryKeySelective(@RequestBody BillNotificationInfoVO vo) {
        BillNotificationInfo billNotificationInfo = new BillNotificationInfo();
        BeanUtils.copyProperties((Object)vo, (Object)billNotificationInfo);
        this.billNotificationInfoMapper.updateStatusByPrimaryKey(billNotificationInfo);
        this.sendAdvice(vo);
        return new BillNotificationInfoVO();
    }

    private void sendAdvice(BillNotificationInfoVO vo) {
        try {
            if (!YesOrNo.YES.getCodeAsString().equals(this.UNC_MESSAGE_SENDING_FLAG)) {
                log.info("\u901a\u77e5\u914d\u7f6e\u4e0d\u53d1\u9001\u901a\u77e5\uff0c\u76f4\u63a5\u7ed3\u675f");
                return;
            }
            SendApplyAdviceMsgReqBO reqBO = new SendApplyAdviceMsgReqBO();
            reqBO.setBusinessDate(DateUtil.dateToStr(new Date()));
            reqBO.setNotificationNo(vo.getNotificationNo());
            reqBO.setTemplateName("\u5f85\u6536\u7968\u7ed3\u7b97\u901a\u77e5");
            List<PayPurchaseOrderInfo> payPurchaseOrderInfos = this.payPurchaseOrderInfoMapper.selectByNotifNo(vo.getNotificationNo());
            if (CollectionUtils.isEmpty(payPurchaseOrderInfos)) {
                throw new PfscExtBusinessException("18003", "\u53d1\u9001\u901a\u77e5\u65f6\u672a\u67e5\u5230\u8ba2\u5355\u4fe1\u606f!");
            }
            if ("0".equals(payPurchaseOrderInfos.get(0).getBusiModel())) {
                reqBO.setTitle(SendApplyAdviceType.UNIFIED_SIGNATURE_UP_STAY_TICKET.getAdviceName());
                reqBO.setOrgId(payPurchaseOrderInfos.get(0).getOperUnitNo());
                reqBO.setReceiver(SendApplyAdviceType.UNIFIED_SIGNATURE_UP_STAY_TICKET.getReceiver());
            } else if ("1".equals(payPurchaseOrderInfos.get(0).getBusiModel())) {
                if (StringUtils.isNotEmpty((String)payPurchaseOrderInfos.get(0).getNoAgreeOrderCategory()) && "0".equals(payPurchaseOrderInfos.get(0).getNoAgreeOrderCategory())) {
                    reqBO.setTitle(SendApplyAdviceType.REDUNDANCY_STAY_TICKET.getAdviceName());
                    reqBO.setOrgId(payPurchaseOrderInfos.get(0).getPurchaseNo());
                } else {
                    reqBO.setTitle(SendApplyAdviceType.SUBCONTRACTING_STAY_TICKET.getAdviceName());
                    reqBO.setOrgId(payPurchaseOrderInfos.get(0).getPurchaseNo());
                }
                reqBO.setReceiverId(payPurchaseOrderInfos.get(0).getPurchaserId());
            }
            this.fscSendApplyAdviceMsgService.sendApplyAdvice(reqBO);
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u901a\u77e5\u5931\u8d25");
        }
    }

    @PostMapping(value={"updateOrderByNotiNo"})
    public PfscExtRspBaseBO updateOrderByNotiNo(@RequestBody PayPurchaseOrderInfoBO payPurchaseOrderInfoBO) {
        PfscExtRspBaseBO rspBaseBO = new PfscExtRspBaseBO();
        PayPurchaseOrderInfoVO vo = new PayPurchaseOrderInfoVO();
        vo.setNotificationNo(payPurchaseOrderInfoBO.getNotificationNo());
        vo.setOrderStatus(payPurchaseOrderInfoBO.getOrderStatus());
        this.payPurchaseOrderInfoMapper.updateStatusBatchByNoti(vo);
        rspBaseBO.setRespCode("0000");
        rspBaseBO.setRespDesc("\u6210\u529f");
        return rspBaseBO;
    }
}

